set more 1

****************************************************************************************************
* PROGRAM TO OBTAIN FIRST-DIFFERENCED OLS ESTIMATES OF MARKET IMPERFECTION PARAMETERS (SECTION 4.2) *
****************************************************************************************************

***********************************************************************
*** ?_{j} *************************************************************
***********************************************************************

forvalues i=1(1)38 {
use C:\data\ind`i'.dta

gen srn=dqk-an*dnk-am*dmk
gen x1n=an*dnk+am*dmk
gen x2n=an*dnk
gen sharefactor=(1-an-am)/an

xi: reg srn i.year, robust
*ereturn list
scalar rss1ind`i'=e(rss)
scalar df1ind`i'=e(df_r)

xi: reg srn x1n x2n i.year, robust
matrix bmatrix=e(b)
svmat bmatrix, name(matcol)
*ereturn list
scalar rss2ind`i'=e(rss)
scalar df2ind`i'=e(df_r)

scalar difdfind`i'=df1ind`i'-df2ind`i'

scalar Find`i'=((rss1ind`i'-rss2ind`i')/(df1ind`i'-df2ind`i'))/(rss2ind`i'/df2ind`i')
scalar fprob=fprob(difdfind`i',df2ind`i',Find`i')
display fprob
gen fprob=fprob(difdfind`i',df2ind`i',Find`i')
keep bmatrixx1n bmatrixx2n sharefactor fprob
keep in 1/1
save  C:\data\b`i'
clear
}

forvalues i=1(1)38 {
use  C:\data\ind`i'.dta

gen srn=dqk-an*dnk-am*dmk
gen x1n=an*dnk+am*dmk
gen x2n=an*dnk

xi: reg srn x1n x2n i.year, robust
matrix Vmatrix=e(V)
svmat Vmatrix, name(matcol)
keep Vmatrixx1n Vmatrixx2n 
keep in 1/2
save  C:\data\V`i'
clear
}

forvalues i=1(1)38 {
use C:\Users\sdobbelaere\Documents\DOBMAIR3\b`i'
rename bmatrixx1n Vmatrixx1n
rename bmatrixx2n Vmatrixx2n
append using  C:\data\V`i'
mkmat Vmatrixx1n Vmatrixx2n, matrix(x)
matrix x=matrix(x)
matrix list x
matrix y=J(1,2,0)
matrix w=J(1,1,0)

***bmatrixx1n bmatrixx2n  [1*2]matrix***  
***Vmatrixx1n Vmatrixx2n  [2*2]matrix***
***Append bmatrix and Vmatrix gives following [3*3]matrix***

***x1n          =x[1,1]    x2n          =x[1,2]***
***var[x1n]     =x[2,1]    cov[x1n,x2n] =x[2,2]***
***cov[x2n,x1n] =x[3,1]    var[x2n]     =x[3,2]***


** matrix y: VAR[x1n]     VAR[x2n]     **
** matrix w: COV[x1n,x2n]              **

matrix y=(x[2,1],x[3,2])
matrix list y
svmat y, name(matcol)
drop if yc1==.
rename yc1 Vx1n
rename yc2 Vx2n


matrix w=(x[2,2])
matrix list w
svmat w, name(matcol)
drop if wc1==.
rename wc1 Covx1nx2n

save  C:\data\varcov`i'
clear
}


use   C:\data\varcov1
forvalues i=2(1)38 {
append using  C:\data\varcov`i'
}
rename Vmatrixx1n mudev
rename Vmatrixx2n psi
rename Vx1n varmudev
rename Vx2n varpsi
rename Covx1nx2n covmudevpsi
gen stdmudev=sqrt(varmudev)
gen stdpsi=sqrt(varpsi)
gen tmudev=mudev/stdmudev
gen tpsi=psi/stdpsi
gen ind38=_n
save  C:\data\psi.dta
clear


***********************************************************************
*** _{j} only ********************************************************
***********************************************************************


forvalues i=1(1)38 {
use C:\data\\ind`i'.dta
xi: reg dqk dxm i.year, robust
matrix bmatrix=e(b)
svmat bmatrix, name(matcol)
matrix Vmatrix=e(V)
svmat Vmatrix, name(matcol)
keep bmatrixdxm Vmatrixdxm an am ratio sum
drop if bmatrix[1,1]==.
gen muonly=bmatrix[1,1]
gen varmuonly=Vmatrix[1,1]
gen stdmuonly=sqrt(varmuonly)
save C:\data\b`i'
clear
}

use C:\data\b1
forvalues i=2(1)38 {
append using C:\data\b`i'
}
gen ind38=_n
drop bmatrixdxm Vmatrixdxm
save C:\data\muonly.dta
clear


***********************************************************************
*** _{j} and f_{j} ***************************************************
***********************************************************************


forvalues i=1(1)38 {
use C:\data\ind\ind`i'.dta
xi: reg dqk dnk dmk i.year, robust
matrix bmatrix=e(b)
svmat bmatrix, name(matcol)
keep bmatrixdnk bmatrixdmk an am ratio sum
drop if bmatrix[1,1]==.
gen nelas=bmatrix[1,1]
gen melas=bmatrix[1,2]
gen mu=bmatrix[1,12]/am[1]
gen gamma=(bmatrix[1,1]-(bmatrix[1,2]*ratio[1]))/((bmatrix[1,2]/am[1])*sum[1])
gen phi=gamma[1]/(1+gamma[1])
save C:\data\b`i'
clear
}


forvalues i=1(1)38 {
use C:\data\ind`i'.dta
xi: reg dqk dnk dmk i.year, robust
matrix Vmatrix=e(V)
svmat Vmatrix, name(matcol)
keep Vmatrixdnk Vmatrixdmk an am ratio sum
keep in 1/2
save C:\data\V`i'
clear
}


forvalues i=1(1)38 {
use C:\data\b`i'
drop nelas melas
rename bmatrixdnk Vmatrixdnk
rename bmatrixdmk Vmatrixdmk
append C:\data\V`i'
mkmat Vmatrixdnk Vmatrixdmk, matrix(x)
matrix x=matrix(x)
matrix list x
matrix y=J(1,2,0)
matrix w=J(1,1,0)
matrix z=J(1,2,0)
matrix r=J(1,1,0)


***bmatrixdnk bmatrixdmk  [1*2]matrix***  
***Vmatrixdnk Vmatrixdmk  [2*2]matrix***
***Append bmatrix and Vmatrix gives following [3*3]matrix***

***dnk           =x[1,1]    dmk           =x[1,2]***
***var[dnk]      =x[2,1]    cov[dnk,dmk]  =x[2,2]***
***cov[dmk,dnk]  =x[3,1]    var[dmk]      =x[3,2]***


** matrix y: VAR[dnk]     VAR[xdmk]    **
** matrix w: COV[dnk,dmk]              **
** matrix z: VAR[mu]      VAR [gamma] **
** matrix r: VAR[phi]                  **


matrix y=(x[2,1],x[3,2])
matrix list y
svmat y, name(matcol)
drop if yc1==.
rename yc1 Vdnk
rename yc2 Vdmk


matrix w=(x[2,2])
matrix list w
svmat w, name(matcol)
drop if wc1==.
rename wc1 Covdnkdmk


matrix z=((1/am[1])^2*x[3,2],(an[1]/sum[1])^2*((1/(ratio[1]^2*x[1,2]^4))*((x[1,2]^2*x[2,1])-(2*x[1,1]*x[1,2]*x[2,2])+(x[1,1]^2*x[3,2]))))
matrix list z
svmat z, name(matcol)
drop if zc1==.
rename zc1 varmu
rename zc2 vargamma


matrix r=((1/(1+gamma[1])^4)*z[1,2])
matrix list r
svmat r, name(matcol)
drop if rc1==.
rename rc1 varphi
saveC:\data\varcov`i'
}


use C:\data\varcov1
forvalues i=2(1)38 {
append using C:\data\varcov`i'
}
rename Vmatrixdnk nelas
rename Vmatrixdmk melas
rename Vdnk varnelas
rename Vdmk varmelas
rename Covdnkdmk covnelasmelas
gen stdnelas=sqrt(varnelas)
gen stdmelas=sqrt(varmelas)
gen stdmu=sqrt(varmu)
gen stdgamma=sqrt(vargamma)
gen stdphi=sqrt(varphi)
gen ind38=_n
save C:\data\muphi.dta
clear


*********************************************************************************************************************************************************************************************
*** _{j} and (e_{w}^{N})_{j}  ***********************************************************************************************************************************************************************************
***********************************************************************************************************************************************************************************************


forvalues i=1(1)38 {
use C:\data\ind`i'.dta
xi: reg dqk dnk dmk i.year, robust
matrix bmatrix=e(b)
svmat bmatrix, name(matcol)
keep bmatrixdnk bmatrixdmk an am ratio sum
drop if bmatrix[1,1]==.
gen nelas=bmatrixdnk
gen melas=bmatrix[1,1]
gen mu=bmatrix[1,2]/am[1]
gen beta=(an[1]/am[1])*(bmatrix[1,2]/bmatrix[1,1])
gen lelas=beta[1]/(1-beta[1])
save C:\data\DOBMAIR3\b`i'
clear
}


forvalues i=1(1)38 {
use C:\data\ind`i'.dta
xi: reg dqk dnk dmk i.year, robust
matrix Vmatrix=e(V)
svmat Vmatrix, name(matcol)
keep Vmatrixdnk Vmatrixdmk an am ratio sum
keep in 1/2
save C:\data\DOBMAIR3\V`i'
clear
}


forvalues i=1(1)38 {
use C:\data\DOBMAIR3\b`i'
drop nelas melas
rename bmatrixdnk Vmatrixdnk
rename bmatrixdmk Vmatrixdmk
append using C:\Users\sdobbelaere\Documents\DOBMAIR3\V`i'
mkmat Vmatrixdnk Vmatrixdmk, matrix(x)
matrix x=matrix(x)
matrix list x
matrix y=J(1,2,0)
matrix w=J(1,1,0)
matrix z=J(1,2,0)
matrix r=J(1,1,0)


***bmatrixdnk bmatrixdmk  [1*2]matrix***  
***Vmatrixdnk Vmatrixdmk  [2*2]matrix***
***Append bmatrix and Vmatrix gives following [3*3]matrix***

***dnk           =x[1,1]    dmk           =x[1,2]***
***var[dnk]      =x[2,1]    cov[dnk,dmk]  =x[2,2]***
***cov[dmk,dnk]  =x[3,1]    var[dmk]      =x[3,2]***


** matrix y: VAR[dnk]     VAR[xdmk]    **
** matrix w: COV[dnk,dmk]              **
** matrix z: VAR[mu]      VAR[beta] **
** matrix r: VAR[lelas]                  **


matrix y=(x[2,1],x[3,2])
matrix list y
svmat y, name(matcol)
drop if yc1==.
rename yc1 Vdnk
rename yc2 Vdmk


matrix w=(x[2,2])
matrix list w
svmat w, name(matcol)
drop if wc1==.
rename wc1 Covdnkdmk


matrix z=((1/am[1])^2*x[3,2],(an[1]/am[1])^2*(1/x[1,2]^4)*((x[1,2]^2*x[2,1])-(2*x[1,1]*x[1,2]*x[2,2])+(x[1,1]^2*x[3,2])))
matrix list z
svmat z, name(matcol)
drop if zc1==.
rename zc1 varmu
rename zc2 varbeta


matrix r=((1/(1-beta[1])^4)*z[1,2])
matrix list r
svmat r, name(matcol)
drop if rc1==.
rename rc1 varlelas
save C:\data\varcov`i'
}


use C:\data\varcov1
forvalues i=2(1)38 {
append using C:\data\varcov`i'
}
rename Vmatrixdnk nelas
rename Vmatrixdmk melas
rename Vdnk varnelas
rename Vdmk varmelas
rename Covdnkdmk covnelasmelas
gen stdnelas=sqrt(varnelas)
gen stdmelas=sqrt(varmelas)
gen stdmu=sqrt(varmu)
gen stdbeta=sqrt(varbeta)
gen stdlelas=sqrt(varlelas)
gen ind38=_n
save C:\data\mulelas.dta
clear

***********************************************************************
