/*
 * Simulation experiment
 *
 * Diks, C. and Wolski, M. (JAE, 2015)
 * Nonlinear Granger Causality - Guidelines for Multivariate Analysis
 * 
 * Copyright 2015, Marcin Wolski and Cees Diks
 * Software distributed under the GNU Public License 3.0. 
 * For details, see `LICENSE.txt'
 *
 * Cees Diks and Marcin Wolski -- May 2015 
 */

#include <stdio.h>#include <stdlib.h>#include <math.h>#include <string.h>
#include <time.h>
//#include <nr.h>#define max(a,b)	a>b?a:b#define min(a,b) 	a<b?a:b#define e_grid 1     // number of different bandwidths that are specified in main()#define filename "grangerDS_h0_2000.csv" //out file#define CV 1.6448530004709 //5% one-sided crit value//ARCH#define alpha    1#define beta     0.4/* Optimal bandwidth values  n    EPS_opt  100    1.11      200    0.99      500    0.85      1000   0.76      2000   0.68      5000   0.58      */  int Nobs=2000;/* * Rates and constants for EPS and eps2. They are now set such that for n=500 * we have EPS=0.76 and eps2=1.5 */double C_EPS=4.6188;double rate_EPS=-0.285714; // -2/7double C_eps2=4; double rate_eps2=-0.14285714; // -1/7double EPS; // Calculated in main()double eps2; // Calculated in main()double C2;  // Calculated in main()//double DS_rate=-0.2;int NN=2000;           // number of iterationsint m=1;            // embedding dimension int n;double T2, Q, **A, C[4], *h;double phihat(double *x, double *y, double *z, double *q, char *what, char *where, int point, int N, double epsilon, double c){	int i;	double nominator, denominator, new, w;		nominator=denominator=new=0.0;        for (i=0;i!=N;i++)	{	    /*       	   if(strcmp(where,"yq")==0)                 w = exp((-(y[i]-y[point])*(y[i]-y[point])-(q[i]-q[point])*(q[i]-q[point]))/(2*epsilon*epsilon));	   if(strcmp(where,"xyq")==0)                 w = exp((-(x[i]-x[point])*(x[i]-x[point])-(y[i]-y[point])*(y[i]-y[point])-(q[i]-q[point])*(q[i]-q[point]))/(2*epsilon*epsilon));	   if(strcmp(where,"yzq")==0)                 w = exp((-(y[i]-y[point])*(y[i]-y[point])-(z[i]-z[point])*(z[i]-z[point])-(q[i]-q[point])*(q[i]-q[point]))/(2*epsilon*epsilon));	   if(strcmp(where,"xyzq")==0) 	    */	     w = exp((-(x[i]-x[point])*(x[i]-x[point])-(y[i]-y[point])*(y[i]-y[point])-(z[i]-z[point])*(z[i]-z[point])-(q[i]-q[point])*(q[i]-q[point]))/(2*epsilon*epsilon));	   if(strcmp(what,"x")==0)            {			     nominator += (x[i]-x[point])*w;	     denominator += w;           }                	   if(strcmp(what,"y")==0)            {			     nominator += (y[i]-y[point])*w;	     denominator += w;           }                	   if(strcmp(what,"z")==0)            {			     nominator += (z[i]-z[point])*w;	     denominator += w;           }                	   if(strcmp(what,"q")==0)            {			     nominator += (q[i]-q[point])*w;	     denominator += w;           }                        }			if (strcmp(what,"x")==0) 			      	  new=x[point];	if (strcmp(what,"y")==0) 			      	  new=y[point];	if (strcmp(what,"z")==0) 			      	  new=z[point];	if (strcmp(what,"q")==0) 			      	  new=q[point];		        //fprintf(stderr,"diff = %1.12f",c*nominator/denominator);	return(new);}/* determine the log of ratios of correlation integrals */void redun(double *x, double *y, double *z, double *q, int N, double epsilon){  int i, j, s;  double IYij, IXYij, IYZij, IXYZij;  double dis2x, dis2y, dis2z, dis2q, tCy=0, tCxy=0, tCyz=0, tCxyz=0, mu, C_DS;  double *shx_xyq, *shx_xyzq, *shz_yzq, *shz_xyzq, *shy_yq, *shy_xyq, *shy_yzq, *shy_xyzq, *shq_yq, *shq_xyq, *shq_yzq, *shq_xyzq;  double e, *Cyq, *Cxyq, *Cyzq, *Cxyzq, disx_xyq, disx_xyzq, disz_yzq, disz_xyzq, disy_yq, disy_xyq, disy_yzq, disy_xyzq, disq_yq, disq_xyq, disq_yzq, disq_xyzq;  //mu=pow(2.0*epsilon,4.0);  mu = 1.0;  //mu = pow(1.0/sqrt(2.0*M_PI)/epsilon,4.0); // Can be set to 1.0 without consequence for the test stats.  Cyq = (double *) malloc(N*sizeof(double));  Cxyq = (double *) malloc(N*sizeof(double));  Cyzq = (double *) malloc(N*sizeof(double));  Cxyzq = (double *) malloc(N*sizeof(double));  shx_xyq = (double *) malloc(N*sizeof(double));  shx_xyzq = (double *) malloc(N*sizeof(double));  shz_yzq = (double *) malloc(N*sizeof(double));  shz_xyzq = (double *) malloc(N*sizeof(double));  shy_yq = (double *) malloc(N*sizeof(double));  shy_xyq = (double *) malloc(N*sizeof(double));  shy_yzq = (double *) malloc(N*sizeof(double));  shy_xyzq = (double *) malloc(N*sizeof(double));  shq_yq = (double *) malloc(N*sizeof(double));  shq_xyq = (double *) malloc(N*sizeof(double));  shq_yzq = (double *) malloc(N*sizeof(double));  shq_xyzq = (double *) malloc(N*sizeof(double));    for (i=0;i!=N;i++)  {    h[i] = Cyq[i] = Cxyq[i] = Cyzq[i] = Cxyzq[i] = 0.0;    shx_xyq[i] = shx_xyzq[i] = shz_yzq[i] = shz_xyzq[i] = shy_yq[i] = shy_xyq[i] = 0.0;    shy_yzq[i] = shy_xyzq[i] = shq_yq[i] = shq_xyq[i] = shq_yzq[i] = shq_xyzq[i] = 0.0;    disx_xyq = disx_xyzq = disz_yzq = disz_xyzq = disy_yq = disy_xyq = 0.0;    disy_yzq = disy_xyzq = disq_yq = disq_xyq = disq_yzq = disq_xyzq = 0.0;   }  T2=Q=0.0;  n = N; // was N - mmax                 //calculate the sharpened values    for (i=0;i!=n;i++)  {		//clean the variables		shx_xyq[i] = shx_xyzq[i] = shz_yzq[i] = shz_xyzq[i] = shy_yq[i] = shy_xyq[i] = shy_yzq[i] = shy_xyzq[i] = shq_yq[i] = shq_xyq[i] = shq_yzq[i] = shq_xyzq[i] = 0.0;		/* vector XYZQ */		shx_xyzq[i] = phihat(x,y,z,q,"x","xyzq",i,n,eps2,C2);		shy_xyzq[i] = phihat(x,y,z,q,"y","xyzq",i,n,eps2,C2);		shz_xyzq[i] = phihat(x,y,z,q,"z","xyzq",i,n,eps2,C2);		shq_xyzq[i] = phihat(x,y,z,q,"q","xyzq",i,n,eps2,C2);		/* vector XYQ */       		shx_xyq[i] = shx_xyzq[i];		shy_xyq[i] = shy_xyzq[i];		shq_xyq[i] = shq_xyzq[i];		/* vector YZQ */		shy_yzq[i] = shy_xyzq[i];		shz_yzq[i] = shz_xyzq[i];		shq_yzq[i] = shq_xyzq[i];		/* vector YQ */		shy_yq[i] = shy_xyzq[i];		shq_yq[i] = shq_xyzq[i];  }    for (i=0;i!=n;i++)  {    Cyq[i]=Cxyq[i]=Cyzq[i]=Cxyzq[i]=0.0;    for (j=0;j!=n;j++)    if (j!=i)    {      dis2y = (y[i]-shy_yq[j])*(y[i]-shy_yq[j]);      dis2q = (q[i]-shq_yq[j])*(q[i]-shq_yq[j]);             Cyq[i] += exp(-(dis2y+dis2q)/(2.0*epsilon*epsilon))/mu;      A[3][i] += exp(-(dis2y+dis2q)/(2.0*epsilon*epsilon))/mu;      dis2x = (x[i]-shx_xyq[j])*(x[i]-shx_xyq[j]);      dis2y = (y[i]-shy_xyq[j])*(y[i]-shy_xyq[j]);      dis2q = (q[i]-shq_xyq[j])*(q[i]-shq_xyq[j]);      Cxyq[i] += exp(-(dis2x+dis2y+dis2q)/(2.0*epsilon*epsilon))/mu;      A[1][i] += exp(-(dis2x+dis2y+dis2q)/(2.0*epsilon*epsilon))/mu;      dis2y = (y[i]-shy_yzq[j])*(y[i]-shy_yzq[j]);      dis2z = (z[i]-shz_yzq[j])*(z[i]-shz_yzq[j]);      dis2q = (q[i]-shq_yzq[j])*(q[i]-shq_yzq[j]);      Cyzq[i] += exp(-(dis2y+dis2z+dis2q)/(2.0*epsilon*epsilon))/mu;      A[2][i] += exp(-(dis2y+dis2z+dis2q)/(2.0*epsilon*epsilon))/mu;      dis2x = (x[i]-shx_xyzq[j])*(x[i]-shx_xyzq[j]);      dis2y = (y[i]-shy_xyzq[j])*(y[i]-shy_xyzq[j]);      dis2z = (z[i]-shz_xyzq[j])*(z[i]-shz_xyzq[j]);      dis2q = (q[i]-shq_xyzq[j])*(q[i]-shq_xyzq[j]);      Cxyzq[i] += exp(-(dis2x+dis2y+dis2z+dis2q)/(2.0*epsilon*epsilon))/mu;      A[0][i] += exp(-(dis2x+dis2y+dis2z+dis2q)/(2.0*epsilon*epsilon))/mu;    }   // end loop over j    Cyq[i] /= (double)(n-1);    Cxyq[i] /= (double)(n-1);    Cyzq[i] /= (double)(n-1);    Cxyzq[i] /= (double)(n-1);    //    h[i] += 2.0/mu*(Cxyzq[i]*Cyq[i] - Cxyq[i]*Cyzq[i])/6.0;    h[i] += 2.0*(Cxyzq[i]*Cyq[i] - Cxyq[i]*Cyzq[i])/6.0;  }  for (i=0;i!=n;i++)  {    for (j=0;j!=n;j++)    if (j!=i)    {      IYij = IXYij = IYZij = IXYZij = 0.0;      dis2y = (y[i]-shy_yq[j])*(y[i]-shy_yq[j]);      dis2q = (q[i]-shq_yq[j])*(q[i]-shq_yq[j]);              IYij= exp(-(dis2y+dis2q)/epsilon/epsilon/2.0)/mu;      dis2x = (x[i]-shx_xyq[j])*(x[i]-shx_xyq[j]);      dis2y = (y[i]-shy_xyq[j])*(y[i]-shy_xyq[j]);      dis2q = (q[i]-shq_xyq[j])*(q[i]-shq_xyq[j]);      IXYij = exp(-(dis2x+dis2y+dis2q)/epsilon/epsilon/2.0)/mu;      dis2y = (y[i]-shy_yzq[j])*(y[i]-shy_yzq[j]);      dis2z = (z[i]-shz_yzq[j])*(z[i]-shz_yzq[j]);      dis2q = (q[i]-shq_yzq[j])*(q[i]-shq_yzq[j]);      IYZij = exp(-(dis2y+dis2z+dis2q)/epsilon/epsilon/2.0)/mu;      dis2x = (x[i]-shx_xyzq[j])*(x[i]-shx_xyzq[j]);      dis2y = (y[i]-shy_xyzq[j])*(y[i]-shy_xyzq[j]);      dis2z = (z[i]-shz_xyzq[j])*(z[i]-shz_xyzq[j]);      dis2q = (q[i]-shq_xyzq[j])*(q[i]-shq_xyzq[j]);      IXYZij = exp(-(dis2x+dis2y+dis2z+dis2q)/epsilon/epsilon/2.0)/mu;      //h[j] += 2.0*(Cy[i]*IXYZij - Cyz[i]*IXYij)/(double)(6*n);      //h[j] += 2.0*(Cxyz[i]*IYij - Cxy[i]*IYZij)/(double)(6*n);      //h[i] += 2.0/mu*(Cxyzq[j]*IYij + IXYZij*Cyq[j] - Cxyq[j]*IYZij - IXYij*Cyzq[j])/(double)(6*n);      h[j] += 2.0*(Cxyzq[i]*IYij + IXYZij*Cyq[i] - Cxyq[i]*IYZij - IXYij*Cyzq[i])/(double)(6*(n-1));    }   // end second loop over j    tCy+=n*Cyq[i]; tCxy+=n*Cxyq[i], tCyz+=n*Cyzq[i], tCxyz+=n*Cxyzq[i];     T2 += Cxyzq[i]*Cyq[i] - Cyzq[i]*Cxyq[i];  } // end loop over i  Q = 0;// Alternatively one might determine T2 as the sum of the h[i]  for (i=0;i!=n;i++)    Q += h[i];  //fprintf(stderr,"T2 = %1.12f, Q=%1.12f, T2/Q = %1.12f, h[1] = %1.12f, Cxqy[1]=%1.12f\n", T2,Q,T2/Q, h[1], Cxyq[1]);  T2 /= (double)(n);  for (i=0;i!=n;i++)     h[i] -= T2;  Q = (double) tCxyz/tCxy - (double) tCyz/tCy;  C[0] = tCxyz/(double)(n*(n-1));  C[1] = tCxy/(double)(n*(n-1));  C[2] = tCyz/(double)(n*(n-1));  C[3] = tCy/(double)(n*(n-1));  for (i=0;i!=4;i++)   for (j=0;j!=n;j++)   {     A[i][j] /= (double)(n-1);     A[i][j] -= C[i];   }  //  for (i=0;i!=1;i++)  //{  //fprintf(stderr,"x[%d] = %1.12f\n", i, x[i]);  // fprintf(stderr,"h[%d] = %1.12f\n", i, h[i]);  //}  //fprintf(stderr,"T2 = %1.12f\n", T2);  free (Cyq);  free (Cxyq);  free (Cxyzq);  free (Cyzq);}/* normalise the time series to unit std. dev. */void normalise(double *x, int N){  int i;  double mean=0.0, var=0.0;  for (i=0;i!=N;i++)  {    mean += x[i];    var += x[i]*x[i];  }  mean /= (double)(N);  var /= (double)(N);  var -= mean*mean;  for (i=0;i!=N;i++)    x[i] = (x[i]-mean)/sqrt(var);  return;}// simulates Normal (0,1)double gasdev(void){	static int iset=0;	static double gset;	double fac,rsq,v1,v2;	if  (iset == 0) {		do {			v1=2.0*((double)(rand())/(double)(RAND_MAX))-1.0;			v2=2.0*((double)(rand())/(double)(RAND_MAX))-1.0;			rsq=v1*v1+v2*v2;		} while (rsq >= 1.0 || rsq == 0.0);		fac=sqrt(-2.0*log(rsq)/rsq);		gset=v1*fac;		iset=1;		return v2*fac;	} else {		iset=0;		return gset;	}}void InsertionSort(double *B, int *S, int M){    int i, *I;    int j;    int r;    double R;    I= (int*) malloc (M*sizeof(int));    for (i=0;i<M;i++)      I[i]=i;    for (i=1; i<M; i++)      {        R = B[i];        r = i;	for (j=i-1; (j>=0) && (B[j]>R); j--)        {	  B[j+1] = B[j];          I[j+1] = I[j];        }	B[j+1] = R;        I[j+1] = r;      }    for (i=0; i<M; i++)      S[I[i]]=i;}void  uniform (double *X, int M){  int *I, i;  I = (int*) malloc (M*sizeof(int));  InsertionSort(X, I, M);  for (i=0;i<M;i++)    X[i] = (double) I[i]/M*3.464101615;        // to make unit variance}int main(int argc, char *argv[]){    EPS = min(C_EPS*pow(Nobs,rate_EPS),1.5);  eps2 = C_eps2*pow(Nobs,rate_eps2);  C2 = EPS*EPS/(2*eps2*eps2);  fprintf(stderr,"EPS = %1.12f, eps2=%12f, C2=%12f\n",EPS, eps2, C2);  if (argc>1)    Nobs=atoi(argv[1]);  //  double epsilon[e_grid] = {0.99};  double epsilon[e_grid] = {EPS};  //  epsilon[e_grid] = 8.67*pow(Nobs,-2/7)/sqrt(3.0);  fprintf(stderr,"epsilon = %lf\n", epsilon[0]);  if (argc>2)    epsilon[0]=atof(argv[2]);    double x[Nobs], y[Nobs], z[Nobs], q[Nobs], *ohm, *cov, S2, VT2,	\    HJ_TVAL, T2_TVAL, HJ_mean[e_grid], T2_mean[e_grid], HJ_sigma[e_grid], T2_sigma[e_grid], d[4], sigma[4][4], hx, hy, hq, size[2][e_grid],pow_HJ[100],pow_T2[100],p_T2,p_HJ;  int i, ieps, j, l, k, K, nn;  FILE *outfil;  long seed=-1;  srand(time(NULL));  A = (double **) malloc(4*sizeof(double *));  h = (double *) malloc(Nobs*sizeof(double));  for (i=0;i!=4;i++)   A[i] = (double *) malloc(Nobs*sizeof(double));  K = (int)(sqrt(sqrt(Nobs-m)));  ohm = (double *) malloc(K*sizeof(double));  cov = (double *) malloc(K*sizeof(double));  ohm[0] = 1.0;  for (k=1;k<K;k++)    ohm[k] = 2.0*(1.0-k/(double)(K));  if ( (outfil=fopen(filename,"a")) == NULL)  {    fprintf(stderr,"Error: unable to open file for writing. Exiting...\n");    exit(1);  }  for(ieps=0;ieps<e_grid;ieps++)    HJ_mean[ieps]=T2_mean[ieps]=\    HJ_sigma[ieps]=T2_sigma[ieps]=\    size[0][ieps]=size[1][ieps]=0.0;  for (i=0;i<100;i++)    pow_HJ[i]=pow_T2[i]=0.0;  //  fprintf(stdout,"\n");  for (nn=0;nn<NN;nn++)   //iteration loop  {    fprintf(stderr,"Iteration: %d\r",nn);    // Generate series    hq=alpha/(1.0-beta);    hy=alpha/(1.0-beta);    hx=alpha/(1.0-beta);    // transient period        for (i=1;i<100;i++)    {       q[0]=sqrt(hq)*gasdev();       y[0]=sqrt(hy)*gasdev();       //hv = alpha+beta*y[0]*y[0]; // Y -> X instantaneously       x[0]=sqrt(hx)*gasdev();       hq = alpha+beta*q[0]*q[0]; // Q -> Q lag one       hy = alpha+beta*q[0]*q[0]; // Q -> Y lag one       hx = alpha+beta*y[0]*y[0]; // Y -> X lag one    }    for (i=0;i<Nobs;i++)    {       q[i]=sqrt(hq)*gasdev();       y[i]=sqrt(hy)*gasdev();       //hv= alpha+beta*y[i]*y[i]; // Y -> X instantaneously       //hv = 0.8*x[i]*exp(-0.01*x[i]*x[i]);       x[i]=sqrt(hx)*gasdev();       hq = alpha+beta*q[i]*q[i]; // Q -> Q lag one       hy = alpha+beta*q[i]*q[i]; // Q -> Y lag one       hx = alpha+beta*y[i]*y[i]; // Y -> X lag one    }    // fill z-variable     for (i=0;i<Nobs-1;i++)      z[i] = y[i+1];    z[Nobs-1] = sqrt(hy)*gasdev();        for (j=0;j!=4;j++)    {      C[j] = 0.0;      for (i=0;i!=Nobs;i++)        A[j][i] = 0.0;    }  //  uniform(x, Nobs);  //  uniform(y, Nobs);    normalise(x, Nobs);    normalise(y, Nobs);    normalise(z, Nobs);    normalise(q, Nobs);    for(ieps=0;ieps<e_grid;ieps++)    {      for (j=0;j!=4;j++)      {        C[j] = 0.0;        for (i=0;i!=Nobs;i++)          A[j][i] = 0.0;      }      // redun(x,y, ..) test statistic for X -> Y      redun(x,y,z,q,Nobs,epsilon[ieps]);      for (i=0;i!=4;i++)        for (j=0;j!=4;j++)        {          sigma[i][j] = 0.0;          for (k=0;k!=K;k++)            for (l=k;l!=Nobs;l++)              sigma[i][j] += 4.0*ohm[k]*(A[i][l]*A[j][l-k]+A[i][l-k]*A[j][l])/(double)(2*(n-k));        }        d[0] = 1.0/C[1];        d[1] = -C[0]/(C[1]*C[1]);        d[2] = -1.0/C[3];        d[3] = C[2]/(C[3]*C[3]);        S2=0.0;        for (i=0;i!=4;i++)          for (j=0;j!=4;j++)            S2 += d[i]*sigma[i][j]*d[j];        HJ_TVAL = Q*sqrt(n)/sqrt(S2);        if (HJ_TVAL>=CV)         size[0][ieps]++;        HJ_mean[ieps] += HJ_TVAL;        HJ_sigma[ieps] += HJ_TVAL*HJ_TVAL;        // determine autocovariance of h[i]        for (k=0;k!=K;k++)        {          cov[k] = 0.0;          for (i=k;i!=Nobs;i++)            cov[k] += h[i]*h[i-k];          cov[k] /= (double)(n-k);        }        VT2=0.0;        // variance of T2          for (k=0;k!=K;k++)          VT2 += 9.0*ohm[k]*cov[k]; //VT2 += 9.0*ohm[k]*cov[k];        T2_TVAL = T2*sqrt(n)/sqrt(VT2);                          if (HJ_TVAL>0)         p_HJ = 0.5 - 0.5*erf(HJ_TVAL/sqrt(2.0));      else         p_HJ = 0.5 + 0.5*erf(-HJ_TVAL/sqrt(2.0));                  for (i=(int)(100*p_HJ);i<100;i++)           pow_HJ[i]+=1.0/(double) NN;      if (T2_TVAL>0)         p_T2 = 0.5 - 0.5*erf(T2_TVAL/sqrt(2.0));      else         p_T2 = 0.5 + 0.5*erf(-T2_TVAL/sqrt(2.0));      fprintf(stderr,"p-value T2=%1.12f, p-value HJ=%1.12f \n", p_T2, p_HJ);      fprintf(outfil,"p-value T2=%1.12f, p-value HJ=%1.12f \n", p_T2, p_HJ); //add p-value to the file      for (i=(int)(100*p_T2);i<100;i++) 	pow_T2[i]+=1.0/(double) NN;        T2_mean[ieps] += T2_TVAL;        T2_sigma[ieps] += T2_TVAL*T2_TVAL;    }//end of for(ieps  }// end of iteration loop  for(ieps=0;ieps<e_grid;ieps++)  {    HJ_mean[ieps] /= (double) NN;    HJ_sigma[ieps] /= (double) NN;    HJ_sigma[ieps] = sqrt(HJ_sigma[ieps] - HJ_mean[ieps]*HJ_mean[ieps]);    T2_mean[ieps] /= (double) NN;    T2_sigma[ieps] /= (double) NN;    T2_sigma[ieps] = sqrt(T2_sigma[ieps] - T2_mean[ieps]*T2_mean[ieps]);  } // fil=fopen("hjt2cond.out","w");  fprintf(stderr, "#Sample, E, nom size, T2sise, HJsize, HJmean,   HJsigma,   T2mean,  T2sigma\n");  for (i=0;i<100;i++)  for (ieps=0;ieps<e_grid;ieps++)     fprintf(stderr, "%d %f %f %f %f %f %f %f %f\n",Nobs, epsilon[ieps], 0.01*(i+1), pow_T2[i], pow_HJ[i], HJ_mean[ieps], HJ_sigma[ieps], T2_mean[ieps], T2_sigma[ieps]);  //fclose(fil);  fclose(outfil);  return(0);}