####################################################################################
#
# calculate local bias of the sharpened test for the length given in the filename
# (may require to change the directories to R packages)
#
# Copyright 2015, Marcin Wolski and Cees Diks
# Software distributed under the GNU Public License 3.0. 
# For details, see `LICENSE.txt'
#
####################################################################################

#library("ks", lib.loc="/home/mwolski/rpackages/")
library("mvtnorm", lib.loc="/home/mwolski/rpackages/")
library("rgl", lib.loc="/home/mwolski/rpackages/")
library("misc3d", lib.loc="/home/mwolski/rpackages/")
library("ks", lib.loc="/home/mwolski/rpackages/")

#require(ks)
kder=function(vector,h,x) {
vector=as.matrix(vector);
x=as.matrix(x);
dims=length(vector[1,]);
if(dims>1) h=sqrt(h);

h0=h[1];
h1=h[2];
h2=h[3];
h3=h[4];
h4=h[5];

n=length(vector[,1]);
k0=0;
k1=matrix(0,nrow = 1, ncol = dims);
k2=matrix(0,nrow = dims, ncol = dims);
k3=matrix(0,nrow = dims, ncol = dims);
k4=matrix(0,nrow = dims, ncol = dims);
for(i in 1:n) {
	v=as.vector(x-vector[i,]);
	kernel0=exp(-1/(2*h0^2)*sum(v^2));
	kernel1=exp(-1/(2*h1^2)*sum(v^2));
	kernel2=exp(-1/(2*h2^2)*sum(v^2));
	kernel3=exp(-1/(2*h3^2)*sum(v^2));
	kernel4=exp(-1/(2*h4^2)*sum(v^2));
	#calculating derivatives from Hermite polynomials
	d1K=(-1/(h1^2)*v);
	d2K=1/h2^4*(v%*%t(v)-diag(dims)*h2^2);
	d3K=as.matrix((kernel1*kernel3)/(h1^2*h3^6)*(v%*%t(v)%*%v%*%t(v)-3*h3^2*v%*%t(v)));
	d4K=as.matrix(kernel4/h4^8*(v%*%t(v)%*%v%*%t(v)-6*h4^2*v%*%t(v)+3*h4^4));
	k0=k0+kernel0;	
	k1=k1+kernel1*d1K;
	k2=k2+kernel2*d2K;
	k3=k3+d3K;
	k4=k4+d4K;
}
k0=1/(n*h0^(dims))*(2*pi)^(-dims/2)*k0;
k1=1/(n*h1^(dims))*(2*pi)^(-dims/2)*k1;
k2=1/(n*h2^(dims))*(2*pi)^(-dims/2)*k2;
k3=(1/(n*h1^(dims))*(2*pi)^(-dims/2))*(1/(n*h3^(dims))*(2*pi)^(-dims/2))*k3;
k4=1/(n*h4^(dims))*(2*pi)^(-dims/2)*k4;
return(list(k0,k1,k2,sum(diag(k3)),sum(diag(k4))));
}


#vector and 3d square matrix multiplication
dp3d=function(vector,matrix) {
dims=dim(matrix);
output=array(0,dim=dims[1:2])
	for(r in 1:dims[1]) {
		for(c in 1:dims[1]) {
			output[r,c]=t(vector)%*%matrix[,c,r];
		}
	}
	return(output);
}
#sum the determinants of the diagonal 2x2 matrices (works only for 2,3,4 dim matrices)
B2=function(matrix) {
	sum=0;
	if(length(matrix[,1])==2) {
		sum=det(matrix);
	}
	if(length(matrix[,1])==3) {
		for(s in 1:3) {
			sum=sum+det(matrix[-s,-s]);
		}
	}
	if(length(matrix[,1])==4) {
		for(s in 4:2) {
			k=1;
			while(k<s) {
				m=matrix[-s,-s];
				sum=sum+det(m[-k,-k]);
			k=k+1;
			}
		}

	} 
 	return(sum);
}
#trace of 4 dim matrix
tr4=function(m) {
	tr=m[1,1,1,1]+m[2,2,2,2];
	if(length(m[,1,1,1])>=3) tr=tr+m[3,3,3,3];
	if(length(m[,1,1,1])>=4) tr=tr+m[4,4,4,4];
	return(tr);
}
#############################################################
#simulation parameters
#ptm=proc.time();
#############################################################
c=1
a=0.4
length=100;
nsim=1000;
q2File="Results/q2_100.csv";
swFile="Results/sw_100.csv";

k2=1; #second kernel moment
k4=3; #fourth kernel moment

length=length+1;

q2=array(0,dim=c(length-1,nsim));
sw=array(0,dim=c(length-1,nsim));

for(sim in 1:nsim) {
#the relationship Q->X->Y
Q=vector();
Y=vector();
X=vector();
Z=vector();

#first values
Q[1]=0;
X[1]=0;
Y[1]=0;
for(i in 2:(length+1)) {
	Q[i]=rnorm(1,0,sqrt(c+a*Q[i-1]^2));
	X[i]=rnorm(1,0,sqrt(c+a*Y[i-1]^2));
	Y[i]=rnorm(1,0,sqrt(c+a*Q[i-1]^2));
}
q=Q[2:(length)];
x=X[2:(length)];
y=Y[2:(length)];
z=Y[3:(length+1)];

	#f_xx=kder(cbind(x,y,z,q),h=1.5,cbind(x[1],y[1],z[1],q[1]));
	#f_xyzq=kde(x=cbind(x,y,z,q),h=hpi(c(x,y,z,q),deriv.order=0),eval.points=cbind(x[1],y[1],z[1],q[1]));
	
	#calculating optimal bandwidths
	h_xyzq=c(Hns(c(x,y,z,q),deriv.order=0),Hns(c(x,y,z,q),deriv.order=1),Hns(c(x,y,z,q),deriv.order=2),Hns(c(x,y,z,q),deriv.order=3),Hns(c(x,y,z,q),deriv.order=4));
	h_yzq=c(Hns(c(y,z,q),deriv.order=0),Hns(c(y,z,q),deriv.order=1),Hns(c(y,z,q),deriv.order=2),Hns(c(y,z,q),deriv.order=3),Hns(c(y,z,q),deriv.order=4));
	h_xyq=c(Hns(c(x,y,q),deriv.order=0),Hns(c(x,y,q),deriv.order=1),Hns(c(x,y,q),deriv.order=2),Hns(c(x,y,q),deriv.order=3),Hns(c(x,y,q),deriv.order=4));
	h_yq=c(Hns(c(y,q),deriv.order=0),Hns(c(y,q),deriv.order=1),Hns(c(y,q),deriv.order=2),Hns(c(y,q),deriv.order=3),Hns(c(y,q),deriv.order=4));
	#h_xyzq=Hns(c(x,y,z,q),deriv.order=0);
	#h_yzq=Hns(c(y,z,q),deriv.order=0);
	#h_xyq=Hns(c(x,y,q),deriv.order=0);
	#h_yq=Hns(c(y,q),deriv.order=0);

	#calculate q2 and sw
	for(i in 1:(length-1)) {
		#calculating density and derivative estimates
		xyzq=kder(cbind(x,y,z,q),h=h_xyzq,cbind(x[i],y[i],z[i],q[i]));
		yzq=kder(cbind(y,z,q),h=h_yzq,cbind(y[i],z[i],q[i]));
		xyq=kder(cbind(x,y,q),h=h_xyq,cbind(x[i],y[i],q[i]));
		yq=kder(cbind(y,q),h=h_yq,cbind(y[i],q[i]));
		
		f_xyzq=xyzq[1][[1]];
		f_yzq=yzq[1][[1]];
		f_xyq=xyq[1][[1]];
		f_yq=yq[1][[1]];

		fd1_xyzq=t(xyzq[2][[1]]);
		fd1_yzq=t(yzq[2][[1]]);
		fd1_xyq=t(xyq[2][[1]]);
		fd1_yq=t(yq[2][[1]]);

		fd2_xyzq=xyzq[3][[1]];
		fd2_yzq=yzq[3][[1]];
		fd2_xyq=xyq[3][[1]];
		fd2_yq=yq[3][[1]];

		trfd3_xyzq=xyzq[4][[1]];
		trfd3_yzq=yzq[4][[1]];
		trfd3_xyq=xyq[4][[1]];
		trfd3_yq=yq[4][[1]];
	
		trfd4_xyzq=xyzq[5][[1]];
		trfd4_yzq=yzq[5][[1]];
		trfd4_xyq=xyq[5][[1]];
		trfd4_yq=yq[5][[1]];
			
		R1_xyzq=t(fd1_xyzq)%*%fd1_xyzq*t(fd1_xyzq)%*%fd1_xyzq/(f_xyzq^3)-5*(t(fd1_xyzq)%*%fd2_xyzq%*%fd1_xyzq^2)/(2*f_xyzq)-(t(fd1_xyzq)%*%(sum(diag(fd2_xyzq))*diag(4)-fd2_xyzq)%*%fd1_xyzq)/(f_xyzq^2) + (sum(diag(t(fd2_xyzq)%*%fd2_xyzq))-B2(fd2_xyzq))/f_xyzq + trfd3_xyzq/f_xyzq;
		R1_yzq=t(fd1_yzq)%*%fd1_yzq*t(fd1_yzq)%*%fd1_yzq/(f_yzq^3)-5*(t(fd1_yzq)%*%fd2_yzq%*%fd1_yzq)/(2*f_yzq^2)-(t(fd1_yzq)%*%(sum(diag(fd2_yzq))*diag(3)-fd2_yzq)%*%fd1_yzq)/(f_yzq^2) + (sum(diag(t(fd2_yzq)%*%fd2_yzq))-B2(fd2_yzq))/f_yzq + trfd3_yzq/f_yzq;
		R1_xyq=t(fd1_xyq)%*%fd1_xyq*t(fd1_xyq)%*%fd1_xyq/(f_xyq^3)-5*(t(fd1_xyq)%*%fd2_xyq%*%fd1_xyq)/(2*f_xyq^2)-(t(fd1_xyq)%*%(sum(diag(fd2_xyq))*diag(3)-fd2_xyq)%*%fd1_xyq)/(f_xyq^2) + (sum(diag(t(fd2_xyq)%*%fd2_xyq))-B2(fd2_xyq))/f_xyq + trfd3_xyq/f_xyq;
		R1_yq=t(fd1_yq)%*%fd1_yq*t(fd1_yq)%*%fd1_yq/(f_yq^3)-5*(t(fd1_yq)%*%fd2_yq%*%fd1_yq)/(2*f_yq^2)-(t(fd1_yq)%*%(sum(diag(fd2_yq))*diag(2)-fd2_yq)%*%fd1_yq)/(f_yq^2) + (sum(diag(t(fd2_yq)%*%fd2_yq))-B2(fd2_yq))/f_yq + trfd3_yq/f_yq;
		
		#summing terms for 2
		q2[i,sim]=4/36*(f_xyzq*f_yq^2);
		sw[i,sim]=1/4*(f_yq*(k2^2*R1_xyzq-k4*trfd4_xyzq)-f_xyq*(k2^2*R1_yzq-k4*trfd4_yzq)+f_xyzq*(k2^2*R1_yq-k4*trfd4_yq)-f_yzq*(k2^2*R1_xyq-k4*trfd4_xyq));	

	}
	print(paste("Simulation number: ",sim,sep=""));
}

write.table(q2, q2File, sep=";", row.names=FALSE, col.names=FALSE, append=TRUE);
write.table(sw, swFile, sep=";", row.names=FALSE, col.names=FALSE, append=TRUE);
