####################################################################################
#
# calculate optimal bandwidth values for the sharpened t-stat
# (require stored simulations of the q2 and sw)
#
# Copyright 2015, Marcin Wolski and Cees Diks
# Software distributed under the GNU Public License 3.0. 
# For details, see `LICENSE.txt'
#
####################################################################################

n=1000; #time series length
a=4; #specify kernel bias
g=4; #number of variables

file_q2=read.table(file=paste("q2_",n,".csv",sep=""),sep=";");
file_sw=read.table(file=paste("sw_",n,".csv",sep=""),sep=";");
q2=mean(as.matrix(file_q2));
sw=mean(as.matrix(file_sw));
C=((18*g*q2)/(2*a*sw^2))^(1/(2*a+g));
eps=C*n^(-2/(2*a+g));
eps
