***********************************************************************************************************
** this do file produces summary statistics
** last update: 04/05/2021
***********************************************************************************************************

clear all
set more off

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

**==============================================================================
use "$working_data/samplePrim.dta", clear

eststo clear
bys male: eststo: quietly estpost summarize age mLiterate mbirthy fLiterate fbirthy, listwise
esttab, cells("count mean(fmt(2)) sd(fmt(2))") label nodepvar fragment replace

merge 1:m pid using $working_data/healthCFPS.dta
keep if _merge == 3
drop _merge

local health "diabetes hypt obesity heart"
foreach var in `health' {
	sum  `var'
	local `var'_mean = r(mean)
	local `var'_sd = r(sd)
	gen std_`var' = (`var' - ``var'_mean')/``var'_sd'
}

gen stdcount1 = (std_diabetes+std_hypt+std_obesity)/3
label variable stdcount1 "Metabolic syndrome(index)"

eststo clear
bys male: eststo: quietly estpost summarize hypt diabetes obesity stdcount1, listwise
esttab, cells("count mean(fmt(2)) sd(fmt(2))") label nodepvar fragment replace

use "$working_data/sampleAux.dta", clear
gen male = 1
expand 2
replace male = 0 in 1/3682

eststo clear
bys male: eststo: quietly estpost summarize mLiterate mbirthy fLiterate fbirthy, listwise
esttab, cells("count mean(fmt(2)) sd(fmt(2))") label nodepvar fragment replace

**==============================================================================
use "$working_data/sampleMatch.dta", clear

eststo clear
bys male: eststo: quietly estpost summarize age mLiterate mbirthy fLiterate fbirthy, listwise
esttab using $out_files/summ4.tex, cells("count mean(fmt(2)) sd(fmt(2))") label nodepvar fragment replace

keep a_aid male
rename a_aid aid
rename male a_male 
merge m:1 aid using "$working_data/sampleAux.dta"
keep if _merge == 3
drop _merge

eststo clear
bys a_male: eststo: quietly estpost summarize mLiterate mbirthy fLiterate fbirthy, listwise
esttab, cells("count mean(fmt(2)) sd(fmt(2))") label nodepvar fragment replace


