***********************************************************************************************************
** this do file produces placebo tests
** last update: 26/09/2021
***********************************************************************************************************

clear all
set more off
set scheme s1mono

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"
set seed 1989

**==============================================================================
use $working_data/sampleHealth.dta, clear
keep if aux == 2

save $working_data/sampleAux.dta, replace

**==============================================================================
use "$working_data/samplePlacebo.dta", clear
keep if placebo == 1

rename pid a_pid

merge m:1 a_pid using "$working_data/famine.dta"
keep if _merge == 3
drop _merge

merge m:1 birthProv using "$working_data/IV1.dta"
keep if _merge == 3
drop _merge

rename a_pid pid
merge 1:m pid using "$working_data/healthCFPS.dta"
keep if _merge == 3
drop _merge

drop age2010
gen time = birthy - 1950
gen age = 2010 - birthy if wave == 1
replace age = 2012 - birthy if wave == 2
replace age = 2014 - birthy if wave == 3
gen age2 = age^2/100

label variable age "Age"
label variable age2 "Age squared(/100)"

local health "diabetes hypt obesity"
foreach var in `health' {
	sum  `var'
	local `var'_mean = r(mean)
	local `var'_sd = r(sd)
	gen std_`var' = (`var' - ``var'_mean')/``var'_sd'
}

gen stdcount1 = (std_diabetes+std_hypt+std_obesity)/3
label variable stdcount1 "Metabolic syndrome(index)"
label variable hunger "Hunger before age 5"

gen logedr = log(edr)
label variable logedr "log(EDR)"
label variable hunger "Hunger before age 5"
label variable fLiterate "Mother literate"

label variable age "Age"
label variable age2 "Age squared(/100)"

gen aux = 1
append using $working_data/sampleAux.dta


*Table 5e
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace keep(hunger) b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)



