***********************************************************************************************************
** this do file generates graphs
** last update: 26/09/2021
***********************************************************************************************************

clear all
set more off
set scheme s1mono

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

**==============================================================================
*** replicate Nancy Qian(2015)
use "$raw_data/province.dta", clear
egen death_mean=mean(deathrate), by(year)
egen death_sd=sd(deathrate), by(year)
g death_sd_norm=death_sd/death_mean
collapse (mean) death_*, by(year)
label var death_mean "Mean Mortality Rates"
label var death_sd_norm "Cross-Province SD/Mean"
twoway (line death_mean year , sort lc(black) lwidth(medthick)), /*
*/ ytitle("Deaths per 1,000") xtitle(Year) xline(1960, lwidth(vthin) lpattern(solid) lcolor(cranberry)) /*
*/ legend(on) graphregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white) ilpattern(blank)) /*
*/ plotregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white)) legend(pos(1) ring(0) col(1))
graph export "$out_files/Fig1a.pdf", replace

use "$raw_data/province.dta", clear
egen death_mean=mean(deathrate), by(year)
egen death_sd=sd(deathrate), by(year)
g death_sd_norm=death_sd/death_mean
collapse (mean) death_*, by(year)
label var death_mean "Mean Mortality Rates"
label var death_sd_norm "Cross-Province SD/Mean"
twoway (line death_sd_norm year, sort lc(gs9) lpattern(dash) lwidth(medthick)), /*
*/ ytitle("Cross-Province SD/Mean") xtitle(Year) xline(1960, lwidth(vthin) lpattern(solid) lcolor(cranberry)) /*
*/ legend(on) graphregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white) ilpattern(blank)) /*
*/ plotregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white)) legend(pos(1) ring(0) col(1))
graph export "$out_files/Fig1b.pdf", replace

use "$raw_data/county.dta", clear
keep if ag==1
egen pop_avg=mean(birpop), by(gb)
gen bpop_rat=birpop/pop_avg
egen bpop_rat_sd=sd(bpop_rat), by(biryr)
collapse (mean) birpop bpop_rat*, by(biryr)
g bpop_rat_sd_norm=bpop_rat_sd/bpop_rat
label var bpop_rat "Cohort Size Ratio"
label var bpop_rat_sd_norm "Cross-County SD/Mean"
twoway (line bpop_rat biryr, sort lc(black) lwidth(medthick)), /*
*/ xline(1959 1961, lcolor(cranberry)) ytitle("Cohort Size / Avg County Cohort Size") xtitle("Birth Year") /*
*/ legend(on) graphregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white) ilpattern(blank)) /*
*/ plotregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white)) legend(pos(11) ring(0) col(1))
graph export "$out_files/Fig1c.pdf", replace

use "$raw_data/county.dta", clear
keep if ag==1
egen pop_avg=mean(birpop), by(gb)
gen bpop_rat=birpop/pop_avg
egen bpop_rat_sd=sd(bpop_rat), by(biryr)
collapse (mean) birpop bpop_rat*, by(biryr)
g bpop_rat_sd_norm=bpop_rat_sd/bpop_rat
label var bpop_rat "Cohort Size Ratio"
label var bpop_rat_sd_norm "Cross-County SD/Mean"
twoway (line bpop_rat_sd_norm biryr, lc(gs9) lpattern(dash) lwidth(medthick) sort), /*
*/ xline(1959 1961, lcolor(cranberry)) ytitle("Cross-County SD/Mean") xtitle("Birth Year") /*
*/ legend(on) graphregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white) ilpattern(blank)) /*
*/ plotregion(fcolor(white) lcolor(none) ifcolor(white) ilcolor(white)) legend(pos(11) ring(0) col(1))
graph export "$out_files/Fig1d.pdf", replace

**==============================================================================
*** save data for later graph
keep bpop_rat biryr
rename biryr birthy
save "$working_data/cohort_census.dta", replace

**==============================================================================
*** replicate Van den Berg(2018)
use "$working_data/famine.dta", clear

gen famineAge = 1962 - birthy
bysort famineAge male: gen totalSize = _N
egen hungerSize = sum(hunger), by(famineAge male)
gen probHunger = hungerSize/totalSize

gen low = 0
gen high = 0.4

twoway (rarea low high famineAge if famineAge>=-1&famineAge<=5, sort color(black%20)) /*
*/ (line probHunger famineAge if famineAge>=-1&famineAge<=35&male==1, lcolor(black) lw(medthick)) /*
*/ (line probHunger famineAge if famineAge>=-1&famineAge<=35&male==0, lp(dash) lcolor(gs9) lw(medthick)), /*
*/ xsc(r(-1 35)) xlabel(0(5)35) xtitle("Age at 1962 (end of the famine)") /*
*/ ytitle("% Reporting Hunger (by gender)") text(0.38 2 "Exposed") text(0.36 2 "Sample") /*
*/ legend(pos(5) ring(0) col(1) order(2 "Male" 3 "Female"))

graph export "$out_files/Fig2.pdf", replace

**==============================================================================
use $working_data/sampleMatch.dta, clear

gen logedr = log(edr)

regress hunger edr, cl(birthProv)
test edr
binscatter hunger edr, absorb(fLiterate) lc(cranberry) color(black) /*
*/ ytitle(% Reporting Hunger) xtitle(EDR (per 1000)) text(0.6 21 "F-stat = 8.39") /*
*/ ylabel(0(.1).6)
graph export "$out_files/Fig3a.pdf", replace

regress hunger logedr, cl(birthProv)
test logedr
binscatter hunger logedr, absorb(fLiterate) lc(cranberry) color(black)/*
*/  ytitle(% Reporting Hunger) xtitle(log(EDR)) text(0.6 1.3 "F-stat = 24.36") /*
*/ ylabel(0(.1).6)
graph export "$out_files/Fig3b.pdf", replace

**==============================================================================
use "$working_data/sampleRural.dta", clear
keep if birthy >= 1950 & birthy <= 1966

egen pop = count(pid)
bysort birthy: egen birpop = count(pid)
replace pop = pop/18
gen birpop_n = birpop/pop

keep birpop_n birthy
duplicates drop

merge 1:1 birthy using "$working_data/cohort_census.dta"

twoway (line birpop_n birthy, sort lc(black) lwidth(medthick)) /*
*/ (line bpop_rat birthy, sort lc(gs9) lpattern(dash) lwidth(medthick)), /*
*/ xline(1959 1961, lcolor(cranberry)) xsc(r(1950 1966)) xlabel(1950(5)1965) /*
*/ legend(order(1 "Our data (CFPS-2010)" 2 "Meng et al. (2015) (Census1990)")) /*
*/ ytitle("Cohort Size / Avg Cohort Size") /*
*/ xtitle("Year(Birth Year)")
graph export "$out_files/Figb1.pdf", replace

**==============================================================================
use "$working_data/sampleRural.dta", clear
keep if birthy >= 1950 & birthy <= 1966

bys mLiterate: egen pop = count(pid)
bysort mLiterate birthy: egen birpop = count(pid)
keep birpop birthy mLiterate pop
duplicates drop

gen birthy_mlit = birthy*mLiterate
regress birpop birthy mLiterate c.birthy#c.mLiterate
predict birpop_h
gen gap = birpop/birpop_h

twoway (line gap birthy if mLiterate == 1, sort lc(black) lwidth(medthick)) /*
*/ (line gap birthy if mLiterate == 0, sort lc(gs9) lpattern(dash) lwidth(medthick)), /*
*/ xline(1959 1961, lcolor(cranberry)) xsc(r(1950 1966)) xlabel(1950(5)1965) /*
*/ legend(order(1 "Mother's Literacy == 1" 2 "Mother's Literacy == 0")) /*
*/ ytitle("Cohort Size / Avg Cohort Size (Detrended)") xtitle("Year(Birth Year)")
graph export "$out_files/Fig6.pdf", replace

**==============================================================================
use "$working_data/conley.dta", clear

gen grid = 0.001*(_n-1)
gen up = mean + 1.645*var
gen down = mean - 1.645*var
twoway (line mean grid, lcolor(cranberry)) /*
*/ (lowess up grid, lpattern(dash) lcolor(black)) /*
*/ (lowess down grid, lpattern(dash) lcolor(black)), /*
*/ legend(order(1 "Point Estimate" 2 "90% CI")) /*
*/ scheme(s1color) title("Union of Conﬁdence Interval") /*
*/ ytitle({&gamma}) xtitle({&lambda})
graph export "$out_files/Fig4.pdf", replace



