***********************************************************************************************************
** this do file constructs health data from CFPS data file 
** last update: 04/05/2021
***********************************************************************************************************

clear all
set more off

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

**==============================================================================
use $raw_data/cfps2010adult.dta, clear

gen male = gender

gen height = qp1
drop if height < 0
gen weight = qp2/2
drop if weight < 0
gen bmi = weight/((height/100)^2)

gen selfReport = qp301
replace selfReport = . if selfReport < 1
*gen vignette1 = qp2031
*gen vignette2 = qp2032

destring qp501acode qp501bcode, replace
gen chronic = (qp5 == 1)
gen diabetes = (qp501acode == 5.37 | qp501bcode == 5.37)
gen hypt = (qp501acode == 11.66 | qp501bcode == 11.66)
gen obesity = (bmi > 30)
gen heart = ((qp501acode >= 11.60 & qp501acode <= 11.65) | (qp501bcode >= 11.60 & qp501bcode <= 11.65))
gen hospiVisit = (qp6 == 1)
gen hospiVisitN = qp601
replace hospiVisitN = 0 if hospiVisit == 0

gen goodHealth = (selfReport == 1)

gen heightAbovemed = 0
replace heightAbovemed = 1 if height >= 169 & male == 1
replace heightAbovemed = 1 if height >= 160 & male == 0
replace heightAbovemed = . if height == .

gen heightAbove75p = 0
replace heightAbove75p = 1 if height >= 172 & male == 1
replace heightAbove75p = 1 if height >= 162 & male == 0
replace heightAbove75p = . if height== .

gen heightBelow5p = 0
replace heightBelow5p = 1 if height < 158 & male == 1
replace heightBelow5p = 1 if height < 150 & male == 0
replace heightBelow5p = . if height== .

gen everSmoked = (qq2 == 1 | qq211 == 1)
gen smokeNow = (qq2 == 1)
gen drinks3plus = (qq3 == 1 | qq211 == 1)
gen drinkNow = (qq3 == 1)

keep pid height weight bmi selfReport chronic diabetes hypt obesity heart hospiVisit* ///
	goodHealth heightAbove* heightBelow5p everSmoked smokeNow drinkNow drinks3plus

gen wave = 1
label variable wave "Wave"

label variable height "Height"
label variable weight "Weight"
label variable bmi "BMI"
label variable selfReport "Reported health"
label variable chronic "Chronic"
label variable diabetes "Diabetes"
label variable hypt "Hypertension"
label variable obesity "Obesity"
label variable heart "Heart disease"
label variable hospiVisit "Hospital visit"
label variable hospiVisitN "Hospital visit N"

save $working_data/healthCFPS10.dta, replace

**==============================================================================
use $raw_data/cfps2012adult.dta

gen male = cfps2012_gender_best

gen height = qp101
drop if height < 0
gen weight = qp102/2
drop if weight < 0
gen bmi = weight/((height/100)^2)

gen selfReport = qp201
replace selfReport = . if selfReport < 1
gen vignette1 = qp2031
gen vignette2 = qp2032
replace vignette1 = . if vignette1 < 0
replace vignette2 = . if vignette2 < 0

destring qp403a qp403b, replace
gen chronic = (qp401 == 1)
gen diabetes = (qp403a == 5.37 | qp403b == 5.37)
gen hypt = (qp403a == 11.66 | qp403b == 11.66)
gen obesity = (bmi > 30)
gen heart = ((qp403a >= 11.60 & qp403a <= 11.65) | (qp403b >= 11.60 & qp403b <= 11.65))
gen hospiVisit = (qp501 == 1)
gen hospiVisitN = qp502
replace hospiVisitN = 0 if hospiVisit == 0

gen goodHealth = (selfReport == 1)
gen vig1Good = (vignette1 == 1)
gen vig2Good = (vignette2 == 1)

gen heightAbovemed = 0
replace heightAbovemed = 1 if height >= 169 & male == 1
replace heightAbovemed = 1 if height >= 160 & male == 0
replace heightAbovemed = . if height == .

gen heightAbove75p = 0
replace heightAbove75p = 1 if height >= 172 & male == 1
replace heightAbove75p = 1 if height >= 162 & male == 0
replace heightAbove75p = . if height== .

gen heightBelow5p = 0
replace heightBelow5p = 1 if height < 158 & male == 1
replace heightBelow5p = 1 if height < 150 & male == 0
replace heightBelow5p = . if height== .

gen everSmoked = (qq201 == 1 | qq204 == 1)
gen smokeNow = (qq201 == 1)
gen drinks3plus = (qq301 == 1 | qq305 == 1)
gen drinkNow = (qq301 == 1)

keep pid height weight bmi selfReport vig* chronic diabetes hypt obesity heart hospiVisit* ///
	goodHealth heightAbove* heightBelow5p everSmoked smokeNow drinkNow drinks3plus

gen wave = 2
label variable wave "Wave"

label variable height "Height"
label variable weight "Weight"
label variable bmi "BMI"
label variable selfReport "Reported health"
label variable chronic "Chronic"
label variable diabetes "Diabetes"
label variable hypt "Hypertension"
label variable obesity "Obesity"
label variable heart "Heart disease"
label variable hospiVisit "Hospital visit"
label variable hospiVisitN "Hospital visit N"

save $working_data/healthCFPS12.dta, replace

**==============================================================================
use $raw_data/cfps2014adult.dta, clear

gen male = cfps_gender

gen height = qp101
drop if height < 0
gen weight = qp102/2
drop if weight < 0
gen bmi = weight/((height/100)^2)

gen selfReport = qp201
replace selfReport = . if selfReport < 1
gen vignette1 = qp2031
gen vignette2 = qp2032
replace vignette1 = . if vignette1 < 0
replace vignette2 = . if vignette2 < 0

destring qp402acode qp402bcode, replace
gen chronic = (qp401 == 1)
gen diabetes = (qp402acode == 5.37 | qp402bcode == 5.37)
gen hypt = (qp402acode == 11.66 | qp402bcode == 11.66)
gen obesity = (bmi > 30)
gen heart = ((qp402acode >= 11.60 & qp402acode <= 11.65) | (qp402bcode >= 11.60 & qp402bcode <= 11.65))
gen hospiVisit = (qp501 == 1)
gen hospiVisitN = hospiVisit
*replace hospiVisitN = 0 if hospiVisit == 0

gen goodHealth = (selfReport == 1)
gen vig1Good = (vignette1 == 1)
gen vig2Good = (vignette2 == 1)

gen heightAbovemed = 0
replace heightAbovemed = 1 if height >= 169 & male == 1
replace heightAbovemed = 1 if height >= 160 & male == 0
replace heightAbovemed = . if height == .

gen heightAbove75p = 0
replace heightAbove75p = 1 if height >= 172 & male == 1
replace heightAbove75p = 1 if height >= 162 & male == 0
replace heightAbove75p = . if height== .

gen heightBelow5p = 0
replace heightBelow5p = 1 if height < 158 & male == 1
replace heightBelow5p = 1 if height < 150 & male == 0
replace heightBelow5p = . if height== .

gen everSmoked = (qq201 == 1 | qq204 == 1)
gen smokeNow = (qq201 == 1)
gen drinkNow = (qq301 == 1)

keep pid height weight bmi selfReport vig* chronic diabetes hypt obesity heart hospiVisit* ///
	goodHealth heightAbove* heightBelow5p everSmoked smokeNow drinkNow

gen wave = 3
label variable wave "Wave"

label variable height "Height"
label variable weight "Weight"
label variable bmi "BMI"
label variable selfReport "Reported health"
label variable chronic "Chronic"
label variable diabetes "Diabetes"
label variable hypt "Hypertension"
label variable obesity "Obesity"
label variable heart "Heart disease"
label variable hospiVisit "Hospital visit"
label variable hospiVisitN "Hospital visit N"

save $working_data/healthCFPS14.dta, replace

**==============================================================================
use $working_data/healthCFPS14.dta, clear
append using $working_data/healthCFPS12.dta
append using $working_data/healthCFPS10.dta

label variable pid
label values pid
tostring pid, replace
save $working_data/healthCFPS.dta, replace

