* This file was created by Adeline Delavande on September 29, 2009
* to look at the boat owner expectations data

use "C:\Data\Boatowner\fish_dat.dta", clear

* Rescale questions 1 to 5 from 0 to 1

foreach i in 1 2 3 4 5 {
gen Pq`i'=q`i'/10 if version<=4
replace Pq`i'=q`i'/20 if version>4
}

forval i=1/20 {
gen Paug_catchdist`i'=aug_catchdist`i'/10 if version<=4
replace Paug_catchdist`i'=aug_catchdist`i'/20 if version>4
}

gen sumdistr=0

forval i=1/20 {
replace sumdistr=sumdistr+ aug_catchdist`i'
}
tab sumdistr


foreach i in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 {
gen Pq10_`i'=q10_`i'/10   if version<=4
replace Pq10_`i'=q10_`i'/20 if version>4
}

gen sumdistr_friend=0

foreach i in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 {
replace sumdistr_friend=sumdistr_friend + Pq10_`i'
}
tab sumdistr_friend
replace sumdistr_friend=1  if sumdistr_friend >=0.9 & sumdistr_friend <=1.01

foreach i in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 {
replace Pq10_`i'=. if sumdistr_friend~=1
}

foreach i in 1 2 3 4 5 6 7 8 9 {
rename Pq10_0`i' Pq10_`i'
}

forval i=1/20 {
gen difownfriend`i'=Paug_catchdist`i' - Pq10_`i'
}



forval i=1/4 {
gen Paug_catchrange`i'=aug_catchrange`i'/10 if version<=4 & sumdistr==10
replace Paug_catchrange`i'=aug_catchrange`i'/20 if version>4 & sumdistr==20
}


gen diffnest=Pq3-Pq2

* create the CDF of friends' catches
gen CDFq10_1=Pq10_1
forval i=1/19 {
local v=`i'+1

gen CDFq10_`v'=CDFq10_`i'+Pq10_`v'

}

* determine in which interval the min, P25, midpoint, p75 and max are

	** delete non-usable distributions (3 observations)
foreach var in min_earn p25 midpoint p75  max_earn {
replace `var'=. if sumdistr==0 | sumdistr==14
}


foreach var in min_earn p25 midpoint p75  max_earn {

gen loc`var'=1 if `var'<=150
replace loc`var'=2 if `var'>150 & `var'<=300
replace loc`var'=3 if `var'>300 & `var'<=450
replace loc`var'=4 if `var'>450 & `var'<=600
replace loc`var'=5 if `var'>600 & `var'<=750
replace loc`var'=6 if `var'>750 & `var'<=900
replace loc`var'=7 if `var'>900 & `var'<=1050
replace loc`var'=8 if `var'>1050 & `var'<=1200
replace loc`var'=9 if `var'>1200 & `var'<=1350
replace loc`var'=10 if `var'>1350 & `var'<=1500
replace loc`var'=11 if `var'>1500 & `var'<=1650
replace loc`var'=12 if `var'>1650 & `var'<=1800
replace loc`var'=13 if `var'>1800 & `var'<=1950
replace loc`var'=14 if `var'>1950 & `var'<=2100
replace loc`var'=15 if `var'>2100 & `var'<=2500
replace loc`var'=16 if `var'>2500 & `var'<=3000
replace loc`var'=17 if `var'>3000 & `var'<=3500
replace loc`var'=18 if `var'>3500 & `var'<=4000
replace loc`var'=19 if `var'>4000 & `var'<=5000
replace loc`var'=20 if `var'>5000  & `var'<.

}


* generate variables for the thresholds of the common support
 gen tr0=0
 gen tr1 =     150 
 gen tr2 =     300 
 gen tr3 =     450 
 gen tr4 =     600 
 gen tr5 =     750 
 gen tr6 =     900 
 gen tr7 =     1050 
 gen tr8 =     1200 
 gen tr9 =     1350
 gen tr10 =     1500
 gen tr11 =     1650
 gen tr12 =     1800
 gen tr13 =     1950
 gen tr14 =     2100
 gen tr15 =     2500
 gen tr16 =     3000
 gen tr17 =     3500
 gen tr18 =     4000
 gen tr19 =     5000    

* determine the number of bins used in the fixed support
gen nCbins=0
forval i=1/20 {
replace nCbins=nCbins+1 if Paug_catchdist`i'>0 & Paug_catchdist`i'<.
}
replace nCbins=. if sumdistr==0 | sumdistr==14
tab nCbins

gen nIbins=0
forval i=1/4 {
replace nIbins=nIbins+1 if Paug_catchrange`i'>0 & Paug_catchrange`i'<.
}
replace nIbins=. if sumdistr==0 | sumdistr==14
tab nIbins

* determine the number of bins in the friend's support
gen nbinsfriend=0
forval i=1/20 {
replace nbinsfriend=nbinsfriend+1 if Pq10_`i'>0 & Pq10_`i'<.
}
replace nbinsfriend=. if sumdistr_friend~=1
replace nbinsfriend=. if sumdistr==0 | sumdistr==14


* determine the probability mass in the intervals of the fixed support that contain [min,P25], [P25, midpoint], [midpoint, P75], 
* for this, let's first do the cdf of the fixed support

gen CDFaug_catchdist1=Paug_catchdist1
forval i=1/19 {
local v=`i'+1

gen CDFaug_catchdist`v'=CDFaug_catchdist`i'+Paug_catchdist`v'

}

* check that no respondent has [min,P25], [P25, midpoint], [midpoint, P75], [P75, max] contained in one of the interval of the fixed support
count if locmin_earn==locp25 & min_earn ~=.
count if locmidpoint==locp25 & min_earn ~=.
count if locmidpoint==locp75 & min_earn ~=.
count if locmax_earn==locp75 & min_earn ~=.

gen Pinminp25=.
forval i=1/20 {
	forval j=1/20 {
replace Pinminp25=CDFaug_catchdist`i'-CDFaug_catchdist`j' if `j'==locmin_earn-1 & `i'==locp25 &  locmin_earn~=1
replace Pinminp25=CDFaug_catchdist`i' if `i'==locp25 &  locmin_earn==1
	}
}

gen Pinp25midpoint=.
forval i=1/20 {
	forval j=1/20 {
replace Pinp25midpoint=CDFaug_catchdist`i'-CDFaug_catchdist`j' if `j'==locp25-1 & `i'==locmidpoint 
	}
}

gen Pinmidpointp75=.
forval i=1/20 {
	forval j=1/20 {
replace Pinmidpointp75=CDFaug_catchdist`i'-CDFaug_catchdist`j' if `j'==locmidpoint-1 & `i'==locp75
	}
}

gen Pinp75max=.
forval i=1/20 {
	forval j=1/20 {
replace Pinp75max=CDFaug_catchdist`i'-CDFaug_catchdist`j' if `j'==locp75-1 & `i'==locmax & locp75~=locmax
replace Pinp75max=Paug_catchdist`i' if `i'==locmax & locp75==locmax

	}
}


gen Cfirst=1 if version==1 | version==2 | version==5 | version==6
replace Cfirst=0 if Cfirst==.

gen n10stones=1 if version <=4
replace n10stones=0 if version>4

** Make the 2 distributions more comparable: i.e., regroup the probability mass of the common support into 4 bins such that the edge are the closest possible to the
*individual-specific support

* Lower bound is 0 for everyone

* determine the "new" thresholds when the support has only 4 bins, and the probability mass in each of the bins
gen newtr1=.
gen PCaug_catchrange1=.
forval i=2/19 {
local j=`i'-1


replace newtr1=tr`i' if locp25==`i' & abs(p25-tr`i')<=abs(p25-tr`j')
replace newtr1=tr`j' if locp25==`i' & abs(p25-tr`i')>abs(p25-tr`j')

replace PCaug_catchrange1=   CDFaug_catchdist`i' if locp25==`i' & abs(p25-tr`i')<=abs(p25-tr`j')
replace PCaug_catchrange1=   CDFaug_catchdist`j' if locp25==`i' & abs(p25-tr`i')>abs(p25-tr`j')

}


gen newtr2=.
gen PCaug_catchrange2=.
forval i=2/19 {
local j=`i'-1


replace newtr2=tr`i' if locmidpoint==`i' & abs(midpoint-tr`i')<=abs(midpoint-tr`j')
replace newtr2=tr`j' if locmidpoint==`i' & abs(midpoint-tr`i')>abs(midpoint-tr`j')

replace PCaug_catchrange2=   CDFaug_catchdist`i' - PCaug_catchrange1 if locmidpoint==`i' & abs(midpoint-tr`i')<=abs(midpoint-tr`j')
replace PCaug_catchrange2=   CDFaug_catchdist`j' - PCaug_catchrange1 if locmidpoint==`i' & abs(midpoint-tr`i')>abs(midpoint-tr`j')

}

gen newtr3=.
gen PCaug_catchrange3=.
forval i=2/19 {
local j=`i'-1


replace newtr3=tr`i' if locp75==`i' & abs(p75-tr`i')<=abs(p75-tr`j')
replace newtr3=tr`j' if locp75==`i' & abs(p75-tr`i')>abs(p75-tr`j')

replace PCaug_catchrange3=   CDFaug_catchdist`i' - PCaug_catchrange2 - PCaug_catchrange1 if locp75==`i' & abs(p75-tr`i')<=abs(p75-tr`j')
replace PCaug_catchrange3=   CDFaug_catchdist`j' - PCaug_catchrange2 - PCaug_catchrange1 if locp75==`i' & abs(p75-tr`i')>abs(p75-tr`j')
}

replace newtr3=5000 if locp75==20
replace PCaug_catchrange3=CDFaug_catchdist19 - PCaug_catchrange2 - PCaug_catchrange1 if locp75==20


gen PCaug_catchrange4=1-PCaug_catchrange3-PCaug_catchrange2 - PCaug_catchrange1 

forval i=1/4 {
replace PCaug_catchrange`i'=round(PCaug_catchrange`i',0.01)
} 

* Allocate the friend's distribution into the same 4 supports

gen PCq10_1=.
forval i=2/19 {
local j=`i'-1
replace PCq10_1=   CDFq10_`i' if locp25==`i' & abs(p25-tr`i')<=abs(p25-tr`j')
replace PCq10_1=   CDFq10_`j' if locp25==`i' & abs(p25-tr`i')>abs(p25-tr`j')
}

gen PCq10_2=.
forval i=2/19 {
local j=`i'-1

replace PCq10_2=   CDFq10_`i' - PCq10_1 if locmidpoint==`i' & abs(midpoint-tr`i')<=abs(midpoint-tr`j')
replace PCq10_2=   CDFq10_`j' - PCq10_1 if locmidpoint==`i' & abs(midpoint-tr`i')>abs(midpoint-tr`j')

}


gen PCq10_3=.
forval i=2/19 {
local j=`i'-1

replace PCq10_3=   CDFq10_`i' - PCq10_2 - PCq10_1 if locp75==`i' & abs(p75-tr`i')<=abs(p75-tr`j')
replace PCq10_3=   CDFq10_`j' - PCq10_2 - PCq10_1 if locp75==`i' & abs(p75-tr`i')>abs(p75-tr`j')
}

replace PCq10_3=CDFq10_19 - PCq10_2- PCq10_1 if locp75==20

gen PCq10_4=1-PCq10_3-PCq10_2- PCq10_1

forval i=1/4 {
replace PCq10_`i'= round(PCq10_`i',0.01)
}

forval i=1/4 {
gen difPCownfriend`i'=PCaug_catchrange`i' - PCq10_`i'
}

* probability mass before the min and after the max?

gen Pbelowmin=.
forval i=2/3 {
local j=`i'-1
replace Pbelowmin= CDFaug_catchdist`j' if locmin_earn==`i'
}
replace Pbelowmin=0 if Pbelowmin==.
replace Pbelowmin=. if sumdistr==0 | sumdistr==14

gen Pabovemax=.
forval i=1/19 {
replace Pabovemax=CDFaug_catchdist20- CDFaug_catchdist`i' if locmax_earn==`i'
}

replace Pabovemax=0 if Pabovemax==.
replace Pabovemax=. if sumdistr==0 | sumdistr==14

* create indicator for min first
gen minfirst=1 if version==2 | version==4 | version==6 | version==8
replace minfirst=0 if version==1 | version==3 | version==5 | version==7
replace minfirst=0 if sumdistr==0 | sumdistr==14

* create probability mass for pre-determined support by collapsing the bins
gen Paug_catchdist_12=Paug_catchdist1+Paug_catchdist2
gen Paug_catchdist_310=Paug_catchdist3+Paug_catchdist4+Paug_catchdist5+Paug_catchdist6+Paug_catchdist7+Paug_catchdist8+Paug_catchdist9+Paug_catchdist10
gen Paug_catchdist_1118=Paug_catchdist11+Paug_catchdist12+Paug_catchdist13+Paug_catchdist14+Paug_catchdist15+Paug_catchdist16+Paug_catchdist17+Paug_catchdist18
gen Paug_catchdist_1920=Paug_catchdist19+Paug_catchdist20


* generate means of the distribution under the uniform assumption within each bin
** start with the common support distribution
* assume that right outer bin is bounded to 6000

gen tr20 =     6500    

gen Cmean=0
forval i=1/20 {
local j=`i'-1
replace Cmean=Cmean + Paug_catchdist`i'* (tr`i' + tr`j')/2
}
replace Cmean=. if sumdistr==0 | sumdistr==14


gen Imean=Paug_catchrange1 * (min_earn + p25)/2 +  Paug_catchrange2 * (p25 + midpoint )/2 + Paug_catchrange3 * (p75 + midpoint )/2  + Paug_catchrange4 * (p75 + max_earn)/2 
replace Imean=. if sumdistr==0 | sumdistr==14


* generate the median of the distribution under the uniform assumption within each bin
gen locmedian=.
replace locmedian=1 if CDFaug_catchdist1>=0.5
forval i=2/19 {
local j=`i'-1
replace locmedian=`i' if CDFaug_catchdist`j'<0.5 & CDFaug_catchdist`i'>=0.5
}
 
replace locmedian=. if sumdistr==0 | sumdistr==14


gen Cmedian=.
forval i=2/17 {
local j=`i'-1
replace Cmedian=tr`j'+ ( (tr`i'-tr`j') * (0.5-CDFaug_catchdist`j') ) / (CDFaug_catchdist`i'-CDFaug_catchdist`j') if locmedian==`i'
}

gen CDFcatchrange1=Paug_catchrange1
gen CDFcatchrange2=CDFcatchrange1 + Paug_catchrange2
gen CDFcatchrange3=CDFcatchrange2 + Paug_catchrange3
gen CDFcatchrange4=CDFcatchrange3 + Paug_catchrange4
forval i=1/4 {
replace CDFcatchrange`i'=round(CDFcatchrange`i',0.01)
} 



gen locmedianI=.
replace locmedianI=1 if Paug_catchrange1>=0.5
forval i=2/4 {
local j=`i'-1
replace locmedianI=`i' if CDFcatchrange`j'<0.5 & CDFcatchrange`i'>=0.5
}
replace locmedianI=. if sumdistr==0 | sumdistr==14

gen T0=min_earn
gen T1=  p25 
gen T2= midpoint
gen T3= p75
gen T4= max_earn

gen CDFcatchrange0=0
gen Imedian=.
forval i=1/4 {
local j=`i'-1
replace Imedian=T`j'+ ( (T`i'-T`j') * (0.5-CDFcatchrange`j') ) / (CDFcatchrange`i'-CDFcatchrange`j') if locmedianI==`i'
}


 log using C:\Data\Boatowner\understandprob.log, replace

******************************
* INTRODUCTION
******************************


************* red and blue fishes **********
* correct answer is 0.2
tab Pq1

************* nested events**********

* Pr of going to town in next 2 days
tab Pq2

* Pr of going to town in next 2 weeks
tab Pq3

* difference Pq3-Pq2
tab diffnest

*********** Zero probability event**********
tab Pq4

*********** Certain event**********
tab Pq5


******************************
* Does being asked about the common support first influence what people say for min and max?
******************************
tab version if Cfirst==1
tab version if Cfirst==0

tabstat min_earn max_earn if Cfirst==1, stat(p5 p25 p50 p75 p95 mean N)
tabstat min_earn max_earn if Cfirst==0, stat(p5 p25 p50 p75 p95 mean N)

******************************
* Does the ordering of the min and max matter?
******************************
tabstat min_earn max_earn if minfirst==1, stat(p5 p25 p50 p75 p95 mean N)
tabstat min_earn max_earn if minfirst==0, stat(p5 p25 p50 p75 p95 mean N)

ttest max_earn, by(minfirst)
ttest min_earn, by(minfirst)

 
ksmirnov max_earn, by(minfirst)
ksmirnov min_earn, by(minfirst)

ranksum max_earn, by(minfirst)
ranksum min_earn, by(minfirst)

median max_earn, by(minfirst)
median min_earn, by(minfirst)

*******************************************************************************
* COMPARE THE TWO DISTRIBUTIONS (FIXED SUPPORT VS. INDIVIDUAL-SPECIFIC SUPPORT
*******************************************************************************

** overal range for the individual-specific support
tabstat min_earn max_earn , stat(p5 p25 p50 p75 p95 mean N)


** How do the 2 different elicited distributions look like?

* individual specific support
tabstat Paug_catchrange1 Paug_catchrange2 Paug_catchrange3 Paug_catchrange4, stat(p5 p25 p50 p75 p95 mean N)

* fixed support rescaled in 4 bins with similar thresholds as the individual-specific support distribution
tabstat PCaug_catchrange*, stat(p5 p25 p50 p75 p95 mean N)

* fixed support (20 bins)
tabstat Paug_catchdist* if( sumdistr==10 | sumdistr==20) , stat(p5 p25 p50 p75 p95 mean N)

* compare the fitted means at the treatment group level 
tabstat Cmean if Cfirst==1, stat(p5 p25 p50 p75 p95 mean sd N)
tabstat Imean if Cfirst==0, stat(p5 p25 p50 p75 p95 mean sd N)

gen poolmean=Cmean if Cfirst==1
replace poolmean=Imean if Cfirst==0

ttest poolmean, by(Cfirst)
median poolmean, by(Cfirst)
ksmirnov poolmean, by(Cfirst)
ranksum poolmean, by(Cfirst)

 
* compare the fitted means at the treatment group level 
tabstat Cmedian if Cfirst==1, stat(p5 p25 p50 p75 p95 mean sd N)
tabstat Imedian if Cfirst==0, stat(p5 p25 p50 p75 p95 mean sd N)

gen poolmedian=Cmedian if Cfirst==1
replace poolmedian=Imedian if Cfirst==0

ttest poolmedian, by(Cfirst)
median poolmedian, by(Cfirst)
ksmirnov poolmedian, by(Cfirst)
ranksum poolmedian, by(Cfirst)



*******************************************************************************
* 10 stones vs. 20 stones
*******************************************************************************

* the going to town questions
tabstat Pq2 if n10stones==1, stat(p5 p25 p50 p75 p95 mean iqr sd N)
tabstat Pq2 if n10stones==0, stat(p5 p25 p50 p75 p95 mean iqr sd N)

tabstat Pq3 if n10stones==1, stat(p5 p25 p50 p75 p95 mean iqr sd N)
tabstat Pq3 if n10stones==0, stat(p5 p25 p50 p75 p95 mean iqr sd N)

forval i=2/3 {
display "*************"
display "Pq`i'"
ttest Pq`i', by(n10stones)
ksmirnov Pq`i', by(n10stones)
ranksum Pq`i', by(n10stones)
median Pq`i', by(n10stones)

}

* do the indvidual-specific distributions look different?
tabstat Paug_catchrange1 Paug_catchrange2 Paug_catchrange3 Paug_catchrange4 if n10stones==1, stat(p5 p25 p50 p75 p95 mean sd N)
tabstat Paug_catchrange1 Paug_catchrange2 Paug_catchrange3 Paug_catchrange4 if n10stones==0, stat(p5 p25 p50 p75 p95 mean sd N)

forval i=1/4 {
display "*********************"
display "Paug_catchrange`i'"
ttest Paug_catchrange`i', by(n10stones)
ksmirnov Paug_catchrange`i', by(n10stones)
ranksum Paug_catchrange`i', by(n10stones)
median Paug_catchrange`i', by(n10stones)
}

* do the common support (on 4 bins) look different?
tabstat PCaug_catchrange* if n10stones==1, stat(p5 p25 p50 p75 p95 mean iqr sd N)
tabstat PCaug_catchrange* if n10stones==0, stat(p5 p25 p50 p75 p95 mean iqr sd N)

forval i=1/4 {
display "*********************"
display "PCaug_catchrange`i'"
ttest PCaug_catchrange`i', by(n10stones)
ksmirnov PCaug_catchrange`i', by(n10stones)
ranksum PCaug_catchrange`i', by(n10stones)
median PCaug_catchrange`i', by(n10stones)
}

* Do common support (on equally collapsed bins):
tabstat Paug_catchdist_12 Paug_catchdist_310  Paug_catchdist_1118 Paug_catchdist_1920 if n10stones==1, stat(p5 p25 p50 p75 p95 mean iqr sd N)
tabstat Paug_catchdist_12 Paug_catchdist_310  Paug_catchdist_1118 Paug_catchdist_1920 if n10stones==0, stat(p5 p25 p50 p75 p95 mean iqr sd N)

foreach i in 12 310 1118 1920 {
display " *********************** "
display " Paug_catchdist_`i' "
ttest Paug_catchdist_`i', by(n10stones)
median Paug_catchdist_`i', by(n10stones)
ksmirnov Paug_catchdist_`i', by(n10stones)
ranksum Paug_catchdist_`i', by(n10stones)
}


* number of bins used in the common support
tabstat nCbins if n10stones==1, stat(p5 p25 p50 p75 p95 mean sd N)
tabstat nCbins if n10stones==0, stat(p5 p25 p50 p75 p95 mean sd N)

ttest nCbins, by(n10stones)
median nCbins, by(n10stones)
ksmirnov nCbins, by(n10stones)
ranksum nCbins, by(n10stones)


*******************************************************************************
* Common support first vs. after
*******************************************************************************

* do the indvidual-specific distributions look different?
tabstat Paug_catchrange1 Paug_catchrange2 Paug_catchrange3 Paug_catchrange4 if Cfirst==1, stat(p5 p25 p50 p75 p95 mean N)
tabstat Paug_catchrange1 Paug_catchrange2 Paug_catchrange3 Paug_catchrange4 if Cfirst==0, stat(p5 p25 p50 p75 p95 mean N)

* do the common support (on 4 bins) look different?
tabstat PCaug_catchrange* if Cfirst==1, stat(p5 p25 p50 p75 p95 mean N)
tabstat PCaug_catchrange* if Cfirst==0, stat(p5 p25 p50 p75 p95 mean N)

* do the common support (on 20 bins) look different

tabstat Paug_catchdist* if( sumdistr==10 | sumdistr==20) &  Cfirst==1, stat(p5 p25 p50 p75 p95 mean N)
tabstat Paug_catchdist* if( sumdistr==10 | sumdistr==20) &  Cfirst==0, stat(p5 p25 p50 p75 p95 mean N)


* number of bins used in the common support
tabstat nCbins if Cfirst==1, stat(p5 p25 p50 p75 p95 mean N)
tabstat nCbins if Cfirst==0, stat(p5 p25 p50 p75 p95 mean N)

** compare the distributions that were asked first (on 4 bins)
tabstat PCaug_catchrange* if Cfirst==1, stat(mean sd p5 p25 p50 p75 p95 N)
tabstat Paug_catchrange1 Paug_catchrange2 Paug_catchrange3 Paug_catchrange4 if Cfirst==0, stat(mean  sd p5 p25 p50 p75 p95 N)

foreach i in 1 2 3 4 {
gen compdist`i'=PCaug_catchrange`i' if Cfirst==1
replace compdist`i'=Paug_catchrange`i' if Cfirst==0
}

foreach i in 1 2 3 4 {
display "*******************"
display "compdist`i'"
ttest compdist`i', by(Cfirst)
median compdist`i', by(Cfirst)
ksmirnov compdist`i', by(Cfirst)
ranksum compdist`i', by(Cfirst)

}


*******************************************************************************
* Probability mass below the elicited min and above the elicited max?
*******************************************************************************
tab Pbelowmin
tab Pabovemax

*******************************************************************************
* Consistency of answers between the 2 elicited distributions
*******************************************************************************

* We look at the intervals that contain [min,P25], [P25, midpoint], [midpoint, P75], [P75, max]  and check whether Rs provide coherent answers across the two support
* we expect  aug_catchrange1<= Prob in [min,P25]
* 		 aug_catchrange2<= Prob in [P25, midpoint]
* 		 aug_catchrange3<= Prob in [midpoint, P75]
* 		 aug_catchrange4<= Prob in [midpoint, P75]


gen difP1=Pinminp25-	   Paug_catchrange1
gen difP2=Pinp25midpoint - Paug_catchrange2
gen difP3=Pinmidpointp75 - Paug_catchrange3
gen difP4=Pinp75max - Paug_catchrange4


tab difP1
tab difP2
tab difP3
tab difP4

gen inconsistentdistr=1 if difP1<-0.0001 | difP2<-0.0001 | difP3<-0.0001 |  difP4<-0.0001
replace inconsistentdistr=0 if  inconsistentdistr==. & difP1<. & difP2<. & difP3<. & difP4<.


tab inconsistentdistr

*********************************************************************************
* comparing friends and own distributions
*********************************************************************************
tabstat PCaug_catchrange* , stat(p5 p25 p50 p75 p95 mean N sd iqr)
tabstat PCq10_* , stat(p5 p25 p50 p75 p95 mean N sd iqr)



log c

save C:\Data\Boatowner\fish_dataugmented.dta
