



clear all
set obs 4000000

gen id=1
gen cat=1
replace id=sum(id)
replace id=ceil(id/4)
sort id
replace cat=cat[_n-1]+1 if id==id[_n-1]
sort id cat

set seed 1

local T = 4

**************************
* True loadings
**************************
gen lambda_M11 = 10
gen lambda_M12 = 15
gen lambda_M13 = 5
gen lambda_M14 = 11

gen mu_M11 = 4
gen mu_M12 = 6
gen mu_M13 = 5
gen mu_M14 = 6

gen lambda_M21 = 10
gen lambda_M22 = 15
gen lambda_M23 = 5
gen lambda_M24 = 11

gen mu_M21 = 4
gen mu_M22 = 6
gen mu_M23 = 5
gen mu_M24 = 6



forvalues j = 1(1)`T'{

* FIRST  AND SECOND FACTOR TECHNOLOGY

gen TFP`j'   = 1

gen gamma1`j' = 0.8   /* Skill 1 */
gen gamma2`j' = 0.1   /* Skill 2 */
gen gamma3`j' = 0.4   /* Investment */
gen gamma4`j' = -0.01   /* Skill 1 sq */
gen gamma5`j' = 0.01   /* Intercation with Skill 2 */
gen gamma6`j' = -0.05   /* Intercation with Inv */

gen gamma7`j' =0.0001
gen gamma8`j' =-0.0001
gen gamma9`j' =0.0001
gen gamma10`j' =0.005
gen gamma11`j' =0.005
gen gamma12`j' =-0.005


gen sigma`j'=0.3

* INVESTMENT FUNCTION

gen alpha0`j'=0
gen alpha1`j'=0.05   /* Skill 1 */
gen alpha2`j'=0.05   /* Skill 2 */
gen alpha3`j'=0.1   /* Income */
gen alpha4`j'=0.4   /* Mothers' Skills */

gen sigmai`j'=0.3

}

* WAGE FUNCTION

gen rho0=4  /* Constant */
gen rho1=0.6  /* Past Income */

gen sigmaw=0.7

* INITIAL CONDITIONS

gen mu_1=2  /* Skill 1 */
gen mu_2=2  /* Skill 2 */
gen mu_3=0  /* Mothers' Skills */
gen mu_4=10  /* Income */


matrix V=[0,0,0,0\0,0,0,0\0,0,0,0\0,0,0,0]

* C
matrix V[1,1] = 0.5
matrix V[1,2] = 0.1
matrix V[2,1] = 0.1
matrix V[1,3] = 0.05
matrix V[3,1] = 0.05
matrix V[1,4] = 0.2
matrix V[4,1] = 0.2
* NC
matrix V[2,2] = 0.5
matrix V[2,3] = 0.05
matrix V[3,2] = 0.05
matrix V[2,4] = 0.2
matrix V[4,2] = 0.2
* M
matrix V[3,3] = 0.1
matrix V[3,4] = 0.05
matrix V[4,3] = 0.05
* Y
matrix V[4,4] = 1

matrix S = cholesky(V)


*Adult outcome

gen mu_Q=7

gen alpha_Q1=1
gen alpha_Q2=0.5

gen c1=rnormal(0,1) if cat==1
gen c2=rnormal(0,1) if cat==1
gen c3=rnormal(0,1) if cat==1
gen c4=rnormal(0,1) if cat==1

gen C=mu_1+S[1,1]*c1
gen N=mu_2+S[2,1]*c1+S[2,2]*c2
gen M=mu_3+S[3,1]*c1+S[3,2]*c2+S[3,3]*c3
gen FI=mu_4+S[4,1]*c1+S[4,2]*c2+S[4,3]*c3+S[4,4]*c4
gen I=.

by id: replace M=M[_n-1] if id==id[_n-1]

forvalues j = 2(1)`T'{
replace FI=rho0+rho1*FI[_n-1]+sigmaw*rnormal(0,1) if cat==`j'
}


forvalues j = 2(1)`T'{
local j_m1 = `j' - 1

replace I=alpha0`j_m1'+alpha1`j_m1'*C+alpha2`j_m1'*N+alpha3`j_m1'*FI+alpha4`j_m1'*M+sigmai`j_m1'*rnormal(0,1) if cat==`j'-1
replace C=TFP`j_m1'+gamma1`j_m1'*C[_n-1]+gamma2`j_m1'*N[_n-1]+gamma3`j_m1'*I[_n-1]+gamma4`j_m1'*C[_n-1]*C[_n-1]+gamma5`j_m1'*N[_n-1]*C[_n-1]+gamma6`j_m1'*I[_n-1]*C[_n-1]+sigma`j_m1'*rnormal(0,1) if cat==`j'

replace C=C+gamma7`j_m1'*C[_n-1]*C[_n-1]*C[_n-1]+gamma8`j_m1'*C[_n-1]*C[_n-1]*N[_n-1]+gamma9`j_m1'*C[_n-1]*C[_n-1]*I[_n-1]+gamma10`j_m1'*N[_n-1]*N[_n-1]+gamma11`j_m1'*I[_n-1]*I[_n-1]+gamma12`j_m1'*N[_n-1]*I[_n-1] if cat==`j'

replace N=TFP`j_m1'+gamma1`j_m1'*N[_n-1]+gamma2`j_m1'*C[_n-1]+gamma3`j_m1'*I[_n-1]+gamma4`j_m1'*N[_n-1]*N[_n-1]+gamma5`j_m1'*N[_n-1]*C[_n-1]+gamma6`j_m1'*I[_n-1]*N[_n-1]+sigma`j_m1'*rnormal(0,1) if cat==`j'


replace N=N+gamma7`j_m1'*N[_n-1]*N[_n-1]*N[_n-1]+gamma8`j_m1'*N[_n-1]*N[_n-1]*C[_n-1]+gamma9`j_m1'*N[_n-1]*N[_n-1]*I[_n-1]+gamma10`j_m1'*C[_n-1]*C[_n-1]+gamma11`j_m1'*I[_n-1]*I[_n-1]+gamma12`j_m1'*C[_n-1]*I[_n-1] if cat==`j'




}

gen Q=mu_Q+alpha_Q1*C+alpha_Q2*N if cat==4

*******************************;
*Generate Observed Variables
*******************************;

gen lambda_Mi1 = 1
gen lambda_Mi2 = 1
gen lambda_Mi3 = 1

gen mu_Mi1 = 0
gen mu_Mi2 = 0
gen mu_Mi3 = 0

gen Z_1 = .
gen Z_2 = .
gen Z_i =.

forvalues j = 1(1)`T'{
replace Z_1 = mu_M1`j'+lambda_M1`j'*C if cat==`j'
replace Z_2 = mu_M2`j'+lambda_M2`j'*N if cat==`j'

if (`j'<`T') {
replace Z_i = mu_Mi`j'+lambda_Mi`j'*I if cat==`j'
}
}

gen Z_M=M
gen Z_W=FI
gen Z_Q=Q

keep id cat Z_*

save data_gen_TL-flex,replace


