************************************************
************************************************
************************************************
*   CES function
*
*
*   Y  = TFP+ psi/phi * ln(  tau1*exp(X1*phi) +  tau2*exp(X2*phi) +  (1-tau1-tau2)*exp(X3*phi) ) + std*shock
*

program nlces

version 14

syntax varlist(min=4 max=4) if, at(name)

local Y     : word 1 of `varlist'
local X1    : word 2 of `varlist'
local X2    : word 3 of `varlist'
local X3    : word 4 of `varlist'

// Parameters

tempname TFP psi phi tau1 tau2

scalar `TFP'      =   `at'[1,1]

scalar `psi'      =   exp(`at'[1,2])
*scalar `psi'      =   `at'[1,2]


scalar `phi'        =   (exp(`at'[1,3])-1)/exp(`at'[1,3])
*scalar `phi'        =   `at'[1,3]

display `gamma'

scalar `tau1'       =  `at'[1,4]
scalar `tau2'       =  `at'[1,5]

replace `Y'  = `TFP'+ `psi'/`phi' * log( `tau1' * exp(`X1'*`phi') +  `tau2' * exp(`X2'*`phi') +  (1-`tau1'-`tau2') * exp(`X3'*`phi') )

display `Y'

end

************************************************
************************************************
************************************************

local T = 4

*Average INITIAL skills
sum Z_1 if cat==1
gen MU_C1=(r(mean)-MU1)/LAMBDA1
sum Z_2 if cat==1
gen MU_N1=(r(mean)-MU1)/LAMBDA1
sum Z_M if cat==1
gen MU_M=r(mean)

*loading
gen L_C1=LAMBDA1
gen L_C2= LAMBDA2
gen L_C3= LAMBDA3
gen L_C4= LAMBDA4

*loading
gen L_N1=LAMBDA1
gen L_N2= LAMBDA2
gen L_N3= LAMBDA3
gen L_N4= LAMBDA4

*mean
gen M_C1=MU1
gen M_C2=MU2
gen M_C3=MU3
gen M_C4=MU4

gen M_N1=MU1
gen M_N2=MU2
gen M_N3=MU3
gen M_N4=MU4


*loading
gen L_I1= 1
gen L_I2= 1
gen L_I3= 1

*mean
gen M_I1=0
gen M_I2=0
gen M_I3=0


*Average skills
gen MU_C=MU_C1
gen MU_N=MU_N1


*standardized
gen Z_C=(Z_1-M_C1)/L_C1 if cat==1
gen Z_N=(Z_2-M_N1)/L_N1 if cat==1
gen Z_I=.
 

******  INCOME  ***********

sum Z_W if cat==1
gen M_y0=r(mean)

sort id cat
gen P_W=Z_W[_n-1] if id==id[_n-1]
gen P_N=Z_N[_n-1] if id==id[_n-1]

reg Z_W P_W P_N

gen sigmaw=sqrt(e(rss)/(e(N)-1))

gen rho0=_b[_cons]
gen rho1=_b[P_W]
gen rho2=_b[P_N]

 
* Time Loop
foreach i in 1 2 3 {


** INITIAL CONDITIONS **

if (`i'==1){

matrix V=[0,0,0,0\0,0,0,0\0,0,0,0\0,0,0,0]

* C
correlate Z_C Z_C if cat==1, covariance
matrix V[1,1] = r(cov_12)
correlate Z_C Z_N if cat==1, covariance
matrix V[1,2] = r(cov_12)
matrix V[2,1] = r(cov_12)
correlate Z_C Z_M if cat==1, covariance
matrix V[1,3] = r(cov_12)
matrix V[3,1] = r(cov_12)
correlate Z_C Z_W if cat==1, covariance
matrix V[1,4] = r(cov_12)
matrix V[4,1] = r(cov_12)
* N
correlate Z_N Z_N if cat==1, covariance
matrix V[2,2] = r(cov_12)
correlate Z_N Z_M if cat==1, covariance
matrix V[2,3] = r(cov_12)
matrix V[3,2] = r(cov_12)
correlate Z_N Z_W if cat==1, covariance
matrix V[2,4] = r(cov_12)
matrix V[4,2] = r(cov_12)
* M
correlate Z_M Z_M if cat==1, covariance
matrix V[3,3] = r(cov_12)
correlate Z_M Z_W if cat==1, covariance
matrix V[3,4] = r(cov_12)
matrix V[4,3] = r(cov_12)
* Y
correlate Z_W Z_W if cat==1, covariance
matrix V[4,4] = r(cov_12)

matrix S = cholesky(V)

}

******  INVESTMENTS ***********


reg Z_i Z_C Z_N Z_M Z_W  if cat==`i'

est store Inv$run`i'

predict err_I`i', residual

*gen L_I`i'= _b[Z_C]+_b[Z_N]+_b[Z_M]+_b[Z_W]

gen alpha_0`i'=_b[_cons]
gen alpha_1`i'=_b[Z_C]
gen alpha_2`i'=_b[Z_N]
gen alpha_3`i'=_b[Z_M]
gen alpha_4`i'=_b[Z_W]

mat INV$run`i'=e(b)
mat INV$run`i'[1,1]=INV$run`i'[1,1]
mat INV$run`i'[1,2]=INV$run`i'[1,2]
mat INV$run`i'[1,3]=INV$run`i'[1,3]
mat INV$run`i'[1,4]=INV$run`i'[1,4]
mat INV$run`i'[1,5]=INV$run`i'[1,5]

replace Z_I=(Z_i-M_I`i')/L_I`i' if cat==`i'

************** TECHNOLOGY ***********************


local i_f=`i'+1


sort id cat

gen C_f= (Z_1[_n+1]-M_C`i_f')/L_C`i_f' if  cat==`i' & id==id[_n+1]

qui nl ces @ C_f Z_C Z_N Z_I  if cat==`i',  parameters(TFP psi phi tau1 tau2 )   initial(TFP 0.5 psi 0.5 phi 0.2 tau1 0.6 tau2 0.1  )

mat MC$run`i'=e(b)


est store TechC$run`i'

 
predict err_C`i', residual

        
gen AC`i'=MC$run`i'[1,1]
gen psiC`i'=exp(MC$run`i'[1,2])
gen phiC`i'=(exp(MC$run`i'[1,3])-1)/exp(MC$run`i'[1,3])
gen tauC1`i'=MC$run`i'[1,4]
gen tauC2`i'=MC$run`i'[1,5]
 
mat TECHC$run`i'=e(b)



replace  Z_C=(Z_1-M_C`i_f')/L_C`i_f' if cat==`i_f'

sum Z_C if cat==`i_f'
replace MU_C=r(mean)


gen N_f= (Z_2[_n+1]-M_N`i_f')/L_N`i_f' if  cat==`i' & id==id[_n+1]

qui nl ces @ N_f Z_N Z_C Z_I  if cat==`i',  parameters(TFP psi phi tau1 tau2 )   initial(TFP 0.5 psi 0.5 phi 0.2 tau1 0.6 tau2 0.1  )

est store TechN$run`i'
 
predict err_N`i', residual

mat MN$run`i'=e(b)


        
gen AN`i'=MN$run`i'[1,1]
gen psiN`i'=exp(MN$run`i'[1,2])
gen phiN`i'=(exp(MN$run`i'[1,3])-1)/exp(MN$run`i'[1,3])
gen tauN1`i'=MN$run`i'[1,4]
gen tauN2`i'=MN$run`i'[1,5]

mat TECHN$run`i'=e(b)


replace  Z_N=(Z_2-M_N`i_f')/L_N`i_f' if cat==`i_f'

sum Z_N if cat==`i_f'
replace MU_N=r(mean)


************** SHOCKS ***********************

sort id cat

by  id: replace err_C`i'=err_C`i'[_n-1] if  cat>`i'

by  id: replace err_N`i'=err_N`i'[_n-1] if  cat>`i'

correlate err_I`i' err_I`i'  if cat==`i', covariance
gen S_I`i'= sqrt(r(cov_12))

correlate err_C`i' err_C`i'  if cat==`i', covariance
gen S_C`i'= sqrt(r(cov_12))

correlate err_N`i' err_N`i'  if cat==`i', covariance
gen S_N`i'= sqrt(r(cov_12))


drop err_* C_f N_f 

}

reg Z_Q Z_C Z_N if cat==4

est store Adult$run

gen M_schooling=_b[_cons]
gen alpha_C=_b[Z_C]
gen alpha_N=_b[Z_N]


************************************************************************************************
************************************************************************************************
**************** SIMULATIONS *******************************************************************
************************************************************************************************
************************************************************************************************

set seed 10

local T = 4


sort id cat

gen c1=rnormal(0,1) if cat==1
gen c2=rnormal(0,1) if cat==1
gen c3=rnormal(0,1) if cat==1
gen c4=rnormal(0,1) if cat==1

gen C=MU_C1+S[1,1]*c1
gen N=MU_N1+S[2,1]*c1+S[2,2]*c2
gen M=MU_M+S[3,1]*c1+S[3,2]*c2+S[3,3]*c3
gen FI=M_y0+S[4,1]*c1+S[4,2]*c2+S[4,3]*c3+S[4,4]*c4
gen I=.



by id: replace M=M[_n-1] if id==id[_n-1]

egen Y_shock=sd(FI) if cat==1

gen C_c1=C
gen N_c1=N
gen FI_c1=FI
replace FI_c1=FI+Y_shock if cat==1
gen I_c1=.

gen C_c2=C
gen N_c2=N
gen FI_c2=FI
replace FI_c2=log(exp(FI)+10000) if cat==1
gen I_c2=.

gen I_shock=.
gen C_shock=.
gen N_shock=.


forvalues j = 2(1)`T'{
local j_m1 = `j' - 1

replace I_shock=S_I`j_m1'*rnormal(0,1) if cat==`j'-1
replace C_shock=S_C`j_m1'*rnormal(0,1) if cat==`j'
replace N_shock=S_N`j_m1'*rnormal(0,1) if cat==`j'

replace I=alpha_0`j_m1'+alpha_1`j_m1'*C+alpha_2`j_m1'*N+alpha_3`j_m1'*M+alpha_4`j_m1'*FI+I_shock if cat==`j'-1
replace I_c1=alpha_0`j_m1'+alpha_1`j_m1'*C_c1+alpha_2`j_m1'*N_c1+alpha_3`j_m1'*M+alpha_4`j_m1'*FI_c1+I_shock if cat==`j'-1
replace I_c2=alpha_0`j_m1'+alpha_1`j_m1'*C_c2+alpha_2`j_m1'*N_c2+alpha_3`j_m1'*M+alpha_4`j_m1'*FI_c2+I_shock if cat==`j'-1




replace C=AC`j_m1'+(psiC`j_m1'/phiC`j_m1')*log(tauC1`j_m1'*exp(C[_n-1]*phiC`j_m1')+tauC2`j_m1'*exp(N[_n-1]*phiC`j_m1')+(1-tauC1`j_m1'-tauC2`j_m1')*exp(I[_n-1]*phiC`j_m1'))+C_shock if cat==`j'
replace C_c1=AC`j_m1'+(psiC`j_m1'/phiC`j_m1')*log(tauC1`j_m1'*exp(C_c1[_n-1]*phiC`j_m1')+tauC2`j_m1'*exp(N_c1[_n-1]*phiC`j_m1')+(1-tauC1`j_m1'-tauC2`j_m1')*exp(I_c1[_n-1]*phiC`j_m1'))+C_shock if cat==`j'
replace C_c2=AC`j_m1'+(psiC`j_m1'/phiC`j_m1')*log(tauC1`j_m1'*exp(C_c2[_n-1]*phiC`j_m1')+tauC2`j_m1'*exp(N_c2[_n-1]*phiC`j_m1')+(1-tauC1`j_m1'-tauC2`j_m1')*exp(I_c2[_n-1]*phiC`j_m1'))+C_shock if cat==`j'


replace N=AN`j_m1'+(psiN`j_m1'/phiN`j_m1')*log(tauN1`j_m1'*exp(N[_n-1]*phiN`j_m1')+tauN2`j_m1'*exp(C[_n-1]*phiN`j_m1')+(1-tauN1`j_m1'-tauN2`j_m1')*exp(I[_n-1]*phiN`j_m1'))+N_shock if cat==`j'
replace N_c1=AN`j_m1'+(psiN`j_m1'/phiN`j_m1')*log(tauN1`j_m1'*exp(N_c1[_n-1]*phiN`j_m1')+tauN2`j_m1'*exp(C_c1[_n-1]*phiN`j_m1')+(1-tauN1`j_m1'-tauN2`j_m1')*exp(I_c1[_n-1]*phiN`j_m1'))+N_shock if cat==`j'
replace N_c2=AN`j_m1'+(psiN`j_m1'/phiN`j_m1')*log(tauN1`j_m1'*exp(N_c2[_n-1]*phiN`j_m1')+tauN2`j_m1'*exp(C_c2[_n-1]*phiN`j_m1')+(1-tauN1`j_m1'-tauN2`j_m1')*exp(I_c2[_n-1]*phiN`j_m1'))+N_shock if cat==`j'


if (`j'==2) {
replace FI_c1=FI if cat==`j'-1
replace FI_c2=FI if cat==`j'-1
}


replace FI=rho0+rho1*FI[_n-1]+sigmaw*rnormal(0,1) if cat==`j'
replace FI_c1=rho0+rho1*FI_c1[_n-1]+sigmaw*rnormal(0,1) if cat==`j'
replace FI_c2=rho0+rho1*FI_c2[_n-1]+sigmaw*rnormal(0,1) if cat==`j'


}

 


******************************************************************************************************************************************************************************************;
*Anchoring and policy effects
******************************************************************************************************************************************************************************************;

gen Sch=M_schooling+alpha_C*C+alpha_N*N if cat==4
gen Sch_c1=alpha_C*(C_c1-C)+alpha_N*(N_c1-N) if cat==4
gen Sch_c2=alpha_C*(C_c2-C)+alpha_N*(N_c2-N) if cat==4


sum Sch_c1
gen treat_adult_sd=r(mean)
sum Sch_c2
gen treat_adult_1k=r(mean)


egen sd=sd(C) if cat==4

gen C_std=C/sd if cat==4
gen C_c1_std=C_c1/sd if cat==4
gen C_c2_std=C_c2/sd if cat==4

gen D_C_c1_std=C_c1_std-C_std
gen D_C_c2_std=C_c2_std-C_std

sum D_C_c1_std
gen treat_stand_sd=r(mean)
sum D_C_c2_std
gen treat_stand_1k=r(mean)



program drop nlces



























