qui{

*Average skills
sum math if cat==1
gen MU_theta1=(r(mean)-MU1)/LAMBDA1
gen MU_theta=MU_theta1

*initial normalization
gen L_math1=LAMBDA1
gen M_math1=MU1


*standardized
gen Z_math=(math-M_math1)/L_math1 if cat==1
gen Z_recognition=.
gen Z_comp=.
gen Z_museum=.
gen Z_gatherings=.
gen Z_books=.
gen Z_theater=.
gen Z_praised=.
gen Z_eatmomdad=.
gen Z_lessons=.
gen Z_newspaper=.
gen Z_instrument=.


*Mothers (Not time varying)

* MOTHER COGNITIVE

correlate word_Z Z_math if cat==1, covariance
gen  cov_C1c = r(cov_12)

correlate paragraph_Z Z_math if cat==1, covariance
gen  cov_C2c = r(cov_12)

gen L_word_Z=1
gen L_paragraph_Z=cov_C2c/cov_C1c

sum word_Z if cat==1
gen M_word_Z=r(mean)

sum paragraph_Z if cat==1
gen M_paragraph_Z=r(mean)

drop cov*

* MOTHER NON COGNITIVE

replace worth_1980=-worth_1980

correlate worth_1980 Z_math if cat==1, covariance
gen  cov_C1c = r(cov_12)

correlate nogood_1980 Z_math if cat==1, covariance
gen  cov_C2c = r(cov_12)

gen L_worth_1980=1
gen L_nogood_1980=cov_C2c/cov_C1c

sum worth_1980 if cat==1
gen M_worth_1980=r(mean)

sum nogood_1980 if cat==1
gen M_nogood_1980=r(mean)

drop cov*

gen Z_word=word-M_word
gen Z_paragraph=(paragraph-M_paragraph)/L_paragraph

gen Z_worth=worth-M_worth
gen Z_nogood=(nogood-M_nogood)/L_nogood

******  INCOME  ***********

sort cid year
gen p_income=income[_n-1] if cid==cid[_n-1]

reg income  year p_income

gen S_y=sqrt(e(rss)/(e(N)-1))

gen M_y=_b[_cons]
gen rho_y=_b[p_income]
gen delta_y=_b[year]

sum income if cat==1
gen M_y0=r(mean)

}

* Time Loop


foreach i in 1 2 3 {

qui{
* CHILD

correlate Z_math recognition if cat==`i', covariance
gen  cov_C12 = r(cov_12)

correlate Z_math comp if cat==`i', covariance
gen  cov_C13 = r(cov_12)

correlate recognition comp if cat==`i', covariance
gen  cov_C23 = r(cov_12)

gen L_recognition`i'=cov_C23/cov_C13
gen L_comp`i'=cov_C23/cov_C12

sum recognition if cat==`i'
gen M_recognition`i'=r(mean)-L_recognition`i'*MU_theta

sum comp if cat==`i'
gen M_comp`i'=r(mean)-L_comp`i'*MU_theta

drop cov*

replace Z_recognition=(recognition-M_recognition`i')/L_recognition`i' if cat==`i'
replace Z_comp=(comp-M_comp`i')/L_comp`i' if cat==`i'

** INITIAL CONDITIONS **

if (`i'==1){

matrix V=[0,0,0,0\0,0,0,0\0,0,0,0\0,0,0,0]

* C
correlate Z_math Z_recognition if cat==1, covariance
matrix V[1,1] = r(cov_12)
correlate Z_math Z_word if cat==1, covariance
matrix V[1,2] = r(cov_12)
matrix V[2,1] = r(cov_12)
correlate Z_math Z_worth if cat==1, covariance
matrix V[1,3] = r(cov_12)
matrix V[3,1] = r(cov_12)
correlate Z_math income if cat==1, covariance
matrix V[1,4] = r(cov_12)
matrix V[4,1] = r(cov_12)

* MC
correlate Z_word Z_paragraph if cat==1, covariance
matrix V[2,2] = r(cov_12)
correlate Z_word Z_worth if cat==1, covariance
matrix V[2,3] = r(cov_12)
matrix V[3,2] = r(cov_12)
correlate Z_word income if cat==1, covariance
matrix V[2,4] = r(cov_12)
matrix V[4,2] = r(cov_12)

* MNC
correlate Z_worth Z_nogood if cat==1, covariance
matrix V[3,3] = r(cov_12)
correlate Z_worth income if cat==1, covariance
matrix V[3,4] = r(cov_12)
matrix V[4,3] = r(cov_12)

* Y
correlate income income if cat==1, covariance
matrix V[4,4] = r(cov_12)


matrix S = cholesky(V)

}


******  INVESTMENTS ***********

*Museum

if (`i'<3) {
	ivreg museum (Z_math Z_word Z_worth = Z_recogn Z_para Z_nog) income if cat==`i'
 qui{
	est store Inv$run`i'
	predict err_museum`i', residual

	gen L_museum`i'= _b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income]

	gen alpha_C`i'=_b[Z_math]/L_museum`i'
	gen alpha_MC`i'=_b[Z_word]/L_museum`i'
	gen alpha_MNC`i'=_b[Z_worth]/L_museum`i'
	gen alpha_Y`i'=_b[income]/L_museum`i'
	gen M_museum`i'=_b[_cons]

	mat INV$run`i'=e(b)
	mat INV$run`i'[1,1]=INV$run`i'[1,1]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,2]=INV$run`i'[1,2]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,3]=INV$run`i'[1,3]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,4]=INV$run`i'[1,4]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,5]=INV$run`i'[1,5]

	replace Z_museum=(museum-M_museum`i')/L_museum`i' if cat==`i'

	sum Z_museum  if cat==`i'
	gen MU_I=r(mean)

	foreach var in books gatherings theater praised eatmomdad lessons newspaper instrument {
		correlate Z_museum Z_math if cat==`i', covariance
		gen  cov_C12 = r(cov_12)
		correlate `var' Z_math if cat==`i', covariance
		gen  cov_C23 = r(cov_12)
		gen L_`var'`i'=cov_C23/cov_C12
		drop cov*

		sum `var' if cat==`i'
		gen M_`var'`i'=r(mean)-L_`var'`i'*MU_I

		replace Z_`var'=(`var'-M_`var'`i')/L_`var'`i' if cat==`i'
	}
 }
}

if (`i'==3) {
	ivreg books (Z_math Z_word Z_worth = Z_recogn Z_para Z_nog) income if cat==`i'
 qui{
	est store Inv$run`i'
	predict err_books`i', residual

	gen L_books`i'= _b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income]

	gen alpha_C`i'=_b[Z_math]/L_books`i'
	gen alpha_MC`i'=_b[Z_word]/L_books`i'
	gen alpha_MNC`i'=_b[Z_worth]/L_books`i'
	gen alpha_Y`i'=_b[income]/L_books`i'
	gen M_books`i'=_b[_cons]

	mat INV$run`i'=e(b)
	mat INV$run`i'[1,1]=INV$run`i'[1,1]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,2]=INV$run`i'[1,2]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,3]=INV$run`i'[1,3]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,4]=INV$run`i'[1,4]/(_b[Z_math]+_b[Z_word]+_b[Z_worth]+_b[income])
	mat INV$run`i'[1,5]=INV$run`i'[1,5]

	replace Z_books=(books-M_books`i')/L_books`i' if cat==`i'

	sum Z_books  if cat==`i'
	gen MU_I=r(mean)

	foreach var in museum gatherings theater praised eatmomdad lessons newspaper instrument {
		correlate Z_books Z_math if cat==`i', covariance
		gen  cov_C12 = r(cov_12)
		correlate `var' Z_math if cat==`i', covariance
		gen  cov_C23 = r(cov_12)
		gen L_`var'`i'=cov_C23/cov_C12
		drop cov*

		sum `var' if cat==`i'
		gen M_`var'`i'=r(mean)-L_`var'`i'*MU_I

		replace Z_`var'=(`var'-M_`var'`i')/L_`var'`i' if cat==`i'
	}
 }
}

}
************** TECHNOLOGY ***********************

*   CES function
*
*
*   Y  = TFP+ psi/phi * ln(  tau*exp(X1*phi) +  (1-tau)*exp(X2*phi)  ) + std*shock
*
qui{
* Math

sort mid cid year

gen math_f= math[_n+1] if  cat==`i' & cid==cid[_n+1]

gen GMM_IV1=Z_recogn
}

if (`i'==1){
qui{
 drop GMM*

 gen GMMC_IV1=Z_recogn
 gen GMMC_IV2=Z_recogn^2

 gen GMMI_IV1=Z_gatherings
 gen GMMI_IV2=Z_gatherings^2

 gen GMMINC_IV1=income
 gen GMMINC_IV2=income^2

 gen GMMCINC_IV1=Z_recogn*income
 gen GMMCINC_IV2=Z_gathe*income
 gen GMMCINC_IV3=Z_recogn^2*income^2
 gen GMMCINC_IV4=Z_gath^2*income^2
 
 gen GMMI4_IV1=Z_word
 gen GMMI4_IV2=Z_para
 gen GMMI4_IV3=Z_nog
 gen GMMI4_IV4=Z_worth
 gen GMMI4_IV5=Z_book
}

 gmm(math_f - {TFP}- {psi}/{phi} * log( {tau} * exp(Z_math*{phi}) +  (1-{tau})  * exp(Z_museum*{phi}) )) if cat==`i' ,instruments(GMM*) from( TFP 20 psi 3  phi -0.1 tau 0.5)
 
}


if (`i'==2){
qui{
 drop GMM*

 gen GMMC_IV1=Z_recogn
 gen GMMC_IV2=Z_recogn^2

 gen GMMINC_IV1=income
 gen GMMINC_IV2=income^2

 gen GMMCINC_IV1=Z_recogn*income
 gen GMMCINC_IV2=Z_recogn^2*income^2

 gen GMMI3_IV1=Z_books 
 gen GMMI2_IV1=Z_word
 gen GMMI4_IV1=Z_worth
 
 gen GMMI_IV1=Z_gatherings
 gen GMMI_IV2=Z_gatherings^2
}
 gmm(math_f - {TFP}- {psi}/{phi} * log( {tau} * exp(Z_math*{phi}) +  (1-{tau})  * exp(Z_museum*{phi}) )) if cat==`i' ,instruments(GMM*) from( TFP 20 psi 3  phi -0.1 tau 0.5)
 
}

if (`i'==3){
qui{
 drop GMM*

 gen GMMC_IV1=Z_recogn
 gen GMMC_IV2=Z_recogn^2

 gen GMMI_IV1=Z_praised
 gen GMMI_IV2=Z_praised^2

 gen GMMINC_IV1=income
 gen GMMINC_IV2=income^2

 gen GMMCINC_IV1=Z_recogn*income
 gen GMMCINC_IV2=Z_praised*income
 gen GMMCINC_IV3=Z_recogn^2*income^2
 gen GMMCINC_IV4=Z_praised^2*income^2
 

 gen GMMI4_IV1=Z_word
 gen GMMI4_IV2=Z_para
 gen GMMI4_IV3=Z_nog
 gen GMMI4_IV4=Z_worth
 gen GMMI4_IV5=Z_book
}
 gmm(math_f - {TFP}- {psi}/{phi} * log( {tau} * exp(Z_math*{phi}) +  (1-{tau})  * exp(Z_museum*{phi}) )) if cat==`i' ,instruments(GMM*) from( TFP 20 psi 3  phi -0.1 tau 0.5) one
 
}

qui{
est store Tech$run`i'

predict err_math`i', residual

mat M`i'=e(b)
        
gen TFP`i'_est=M`i'[1,1]
gen psi`i'_est=M`i'[1,2]
gen phi`i'_est=M`i'[1,3]
gen tau`i'_est=M`i'[1,4]


local i_f=`i'+1

gen L_math`i_f'=psi`i'_est

gen A`i'=0

gen M_math`i_f'=TFP`i'_est


mat TECH$run`i'=e(b)
mat TECH$run`i'[1,1]=(TECH$run`i'[1,1]- M_math`i_f'[1])/L_math`i_f'[1]
mat TECH$run`i'[1,2]=TECH$run`i'[1,2]/L_math`i_f'[1]
mat TECH$run`i'[1,3]=TECH$run`i'[1,3]
mat TECH$run`i'[1,4]=TECH$run`i'[1,4]


replace psi`i'_est=1

replace  Z_math=(math-M_math`i_f')/L_math`i_f' if cat==`i_f'

sum Z_math if cat==`i_f'
replace MU_theta=r(mean)

drop GMM*

* Recognition
gen p_math=Z_math[_n-1] if cat==`i_f' & cid==cid[_n-1]

correlate Z_math p_math if cat==`i_f', covariance
gen  cov_C13 = r(cov_12)
correlate recognition p_math if cat==`i_f', covariance
gen  cov_C23 = r(cov_12)
gen L_recognition`i_f'=cov_C23/cov_C13
drop cov*
 
sum recognition if cat==`i_f'
gen M_recognition`i_f'=r(mean)-L_recognition`i_f'*MU_theta

replace Z_recognition=(recognition-M_recognition`i_f')/L_recognition`i_f' if cat==`i_f'

************** SHOCKS ***********************

sort mid cid year

if (`i'<3) {
	replace err_museum`i'=err_museum`i'/L_museum`i' if cat==`i'
	correlate err_museum`i' Z_books  if cat==`i', covariance
	gen S_I`i'= sqrt(r(cov_12))
}

if (`i'==3) {
	replace err_books`i'=err_books`i'/L_books`i' if cat==`i'
	correlate err_books`i' Z_museum  if cat==`i', covariance
	gen S_I`i'= sqrt(r(cov_12))
}

replace err_math`i'=err_math`i'/L_math`i_f' if cat==`i'
by mid cid: replace err_math`i'=err_math`i'[_n-1] if  cat>`i'

correlate err_math`i' Z_recognition  if cat==`i_f', covariance
gen S_P`i'= sqrt(r(cov_12))

drop err_* math_f L_recognition`i_f' M_recognition`i_f' MU_I p_math

}
}

qui{

ivreg schooling (Z_math=Z_recog) if cat==4 & schooling>0

est store Adult$run

gen M_schooling=_b[_cons]
gen alpha_schooling=_b[Z_math]



************************************************************************************************
************************************************************************************************
**************** SIMULATIONS *******************************************************************
************************************************************************************************
************************************************************************************************

set seed 1

local T = 4


sort mid cid year

gen c1=rnormal(0,1) if cat==1
gen c2=rnormal(0,1) if cat==1
gen c3=rnormal(0,1) if cat==1
gen c4=rnormal(0,1) if cat==1

gen C=MU_theta1+S[1,1]*c1
gen MC=S[2,1]*c1+S[2,2]*c2
gen MN=S[3,1]*c1+S[3,2]*c2+S[3,3]*c3
gen FI=M_y0+S[4,1]*c1+S[4,2]*c2+S[4,3]*c3+S[4,4]*c4
gen I=.

by mid cid: replace MC=MC[_n-1] if cid==cid[_n-1]
by mid cid: replace MN=MN[_n-1] if cid==cid[_n-1]

forvalues j = 2(1)`T'{
replace FI=M_y+delta_y*year+rho_y*FI[_n-1]+S_y*rnormal(0,1) if cat==`j'
}


egen Y_shock=sd(FI) if cat==1


gen C_c1=C
gen FI_c1=FI
replace FI_c1=FI+Y_shock if cat==1
gen I_c1=.

gen C_c2=C
gen FI_c2=FI
replace FI_c2=log(exp(FI)+10000) if cat==1
gen I_c2=.

gen I_shock=.
gen P_shock=.

forvalues j = 2(1)`T'{
local j_m1 = `j' - 1

replace I_shock=S_I`j_m1'*rnormal(0,1) if cat==`j'-1
replace P_shock=S_P`j_m1'*rnormal(0,1) if cat==`j'


replace I=alpha_C`j_m1'*C+alpha_MC`j_m1'*MC+alpha_MNC`j_m1'*MN+alpha_Y`j_m1'*FI+I_shock if cat==`j'-1
replace I_c1=alpha_C`j_m1'*C_c1+alpha_MC`j_m1'*MC+alpha_MNC`j_m1'*MN+alpha_Y`j_m1'*FI_c1+I_shock if cat==`j'-1
replace I_c2=alpha_C`j_m1'*C_c2+alpha_MC`j_m1'*MC+alpha_MNC`j_m1'*MN+alpha_Y`j_m1'*FI_c2+I_shock if cat==`j'-1

replace C=A`j_m1'+(psi`j_m1'/phi`j_m1')*log(tau`j_m1'*exp(C[_n-1]*phi`j_m1')+(1-tau`j_m1')*exp(I[_n-1]*phi`j_m1'))+P_shock if cat==`j'
replace C_c1=A`j_m1'+(psi`j_m1'/phi`j_m1')*log(tau`j_m1'*exp(C_c1[_n-1]*phi`j_m1')+(1-tau`j_m1')*exp(I_c1[_n-1]*phi`j_m1'))+P_shock if cat==`j'
replace C_c2=A`j_m1'+(psi`j_m1'/phi`j_m1')*log(tau`j_m1'*exp(C_c2[_n-1]*phi`j_m1')+(1-tau`j_m1')*exp(I_c2[_n-1]*phi`j_m1'))+P_shock if cat==`j'

}

******************************************************************************************************************************************************************************************;
*Anchoring and policy effects
******************************************************************************************************************************************************************************************;

gen Sch= M_schooling+ alpha_schooling*C if cat==4
gen Sch_c1= alpha_schooling*(C_c1-C) if cat==4
gen Sch_c2= alpha_schooling*(C_c2-C) if cat==4


gen diff_c1=(C_c1-C) if cat==4
gen diff_c2=(C_c2-C) if cat==4
sum diff_c1 diff_c2

sum Sch_c1
gen treat_adult_sd=r(mean)
sum Sch_c2
gen treat_adult_1k=r(mean)

egen sd=sd(C) if cat==4

gen C_std=C/sd if cat==4
gen C_c1_std=C_c1/sd if cat==4
gen C_c2_std=C_c2/sd if cat==4

gen D_C_c1_std=C_c1_std-C_std
gen D_C_c2_std=C_c2_std-C_std

sum D_C_c1_std
gen treat_stand_sd=r(mean)
sum D_C_c2_std
gen treat_stand_1k=r(mean)


}















