clear all
set more off
capture log close

log using TABLE-B4.txt, replace text

****************************************
* Simulate data from a CES specification using the true loadings below

set obs 4000000
**************************
* True loadings
**************************
gen lambda_M11 = 5
gen lambda_M12 = 5
gen lambda_M13 = 5
gen lambda_M14 = 5

gen mu_M11 = 2
gen mu_M12 = 2
gen mu_M13 = 2
gen mu_M14 = 2

gen lambda_M21 = 5
gen lambda_M22 = 5
gen lambda_M23 = 5
gen lambda_M24 = 5

gen mu_M21 = 2
gen mu_M22 = 2
gen mu_M23 = 2
gen mu_M24 = 2

run codes/mis-specify-sim


*****************************************
*****************************************
* Estimate the CES using the correct loadings

use data_mis_specify,clear

* Normalizations

gen LAMBDA1 = 5
gen LAMBDA2 = 5
gen LAMBDA3 = 5
gen LAMBDA4 = 5

gen MU1 = 2
gen MU2 = 2
gen MU3 = 2
gen MU4 = 2

global run=1

run codes/mis-specify-CES.do

sum treat*


*****************************************
*****************************************
* Estimate the CES using the incorrect loadings

use data_mis_specify,clear

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=2

run codes/mis-specify-CES.do

sum treat*


matrix  INV1 = (INV11 \ INV12 \ INV13)
matrix  INV2 = (INV21 \ INV22 \ INV23)


mat list INV1
mat list INV2

mat TECHC1=(TECHC11\TECHC12\TECHC13 )
mat TECHC2=(TECHC21\TECHC22\TECHC23)

mat list TECHC1
mat list TECHC2

mat TECHN1=(TECHN11\TECHN12\TECHN13 )
mat TECHN2=(TECHN21\TECHN22\ TECHN23 )

mat list TECHN1
mat list TECHN2


*****************************************
*****************************************
* Estimate using a translog

use data_mis_specify,clear

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=3

run codes/mis-specify-TL.do

sum treat*

mat TECHC1=(TECHC31\TECHC32\TECHC33)
mat list TECHC1

mat TECHN1=(TECHN31\TECHN32\TECHN33 )
mat list TECHN1

matrix  INV1 = (INV31 \ INV32 \ INV33)
mat list INV1


*****************************************
*****************************************
* Estimate using a more flexible translog

use data_mis_specify,clear

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=4

run codes/mis-specify-TL-flex.do

sum treat*

mat TECHC1=(TECHC41\TECHC42\TECHC43)
mat list TECHC1

mat TECHN1=(TECHN41\TECHN42\TECHN43 )
mat list TECHN1

matrix  INV1 = (INV41 \ INV42 \ INV43)
mat list INV1



