clear all
set more off
pause on

capture log close

log using TABLE-1-B1-B2.txt, replace text

* REPLACE do codes/ WITH run codes/ TO GET THE STD FOR THE ESTIMATES OF B2


run raw/data


**************************************************************************************************
****** AGE INVARIANCE + STANDARD INITIAL NORMALIZATION + TRANSLOG ********************************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=1

run codes/TL_model1.do

sum treat*

**************************************************************************************************
****** AGE INVARIANCE + DIFFERENT INITIAL NORMALIZATION + TRANSLOG ********************************
**************************************************************************************************


use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=10
gen LAMBDA2=10
gen LAMBDA3=10
gen LAMBDA4=10

*mean of measurement
*qui sum math if cat==1
gen MU1=5
gen MU2=5
gen MU3=5
gen MU4=5

global run=2

run codes/TL_model1.do

sum treat*


**************************************************************************************************
****** AGE INVARIANCE + STANDARD INITIAL NORMALIZATION + TRANSLOG + RESCALED UNIT *****************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0

*replace `var'=`var'/84   /* get percent correct */

sum `var' if cat==1
replace `var'=`var'-r(mean)
replace `var'=`var'/r(sd)
}

* Normalizations

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=3

run codes/TL_model1.do

sum treat*

matrix  INV1 = (INV11 \ INV12 \ INV13)
matrix  INV2 = (INV21 \ INV22 \ INV23)
matrix  INV3 = (INV31 \ INV32 \ INV33)

mat list INV1
mat list INV2
mat list INV3

mat TECH1=(TECH11\TECH12\TECH13)
mat TECH2=(TECH21\TECH22\TECH23)
mat TECH3=(TECH31\TECH32\TECH33)

mat list TECH1
mat list TECH2
mat list TECH3

 
**************************************************************************************************
****** AGE INVARIANCE + STANDARD INITIAL NORMALIZATION + CES ********************************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=1

run codes/CES_model1.do

sum treat*

**************************************************************************************************
****** AGE INVARIANCE + DIFFERENT INITIAL NORMALIZATION + CES ********************************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=10
gen LAMBDA2=10
gen LAMBDA3=10
gen LAMBDA4=10


*mean of measurement
*qui sum math if cat==1
gen MU1=5
gen MU2=5
gen MU3=5
gen MU4=5

global run=2

run codes/CES_model1.do

sum treat*


**************************************************************************************************
****** AGE INVARIANCE + STANDARDINITIAL NORMALIZATION + CES + RESCALED UNIT **********************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0

*replace `var'=`var'/84   /* get percent correct */

sum `var' if cat==1
replace `var'=`var'-r(mean)
replace `var'=`var'/r(sd)

}

* Normalizations

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=1
gen LAMBDA3=1
gen LAMBDA4=1

*mean of measurement
gen MU1=0
gen MU2=0
gen MU3=0
gen MU4=0

global run=3

run codes/CES_model1.do

sum treat*


matrix  INV1 = (INV11 \ INV12 \ INV13)
matrix  INV2 = (INV21 \ INV22 \ INV23)
matrix  INV3 = (INV31 \ INV32 \ INV33)

mat list INV1
mat list INV2
mat list INV3

mat TECH1=(TECH11\TECH12\TECH13)
mat TECH2=(TECH21\TECH22\TECH23)
mat TECH3=(TECH31\TECH32\TECH33)

mat list TECH1
mat list TECH2
mat list TECH3


clear all

**************************************************************************************************
****** NO AGE INVARIANCE + TRANSLOG ********************************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=2
gen LAMBDA3=3
gen LAMBDA4=4

*mean of measurement
gen MU1=4
gen MU2=3
gen MU3=2
gen MU4=1

global run=1

run codes/TL_model1.do

sum treat*


**************************************************************************************************
****** NO AGE INVARIANCE + CES *****************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=1
gen LAMBDA2=2
gen LAMBDA3=3
gen LAMBDA4=4

*mean of measurement
gen MU1=4
gen MU2=3
gen MU3=2
gen MU4=1

global run=10

run codes/CES_model1.do

sum treat*

matrix  INV1 = (INV11 \ INV12 \ INV13)
matrix  INV2 = (INV101 \ INV102 \ INV103)

mat list INV1
mat list INV2

mat TECH1=(TECH11\TECH12\TECH13)
mat TECH2=(TECH101\TECH102\TECH103)

mat list TECH1
mat list TECH2

clear all


**************************************************************************************************
****** TECHNOLOGY + STANDARD INITIAL NORMALIZATION + TRANSLOG ********************************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0
}

* Normalizations

*loading of measurement
gen LAMBDA1=1

*mean of measurement
gen MU1=0

global run=1

run codes/TL_model2.do

sum treat*


**************************************************************************************************
****** TECHNOLOGY + STANDARD INITIAL NORMALIZATION + CES *****************
**************************************************************************************************

use data,clear
set more off

qui foreach var in museum gatherings books theater praised eatmomdad lessons newspaper instrument word_Z paragraph_Z income worth_1980 nogood_1980 {
replace `var'=. if  `var'<0
replace `var'=log(`var')
}

qui foreach var in math recognition comp {
replace `var'=. if  `var'<0

*sum `var' if cat==1
*replace `var'=`var'-r(mean)
*replace `var'=`var'/r(sd)

}

* Normalizations

*loading of measurement
gen LAMBDA1=1

*mean of measurement
gen MU1=0

global run=2

run codes/CES_model2.do

sum treat*


matrix  INV1 = (INV11 \ INV12 \ INV13)
matrix  INV2 = (INV21 \ INV22 \ INV23)


mat list INV1
mat list INV2

mat TECH1=(TECH11\TECH12\TECH13)
mat TECH2=(TECH21\TECH22\TECH23)

mat list TECH1
mat list TECH2

