capture: log close
clear
set mem 200m
#delimit;

************************************************************
Aug 12 2011

Tables of cells

**************************************************************



********************;
* extramarital all;

***
* 0,1,2-10 aggregation;
*insheet using "extra", clear; //need to set directory

gen age_1 = 1 if age2008>36;
replace age_1 = 0 if age_1!=1;
gen age_2 = 1 if age2008>42;
replace age_2 = 0 if age_2!=1;
gen age_3 = 1 if age2008>49;
replace age_3 = 0 if age_3!=1;
gen age_4 = 1 if age2008>56;
replace age_4 = 0 if age_4!=1;
replace age2008 = age_1+age_2 + age_3 + age_4;
drop age_1 age_2 age_3 age_4;


replace bean_status2006 = 2 if bean_status2006>2;

gen id= (age2008*1000) + (bean_status2006*1000000) + (cheat2004*100000000); 



* number of observations in cell;
gen one = 1;
bysort id: egen cell_size = sum(one);

* one line per cell;
sort id;
drop if id == id[_n-1];


keep cheat2004 bean_status2006 age2008 cell_size;
order age2008 bean_status2006 cheat2004 cell_size;

gsort -cell_size age2008 bean_status2006 cheat2004;


outsheet using "$cells\extra2_10.csv", replace comma;


***
* 0,1,2-4, 5-10 aggregation;
*insheet using "extra", clear; //need to set directory

gen age_1 = 1 if age2008>36;
replace age_1 = 0 if age_1!=1;
gen age_2 = 1 if age2008>42;
replace age_2 = 0 if age_2!=1;
gen age_3 = 1 if age2008>49;
replace age_3 = 0 if age_3!=1;
gen age_4 = 1 if age2008>56;
replace age_4 = 0 if age_4!=1;
replace age2008 = age_1+age_2 + age_3 + age_4;
drop age_1 age_2 age_3 age_4;


replace bean_status2006 = 2 if bean_status2006>2 & bean_status2006<=4;
replace bean_status2006 = 3 if bean_status2006>4 & bean_status2006<=10;

gen id= (age2008*1000) + (bean_status2006*1000000) + (cheat2004*100000000); 



* number of observations in cell;
gen one = 1;
bysort id: egen cell_size = sum(one);

* one line per cell;
sort id;
drop if id == id[_n-1];


keep cheat2004 bean_status2006 age2008 cell_size;
order age2008 bean_status2006 cheat2004 cell_size;

gsort -cell_size age2008 bean_status2006 cheat2004;


outsheet using "$cells\extra2_4_5_10.csv", replace comma;



********************;
* more than one partner, all;

***
* 0,1,2-10 aggregation;
*insheet using "number", clear; //need to set directory

gen age_1 = 1 if age2008>36;
replace age_1 = 0 if age_1!=1;
gen age_2 = 1 if age2008>42;
replace age_2 = 0 if age_2!=1;
gen age_3 = 1 if age2008>49;
replace age_3 = 0 if age_3!=1;
gen age_4 = 1 if age2008>56;
replace age_4 = 0 if age_4!=1;
replace age2008 = age_1+age_2 + age_3 + age_4;
drop age_1 age_2 age_3 age_4;


replace bean_status2006 = 2 if bean_status2006>2;

gen id= (age2008*1000) + (bean_status2006*1000000) + (more12004*100000000); 



* number of observations in cell;
gen one = 1;
bysort id: egen cell_size = sum(one);

* one line per cell;
sort id;
drop if id == id[_n-1];


keep more12004 bean_status2006 age2008 cell_size;
order age2008 bean_status2006 more12004 cell_size;

gsort -cell_size age2008 bean_status2006 more12004;


outsheet using "$cells\number2_10.csv", replace comma;


***
* 0,1,2-4, 5-10 aggregation;
*insheet using "number", clear; //need to set directory

gen age_1 = 1 if age2008>36;
replace age_1 = 0 if age_1!=1;
gen age_2 = 1 if age2008>42;
replace age_2 = 0 if age_2!=1;
gen age_3 = 1 if age2008>49;
replace age_3 = 0 if age_3!=1;
gen age_4 = 1 if age2008>56;
replace age_4 = 0 if age_4!=1;
replace age2008 = age_1+age_2 + age_3 + age_4;
drop age_1 age_2 age_3 age_4;


replace bean_status2006 = 2 if bean_status2006>2 & bean_status2006<=4;
replace bean_status2006 = 3 if bean_status2006>4 & bean_status2006<=10;

gen id= (age2008*1000) + (bean_status2006*1000000) + (more12004*100000000); 



* number of observations in cell;
gen one = 1;
bysort id: egen cell_size = sum(one);

* one line per cell;
sort id;
drop if id == id[_n-1];


keep more12004 bean_status2006 age2008 cell_size;
order age2008 bean_status2006 more12004 cell_size;

gsort -cell_size age2008 bean_status2006 more12004;

* set directory
*outsheet using "$cells\number2_4_5_10.csv", replace comma;


