*! Version 9 (06/06/2006)
*! De Luca Giuseppe
*! Semi-nonparametric estimation of sequential binary choice model

program define snpbpsel_m, eclass
	version 10.0
	if replay() {
		if "`e(cmd)'" ~= "snpbpsel_m" error 301
		Replay `0'
	}
	else Estimate `0'
end

program define Estimate, eclass
qui {
	* Identify variable 
		gettoken depvar 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depvarn : subinstr local depvar "." "_"

	* Syntax
		syntax varlist(min=1) [pw fw iw] [if] [in] , SELect(string)						///
			[noCONstant OFFset(varname numeric) order1(integer 0) order2(integer 0) 		///
			Robust From(string) dplot(string) Level(passthru) noLOg 					///
			cv(string) startprobit											///
			p1(string) p2(string) p12(string) xb1(string) xb2(string) NORMality			///
			*]

	* Identify Selection equation 
		Select seldep selind selnc seloff : `"`select'"'
		local selname : subinstr local seldep "." "_"

	* Options
		local nc `constant'
		local snc `selnc'
		if "`seloff'"  != "" local soff "offset(`seloff')" 
		if "`offset'"  != "" local off "offset(`offset')" 
		if "`weight'" != "" local wgt [`weight'`exp']
		mlopts mlopts, `options'
		noi di in gr "`mlopts'"

	* Estimation sample 
		marksample touse, novarlist
		markout `touse' `seldep' `selind' `seloff' `cluster', strok
		marksample touse2
		markout `touse2' `depvar' `varlist' `offset'
		replace `touse' = 0 if `seldep' & !`touse2'

	* Check estimation sample 
		count if `touse' 
		if r(N)==0 error 2000 
		count if `touse2' 
		if r(N)==0 error 2000 

	* Count number of coefficients in each equation
		local vareq2 `"`varlist'"'
		tokenize `vareq2'
		local k2: word count `vareq2'

		local vareq1 `"`selind'"'
		tokenize `vareq1'
		local k1: word count `vareq1'

	* Check order and cv options 
		if "`cv'"!="" & ("`order1'"!="0"|"`order2'"!="0") {
			noi di in red "order and cv options cannot be specified simultaneously"
			exit
		}
		if "`cv'"=="" & ("`order1'"=="0"|"`order2'"=="0") {
			noi di in red "order or cv options required"
			exit
		}

	* Get degree of the polinomial expansion
		if "`cv'"!="" {
			noi snpopsel_cv `depvar'=`varlist' 				///
				if `touse',							///
				`off' sel(`seldep'=`selind', `snc' `soff')	///
				`robust' from(`from') cv(`cv') `mlopts' 
			global R1=e(order1)
			global R2=e(order2)
		}
		else {	
			global R1=`order1'
			global R2=`order2'
		}			
		if $R1<=0 | $R2<=0 {
			noi di _n "Order R1 and R2 of SNP polynomial must be a positive integer"
			exit
		}
		noi di in gr "Order of SNP polynomial - (R1,R2)=(" in ye ${R1} in gr "," in ye ${R2} in gr ")" 
	  	local snp_par=$R1 * $R2

	* Default starting values for the constrained parameters 
		local j=`k2'+2
		local k=`k2'+`k1'+1
		cap heckprob `depvar' `varlist' `wgt' if `touse', 	///
			sel(`seldep'=`selind' , `snc' `soff') `mlopts'  ///
			`nc' `off'
		if e(converged)==1 {
			if "`snc'"=="" 	global Con1=_b[`selname':_cons]
			else {			
				global Con1=0
				local k=`k'-1
			}				
			if "`nc'"=="" 	global Con2=_b[`depvarn':_cons]
			else {
				global Con2=0
				local j=`j'-1
			}
		}
		else {
			cap probit `seldep' `selind'  `wgt' if `touse', `snc' `soff' `mlopts'  
			global Con1=_b[_cons]
			
			cap probit `depvar' `varlist' `wgt' if `touse', `nc' `off' `mlopts'  
			global Con2=_b[_cons]
		}

	* Starting values
		if "`from'" == "" {
			if "`startprobit'"=="" {
				* Parametric default estimates
					tempname b0 
					matrix `b0' = e(b)

				* Main equation
					tempname b0_main 
					matrix `b0_main' = `b0'[1..1,1..`k2']

				* Selection equation
					tempname b0_sel 
					matrix `b0_sel' = `b0'[1..1,`j'..`k']
			}
			else {

				* Main equation
					tempname b0 b0_main 
					cap probit `depvar' `varlist' `wgt' if `touse', `nc' `off'
					matrix `b0' = e(b)
					matrix `b0_main' = `b0'[1..1,1..`k2']
					matrix coleq `b0_main'=`depvar' 
 
				* Selection equation
					tempname b0 b0_sel 
					cap probit `seldep' `selind'  `wgt' if `touse', `snc' `soff'
					matrix `b0' = e(b)
					matrix `b0_sel' = `b0'[1..1,1..`k1']
					matrix coleq `b0_sel'=`seldep' 
 
			}
			* SNP equations
				tempname b0_snp
				mat def `b0_snp' = J(1,`snp_par',0)
				local snp_matn ""
				forvalues i=1(1)$R1 {
					forvalues j=1(1)$R2 {
						local snp_matn "`snp_matn' g_`i'_`j':_cons"
					}
				}
				matrix colnames `b0_snp' = `snp_matn'

			* Define starting values
				tempname from
				mat def `from' = (`b0_main', `b0_sel', `b0_snp')
				*noi matrix list `from'
		}

	* Generate SNP ML equations
		local snp_eq ""
		global SNP_PAR ""
		forvalues i=1(1)$R1 {
			forvalues j=1(1)$R2 {
				local snp_eq "`snp_eq' (g_`i'_`j':)"
				global SNP_PAR "${SNP_PAR} gg_`i'_`j'"
			}
		}

	* Generate categories indicators (check if we need this)
		tempvar YI_0 YI_1 YI_2
		gen `YI_0'=(`seldep'==0)
		gen `YI_1'=(`seldep'==1 & `depvar'==0)
		gen `YI_2'=(`seldep'==1 & `depvar'==1)
		global YIND "`YI_0' `YI_1' `YI_2'"

	* Optimization routine
		noi ml model lf snpbpsel_ll_m 								///
			(`depvarn': `depvar'=`varlist', nocons `off') 					///
			(`selname': `seldep'=`selind', nocons `soff') 					///
			`snp_eq'											///
			`wgt' if `touse', 									///
			max miss nopreserve difficult `robust' init(`from') search(off) 		///
			title("SNP Bivariate Sequential Choice Model") `log' `mlopts'  

	* Get indexes (without intercepts)
		if "`xb2'"=="" tempvar xb2
		tokenize `varlist'
		local i 1
		gen `xb2'=0
		foreach j of local varlist {
			replace `xb2'=`xb2'+_b[`depvarn':`j']*`j'
		}

		if "`xb1'"=="" tempvar xb1
		tokenize `selind'
		local i 1
		gen `xb1'=0
		foreach j of local selind {
			replace `xb1'=`xb1'+_b[`selname':`j']*`j'
		}

	* Get SNP parameters (tau_{i,j})
		tempname allpar snppar
		matrix `allpar' = e(b)
		local numpar = colsof(`allpar')
		mat `snppar' = `allpar'[1,(`numpar'-`snp_par'+1)..colsof(`allpar')]
		local g_0_0 = 1
		local temp = 1
		forvalues i=1(1)${R1} {
			tempname g_`i'_0
			scalar  `g_`i'_0' = 0
			forvalues j=1(1)${R2} {
				if `i'==1 {
					tempname g_0_`j' 
					scalar `g_0_`j'' = 0
				}
				tempname g_`i'_`j'
				scalar `g_`i'_`j'' =`snppar'[1,`temp']
				local temp=`temp'+1
			}
		}
	
	* Central moments of the standardized Gaussian distribution
		local Rmax = 2*max(${R1},${R2})+4
		local R12 = 2*${R1}
		local R22 = 2*${R2}
		tempname mu0 mu1 
		scalar `mu0' = 1
		scalar `mu1' = 0
		forvalues i=2(1)`Rmax' {
			local i2=`i'-2
			tempname mu`i'
			scalar `mu`i'' = (`i'-1)*`mu`i2''
		}

	* Compute tau^{*}_{i,j} coefficients and normalization factor 
		tempname theta
		scalar `theta' = 0
		forvalues i=0(1)`R12' {						
			local ai=max(0,`i'-${R1})
			local bi=min(`i',${R1})
			forvalues j=0(1)`R22' {						
				local aj=max(0,`j'-${R2})
				local bj=min(`j',${R2})
				tempname gs_`i'_`j' 
				scalar `gs_`i'_`j''=0
				forvalues is=`ai'(1)`bi' {
					forvalues js=`aj'(1)`bj' {
						local iis = `i'-`is'
						local jjs = `j'-`js'
						scalar `gs_`i'_`j''=`gs_`i'_`j''+ (`g_`is'_`js'' * `g_`iis'_`jjs'')
					}
				}
				scalar `theta'=`theta' + `gs_`i'_`j'' * `mu`i'' * `mu`j'' 
			}
		}

	* Generate p11
	if "`p1'"!=""|"`p2'"!=""|"`p12'"!=""	{
		* Compute factors that are relevant for the probabilities 
		tempvar Au1 Au1L1 Au1L2 Au2 Au2L1 Au2L2 A1 A2 A3
		tempname con1 con2
		scalar `con1'=${Con1}
		scalar `con2'=${Con2}
		gen double `Au1' = 1
		gen double `Au1L1' = 1
		gen double `Au1L2' = 0
		gen double `Au2' = 1   if `seldep'==1
		gen double `Au2L1' = 1 if `seldep'==1
		gen double `Au2L2' = 0 if `seldep'==1
		gen double `A1' = 0
		gen double `A2' = 0
		gen double `A3' = 0
		forvalues i=1(1)`R12' {
			if `i'>1 {	
				replace `Au1'=(`i'-1) * `Au1L2' + ((-`con1'-`xb1')^(`i'-1))	
				if `i'<`R12' {
					replace `Au1L2' = `Au1L1' 						
					replace `Au1L1' = `Au1' 							
				}
				replace `Au2' = 1    if `seldep'==1
				replace `Au2L1' = 1  if `seldep'==1
				replace `Au2L2' = 0  if `seldep'==1
			}
			forvalues j=1(1)`R22' {
				if `j'>1 {
					replace `Au2'=(`j'-1) * `Au2L2' + ((-`con2'-`xb2')^(`j'-1))
					if `j' < `R22' {
						replace `Au2L2' = `Au2L1' 						
						replace `Au2L1' = `Au2' 
					}
				}
				if (`i'!=1 | `j'<=${R2}) & (`j'!=1 | `i'<=${R1}) {
					replace `A1'=`A1' + `gs_`i'_`j'' * `Au1' * `Au2'
					local temp_i=2*int(`i'/2)
					local temp_j=2*int(`j'/2)
					if `temp_i'==`i' {
						replace `A2'=`A2' + `gs_`i'_`j'' * `mu`i'' * `Au2' 
					}
					if `temp_j'==`j' {
						replace `A3'=`A3' + `gs_`i'_`j'' * `Au1' * `mu`j'' 
					}
				}
			}
		}	

		* Compute p11 

		tempvar Fu1 Fu2 Fu1u2
		gen double `Fu1u2' = normal(-`con1'-`xb1') * normal(-`con2'-`xb2')	 		 		+ 	/*
					    */ `A1' * normalden(-`con1'-`xb1') * normalden(-`con2'-`xb2')/`theta' 	-	/*
					    */ `A2' * normal(-`con1'-`xb1')    * normalden(-`con2'-`xb2')/`theta' 	-   	/*
					    */ `A3' * normalden(-`con1'-`xb1') * normal(-`con2'-`xb2')   /`theta'   
		gen double `Fu1' = normal(-`con1'-`xb1') - `A3' * normalden(-`con1'-`xb1')/`theta'   
		gen double `Fu2' = normal(-`con2'-`xb2') - `A2' * normalden(-`con2'-`xb2')/`theta' 

		gen double `p1' = 1-`Fu1'
		gen double `p2' = 1-`Fu2'
		gen double `p12' = 1-`Fu1'-`Fu2'+`Fu1u2'   
	}

	* Compute uncentered moments
		forvalues i=1(1)4 {
			tempname mom_u1_`i' mom_u2_`i'
			scalar `mom_u1_`i''=0
			scalar `mom_u2_`i''=0
		}
		tempname mom_u1_u2
		scalar `mom_u1_u2'=0
		forvalues i=0(1)`R12' {
			forvalues j=0(1)`R22' {
				local h1=`i'+1
				local h2=`j'+1
				scalar `mom_u1_u2' = `mom_u1_u2' + (`gs_`i'_`j''*`mu`h1''*`mu`h2'')
				forvalues t=1(1)4 {
					local h3=`i'+`t'
					local h4=`j'+`t'
					scalar `mom_u1_`t'' = `mom_u1_`t'' + (`gs_`i'_`j''*`mu`h3''*`mu`j'')
					scalar `mom_u2_`t'' = `mom_u2_`t'' + (`gs_`i'_`j''*`mu`i''*`mu`h4'')
				}
			}
		}
		scalar `mom_u1_u2'=`mom_u1_u2'/`theta'
		forvalues t=1(1)4 {
			scalar `mom_u1_`t'' = `mom_u1_`t''/`theta'
			scalar `mom_u2_`t'' = `mom_u2_`t''/`theta'
		}

	* Estimation return
		ereturn local cmd "snpbpsel_m"
		ereturn scalar R1=$R1
		ereturn scalar R2=$R2
		ereturn scalar mean1=`mom_u1_1'
		ereturn scalar var1=`mom_u1_2'-(`mom_u1_1')^2
		ereturn scalar sd1= sqrt(e(var1))
		ereturn scalar ske1= (`mom_u1_3'+2*(`mom_u1_1'^3)-3*`mom_u1_1'*`mom_u1_2')/(e(sd1)^3)
		ereturn scalar kurt1= (`mom_u1_4'+6*(`mom_u1_1'^2)*`mom_u1_2'-4*`mom_u1_1'*`mom_u1_3'-3*(`mom_u1_1'^4))/(e(var1)^2)
		ereturn scalar mean2=`mom_u2_1'
		ereturn scalar var2=`mom_u2_2'-(`mom_u2_1')^2
		ereturn scalar sd2= sqrt(e(var2))
		ereturn scalar ske2= (`mom_u2_3'+2*(`mom_u2_1'^3)-3*`mom_u2_1'*`mom_u2_2')/(e(sd2)^3)
		ereturn scalar kurt2= (`mom_u2_4'+6*(`mom_u2_1'^2)*`mom_u2_2'-4*`mom_u2_1'*`mom_u2_3'-3*(`mom_u2_1'^4))/(e(var2)^2)
		ereturn scalar rho=(`mom_u1_u2'-`mom_u1_1'*`mom_u2_1')/(e(sd1)*e(sd2)) 
	
	* Display estimates
		noi Replay, `level' 

	* Density plots 
		if "`dplot'"!="" {
			local pol1 ""
			forvalues i=0(1)`R12' {
				local gam_`i'=0
				forvalues j=0(1)`R22' {	
					local gam_`i'=`gam_`i''+`gs_`i'_`j''*`mu`j''
				}
				if `i'< `R12' local pol1 "`pol1' `gam_`i''* x^(`i') + "
				else local pol1 "`pol1' `gam_`i''*x^(`i') "
			}

			local pol2 ""
			forvalues j=0(1)`R22' {
				local del_`j'=0
				forvalues i=0(1)`R12' {	
					local del_`j'=`del_`j''+`gs_`i'_`j''*`mu`i''
				}
				if `j'<`R22' local pol2 "`pol2' `del_`j''*x^(`j') +"
				else local pol2 "`pol2' `del_`j''*x^(`j')"
			}

			qui twoway 													///
				(function SNP=[1/`theta']*[normalden(x)]* [`pol1'] , range(-5 5)) 		///
				(function Normal=exp(-(x-e(mean1))^2/(2*e(sd1)^2))/(sqrt(2*c(pi))*e(sd1))	///
					, range(-5 5) lp(dash_dot) lc(red))							///
				, xtitle("Sel. eq.") ytitle(Density) xlabel(-5(1)5) ylabel(0(.1).4)		///
				legend(off) graphr(c(white))									///
				name(`name'_1, replace) saving("`dplot'_1", replace)		

			qui twoway 													///
				(function SNP=[1/`theta']*[normalden(x)]* [`pol2'] , range(-5 5)) 		///
				(function Normal=exp(-(x-e(mean2))^2/(2*e(sd2)^2))/(sqrt(2*c(pi))*e(sd2))	///
					, range(-5 5) lp(dash_dot) lc(red))							///
				, xtitle("Main Eq.") ytitle(Density) xlabel(-5(1)5) ylabel(0(.1).4)		///
				legend(off) graphr(c(white))									///
				name(`name'_2, replace) saving("`dplot'_2", replace)	

			qui gr combine `name'_2 `name'_1, name(`name', replace) saving("`dplot'", replace) graphr(c(white))	
		}


		* Wald Test for the Gaussianity of the error terms
			if "`normality'"!="" {
				tempname est
				estimates store `est'

				if ${R1}==3 & ${R2}==3 {
					nlcom  	(gam1:2*[g_1_2]_cons										    ) /*
						*/	(gam2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_1_3]_cons+						/*
						*/		3*([g_1_2]_cons)^2+15*([g_1_3]_cons)^2+2*[g_2_2]_cons				    )	/*
						*/ 	(gam3:2*[g_1_1]_cons*([g_2_1]_cons+3*[g_2_3]_cons)+6*[g_1_2]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_1_3]_cons*([g_2_1]_cons+5*[g_2_3]_cons)+2*[g_3_2]_cons			    )	/*
						*/ 	(gam4:2*[g_1_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_1_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+([g_2_1]_cons)^2+			/*
						*/		6*[g_2_1]_cons*[g_2_3]_cons+3*([g_2_2]_cons)^2+15*([g_2_3]_cons)^2	    )	/*
						*/	(gam5:2*[g_2_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)					    ) /*
						*/	(gam6:([g_3_1]_cons)^2+6*[g_3_1]_cons*[g_3_3]_cons+3*([g_3_2]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2									    )	/*
						*/	(del1:2*[g_2_1]_cons										    ) /*
						*/	(del2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_3_1]_cons+						/*
						*/		3*([g_2_1]_cons)^2+15*([g_3_1]_cons)^2+2*[g_2_2]_cons				    )	/*
						*/ 	(del3:2*[g_1_1]_cons*([g_1_2]_cons+3*[g_3_2]_cons)+6*[g_2_1]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_3_1]_cons*([g_1_2]_cons+5*[g_3_2]_cons)+2*[g_2_3]_cons			    )	/*
						*/ 	(del4:2*[g_1_1]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_1]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+([g_1_2]_cons)^2+			/*
						*/		6*[g_1_2]_cons*[g_3_2]_cons+3*([g_2_2]_cons)^2+15*([g_3_2]_cons)^2	    )	/*
						*/	(del5:2*[g_1_2]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_2]_cons*([g_1_3]_cons+5*[g_3_3]_cons)					    ) /*
						*/	(del6:([g_1_3]_cons)^2+6*[g_1_3]_cons*[g_3_3]_cons+3*([g_2_3]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2									    ) /*
						*/	, post
					test _b[gam1]=_b[gam2]=_b[gam3]=_b[gam4]=_b[gam5]=_b[gam6]=0
					local stat1=r(chi2)
					local dof1=r(df)
					local p1=r(p)
					test _b[del1]=_b[del2]=_b[del3]=_b[del4]=_b[del5]=_b[del6]=0
					local stat2=r(chi2)
					local dof2=r(df)
					local p2=r(p)
				}
				if ${R1}==4 & ${R2}==3{
					nlcom  	(gam1:2*[g_1_2]_cons										    ) /*
						*/	(gam2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_1_3]_cons+						/*
						*/		3*([g_1_2]_cons)^2+15*([g_1_3]_cons)^2+2*[g_2_2]_cons				    )	/*
						*/ 	(gam3:2*[g_1_1]_cons*([g_2_1]_cons+3*[g_2_3]_cons)+6*[g_1_2]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_1_3]_cons*([g_2_1]_cons+5*[g_2_3]_cons)+2*[g_3_2]_cons			    )	/*
						*/ 	(gam4:2*[g_1_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_1_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+([g_2_1]_cons)^2+			/*
						*/		6*[g_2_1]_cons*[g_2_3]_cons+3*([g_2_2]_cons)^2+15*([g_2_3]_cons)^2+		/*
						*/		2*[g_4_2]_cons    									    )	/*
						*/	(gam5:2*[g_2_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_1_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)    				    ) /*
						*/	(gam6:([g_3_1]_cons)^2+6*[g_3_1]_cons*[g_3_3]_cons+3*([g_3_2]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_2_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_2_2]_cons*[g_4_2]_cons+	/*
						*/	    	6*[g_2_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)					    )	/*
						*/	(gam7:2*[g_3_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_3_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_3_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)					    )	/*
						*/	(gam8:([g_4_1]_cons)^2+6*[g_4_1]_cons*[g_4_3]_cons+3*([g_4_2]_cons)^2+			/*
						*/		15*([g_4_3]_cons)^2									    )	/*
						*/	(del1:2*[g_2_1]_cons+6*[g_4_1]_cons								    ) /*
						*/	(del2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_3_1]_cons+						/*
						*/		3*([g_2_1]_cons)^2+15*([g_3_1]_cons)^2+2*[g_2_2]_cons+				/*
						*/		30*[g_2_1]_cons*[g_4_1]_cons+105*([g_4_1]_cons)^2+6*[g_4_2]_cons		    )	/*
						*/ 	(del3:2*[g_1_1]_cons*([g_1_2]_cons+3*[g_3_2]_cons)+6*[g_2_1]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_3_1]_cons*([g_1_2]_cons+5*[g_3_2]_cons)+2*[g_2_3]_cons+			/*
						*/    	30*[g_2_1]_cons*[g_4_2]_cons+30*[g_4_1]_cons*([g_2_2]_cons+7*[g_4_2]_cons)+	/*
						*/		6*[g_4_3]_cons										    ) /*
						*/ 	(del4:2*[g_1_1]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_1]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+([g_1_2]_cons)^2+			/*
						*/		6*[g_1_2]_cons*[g_3_2]_cons+3*([g_2_2]_cons)^2+15*([g_3_2]_cons)^2+	    	/*
						*/		30*[g_4_3]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_2_3]_cons*[g_4_1]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_2]_cons+105*([g_4_2]_cons)^2				    )	/*
						*/	(del5:2*[g_1_2]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_2]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+						/*
						*/		30*[g_4_3]_cons*[g_2_2]_cons+30*[g_4_2]_cons*([g_2_3]_cons+7*[g_4_3]_cons)  ) /*
						*/	(del6:([g_1_3]_cons)^2+6*[g_1_3]_cons*[g_3_3]_cons+3*([g_2_3]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		30*[g_2_3]_cons*[g_4_3]_cons+105*([g_4_3]_cons)^2				    ) /*
						*/	, post
					test _b[gam1]=_b[gam2]=_b[gam3]=_b[gam4]=_b[gam5]=_b[gam6]=_b[gam7]=_b[gam8]=0
					local stat1=r(chi2)
					local dof1=r(df)
					local p1=r(p)
					test _b[del1]=_b[del2]=_b[del3]=_b[del4]=_b[del5]=_b[del6]=0
					local stat2=r(chi2)
					local dof2=r(df)
					local p2=r(p)
				}
				if ${R1}==4 & ${R2}==4{
					nlcom  	(gam1:2*[g_1_2]_cons+6*[g_1_4]_cons								    ) /*
						*/	(gam2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_1_3]_cons+						/*
						*/		3*([g_1_2]_cons)^2+15*([g_1_3]_cons)^2+2*[g_2_2]_cons+			    	/*
						*/		30*[g_1_2]_cons*[g_1_4]_cons+105*([g_1_4]_cons)^2+6*[g_2_4]_cons		    )	/*
						*/ 	(gam3:2*[g_1_1]_cons*([g_2_1]_cons+3*[g_2_3]_cons)+6*[g_1_2]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_1_3]_cons*([g_2_1]_cons+5*[g_2_3]_cons)+2*[g_3_2]_cons+		    	/*
						*/		30*[g_2_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_2_2]_cons+	/*
						*/		6*[g_3_4]_cons										    )	/*
						*/ 	(gam4:2*[g_1_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_1_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+([g_2_1]_cons)^2+			/*
						*/		6*[g_2_1]_cons*[g_2_3]_cons+3*([g_2_2]_cons)^2+15*([g_2_3]_cons)^2+		/*
						*/		2*[g_4_2]_cons+    									    	/*
						*/		30*[g_3_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_3_2]_cons+	/*
						*/		30*[g_2_2]_cons*[g_2_4]_cons+105*([g_2_4]_cons)^2+6*[g_4_4]_cons		    )	/*
						*/	(gam5:2*[g_2_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_1_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+    				    	/*
						*/		30*[g_4_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_4_2]_cons+	/*
						*/		30*[g_2_2]_cons*[g_3_4]_cons+30*[g_2_4]_cons*([g_3_2]_cons+7*[g_3_4]_cons)  ) /*
						*/	(gam6:([g_3_1]_cons)^2+6*[g_3_1]_cons*[g_3_3]_cons+3*([g_3_2]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_2_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_2_2]_cons*[g_4_2]_cons+	/*
						*/	    	6*[g_2_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+						/*
						*/		30*[g_4_4]_cons*([g_2_2]_cons+7*[g_2_4]_cons)+30*[g_2_4]_cons*[g_4_2]_cons+ 	/*
						*/		30*[g_3_2]_cons*[g_3_4]_cons+105*([g_3_4]_cons)^2				    )	/*
						*/	(gam7:2*[g_3_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_3_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_3_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_3_2]_cons+7*[g_3_4]_cons)+30*[g_3_4]_cons*[g_4_2]_cons  )	/*
						*/	(gam8:([g_4_1]_cons)^2+6*[g_4_1]_cons*[g_4_3]_cons+3*([g_4_2]_cons)^2+			/*
						*/		15*([g_4_3]_cons)^2+										/*
						*/		30*[g_4_2]_cons*[g_4_4]_cons+105*([g_4_4]_cons)^2				    )	/*
						*/	(del1:2*[g_2_1]_cons+6*[g_4_1]_cons								    ) /*
						*/	(del2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_3_1]_cons+						/*
						*/		3*([g_2_1]_cons)^2+15*([g_3_1]_cons)^2+2*[g_2_2]_cons+			    	/*
						*/		30*[g_2_1]_cons*[g_4_1]_cons+105*([g_4_1]_cons)^2+6*[g_4_2]_cons		    )	/*
						*/ 	(del3:2*[g_1_1]_cons*([g_1_2]_cons+3*[g_3_2]_cons)+6*[g_2_1]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_3_1]_cons*([g_1_2]_cons+5*[g_3_2]_cons)+2*[g_2_3]_cons+		    	/*
						*/		30*[g_4_2]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_2]_cons+	/*
						*/		6*[g_4_3]_cons										    )	/*
						*/ 	(del4:2*[g_1_1]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_1]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+([g_1_2]_cons)^2+			/*
						*/		6*[g_1_2]_cons*[g_3_2]_cons+3*([g_2_2]_cons)^2+15*([g_3_2]_cons)^2+		/*
						*/		2*[g_2_4]_cons+    									    	/*
						*/		30*[g_4_3]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_3]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_2]_cons+105*([g_4_2]_cons)^2+6*[g_4_4]_cons		    )	/*
						*/	(del5:2*[g_1_2]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_2]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_1]_cons*[g_2_4]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+    				    	/*
						*/		30*[g_4_4]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_4]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_3]_cons+30*[g_4_2]_cons*([g_2_3]_cons+7*[g_4_3]_cons)  ) /*
						*/	(del6:([g_1_3]_cons)^2+6*[g_1_3]_cons*[g_3_3]_cons+3*([g_2_3]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_1_2]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_2]_cons*[g_2_4]_cons+	/*
						*/	    	6*[g_3_2]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+						/*
						*/		30*[g_4_4]_cons*([g_2_2]_cons+7*[g_4_2]_cons)+30*[g_4_2]_cons*[g_2_4]_cons+ 	/*
						*/		30*[g_2_3]_cons*[g_4_3]_cons+105*([g_4_3]_cons)^2				    )	/*
						*/	(del7:2*[g_1_3]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_3]_cons*[g_2_4]_cons+	/*
						*/		6*[g_3_3]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_2_3]_cons+7*[g_4_3]_cons)+30*[g_4_3]_cons*[g_2_4]_cons  )	/*
						*/	(del8:([g_1_4]_cons)^2+6*[g_1_4]_cons*[g_3_4]_cons+3*([g_2_4]_cons)^2+			/*
						*/		15*([g_3_4]_cons)^2+										/*
						*/		30*[g_2_4]_cons*[g_4_4]_cons+105*([g_4_4]_cons)^2				    )	/*
						*/	, post
					test _b[gam1]=_b[gam2]=_b[gam3]=_b[gam4]=_b[gam5]=_b[gam6]=_b[gam7]=_b[gam8]=0
					local stat1=r(chi2)
					local dof1=r(df)
					local p1=r(p)
					test _b[del1]=_b[del2]=_b[del3]=_b[del4]=_b[del5]=_b[del6]=_b[del7]=_b[del8]=0
					local stat2=r(chi2)
					local dof2=r(df)
					local p2=r(p)
				}
				if ${R1}==5 & ${R2}==3{
					nlcom  	(gam1:2*[g_1_2]_cons										    ) /*
						*/	(gam2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_1_3]_cons+						/*
						*/		3*([g_1_2]_cons)^2+15*([g_1_3]_cons)^2+2*[g_2_2]_cons				    )	/*
						*/ 	(gam3:2*[g_1_1]_cons*([g_2_1]_cons+3*[g_2_3]_cons)+6*[g_1_2]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_1_3]_cons*([g_2_1]_cons+5*[g_2_3]_cons)+2*[g_3_2]_cons			    )	/*
						*/ 	(gam4:2*[g_1_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_1_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+([g_2_1]_cons)^2+			/*
						*/		6*[g_2_1]_cons*[g_2_3]_cons+3*([g_2_2]_cons)^2+15*([g_2_3]_cons)^2+		/*
						*/		2*[g_4_2]_cons    									    )	/*
						*/	(gam5:2*[g_2_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_1_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+    				    	/*
						*/		2*[g_5_2]_cons										    ) /*
						*/	(gam6:([g_3_1]_cons)^2+6*[g_3_1]_cons*[g_3_3]_cons+3*([g_3_2]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_2_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_2_2]_cons*[g_4_2]_cons+	/*
						*/	    	6*[g_2_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+					    	/*
						*/		2*[g_1_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+6*[g_1_2]_cons*[g_5_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)					    )	/*
						*/	(gam7:2*[g_3_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_3_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_3_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+					    	/*
						*/		2*[g_2_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+6*[g_2_2]_cons*[g_5_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)					    )	/*
						*/	(gam8:([g_4_1]_cons)^2+6*[g_4_1]_cons*[g_4_3]_cons+3*([g_4_2]_cons)^2+			/*
						*/		15*([g_4_3]_cons)^2+									    	/*
						*/		2*[g_3_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+6*[g_3_2]_cons*[g_5_2]_cons+	/*
						*/		6*[g_3_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)					    )	/*
						*/	(gam9:2*[g_4_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+6*[g_4_2]_cons*[g_5_2]_cons+	/*
						*/		6*[g_4_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)					    )	/*
						*/   (gam10:([g_5_1]_cons)^2+6*[g_5_1]_cons*[g_5_3]_cons+3*([g_5_2]_cons)^2+			/*
						*/		15*([g_5_3]_cons)^2									    ) /*
						*/	(del1:2*[g_2_1]_cons+6*[g_4_1]_cons								    ) /*
						*/	(del2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_3_1]_cons+						/*
						*/		3*([g_2_1]_cons)^2+15*([g_3_1]_cons)^2+2*[g_2_2]_cons+				/*
						*/		30*[g_2_1]_cons*[g_4_1]_cons+105*([g_4_1]_cons)^2+6*[g_4_2]_cons+		    	/*
						*/		30*[g_5_1]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+945*([g_5_1]_cons)^2	    )	/*
						*/ 	(del3:2*[g_1_1]_cons*([g_1_2]_cons+3*[g_3_2]_cons)+6*[g_2_1]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_3_1]_cons*([g_1_2]_cons+5*[g_3_2]_cons)+2*[g_2_3]_cons+			/*
						*/    	30*[g_2_1]_cons*[g_4_2]_cons+30*[g_4_1]_cons*([g_2_2]_cons+7*[g_4_2]_cons)+	/*
						*/		6*[g_4_3]_cons+										    	/*
						*/		30*[g_5_1]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+1890*[g_5_1]_cons*[g_5_2]_cons+	/*
						*/		30*[g_5_2]_cons*([g_1_1]_cons+7*[g_3_1]_cons)					    ) /*
						*/ 	(del4:2*[g_1_1]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_1]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+([g_1_2]_cons)^2+			/*
						*/		6*[g_1_2]_cons*[g_3_2]_cons+3*([g_2_2]_cons)^2+15*([g_3_2]_cons)^2+	    	/*
						*/		30*[g_4_3]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_2_3]_cons*[g_4_1]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_2]_cons+105*([g_4_2]_cons)^2+				    	/*
						*/		30*[g_5_1]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+945*([g_5_2]_cons)^2+		/*
						*/		30*[g_5_2]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+1890*[g_5_1]_cons*[g_5_3]_cons+	/*
						*/		30*[g_5_3]_cons*([g_1_1]_cons+7*[g_3_1]_cons)					    )	/*
						*/	(del5:2*[g_1_2]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_2]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+						/*
						*/		30*[g_4_3]_cons*[g_2_2]_cons+30*[g_4_2]_cons*([g_2_3]_cons+7*[g_4_3]_cons)+	/*
						*/		30*[g_5_2]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+1890*[g_5_2]_cons*[g_5_3]_cons+ /*
						*/		30*[g_5_3]_cons*([g_1_2]_cons+7*[g_3_2]_cons) 					    ) /*
						*/	(del6:([g_1_3]_cons)^2+6*[g_1_3]_cons*[g_3_3]_cons+3*([g_2_3]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		30*[g_2_3]_cons*[g_4_3]_cons+105*([g_4_3]_cons)^2+				    	/*
						*/		30*[g_5_3]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+945*([g_5_3]_cons)^2	    ) /*
						*/	, post
					test _b[gam1]=_b[gam2]=_b[gam3]=_b[gam4]=_b[gam5]=_b[gam6]=_b[gam7]=_b[gam8]=_b[gam9]=_b[gam10]=0
					local stat1=r(chi2)
					local dof1=r(df)
					local p1=r(p)
					test _b[del1]=_b[del2]=_b[del3]=_b[del4]=_b[del5]=_b[del6]=0
					local stat2=r(chi2)
					local dof2=r(df)
					local p2=r(p)
				}
				if ${R1}==5 & ${R2}==4{
					nlcom  	(gam1:2*[g_1_2]_cons+6*[g_1_4]_cons								    ) /*
						*/	(gam2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_1_3]_cons+						/*
						*/		3*([g_1_2]_cons)^2+15*([g_1_3]_cons)^2+2*[g_2_2]_cons+			    	/*
						*/		30*[g_1_2]_cons*[g_1_4]_cons+105*([g_1_4]_cons)^2+6*[g_2_4]_cons		    )	/*
						*/ 	(gam3:2*[g_1_1]_cons*([g_2_1]_cons+3*[g_2_3]_cons)+6*[g_1_2]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_1_3]_cons*([g_2_1]_cons+5*[g_2_3]_cons)+2*[g_3_2]_cons+		    	/*
						*/		30*[g_2_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_2_2]_cons+	/*
						*/		6*[g_3_4]_cons										    )	/*
						*/ 	(gam4:2*[g_1_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_1_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+([g_2_1]_cons)^2+			/*
						*/		6*[g_2_1]_cons*[g_2_3]_cons+3*([g_2_2]_cons)^2+15*([g_2_3]_cons)^2+		/*
						*/		2*[g_4_2]_cons+    									    	/*
						*/		30*[g_3_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_3_2]_cons+	/*
						*/		30*[g_2_2]_cons*[g_2_4]_cons+105*([g_2_4]_cons)^2+6*[g_4_4]_cons		    )	/*
						*/	(gam5:2*[g_2_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_1_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+    				    	/*
						*/		30*[g_4_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_4_2]_cons+	/*
						*/		30*[g_2_2]_cons*[g_3_4]_cons+30*[g_2_4]_cons*([g_3_2]_cons+7*[g_3_4]_cons)+  	/*
						*/		2*[g_5_2]_cons+6*[g_5_4]_cons								    ) /*
						*/	(gam6:([g_3_1]_cons)^2+6*[g_3_1]_cons*[g_3_3]_cons+3*([g_3_2]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_2_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_2_2]_cons*[g_4_2]_cons+	/*
						*/	    	6*[g_2_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+						/*
						*/		30*[g_4_4]_cons*([g_2_2]_cons+7*[g_2_4]_cons)+30*[g_2_4]_cons*[g_4_2]_cons+ 	/*
						*/		30*[g_3_2]_cons*[g_3_4]_cons+105*([g_3_4]_cons)^2+					/*
						*/		2*[g_1_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+  						/*
						*/		6*[g_1_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+  						/*
						*/		6*[g_1_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+  						/*
						*/		30*[g_1_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)					    )	/*
						*/	(gam7:2*[g_3_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_3_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_3_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_3_2]_cons+7*[g_3_4]_cons)+30*[g_3_4]_cons*[g_4_2]_cons+	/*
						*/		2*[g_2_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+  						/*
						*/		6*[g_2_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+						/*
						*/		6*[g_2_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+						/*
						*/		30*[g_2_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)					    )	/*
						*/	(gam8:([g_4_1]_cons)^2+6*[g_4_1]_cons*[g_4_3]_cons+3*([g_4_2]_cons)^2+			/*
						*/		15*([g_4_3]_cons)^2+										/*
						*/		30*[g_4_2]_cons*[g_4_4]_cons+105*([g_4_4]_cons)^2+					/*
						*/		2*[g_3_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+  						/*
						*/		6*[g_3_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+						/*
						*/		6*[g_3_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+						/*
						*/		30*[g_3_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)					    )	/*
						*/	(gam9:2*[g_4_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+6*[g_4_2]_cons*[g_5_2]_cons+	/*
						*/		6*[g_4_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+					    	/*
						*/		6*[g_4_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)					    )	/*
						*/   (gam10:([g_5_1]_cons)^2+6*[g_5_1]_cons*[g_5_3]_cons+3*([g_5_2]_cons)^2+			/*
						*/		30*[g_5_2]_cons*[g_5_4]_cons+15*([g_5_3]_cons)^2+105*([g_5_4]_cons)^2	    ) /*
						*/	(del1:2*[g_2_1]_cons+6*[g_4_1]_cons								    ) /*
						*/	(del2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_3_1]_cons+						/*
						*/		3*([g_2_1]_cons)^2+15*([g_3_1]_cons)^2+2*[g_2_2]_cons+			    	/*
						*/		30*[g_2_1]_cons*[g_4_1]_cons+105*([g_4_1]_cons)^2+6*[g_4_2]_cons+		    	/*
						*/		30*[g_5_1]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+945*([g_5_1]_cons)^2	    )	/*
						*/ 	(del3:2*[g_1_1]_cons*([g_1_2]_cons+3*[g_3_2]_cons)+6*[g_2_1]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_3_1]_cons*([g_1_2]_cons+5*[g_3_2]_cons)+2*[g_2_3]_cons+		    	/*
						*/		30*[g_4_2]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_2]_cons+	/*
						*/		6*[g_4_3]_cons+										    	/*
						*/		30*[g_5_1]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+1890*[g_5_1]_cons*[g_5_2]_cons+	/*
						*/		30*[g_5_2]_cons*([g_1_1]_cons+7*[g_3_1]_cons)					    ) /*
						*/ 	(del4:2*[g_1_1]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_1]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+([g_1_2]_cons)^2+			/*
						*/		6*[g_1_2]_cons*[g_3_2]_cons+3*([g_2_2]_cons)^2+15*([g_3_2]_cons)^2+		/*
						*/		2*[g_2_4]_cons+    									    	/*
						*/		30*[g_4_3]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_3]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_2]_cons+105*([g_4_2]_cons)^2+6*[g_4_4]_cons+		    	/*
						*/		30*[g_5_1]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_2]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
						*/		945*([g_5_2]_cons)^2+1890*[g_5_1]_cons*[g_5_3]_cons				    )	/*
						*/	(del5:2*[g_1_2]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_2]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_1]_cons*[g_2_4]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+    				    	/*
						*/		30*[g_4_4]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_4]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_3]_cons+30*[g_4_2]_cons*([g_2_3]_cons+7*[g_4_3]_cons)+	/*
						*/		30*[g_5_1]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_2]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
				  		*/		1980*([g_5_1]_cons*[g_5_4]_cons+[g_5_2]_cons*[g_5_3]_cons)			    ) /*
						*/	(del6:([g_1_3]_cons)^2+6*[g_1_3]_cons*[g_3_3]_cons+3*([g_2_3]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_1_2]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_2]_cons*[g_2_4]_cons+	/*
						*/	    	6*[g_3_2]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+						/*
						*/		30*[g_4_4]_cons*([g_2_2]_cons+7*[g_4_2]_cons)+30*[g_4_2]_cons*[g_2_4]_cons+ 	/*
						*/		30*[g_2_3]_cons*[g_4_3]_cons+105*([g_4_3]_cons)^2+				    	/*
						*/		30*[g_5_2]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		945*([g_5_3]_cons)^2+1890*[g_5_2]_cons*[g_5_4]_cons				    )	/*
						*/	(del7:2*[g_1_3]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_3]_cons*[g_2_4]_cons+	/*
						*/		6*[g_3_3]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_2_3]_cons+7*[g_4_3]_cons)+30*[g_4_3]_cons*[g_2_4]_cons+  	/*
						*/		30*[g_5_3]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		1890*[g_5_3]_cons*[g_5_4]_cons				    			    )	/*
						*/	(del8:([g_1_4]_cons)^2+6*[g_1_4]_cons*[g_3_4]_cons+3*([g_2_4]_cons)^2+			/*
						*/		15*([g_3_4]_cons)^2+										/*
						*/		30*[g_2_4]_cons*[g_4_4]_cons+105*([g_4_4]_cons)^2+					/*
						*/		30*[g_5_4]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		945*([g_5_4]_cons)^2									    )	/*
						*/	, post
					test _b[gam1]=_b[gam2]=_b[gam3]=_b[gam4]=_b[gam5]=_b[gam6]=_b[gam7]=_b[gam8]=_b[gam9]=_b[gam10]=0
					local stat1=r(chi2)
					local dof1=r(df)
					local p1=r(p)
					test _b[del1]=_b[del2]=_b[del3]=_b[del4]=_b[del5]=_b[del6]=_b[del7]=_b[del8]=0
					local stat2=r(chi2)
					local dof2=r(df)
					local p2=r(p)
				}
				if ${R1}==5 & ${R2}==5{
					nlcom  	(gam1:2*[g_1_2]_cons+6*[g_1_4]_cons								    ) /*
						*/	(gam2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_1_3]_cons+						/*
						*/		3*([g_1_2]_cons)^2+15*([g_1_3]_cons)^2+2*[g_2_2]_cons+			    	/*
						*/		30*[g_1_2]_cons*[g_1_4]_cons+105*([g_1_4]_cons)^2+6*[g_2_4]_cons+		    	/*
						*/		30*[g_1_5]_cons*([g_1_1]_cons+7*[g_1_3]_cons)+						/*
						*/		945*([g_1_5]_cons)^2									    )	/*
						*/ 	(gam3:2*[g_1_1]_cons*([g_2_1]_cons+3*[g_2_3]_cons)+6*[g_1_2]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_1_3]_cons*([g_2_1]_cons+5*[g_2_3]_cons)+2*[g_3_2]_cons+		    	/*
						*/		30*[g_2_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_2_2]_cons+	/*
						*/		6*[g_3_4]_cons+										    	/*
						*/		30*[g_1_5]_cons*([g_2_1]_cons+7*[g_2_3]_cons)+						/*
						*/		30*[g_2_5]_cons*([g_1_1]_cons+7*[g_1_3]_cons)+						/*
						*/		1890*[g_1_5]_cons*[g_2_5]_cons							    )	/*
						*/ 	(gam4:2*[g_1_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_1_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+([g_2_1]_cons)^2+			/*
						*/		6*[g_2_1]_cons*[g_2_3]_cons+3*([g_2_2]_cons)^2+15*([g_2_3]_cons)^2+		/*
						*/		2*[g_4_2]_cons+    									    	/*
						*/		30*[g_3_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_3_2]_cons+	/*
						*/		30*[g_2_2]_cons*[g_2_4]_cons+105*([g_2_4]_cons)^2+6*[g_4_4]_cons+		    	/*
						*/		30*[g_1_5]_cons*([g_3_1]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_2_5]_cons*([g_2_1]_cons+7*[g_2_3]_cons)+						/*
						*/		30*[g_3_5]_cons*([g_1_1]_cons+7*[g_1_3]_cons)+						/*
						*/		1890*[g_1_5]_cons*[g_3_5]_cons+945*([g_2_5]_cons)^2				    )	/*
						*/	(gam5:2*[g_2_1]_cons*([g_3_1]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_3_2]_cons+	/*
						*/		6*[g_2_3]_cons*([g_3_1]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_1_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_1_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+    				    	/*
						*/		30*[g_4_4]_cons*([g_1_2]_cons+7*[g_1_4]_cons)+30*[g_1_4]_cons*[g_4_2]_cons+	/*
						*/		30*[g_2_2]_cons*[g_3_4]_cons+30*[g_2_4]_cons*([g_3_2]_cons+7*[g_3_4]_cons)+  	/*
						*/		2*[g_5_2]_cons+6*[g_5_4]_cons+							      /*
						*/		30*[g_1_5]_cons*([g_4_1]_cons+7*[g_4_3]_cons)+						/*
						*/		30*[g_2_5]_cons*([g_3_1]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_3_5]_cons*([g_2_1]_cons+7*[g_2_3]_cons)+						/*
						*/		30*[g_4_5]_cons*([g_1_1]_cons+7*[g_1_3]_cons)+						/*
						*/		1890*([g_1_5]_cons*[g_4_5]_cons+[g_2_5]_cons*[g_3_5]_cons)			    )	/*
						*/	(gam6:([g_3_1]_cons)^2+6*[g_3_1]_cons*[g_3_3]_cons+3*([g_3_2]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_2_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_2_2]_cons*[g_4_2]_cons+	/*
						*/	    	6*[g_2_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+						/*
						*/		30*[g_4_4]_cons*([g_2_2]_cons+7*[g_2_4]_cons)+30*[g_2_4]_cons*[g_4_2]_cons+ 	/*
						*/		30*[g_3_2]_cons*[g_3_4]_cons+105*([g_3_4]_cons)^2+					/*
						*/		2*[g_1_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+  						/*
						*/		6*[g_1_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+  						/*
						*/		6*[g_1_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+  						/*
						*/		30*[g_1_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)+					     	/*
						*/		30*[g_1_5]_cons*([g_5_1]_cons+7*[g_5_3]_cons)+						/*
						*/		30*[g_2_5]_cons*([g_4_1]_cons+7*[g_4_3]_cons)+						/*
						*/		30*[g_3_5]_cons*([g_3_1]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_4_5]_cons*([g_2_1]_cons+7*[g_2_3]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_1_1]_cons+7*[g_1_3]_cons)+						/*
						*/		1890*([g_1_5]_cons*[g_5_5]_cons+[g_2_5]_cons*[g_4_5]_cons)+				/*
						*/		945*([g_3_5]_cons)^2			    						    )	/*
						*/	(gam7:2*[g_3_1]_cons*([g_4_1]_cons+3*[g_4_3]_cons)+6*[g_3_2]_cons*[g_4_2]_cons+	/*
						*/		6*[g_3_3]_cons*([g_4_1]_cons+5*[g_4_3]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_3_2]_cons+7*[g_3_4]_cons)+30*[g_3_4]_cons*[g_4_2]_cons+	/*
						*/		2*[g_2_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+  						/*
						*/		6*[g_2_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+						/*
						*/		6*[g_2_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+						/*
						*/		30*[g_2_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)+					    	/*
						*/		30*[g_2_5]_cons*([g_5_1]_cons+7*[g_5_3]_cons)+						/*
						*/		30*[g_3_5]_cons*([g_4_1]_cons+7*[g_4_3]_cons)+						/*
						*/		30*[g_4_5]_cons*([g_3_1]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_2_1]_cons+7*[g_2_3]_cons)+						/*
						*/		1890*([g_2_5]_cons*[g_5_5]_cons+[g_3_5]_cons*[g_4_5]_cons)			    )	/*
						*/	(gam8:([g_4_1]_cons)^2+6*[g_4_1]_cons*[g_4_3]_cons+3*([g_4_2]_cons)^2+			/*
						*/		15*([g_4_3]_cons)^2+										/*
						*/		30*[g_4_2]_cons*[g_4_4]_cons+105*([g_4_4]_cons)^2+					/*
						*/		2*[g_3_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+  						/*
						*/		6*[g_3_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+						/*
						*/		6*[g_3_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+						/*
						*/		30*[g_3_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)+					    	/*
						*/		30*[g_3_5]_cons*([g_5_1]_cons+7*[g_5_3]_cons)+						/*
						*/		30*[g_4_5]_cons*([g_4_1]_cons+7*[g_4_3]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_3_1]_cons+7*[g_3_3]_cons)+						/*
						*/		1890*[g_3_5]_cons*[g_5_5]_cons+945*([g_4_5]_cons)^2				    )	/*
						*/	(gam9:2*[g_4_1]_cons*([g_5_1]_cons+3*[g_5_3]_cons)+6*[g_4_2]_cons*[g_5_2]_cons+	/*
						*/		6*[g_4_2]_cons*([g_5_2]_cons+5*[g_5_4]_cons)+					    	/*
						*/		6*[g_4_3]_cons*([g_5_1]_cons+5*[g_5_3]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_5_2]_cons+7*[g_5_4]_cons)+					    	/*
						*/		30*[g_4_5]_cons*([g_5_1]_cons+7*[g_5_3]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_4_1]_cons+7*[g_4_3]_cons)+						/*
						*/		1890*[g_4_5]_cons*[g_5_5]_cons							    )	/*
						*/   (gam10:([g_5_1]_cons)^2+6*[g_5_1]_cons*[g_5_3]_cons+3*([g_5_2]_cons)^2+			/*
						*/		30*[g_5_2]_cons*[g_5_4]_cons+15*([g_5_3]_cons)^2+105*([g_5_4]_cons)^2+	      /*
						*/		30*[g_5_5]_cons*([g_5_1]_cons+7*[g_5_3]_cons)+						/*
						*/		945*([g_5_5]_cons)^2									    )	/*
						*/	(del1:2*[g_2_1]_cons+6*[g_4_1]_cons								    ) /*
						*/	(del2:([g_1_1]_cons)^2+6*[g_1_1]_cons*[g_3_1]_cons+						/*
						*/		3*([g_2_1]_cons)^2+15*([g_3_1]_cons)^2+2*[g_2_2]_cons+			    	/*
						*/		30*[g_2_1]_cons*[g_4_1]_cons+105*([g_4_1]_cons)^2+6*[g_4_2]_cons+		    	/*
						*/		30*[g_5_1]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
						*/		945*([g_5_1]_cons)^2									    )	/*
						*/ 	(del3:2*[g_1_1]_cons*([g_1_2]_cons+3*[g_3_2]_cons)+6*[g_2_1]_cons*[g_2_2]_cons+ 	/*
						*/		6*[g_3_1]_cons*([g_1_2]_cons+5*[g_3_2]_cons)+2*[g_2_3]_cons+		    	/*
						*/		30*[g_4_2]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_2]_cons+	/*
						*/		6*[g_4_3]_cons+										    	/*
						*/		30*[g_5_1]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		30*[g_5_2]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
						*/		1890*[g_5_1]_cons*[g_5_2]_cons							    )	/*
						*/ 	(del4:2*[g_1_1]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_1]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+([g_1_2]_cons)^2+			/*
						*/		6*[g_1_2]_cons*[g_3_2]_cons+3*([g_2_2]_cons)^2+15*([g_3_2]_cons)^2+		/*
						*/		2*[g_2_4]_cons+    									    	/*
						*/		30*[g_4_3]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_3]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_2]_cons+105*([g_4_2]_cons)^2+6*[g_4_4]_cons+		    	/*
						*/		30*[g_5_1]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_2]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
						*/		1890*[g_5_1]_cons*[g_5_3]_cons+945*([g_5_2]_cons)^2				    )	/*
						*/	(del5:2*[g_1_2]_cons*([g_1_3]_cons+3*[g_3_3]_cons)+6*[g_2_2]_cons*[g_2_3]_cons+	/*
						*/		6*[g_3_2]_cons*([g_1_3]_cons+5*[g_3_3]_cons)+						/*
						*/		2*[g_1_1]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_1]_cons*[g_2_4]_cons+	/*
						*/		6*[g_3_1]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+    				    	/*
						*/		30*[g_4_4]_cons*([g_2_1]_cons+7*[g_4_1]_cons)+30*[g_4_1]_cons*[g_2_4]_cons+	/*
						*/		30*[g_2_2]_cons*[g_4_3]_cons+30*[g_4_2]_cons*([g_2_3]_cons+7*[g_4_3]_cons)+  	/*
						*/		2*[g_2_5]_cons+6*[g_4_5]_cons+							      /*
						*/		30*[g_5_1]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_2]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
						*/		1890*([g_5_1]_cons*[g_5_4]_cons+[g_5_2]_cons*[g_5_3]_cons)			    )	/*
						*/	(del6:([g_1_3]_cons)^2+6*[g_1_3]_cons*[g_3_3]_cons+3*([g_2_3]_cons)^2+			/*
						*/		15*([g_3_3]_cons)^2+										/*
						*/		2*[g_1_2]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_2]_cons*[g_2_4]_cons+	/*
						*/	    	6*[g_3_2]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+						/*
						*/		30*[g_4_4]_cons*([g_2_2]_cons+7*[g_4_2]_cons)+30*[g_4_2]_cons*[g_2_4]_cons+ 	/*
						*/		30*[g_2_3]_cons*[g_4_3]_cons+105*([g_4_3]_cons)^2+					/*
						*/		2*[g_1_1]_cons*([g_1_5]_cons+3*[g_3_5]_cons)+  						/*
						*/		6*[g_2_1]_cons*([g_2_5]_cons+5*[g_4_5]_cons)+  						/*
						*/		6*[g_3_1]_cons*([g_1_5]_cons+5*[g_3_5]_cons)+  						/*
						*/		30*[g_4_1]_cons*([g_2_5]_cons+7*[g_4_5]_cons)+					     	/*
						*/		30*[g_5_1]_cons*([g_1_5]_cons+7*[g_3_5]_cons)+						/*
						*/		30*[g_5_2]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_1_1]_cons+7*[g_3_1]_cons)+						/*
						*/		1890*([g_5_1]_cons*[g_5_5]_cons+[g_5_2]_cons*[g_5_4]_cons)+				/*
						*/		945*([g_5_3]_cons)^2			    						    )	/*
						*/	(del7:2*[g_1_3]_cons*([g_1_4]_cons+3*[g_3_4]_cons)+6*[g_2_3]_cons*[g_2_4]_cons+	/*
						*/		6*[g_3_3]_cons*([g_1_4]_cons+5*[g_3_4]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_2_3]_cons+7*[g_4_3]_cons)+30*[g_4_3]_cons*[g_2_4]_cons+	/*
						*/		2*[g_1_2]_cons*([g_1_5]_cons+3*[g_3_5]_cons)+  						/*
						*/		6*[g_2_2]_cons*([g_2_5]_cons+5*[g_4_5]_cons)+						/*
						*/		6*[g_3_2]_cons*([g_1_5]_cons+5*[g_3_5]_cons)+						/*
						*/		30*[g_4_2]_cons*([g_2_5]_cons+7*[g_4_5]_cons)+					    	/*
						*/		30*[g_5_2]_cons*([g_1_5]_cons+7*[g_3_5]_cons)+						/*
						*/		30*[g_5_3]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_1_2]_cons+7*[g_3_2]_cons)+						/*
						*/		1890*([g_5_2]_cons*[g_5_5]_cons+[g_5_3]_cons*[g_5_4]_cons)			    )	/*
						*/	(del8:([g_1_4]_cons)^2+6*[g_1_4]_cons*[g_3_4]_cons+3*([g_2_4]_cons)^2+			/*
						*/		15*([g_3_4]_cons)^2+										/*
						*/		30*[g_2_4]_cons*[g_4_4]_cons+105*([g_4_4]_cons)^2+					/*
						*/		2*[g_1_3]_cons*([g_1_5]_cons+3*[g_3_5]_cons)+  						/*
						*/		6*[g_2_3]_cons*([g_2_5]_cons+5*[g_4_5]_cons)+						/*
						*/		6*[g_3_3]_cons*([g_1_5]_cons+5*[g_3_5]_cons)+						/*
						*/		30*[g_4_3]_cons*([g_2_5]_cons+7*[g_4_5]_cons)+					    	/*
						*/		30*[g_5_3]_cons*([g_1_5]_cons+7*[g_3_5]_cons)+						/*
						*/		30*[g_5_4]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_1_3]_cons+7*[g_3_3]_cons)+						/*
						*/		1890*[g_5_3]_cons*[g_5_5]_cons+945*([g_5_4]_cons)^2				    )	/*
						*/	(del9:2*[g_1_4]_cons*([g_1_5]_cons+3*[g_3_5]_cons)+6*[g_2_4]_cons*[g_2_5]_cons+	/*
						*/		6*[g_2_4]_cons*([g_2_5]_cons+5*[g_4_5]_cons)+					    	/*
						*/		6*[g_3_4]_cons*([g_1_5]_cons+5*[g_3_5]_cons)+					    	/*
						*/		30*[g_4_4]_cons*([g_2_5]_cons+7*[g_4_5]_cons)+					    	/*
						*/		30*[g_5_4]_cons*([g_1_5]_cons+7*[g_3_5]_cons)+						/*
						*/		30*[g_5_5]_cons*([g_1_4]_cons+7*[g_3_4]_cons)+						/*
						*/		1890*[g_5_4]_cons*[g_5_5]_cons							    )	/*
						*/   (del10:([g_1_5]_cons)^2+6*[g_1_5]_cons*[g_3_5]_cons+3*([g_2_5]_cons)^2+			/*
						*/		30*[g_2_5]_cons*[g_4_5]_cons+15*([g_3_5]_cons)^2+105*([g_4_5]_cons)^2+	      /*
						*/		30*[g_5_5]_cons*([g_1_5]_cons+7*[g_3_5]_cons)+						/*
						*/		945*([g_5_5]_cons)^2									    )	/*
						*/	, post
					test _b[gam1]=_b[gam2]=_b[gam3]=_b[gam4]=_b[gam5]=_b[gam6]=_b[gam7]=_b[gam8]=_b[gam9]=_b[gam10]=0
					local stat1=r(chi2)
					local dof1=r(df)
					local p1=r(p)
					test _b[del1]=_b[del2]=_b[del3]=_b[del4]=_b[del5]=_b[del6]=_b[del7]=_b[del8]=_b[del9]=_b[del10]=0
					local stat2=r(chi2)
					local dof2=r(df)
					local p2=r(p)
				}
			noi di in gr "Wald test for the Gaussianity of the error terms"				/*
			*/ _n " Main Eq: Chi2(" `dof2' ") statistic = " _column(25) in ye %9.0g `stat2'  	/*
			*/ _column(40) in gr "(p-value = " in ye %9.0g `p2' in gr ")" 				/*
			*/ _n " Sel. Eq: Chi2(" `dof1' ") statistic = " _column(25) in ye %9.0g `stat1'  	/*
			*/ _column(40) in gr "(p-value = " in ye %9.0g `p1' in gr ")" 				/*
			*/ _n "{hline 78}"

			estimates restore `est'
		}

	}
end


program define Select
	args seldep selind selnc seloff colon sel_eqn

	gettoken dep rest : sel_eqn, parse(" =")
	gettoken equal rest : rest, parse(" =")

	if "`equal'" == "=" { 
		tsunab dep : `dep'
		c_local `seldep' `dep' 
	}
	else	local rest `"`sel_eqn'"'
	
	local 0 `"`rest'"'
	syntax [varlist(numeric default=none)] 	/*
		*/ [, noCONstant OFFset(varname numeric) ]

	if "`varlist'" == "" {
		di in red "no variables specified for selection equation"
		exit 198
	}

	c_local `selind' `varlist'
	c_local `selnc' `constant'
	c_local `seloff' `offset'
end



program define Replay
	syntax [, Level(int $S_level)]
	ml di, level(`level') neq(2) plus
	DispC 
	DispSNP `level'
	DispMOM
end 


program define DispC
	di  in gr "Intercepts:  {c |}"										///
	  _n _column(7) "_cons1 {c |}  " _column(17) in ye %9.0g $Con1 _column(32) in gr "Fixed"	///
	  _n  _column(7) "_cons2 {c |}  " _column(17) in ye %9.0g $Con2 _column(32) in gr "Fixed"	///
	  _n in gr "{hline 13}{c +}{hline 64}"
end

program define DispSNP
	local level = `1'
	di in gr "SNP coefs:   {c |}"
	forvalues i=1(1)${R1} {
		forvalues j=1(1)${R2} {
			_diparm g_`i'_`j', level(`level') label("       g_`i'_`j'")
		}
	}
	di in gr "{hline 13}{c BT}{hline 64}"
end

program define DispMOM
	di "Estimated moments of errors distribution" 								///
		_n _column(5) "Main equation" 									///
		_column(39) _column(45) "Selection equation" 							///
		_n _column(5) in gr "Standard Deviation =" _column(25) in ye %9.0g e(sd2)		///
		_column(39) _column(45) in gr "Standard Deviation =" _column(65) in ye %9.0g e(sd1)	///
		_n _column(5) in gr "Variance = " _column(25) in ye %9.0g e(var2)				///
		_column(39) _column(45) in gr "Variance = " _column(65) in ye %9.0g e(var1)		///
		_n _column(5) in gr "Skewness = " _column(25) in ye %9.0g e(ske2) 			///
		_column(39) _column(45) in gr "Skewness = " _column(65) in ye %9.0g e(ske1)		///
		_n _column(5) in gr "Kurtosis = " _column(25) in ye %9.0g e(kurt2) 			///
		_column(39) _column(45) in gr "Kurtosis = " _column(65) in ye %9.0g e(kurt1)		///
		_n in gr "{hline 78}"											///
		_n in gr "Estimated correlation coefficient"							///
		_n _column(5) in gr "rho = " _column(25) in ye %9.0g e(rho)					///
		_n in gr "{hline 78}"
end

