
program define reg_cv2, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "reg_cv2" {
			di as error "results for reg_cv2 not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass 

* Dependent variable
	gettoken dep 0 : 0 , parse(" =,[")
	gettoken equals rest : 0 , parse(" =")
	if "`equals'" == "=" local 0 `"`rest'"'
	local depn : subinstr local dep "." "_"

* Other equations & options
	syntax varlist(min=1) [if] [in] [pw fw iw] ,		///
		cvlist1(string) suffix1(string) 			///
		[cvlist2(string) suffix2(string) 			///
		order1(integer 3) order2(integer 3)			///
		noCONstant OFFset(varname numeric) 			///
		Robust Cluster(varname)			   		///
		Level(integer $S_level)]

* Identify noconstant and offset main equation
	local nc `constant'
	if "`offset'"  != "" local off "offset(`offset')" 

* Estimation sample 
	marksample touse

* Identify variables for the non-linear part of the model
	if "`cvlist2'"!="" & "`suffix2'"=="" {
		noi di in red "Option suffix2 required"
		exit
	}
	forvalues l=1(1)2 {
		if "`cvlist`l''"!="" {
			local PT`l': word 1 of `suffix`l''
			local nc_PT`l': length local PT`l'
		}
	}


* Identify variables for the non-linear part of the model
	forvalues l=1(1)2 {
		if "`cvlist`l''"!="" {
			local n`l'_var: word count `cvlist`l''
			forvalues i=1(1)`n`l'_var' {
				local x`l'_`i': word `i' of `cvlist`l''
			}
		}
		else local n`l'_var=0
	}

* Generate powers, interaction and count specifications
	forvalues l=1(1)2 {

		* One variable 
			if `n`l'_var'==1 {
				* Generate powers 
					local `PT`l''_var ""
					forvalue p1=2(1)`order`l'' {
						qui gen double `PT`l''_`p1'=`x`l'_1'^`p1'
						local `PT`l''_var "``PT`l''_var' `PT`l''_`p1'" 
					}
				* Count number of specifications
					local n`l'_spec=0
					forvalues j=2(1)`order`l''{
						local terms`l'_`j' "`PT`l''_`j'"
						local nt`l'_`j': word count `terms`l'_`j''
						local n`l'_spec_`j'=1
						local n`l'_spec=`n`l'_spec'+`n`l'_spec_`j''
					}
					*noi di _n "Number of total specifications from list `l': "`n`l'_spec'	
			}

		* Two variables 
			if `n`l'_var'==2 {

				* Generate powers and their interactions
					local `PT`l''_var ""
					forvalue p1=0(1)`order`l'' {
						local t1=`order`l''-`p1'
						forvalue p2=0(1)`t1' {
							if `p1'+`p2'>1 {
								qui gen double `PT`l''_`p1'_`p2'=`x`l'_1'^`p1'*`x`l'_2'^`p2'
								local `PT`l''_var "``PT`l''_var' `PT`l''_`p1'_`p2'" 
							}
						}
					}

				* Count number of specifications
					local n`l'_spec=0
					forvalues j=2(1)`order`l''{
						local terms`l'_`j' ""
						forvalues t1=0(1)`order`l''{
							forvalues t2=0(1)`order`l''{
								if `t1'+`t2'!=`j' continue
								local terms`l'_`j' "`terms`l'_`j'' `PT`l''_`t1'_`t2'"
							}			
						}
						*noi di _n _n _n "List`l' of terms of order `j': `terms`l'_`j''"
						local nt`l'_`j': word count `terms`l'_`j''
						*noi di "Number of terms in list `l' of order `j': " `nt`l'_`j''
						local n`l'_spec_`j'=0
						forvalues k=1(1)`nt`l'_`j''{
							local n`l'_spec_`j'=`n`l'_spec_`j''+comb(`nt`l'_`j'',`k')
						}
						*noi di "Number of specifications from polinomial`l' of order `j': " `n`l'_spec_`j''	
						local n`l'_spec=`n`l'_spec'+`n`l'_spec_`j''
					}
					*noi di _n "Number of total specifications from list `l': "`n`l'_spec'	
			}

		* Three variables 
			if `n`l'_var'==3 {

				* Generate powers and their interactions
					local `PT`l''_var ""
					forvalue p1=0(1)`order`l'' {
						local t1=`order`l''-`p1'
						forvalue p2=0(1)`t1' {
							local t2=`order`l''-`p2'-`p1'
							forvalue p3=0(1)`t2' {
								if `p1'+`p2'+`p3'>1 {
									qui gen double `PT`l''_`p1'_`p2'_`p3'=`x`l'_1'^`p1'*`x`l'_2'^`p2'*`x`l'_3'^`p3'
									local `PT`l''_var "``PT`l''_var' `PT`l''_`p1'_`p2'_`p3'" 
								}
							}
						}
					}


				* Count number of specifications
					local n`l'_spec=0
					forvalues j=2(1)`order`l''{
						local terms`l'_`j' ""
						forvalues t1=0(1)`order`l''{
							forvalues t2=0(1)`order`l''{
								forvalues t3=0(1)`order`l''{
									if `t1'+`t2'+`t3'!=`j' continue
									local terms`l'_`j' "`terms`l'_`j'' `PT`l''_`t1'_`t2'_`t3'"
								}
							}			
						}
						*noi di _n _n _n "List`l' of terms of order `j': `terms`l'_`j''"
						local nt`l'_`j': word count `terms`l'_`j''
						local n`l'_spec_`j'=0
						forvalues k=1(1)`nt`l'_`j''{
							local n`l'_spec_`j'=`n`l'_spec_`j''+comb(`nt`l'_`j'',`k')
						}
						*noi di "Number of specifications from polinomial`l' of order `j': " `n`l'_spec_`j''	
						local n`l'_spec=`n`l'_spec'+`n`l'_spec_`j''
					}
			}
	}

* Create list of specifications
	forvalues L=1(1)2 {
		if `n`L'_var'>0 {
		local s=1
		forvalues J=2(1)`order`L''{
			if `s'>1 {
				local sl1=`s'-1
				local S`L'_po "`S`L'_`sl1''"
			}
			else local S`L'_po ""

			local lo1=1												// 1 
			local up1=`nt`L'_`J''
			forvalues k=`lo1'(1)`up1'{	 
				local y1: word `k' of `terms`L'_`J''
				local S`L'_`s' "`S`L'_po' `y1'"
				*noi di "List `L' - Specif `s': `S`L'_`s''"
				local s=`s'+1
			}

			local lo1=1												// 2 
			local up1=`nt`L'_`J''-1
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local S`L'_`s' "`S`L'_po' `y1' `y2'"
					*noi di "List `L' - Specif `s': `S`L'_`s''"
					local s=`s'+1
				}
			} 	

			local lo1=1												// 3 
			local up1=`nt`L'_`J''-2					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-1
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local S`L'_`s' "`S`L'_po' `y1' `y2' `y3'"
						*noi di "List `L' - Specif `s': `S`L'_`s''"
						local s=`s'+1
					}
				}
			} 	


			local lo1=1												// 4 
			local up1=`nt`L'_`J''-3					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-2
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-1
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4'"
							*noi di "List `L' - Specif `s': `S`L'_`s''"
							local s=`s'+1
						}
					}
				}
			} 	


			local lo1=1												// 5 
			local up1=`nt`L'_`J''-4					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-3
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-2
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''-1
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local lo5=`k4'+1
							local up5=`nt`L'_`J''
							forvalues k5=`lo5'(1)`up5'{
								local y5: word `k5' of `terms`L'_`J''
								local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4' `y5'"
								*noi di "List `L' - Specif `s': `S`L'_`s''"
								local s=`s'+1
							}
						}
					}
				}
			} 	

			local lo1=1												// 6 
			local up1=`nt`L'_`J''-5					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-4
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-3
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''-2
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local lo5=`k4'+1
							local up5=`nt`L'_`J''-1
							forvalues k5=`lo5'(1)`up5'{
								local y5: word `k5' of `terms`L'_`J''
								local lo6=`k5'+1
								local up6=`nt`L'_`J''
								forvalues k6=`lo6'(1)`up6'{
									local y6: word `k6' of `terms`L'_`J''
									local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4' `y5' `y6'"
									*noi di "List `L' - Specif `s': `S`L'_`s''"
									local s=`s'+1
								}
							}
						}
					}
				}
			} 	


			local lo1=1												// 7 
			local up1=`nt`L'_`J''-6					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-5
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-4
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''-3
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local lo5=`k4'+1
							local up5=`nt`L'_`J''-2
							forvalues k5=`lo5'(1)`up5'{
								local y5: word `k5' of `terms`L'_`J''
								local lo6=`k5'+1
								local up6=`nt`L'_`J''-1
								forvalues k6=`lo6'(1)`up6'{
									local y6: word `k6' of `terms`L'_`J''
									local lo7=`k6'+1
									local up7=`nt`L'_`J''
									forvalues k7=`lo7'(1)`up7'{
										local y7: word `k7' of `terms`L'_`J''
										local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4' `y5' `y6' `y7'"
										*noi di "List `L' - Specif `s': `S`L'_`s''"
										local s=`s'+1
									}
								}
							}
						}
					}
				}
			} 	


			local lo1=1												// 8 
			local up1=`nt`L'_`J''-7					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-6
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-5
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''-4
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local lo5=`k4'+1
							local up5=`nt`L'_`J''-3
							forvalues k5=`lo5'(1)`up5'{
								local y5: word `k5' of `terms`L'_`J''
								local lo6=`k5'+1
								local up6=`nt`L'_`J''-2
								forvalues k6=`lo6'(1)`up6'{
									local y6: word `k6' of `terms`L'_`J''
									local lo7=`k6'+1
									local up7=`nt`L'_`J''-1
									forvalues k7=`lo7'(1)`up7'{
										local y7: word `k7' of `terms`L'_`J''
										local lo8=`k7'+1
										local up8=`nt`L'_`J''
										forvalues k8=`lo8'(1)`up8'{
											local y8: word `k8' of `terms`L'_`J''
											local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4' `y5' `y6' `y7' `y8'"
											*noi di "List `L' - Specif `s': `S`L'_`s''"
											local s=`s'+1
										}
									}
								}
							}
						}
					}
				}
			} 	


			local lo1=1												// 9 
			local up1=`nt`L'_`J''-8					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-7
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-6
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''-5
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local lo5=`k4'+1
							local up5=`nt`L'_`J''-4
							forvalues k5=`lo5'(1)`up5'{
								local y5: word `k5' of `terms`L'_`J''
								local lo6=`k5'+1
								local up6=`nt`L'_`J''-3
								forvalues k6=`lo6'(1)`up6'{
									local y6: word `k6' of `terms`L'_`J''
									local lo7=`k6'+1
									local up7=`nt`L'_`J''-2
									forvalues k7=`lo7'(1)`up7'{
										local y7: word `k7' of `terms`L'_`J''
										local lo8=`k7'+1
										local up8=`nt`L'_`J''-1
										forvalues k8=`lo8'(1)`up8'{
											local y8: word `k8' of `terms`L'_`J''
											local lo9=`k8'+1
											local up9=`nt`L'_`J''
											forvalues k9=`lo9'(1)`up9'{
												local y9: word `k9' of `terms`L'_`J''
												local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4' `y5' `y6' `y7' `y8' `y9'"
												*noi di "List `L' - Specif `s': `S`L'_`s''"
												local s=`s'+1
											}
										}
									}
								}
							}
						}
					}
				}
			} 	


			local lo1=1												// 10 
			local up1=`nt`L'_`J''-9					
			forvalues k1=`lo1'(1)`up1'{
				local y1: word `k1' of `terms`L'_`J''
				local lo2=`k1'+1
				local up2=`nt`L'_`J''-8
				forvalues k2=`lo2'(1)`up2'{
					local y2: word `k2' of `terms`L'_`J''
					local lo3=`k2'+1
					local up3=`nt`L'_`J''-7
					forvalues k3=`lo3'(1)`up3'{
						local y3: word `k3' of `terms`L'_`J''
						local lo4=`k3'+1
						local up4=`nt`L'_`J''-6
						forvalues k4=`lo4'(1)`up4'{
							local y4: word `k4' of `terms`L'_`J''
							local lo5=`k4'+1
							local up5=`nt`L'_`J''-5
							forvalues k5=`lo5'(1)`up5'{
								local y5: word `k5' of `terms`L'_`J''
								local lo6=`k5'+1
								local up6=`nt`L'_`J''-4
								forvalues k6=`lo6'(1)`up6'{
									local y6: word `k6' of `terms`L'_`J''
									local lo7=`k6'+1
									local up7=`nt`L'_`J''-3
									forvalues k7=`lo7'(1)`up7'{
										local y7: word `k7' of `terms`L'_`J''
										local lo8=`k7'+1
										local up8=`nt`L'_`J''-2
										forvalues k8=`lo8'(1)`up8'{
											local y8: word `k8' of `terms`L'_`J''
											local lo9=`k8'+1
											local up9=`nt`L'_`J''-1
											forvalues k9=`lo9'(1)`up9'{
												local y9: word `k9' of `terms`L'_`J''
												local lo10=`k9'+1
												local up10=`nt`L'_`J''
												forvalues k10=`lo10'(1)`up10'{
													local y10: word `k10' of `terms`L'_`J''
													local S`L'_`s' "`S`L'_po' `y1' `y2' `y3' `y4' `y5' `y6' `y7' `y8' `y9' `y10'"
													*noi di "List `L' - Specif `s': `S`L'_`s''"
													local s=`s'+1
												}
											}
										}
									}
								}
							}
						}
					}
				}
			} 
		}	
		local n`L'_spec =`s'-1
		noi di in ye ""
		}
	}


* Perform cross validation over specifications
	tempvar use
	qui reg `dep' `varlist' `S1_`n1_spec'' `S2_`n2_spec'' if `touse'==1 
	qui gen `use'=e(sample)
	qui count if `use'==1
	local N=r(N)

	if "`cvlist2'"=="" {
		local T=`n1_spec'+1
		di in gr "{hline 78}"							  		///
			_n in gr "Cross validation over specifications"				///
			_n in gr "{hline 78}"								///
			_n in gr "Specifications (" in ye `T' in gr")"				///
			in gr " - Obs. (" in ye `N' in gr")"					///
			_n as txt "{hline 4}{c +}{hline 3} 1 "					///
		  	"{hline 3}{c +}{hline 3} 2 "							///
		  	"{hline 3}{c +}{hline 3} 3 "							///
		  	"{hline 3}{c +}{hline 3} 4 "							///
		  	"{hline 3}{c +}{hline 3} 5 "

		mata: cv=J(`T', 1, 0)
		local s=1
		forvalues s1=0(1)`n1_spec' {
			* Display
				if `s'!=50*int(`s'/50) {
					di as txt "." _c 
				}
				else{ 
					di as txt "." _c 
					di as txt " " in ye %5.0f `s'  
				}	

			* Execute
				gsort - `use'
				forvalue i=1(1)`N' {
					qui reg `dep' `varlist' `S1_`s1'' if `use'==1 & _n!=`i'
					qui predict TEMPres if _n==`i', res 
					local TTemp=TEMPres[`i']^2
					mata: cv[`s',1]=cv[`s',1]+`TTemp'
					drop TEMPres
				}
			local s=`s'+1
		}
	}
	else {
		local T=(`n1_spec'+1)*(`n2_spec'+1) 
		di in gr "{hline 78}"							  	///
			_n in gr "Cross validation over specifications"			///
			_n in gr "{hline 78}"							///
			_n in gr "Specifications (" in ye `T' in gr")"			///
			in gr " - Obs. (" in ye `N' in gr")"				///
			_n as txt "{hline 4}{c +}{hline 3} 1 "				///
		  	"{hline 3}{c +}{hline 3} 2 "						///
		  	"{hline 3}{c +}{hline 3} 3 "						///
		  	"{hline 3}{c +}{hline 3} 4 "						///
		  	"{hline 3}{c +}{hline 3} 5 "
		mata: cv=J(`T', 1, 0)
		local s=1
		forvalues s1=0(1)`n1_spec' {
			forvalues s2=0(1)`n2_spec' {
				* Display
					if `s'!=50*int(`s'/50) {
						di as txt "." _c 
					}
					else{ 
						di as txt "." _c 
						di as txt " " in ye %5.0f `s'  
					}	

				* Execute
					***local cv_`s1'_`s2'=0
					gsort - `use'
					forvalue i=1(1)`N' {
						qui reg `dep' `varlist' `S1_`s1'' `S2_`s2'' if `use'==1 & _n!=`i', `nc' `off' 
						qui predict TEMPres if `use'==1 & _n==`i', res 
						local TTemp=TEMPres[`i']^2
						mata: cv[`s',1]=cv[`s',1]+`TTemp'
						drop TEMPres
					}
				local s=`s'+1
			}
		}
	}

* Determine minimum cv critaria
	if "`cvlist2'"=="" {
		local s=1
		forvalues s1=0(1)`n1_spec' {
			if `s1'==0 {
				mata: st_numscalar("r(cv)", cv[`s',1])
				local cv_sel=r(cv)
				local s1_sel=0
			}
			else {
				mata: st_numscalar("r(cv)", cv[`s',1])
				local cv_s1=r(cv)
				if `cv_s1'<`cv_sel' {
					local s1_sel=`s1'
					local cv_sel=`cv_s1'
				}
			}
			local s=`s'+1
		}
	}
	else {
		local s=1
		forvalues s1=0(1)`n1_spec' {
			forvalues s2=0(1)`n2_spec' {
				if `s1'==0 & `s2'==0 {
					mata: st_numscalar("r(cv)", cv[`s',1])
					local cv_sel=r(cv)
					local s1_sel=0
					local s2_sel=0
				}
				else {
					mata: st_numscalar("r(cv)", cv[`s',1])
					local cv_s1_s2=r(cv)
					if `cv_s1_s2'<`cv_sel' {
						local s1_sel=`s1'
						local s2_sel=`s2'
						local cv_sel=`cv_s1_s2'
					}
				}
				local s=`s'+1
			}
		}
	}

* Return programs results
	ereturn clear
	ereturn local spec1 "`S1_`s1_sel''"
	ereturn scalar cv=`cv_sel'
	if "`cvlist2'"!="" {
		ereturn local spec2 "`S2_`s2_sel''"
	}
	ereturn local cmd "reg_cv"


* Table of results
	if "`cvlist2'"=="" {
		if `n1_var'==1 {
			local c1_1=`nc_PT1'+2
			noi di in gr _n "{hline 78}" 							///
				_n "Values of cross validation across specifications"		///
				_n "{hline 78}"								///
				_n 	_col(1)  "Spec" _col(7)  "&"					///
				 	_col(14)  "V1" _col(17) "&"					///
					_col(24)  "CV" _col(27) "\\\"					///
				_n, _continue
			local s=1
			forvalues s1=0(1)`n1_spec' {
				if `s1'==0 local V1=1
				if `s1'>0 {
					local V1=0
					local n_var_spec`s1': word count `S1_`s1''
					forvalues j=1(1)`n_var_spec`s1'' {
						local var`j': word `j' of `S1_`s1''
						local t1=real(substr("`var`j''",`c1_1',1))
						local V1=max(`V1',`t1')
					}
				}
				mata: st_numscalar("r(cv)", cv[`s',1])
				local cv_s1=r(cv)
				noi di in ye 									///
					_col(5)   in ye "`s1'" in gr _col(7)  "&"				///
					_col(15)  in ye "`V1'" in gr _col(17) "&"				///
					_col(18)  in ye %9.4f `cv_s1' in gr _col(27) "\\\"		///
				_n, _continue
				local s=`s'+1
			}
		}	
		if `n1_var'==2 {
			local c1_1=`nc_PT1'+2
			local c1_2=`nc_PT1'+4
			noi di in gr _n "{hline 78}" 							///
				_n "Values of cross validation across specifications"		///
				_n "{hline 78}"								///
				_n 	_col(1) "Spec" _col(7)  "&"					///
				 	_col(14)  "V1" _col(17) "&"					///
				 	_col(24)  "V2" _col(27) "&"					///
				 	_col(34)  "IV" _col(37) "&"					///
					_col(44)  "CV" _col(47) "\\\"					///
				_n, _continue
			local s=1
			forvalues s1=0(1)`n1_spec' {
				if `s1'==0 {
					local V1=1
					local V2=1
					local IV=0
				}	
				else {
					local V1=0
					local V2=0
					local IV=0
					local n_var_spec`s1': word count `S1_`s1''
					forvalues j=1(1)`n_var_spec`s1'' {
						local var`j': word `j' of `S1_`s1''
						local t1=real(substr("`var`j''",`c1_1',1))
						local t2=real(substr("`var`j''",`c1_2',1))
						local V1=max(`V1',cond(`t1'>0 & `t2'==0,`t1',0))
						local V2=max(`V2',cond(`t1'==0 & `t2'>0,`t2',0))
						local IV=`IV'+cond(`t1'>0 & `t2'>0,1,0)
					}
					if `V1'==0 local V1=1
					if `V2'==0 local V2=1
				}	
				mata: st_numscalar("r(cv)", cv[`s',1])
				local cv_s1=r(cv)
				noi di in ye 									///
					_col(1)   in ye "`s1'" in gr _col(7)  "&"				///
					_col(15)  in ye "`V1'" in gr _col(17) "&"				///
					_col(25)  in ye "`V2'" in gr _col(27) "&"				///
					_col(35)  in ye "`IV'"  in gr _col(37) "&"			///
					_col(38)  in ye %9.4f `cv_s1' in gr _col(47) "\\\"		///
				_n, _continue
				local s=`s'+1
			}
		}
		if `n1_var'==3 {
			local c1_1=`nc_PT1'+2
			local c1_2=`nc_PT1'+4
			local c1_3=`nc_PT1'+6
			noi di in gr _n "{hline 78}" 							///
				_n "Values of cross validation across specifications"		///
				_n "{hline 78}"								///
				_n 	_col(1) "Spec" _col(7)  "&"					///
				 	_col(14)  "V1" _col(17) "&"					///
				 	_col(24)  "V2" _col(27) "&"					///
				 	_col(34)  "V3" _col(37) "&"					///
				 	_col(44)  "IV" _col(47) "&"					///
					_col(54)  "CV" _col(57) "\\\"					///
				_n, _continue
			local s=1
			forvalues s1=0(1)`n1_spec' {
				if `s1'==0 {
					local V1=1
					local V2=1
					local V3=1
					local IV=0
				}		
				else {
					local V1=0
					local V2=0
					local V3=0
					local IV=0
					local n_var_spec`s1': word count `S1_`s1''
					forvalues j=1(1)`n_var_spec`s1'' {
						local var`j': word `j' of `S1_`s1''
						local t1=real(substr("`var`j''",`c1_1',1))
						local t2=real(substr("`var`j''",`c1_2',1))
						local t3=real(substr("`var`j''",`c1_3',1))
						local V1=max(`V1',cond(`t1'>0  & `t2'==0 & `t3'==0,`t1',0))
						local V2=max(`V2',cond(`t1'==0 & `t2'>0  & `t3'==0,`t2',0))
						local V3=max(`V3',cond(`t1'==0 & `t2'==0 & `t3'>0 ,`t3',0))
						local IV=`IV'+cond((`t1'>0 & `t2'>0)|(`t1'>0 & `t3'>0)|(`t2'>0 & `t3'>0),1,0)
					}
					if `V1'==0 local V1=1
					if `V2'==0 local V2=1
					if `V3'==0 local V3=1
				}
				mata: st_numscalar("r(cv)", cv[`s',1])
				local cv_s1=r(cv)
				noi di in ye 									///
					_col(1)   in ye "`s1'" in gr _col(7)  "&"				///
					_col(15)  in ye "`V1'" in gr _col(17) "&"				///
					_col(25)  in ye "`V2'" in gr _col(27) "&"				///
					_col(35)  in ye "`V3'" in gr _col(37) "&"				///
					_col(45)  in ye "`IV'"  in gr _col(47) "&"			///
					_col(49)  in ye %9.4f `cv_s1' in gr _col(57) "\\\"		///
				_n, _continue
				local s=`s'+1
			}
		}	
	}
	else {
		if `n1_var'==1 & `n2_var'==1 {
			local c1_1=`nc_PT1'+2
			local c2_1=`nc_PT2'+2
			noi di in gr _n "{hline 78}" 							///
				_n "Values of cross validation across specifications"		///
				_n "{hline 78}"								///
				_n 	_col(1)  "Spec" _col(7)  "&"					///
				 	_col(14)  "V1" _col(17)  "&"					///
				 	_col(24)  "Z1" _col(27)  "&"					///
					_col(34)  "CV" _col(37)  "\\\"				///
				_n, _continue
			local s=1
			forvalues s1=0(1)`n1_spec' {
				forvalues s2=0(1)`n2_spec' {
					if `s1'==0 local V1=1
					else {
						local V1=0
						local n_var_spec1: word count `S1_`s1''
						forvalues j=1(1)`n_var_spec1' {
							local var1_`j': word `j' of `S1_`s1''
							local t1_1=real(substr("`var1_`j''",`c1_1',1))
							local V1=max(`V1',`t1_1')
						}
					}
					if `s2'==0 local Z1=1
					else {
						local Z1=0
						local n_var_spec2: word count `S2_`s2''
						forvalues j=1(1)`n_var_spec2' {
							local var2_`j': word `j' of `S2_`s2''
							local t2_1=real(substr("`var2_`j''",`c2_1',1))
							local Z1=max(`Z1',`t2_1')
						}
					}	
					mata: st_numscalar("r(cv)", cv[`s',1])
					local cv_s1_s2=r(cv)
					noi di in ye 									///
						_col(5)   in ye "`s'" in gr _col(7)  "&"				///
						_col(15)  in ye "`V1'" in gr _col(17) "&"				///
						_col(25)  in ye "`Z1'" in gr _col(27) "&"				///
						_col(29)  in ye %9.4f `cv_s1_s2' in gr _col(37) "\\\"		///
					_n, _continue
					local s=`s'+1
				}
			}
		}

		if `n1_var'==2 & `n2_var'==1 {
			local c1_1=`nc_PT1'+2
			local c1_2=`nc_PT1'+4
			local c2_1=`nc_PT2'+2
			noi di in gr _n "{hline 78}" 							///
				_n "Values of cross validation across specifications"		///
				_n "{hline 78}"								///
				_n 	_col(1)  "Spec" _col(7)  "&"					///
				 	_col(14)  "V1" _col(17)  "&"					///
				 	_col(24)  "V2" _col(27)  "&"					///
				 	_col(34)  "IV" _col(37)  "&"					///
				 	_col(44)  "Z1" _col(47)  "&"					///
					_col(54)  "CV" _col(57)  "\\\"				///
				_n, _continue
			local s=1
			forvalues s1=0(1)`n1_spec' {
				forvalues s2=0(1)`n2_spec' {
					if `s1'==0 {
						local V1=1
						local V2=1
						local IV=0
					}	
					else {
						local V1=0
						local V2=0
						local IV=0
						local n_var_spec1: word count `S1_`s1''
						forvalues j=1(1)`n_var_spec1' {
							local var1_`j': word `j' of `S1_`s1''
							local t1_1=real(substr("`var1_`j''",`c1_1',1))
							local t1_2=real(substr("`var1_`j''",`c1_2',1))
							local V1=max(`V1',cond(`t1_1'>0  & `t1_2'==0,`t1_1',0))
							local V2=max(`V2',cond(`t1_1'==0 & `t1_2'>0 ,`t1_2',0))
							local IV=`IV'+cond(`t1_1'>0 & `t1_2'>0,1,0)
						}
						if `V1'==0 local V1=1
						if `V2'==0 local V2=1
					}

					if `s2'==0 local Z1=1
					else {
						local Z1=0
						local n_var_spec2: word count `S2_`s2''
						forvalues j=1(1)`n_var_spec2' {
							local var2_`j': word `j' of `S2_`s2''
							local t2_1=real(substr("`var2_`j''",`c2_1',1))
							local Z1=max(`Z1',`t2_1')
						}
					}
					mata: st_numscalar("r(cv)", cv[`s',1])
					local cv_s1_s2=r(cv)
					noi di in ye 									///
						_col(5)   in ye "`s'" in gr _col(7)   "&"				///
						_col(15)  in ye "`V1'" in gr _col(17) "&"				///
						_col(25)  in ye "`V2'" in gr _col(27) "&"				///
						_col(35)  in ye "`IV'" in gr _col(37) "&"				///
						_col(45)  in ye "`Z1'" in gr _col(47) "&"				///
						_col(49)  in ye %9.4f `cv_s1_s2' in gr _col(57) "\\\"		///
					_n, _continue
					local s=`s'+1
				}
			}
		}	

		if `n1_var'==3 & `n2_var'==1 {
			local c1_1=`nc_PT1'+2
			local c1_2=`nc_PT1'+4
			local c1_3=`nc_PT1'+6
			local c2_1=`nc_PT2'+2
			noi di in gr _n "{hline 78}" 							///
				_n "Values of cross validation across specifications"		///
				_n "{hline 78}"								///
				_n 	_col(1)  "Spec" _col(7)  "&"					///
				 	_col(14)  "V1" _col(17)  "&"					///
				 	_col(24)  "V2" _col(27)  "&"					///
				 	_col(34)  "V3" _col(37)  "&"					///
				 	_col(44)  "IV" _col(47)  "&"					///
				 	_col(54)  "Z1" _col(57)  "&"					///
					_col(64)  "CV" _col(67)  "\\\"				///
				_n, _continue
			local s=1
			forvalues s1=0(1)`n1_spec' {
				forvalues s2=0(1)`n2_spec' {
					if `s1'==0 {
						local V1=1
						local V2=1
						local V3=1
						local IV=0
					}		
					else {
						local V1=0
						local V2=0
						local V3=0
						local IV=0
						local n_var_spec1: word count `S1_`s1''
						forvalues j=1(1)`n_var_spec1' {
							local var1_`j': word `j' of `S1_`s1''
							local t1_1=real(substr("`var1_`j''",`c1_1',1))
							local t1_2=real(substr("`var1_`j''",`c1_2',1))
							local t1_3=real(substr("`var1_`j''",`c1_3',1))
							local V1=max(`V1',cond(`t1_1'>0  & `t1_2'==0 & `t1_3'==0,`t1_1',0))
							local V2=max(`V2',cond(`t1_1'==0 & `t1_2'>0  & `t1_3'==0,`t1_2',0))
							local V3=max(`V3',cond(`t1_1'==0 & `t1_2'==0 & `t1_3'>0 ,`t1_3',0))
							local IV=`IV'+cond((`t1_1'>0 & `t1_2'>0)|(`t1_1'>0 & `t1_3'>0)|(`t1_2'>0 & `t1_3'>0),1,0)
						}
						if `V1'==0 local V1=1
						if `V2'==0 local V2=1
						if `V3'==0 local V3=1
					}

					if `s2'==0 local Z1=1
					else {
						local Z1=0
						local n_var_spec2: word count `S2_`s2''
						forvalues j=1(1)`n_var_spec2' {
							local var2_`j': word `j' of `S2_`s2''
							local t2_1=real(substr("`var2_`j''",`c2_1',1))
							local Z1=max(`Z1',`t2_1')
						}	
					}
					mata: st_numscalar("r(cv)", cv[`s',1])
					local cv_s1_s2=r(cv)
					noi di in ye 									///
						_col(5)   in ye "`s'" in gr _col(7)  "&"				///
						_col(15)  in ye "`V1'" in gr _col(17) "&"				///
						_col(25)  in ye "`V2'" in gr _col(27) "&"				///
						_col(35)  in ye "`V3'" in gr _col(37) "&"				///
						_col(45)  in ye "`IV'" in gr _col(47) "&"				///
						_col(55)  in ye "`Z1'" in gr _col(57) "&"				///
						_col(59)  in ye %9.4f `cv_s1_s2' in gr _col(67) "\\\"		///
					_n, _continue
					local s=`s'+1
				}
			}

		}	
	}

end




