
program define plinear_0, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "plinear_0" {
			di as error "results for plinear_0 not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass 

	* Dependent variable
		gettoken dep 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depn : subinstr local dep "." "_"

	* Other equations & options
		syntax varlist(min=1) [if] [in] [pw fw iw] , nonlinear(varname)			///
			[noCONstant OFFset(varname numeric) Robust Cluster(varname)   		///
			order(integer 3) wtype(string) wvar(string) TRIMming(integer 0) Level(integer $S_level)]

	* Identify noconstant and offset main equation
		local nc `constant'
		if "`offset'"  != "" local off "offset(`offset')" 

	* Estimation sample 
		marksample touse
		markout `touse' `dep' `cluster', strok

	* Other options
		if "`wtype'" 	!= "" local wgt [`wtype'`wvar']
		if "`cluster'" 	!= "" local clopt "cluster(`cluster')" 
		if "`level'" 	!= "" local level "level(`level')"

	* Trimming
		if `trimming'!=0 {
			local t_inf=`trimming'
			local t_sup=100-`trimming'
			_pctile `nonlinear' 		if `touse', p(`t_inf' `t_sup')
			local inf1=r(r1)
			local sup1=r(r2)
			local touse1 "`touse' & (`nonlinear'>= `inf1' & `nonlinear' <= `sup1')"
		}
		else local touse1 "`touse'"

	* List of powers for nonlinear relationship
		local nl_list " "
		forvalues k=2(1)`order' {
			gen double `nonlinear'`k'=`nonlinear'^`k'		if `touse1' 
			local nl_list "`nl_list' `nonlinear'`k'"
		}

	* Augmented regression model - variable of interest
		regress `dep' `varlist' `nl_list' `wgt' 			if `touse1', 	///
			`nc' `off' `robust' `clopt' `level'
		if `order'>1 drop `nl_list' 

	* Store estimated coefficients
		tempname b sd
		matrix `b'=e(b)
		matrix `sd'=e(V)
		matrix coleq `b'= `dep'
		matrix roweq `sd'= `dep'
		matrix coleq `sd'= `dep'

	* Return
		eret post `b' `sd', esample(`touse') dep("`dep'")
		eret local depvar "`dep'"
		eret local rhs "`varlist' `nl_list'"
		ereturn local cmd="bootstrap"
end






