
program define ivgres, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "ivgres" {
			di as error "results for ivgres not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass 

	* Dependent variable
		gettoken dep 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depn : subinstr local dep "." "_"

	* Other equations & options
		syntax varlist(min=1) [if] [in] [pw fw iw], 						///
			ENDOGeneity(string) 									///
			[noCONstant OFFset(varname numeric) Robust Cluster(varname)   		///
			order1(integer 3) order2(integer 3)	TRIMming(real 0)			///
			First Level(integer $S_level)								///
			reps(integer 100) Seed(integer 123456789) save(string)]

	* Identify noconstant and offset main equation
		local nc `constant'
		if "`offset'"  != "" local off "offset(`offset')" 

	* Identify Selection equations
		Select enddep endind endnc endoff : `"`endogeneity'"'

	* Estimation sample 
		marksample touse
		markout `touse' `dep' `enddep' `endind' `endoff' `cluster', strok
noi tab `touse'
	* Other options
		if "`weight'" 	!= "" local wgt [`weight'`exp']
		if "`cluster'" 	!= "" local clopt "cluster(`cluster')" 
		if "`level'" 	!= "" local level "level(`level')"
		if "`save'"		!= "" local saving "saving(`save')"
		if "`weight'" == "pweight" | "`cluster'" != "" local robust "robust"
		local showf = cond("`first'" == "", "quietly", "noisily")
		local title "IV with generated residual"

	* First estimation step
		if `trimming'!=0 {
			local t_inf=`trimming'
			local t_sup=100-`trimming'
			_pctile `enddep' 		if `touse', p(`t_inf' `t_sup')
			local inf1=r(r1)
			local sup1=r(r2)
			local touse1 "`touse' & (`enddep'>= `inf1' & `enddep' <= `sup1')"
		}
		else local touse1 "`touse'"
		
		tempname est1
		`showf' di in gr "First estimation step"
		`showf' regress `enddep' `endind' 	`wgt' if `touse1', 	///
				`endnc' `endoff' `robust' `clopt' `level'
		estimates store `est1'

	* Bootstrapped second step 
		tempname est2
		noi bootstrap _b,								///
			reps(`reps') seed(`seed') `level' nol noh			///
			saving("`save'" , every(5) replace) title(`title'):	///
			ivgres_0 `dep' `varlist' if `touse', `nc' `off'		///
			endog(`enddep'=`endind', `endnc' `endoff')		///
			order1(`order1') order2(`order2') 				///
			wtype(`weight') wvar(`exp')					///
			trimming(`trimming') `level'  
		estimates store `est2'

	* Store estimated coefficients
		tempname b sd
		matrix `b'=e(b)
		matrix `sd'=e(V)
		matrix coleq `b'= `dep'
		matrix roweq `sd'= `dep'
		matrix coleq `sd'= `dep'

	* Test for endogeneity
		qui estimates restore `est1'
		qui predict double resid 	if `touse', r
		if `trimming'!=0 {
/*			local t_inf=`trimming'
			local t_sup=100-`trimming'

			_pctile `enddep' 		if `touse', p(`t_inf' `t_sup')
			local inf1=r(r1)
			local sup1=r(r2)
			local touse1 "`touse' & (`enddep'>= `inf1' & `enddep' <= `sup1')"
*/
			_pctile resid 		if `touse', p(`t_inf' `t_sup')
			local inf2=r(r1)
			local sup2=r(r2)
			local touse2 "`touse1' & (resid>= `inf2' & resid <= `sup2')"
		}
		else local touse2 "`touse'"
		local res_list "resid"
		forvalues k=2(1)`order2' {
			qui gen double resid`k'=resid^`k'		if `touse2'
			local res_list "`res_list' resid`k'"
		}
		qui estimates restore `est2'
		qui test `res_list'
		noi di in gr "Test of endogeneity - chi2(" in ye r(df) in gr ")=" 	///
		 	in ye %9.2f r(chi2) 								///
			 _col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)			///
			 _n in gr "{hline 78}"

	* Set estimation sample
		qui count if `touse'		
		local n=r(N)
		cap drop `res_list'
		
	
	* Return
		eret post `b' `sd', esample(`touse') dep("`dep'")
		eret local depvar "`dep'"
		eret local rhs "`varlist'"
		eret local enddep "`enddep'"
		eret local endind "`endind'"
		ereturn scalar N=`n'
		ereturn local cmd="ivgres"
end



program define Select
	args seldep selind selnc seloff colon sel_eqn

	gettoken dep rest : sel_eqn, parse(" =")
	gettoken equal rest : rest, parse(" =")

	if "`equal'" == "=" { 
		tsunab dep : `dep'
		c_local `seldep' `dep' 
	}
	else	local rest `"`sel_eqn'"'
	
	local 0 `"`rest'"'
	syntax [varlist(numeric default=none)] 	/*
		*/ [, noCONstant OFFset(varname numeric) ]

	if "`varlist'" == "" {
		di in red "no variables specified for selection equation"
		exit 198
	}

	c_local `selind' `varlist'
	c_local `selnc' `constant'
	c_local `seloff' `offset'
end




