qui {

*------------------------------------------------------------------------------------------------
* A - Setting stata
*------------------------------------------------------------------------------------------------
* Basic
	version 10.1
	clear 
	clear mata
	program drop _all
	macro drop _all
	set mem 300m
	set more off
	set linesize 150

* Globals for the estimation process
	global seed=123
	global draw=75
	global replicates=1000
	global iter=100

* Global for log income terms
	global RI=1
	global inc_degree=2
	global reference "income"

* Directories				
	global mydir		"C:\Users\FP_Tablet\Desktop\De Luca, Peracchi (2010)\DeLuca_Peracchi_Analysis"
	global share_w1 		"F:\PBAB\Giuseppe De Luca\C\DATA\SHARE\sharew1"

	global FS_DEGREE	"${mydir}\FS_DEGREE"
	global PL_DEGREE	"${mydir}\PL_DEGREE"
	global SS_EST		"${mydir}\SS_EST"
	global TS_EST		"${mydir}\TS_EST"
	global TS_BOOT		"${mydir}\TS_BOOT"
	global TS_GRA		"${mydir}\TS_GRA"
	global TS_USM		"${mydir}\TS_USM"
	global TS_BS_IV		"${mydir}\TS_BASELINE_IV"

	cd "$mydir"
	adopath + "${mydir}\routine_ado"

* Run other stata procedures in do files
	run "routine_do\dropping.do"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* B - Extract data from SHARE rel 2.0.1 -> [sample_income.dta]
*------------------------------------------------------------------------------------------------
noi run 1_Fieldwork.do				// Select relevant fieldwork info 
									// -> unit.dta, contact.dta

noi run 2_Imputations.do			// Select imputated data 
									// -> Imputation.dta, imp_income.dta

noi run 3_Capi.do					// Select and merge capi data from all SHARE modules 
									// -> capi.dta					 

noi run 4_Merge_data.do				// Merge capi.dta, unit.dta and contact.dta
									// -> capi.dta, unit.dta, contact.dta					 

noi run 5_Select_capi.do			// Select relevant variables from capi.dta
									// -> capi.dta

noi run 6_Mydata.do 				// Generate covariates from unit.dta and capi.dta
									// -> mydata.dta					 

noi run 7_Budget_share.do 			// Generate budget share 
									// Impute about 200 outliers in the budget shares 
									// Generate log of household income and its powers
									// -> sample_income.dta
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* C - Descriptive analysis
*------------------------------------------------------------------------------------------------
noi run 8_Descriptive				// Response rates and summary statistics
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* D - First-step estimates of unit and item nonresponse
*------------------------------------------------------------------------------------------------
noi run 9_FS_degree.do				// Fit SNP models for the two different definitions 
									// of item nonresponse on budget share using alternative 
									// starting values and orders of the Hermite pol. expansion. 
									// Estimates are obtained separately by country and 
									// for the pooling of all countries.
									// Results: FS_DEGREE folder 

noi run 10_FS_estimates.do			// Display first-step estimates of unit and item nonresponse 
									// for the selected specification 
									// Results: 10_FS_Estimates_a.log 
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* E - Cross-Validation on second and third estimation steps
*------------------------------------------------------------------------------------------------
noi run 11_PL_degree.do				// Determine degree of pol. expansion in semiparametric 
									// models with k=(3,3) in the first estimation step.
									// Countries: `C'=ALL, DK, ES, IT, NL, SE
									// Definition of item nonresponse on budget share: `v'=a, b
									// Trimming: 1%
									// Results: PL_DEGREE folder
									// Files:   `v'_`C'.log, trimm_`v'_`C'.dta
								
noi run 12_PL_degree_base.do			// Determine degree of pol. expansion in baseline models
									// Countries: `C'=ALL, DK, ES, IT, NL, SE
									// Definition of item nonresponse on budget share: `v'=a, b
									// Trimming: 1%
									// Results: PL_DEGREE folder
									// Files: `v'_`C'_baseline.log
								
noi run 13_PL_degree_44.do			// Determine degree of pol. expansion in semiparametric 
									// models with k=(4,4) in the first estimation step.
									// Countries: ALL,
									// Definition of item nonresponse on budget share: a
									// Trimming: 1%
									// Results: PL_DEGREE folder
									// Files: a_ALL_44.log, trimm_a_ALL_44.dta	
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* F - Second Estimation Step
*------------------------------------------------------------------------------------------------
noi run 14_SS_estimates.do			// Run and display second step estimates
									// Legend: M1-Model 1,M2-Model 2,S3-Model 3, M3-Model 4
									// Countries: ALL,
									// Definition of item nonresponse on budget share: v=a
									// Models: `m'=M1, M2, S3, M3
									// Trimming: 1% (Model 4)
									// Results: SS_EST folder
									// Files: Table_a_ALL.log, a_ALL_`m'.log, a_ALL_`m'.dta	
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* G - Third Estimation Step & Sesitivity Analysis
*------------------------------------------------------------------------------------------------
noi run 15_TS_estimates.do			// Run and display third step estimates
									// Legend: M1-Model 1,M2-Model 2,S3-Model 3, M3-Model 4
									// Countries: ALL,
									// Definition of item nonresponse on budget share: `v'=a,b
									// Models: `m'=M1, M2, S3, M3
									// Trimming: 1% 
									// Results: TS_EST folder
									// Files: Table_a_ALL.log, `v'_ALL_`m'.log, `v'_ALL_`m'.dta	
									// Results: TS_BOOT folder
									// Files: `v'_ALL_`m'.dta	

noi run 16_TS_USM.do				// Run third-step estimates with undersmoothing
									// Legend: M1-Model 1,M2-Model 2,S3-Model 3, M3-Model 4
									// Countries: ALL,
									// Definition of item nonresponse on budget share: v=a
									// Models: `m'=M1, M2, S3, M3
									// Trimming: 1% 
									// Results: TS_USM folder
									// Files: a_ALL.log, a_ALL.dta	
									// Results: TS_BOOT_USM folder
									// Files: a_ALL_M1_USM.dta, a_ALL_M2_USM.dta	
									
noi run 17_TS_Country.do			// Run third-step estimates separately by country
									// Legend: M1-Model 1,M2-Model 2, M3-Model 4 (model S3 excluded)
									// Countries: `C'=DK, ES, IT, NL, SE
									// Definition of item nonresponse on budget share: v=a
									// Models: `m'=M1, M2, M3
									// Trimming: 1% 
									// Results: TS_EST folder
									// Files: a_`C'_`m'.log, a_`C'_`m'.dta	
									// Results: TS_BOOT folder
									// Files: a_`C'_`m'.dta

noi run 18_TS_WAD.do				// Compute Waighted average derivative (pooled and separately by country)
									// Legend: M1-Model 1,M2-Model 2, M3-Model 4 (model S3 excluded)
									// Countries: `C'=ALL, DK, ES, IT, NL, SE
									// Definition of item nonresponse on budget share: v=a
									// Models: `m'=M1, M2, M3
									// Results: TS_EST folder
									// Files: a_wad.log (Table 8), WAD_a_`C'_`m'.dta	
									
noi run 19_TS_Fig_1_4.do			// Plot food share derivatives (pooled and separately by country)
									// Legend: M1-Model 1,M2-Model 2, M3-Model 4 (model S3 only for pooled)
									// Countries: `C'=ALL, DK, ES, IT, NL, SE
									// Definition of item nonresponse on budget share: v=a
									// Models: `m'=M1, M2, S3, M3
									// Format: `f'=.gph, .wmf, .eps
									// Graph: TS_GRA folder
									// Files: DER_a_ALL_cb.`f' (Figure 1), DER_a.`f' (Figure 4), GRA_a_`C'.dta	
									
noi run 20_TS_Fig_2.do				// Plot food share derivatives with undersmoothing 
									// Legend: M1-Model 1,M2-Model 2,S3-Model, M3-Model 4 
									// Countries: C=ALL
									// Definition of item nonresponse on budget share: v=a
									// Models: `m'=M1, M2, S3, M3
									// Format: `f'=.gph, .wmf, .eps
									// Graph: TS_GRA folder
									// Files: DER_a_ALL_USM.`f' (Figure 2), USM_b_ALL.dta	

noi run 21_TS_Fig_3.do				// Plot food share derivatives for more and less conservative 
									// definition of item nonresponse on household income
									// Legend: M1-Model 1,M2-Model 2,S3-Model, M3-Model 4 
									// Countries: C=ALL
									// Definition of item nonresponse on budget share: v=a,b
									// Models: `m'=M1, M2, S3, M3
									// Format: `f'=.gph, .wmf, .eps
									// Graph: TS_GRA folder
									// Files: DER_ab_ALL.`f' (Figure 3), GRA_b_ALL.dta	
*------------------------------------------------------------------------------------------------


}
