qui {


*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables1 	"a b"
	local Country_list1 "ALL DK ES IT NL SE"
	local R1_list 		"3 4"
	local R2_list 		"3 4"
	local start_val 	"pro snp"
*------------------------------------------------------------------------------------------------






*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
* Do Estimates
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over variables1

foreach V of local Variables1 {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over country_list1
foreach C of local Country_list1 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="DK" 		local C_tit "Denmark"
		if "`C'"=="ES" 		local C_tit "Spain"
		if "`C'"=="IT" 		local C_tit "Italy"
		if "`C'"=="NL" 		local C_tit "Netherland"
		if "`C'"=="SE" 		local C_tit "Sweden"
		if "`C'"=="ALL" 	local C_tit "All countries"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye						///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}					if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  	if `U'==1 & `I_Y'==1
		keep  sampid2 country						///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} ${wgt} 		 
		order sampid2 country						///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} ${wgt} 	
	 
		compress
		saveold "${FS_DEGREE}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Loop over starting values
foreach S of local start_val {

	* Log file 
		cap log close
		log using "${FS_DEGREE}/`V'_`C'_`S'", replace text
		estimates clear

	* Inizialize file of estimates
		use "${FS_DEGREE}/temp_`V'_`C'", replace
		keep sampid2
		sort sampid2
		saveold "${FS_DEGREE}/`V'_`C'_`S'", replace

	* Load data
		use "${FS_DEGREE}/temp_`V'_`C'", replace

	* Bivariate probit with sample sel. for unit and item response
		noi di _n in ye "Bivariate probit with sample sel. for unit and item response"

		probit `U' ${U_X}
		local c=_b[_cons]
		constraint 1 [`U']_cons=`c'

		probit `I_Y' ${I_Y_X}
		local c=_b[_cons]
		constraint 2 [`I_Y']_cons=`c'

		noi heckprob `I_Y' ${I_Y_X}, sel(`U'=${U_X}) difficult iterate(40) // constraints(1 2)

		if e(converged)==1 {
			estimates store BP
			noi estat ic
			estwrite BP using "${FS_DEGREE}/`V'_`C'_`S'", estsave append id(sampid2)
		}

	* Univariate SNP for unit nonresponse
		noi di _n in gr "{hline 85}" _n in ye		///
			"Univariate SNP for unit nonresponse"	///
			_n in gr "{hline 85}"
		foreach R1 of local R1_list {
			noi di _n in gr "Varible `V' - Country `C' - (R1=`R1')"	
			noi snp `U' ${U_X}, order(`R1') iterate(80) 
			noi estat ic
		}

	* Univariate SNP for item nonresponse
		noi di _n in gr "{hline 85}" _n in ye		///
			"Univariate SNP for item nonresponse"	///
			_n in gr "{hline 85}"
		foreach R2 of local R2_list {
			noi di _n in gr "Varible `V' - Country `C' - (R2=`R2')"
			noi snp `I_Y' ${I_Y_X}, order(`R2') iterate(80) 
			noi estat ic
		}

	* Bivariate SNP with sample selection for unit and item response
		noi di _n in gr "{hline 85}" _n in ye		///
			"Bivariate SNP with sample selection"	///
			_n in gr "{hline 85}"

		foreach R1 of local R1_list {
			foreach R2 of local R2_list {

				* Starting values
					if "`S'"=="pro" local from "startprobit"
					if "`S'"=="snp" {
						if `R1'==3 & `R2'==3 {

							noi di _n in gr "Varible `V' - Country `C' - Start Val `S' - Model for starting values (R1=3,R2=2)"
							noi snpbpsel_m `I_Y' ${I_Y_X}, sel(`U'=${U_X}) order1(3) order2(2) iterate(80) startprobit
							estimates store SNP_3_2
							noi estat ic
							estwrite SNP_3_2 using "${FS_DEGREE}/`V'_`C'_`S'", estsave append id(sampid2)
							matrix b_32=e(b)
							local k0=e(k)-6
							local k1=e(k)-5
							local k2=e(k)-4
							local k3=e(k)-3
							local k4=e(k)-2
							local k5=e(k)-1
							matrix b0=b_32[1,1..`k0']
							matrix g1=(b_32[1,`k1'..`k2'],0)
							matrix g2=(b_32[1,`k3'..`k4'],0)
							matrix g3=(b_32[1,`k5'..e(k)],0)
							matrix b_start_33=(b0,g1,g2,g3)

							local from "from(b_start_33, copy)"
							matrix drop b0 g1 g2 g3
						}
						if `R1'==3 & `R2'==4 {
							cap estimates restore SNP_3_3
							if _rc==0 {
								local k0=e(k)-9
								local k1=e(k)-8
								local k2=e(k)-6
								local k3=e(k)-5
								local k4=e(k)-3         
								local k5=e(k)-2         
								matrix b0=b_33[1,1..`k0']
								matrix g1=(b_33[1,`k1'..`k2'],0)
								matrix g2=(b_33[1,`k3'..`k4'],0)
								matrix g3=(b_33[1,`k5'..e(k)],0)
								matrix b_start_34=(b0,g1,g2,g3)
								local from "from(b_start_34, copy)"
								matrix drop b0 g1 g2 g3
							}
							else local from ""
						}						
						if `R1'==4 & `R2'==3 {
							cap estimates restore SNP_3_3
							if _rc==0 {
								matrix b_start_43=(b_33,0,0,0)
								local from "from(b_start_43, copy)"
							}
							else local from ""
						}
						if `R1'==4 & `R2'==4 {
							cap estimates restore SNP_3_3
							if _rc==0 {
								matrix b_start_44=(b_start_34,0,0,0,0)
								local from "from(b_start_44, copy)"
							}
							else local from ""
						}
					}
						
				* SNP Estimate with specified starting values
					noi di _n in gr "Varible `V' - Country `C' - Start Val `S' - (R1=`R1',R2=`R2')"
					noi snpbpsel_m `I_Y' ${I_Y_X}, sel(`U'=${U_X}) 	///
						order1(`R1') order2(`R2') `from' iterate(80) 

				* Estimate storing
					if e(converged)==1 {
						if `R1'==3 & `R2'==3 matrix b_33=e(b)
						estimates store SNP_`R1'_`R2'
						noi estat ic
						estwrite SNP_`R1'_`R2' using "${FS_DEGREE}/`V'_`C'_`S'", 	///
							estsave append id(sampid2)
					}
			}	
		}	

		cap log close
		estimates clear
	}	// End loop over starting values
	cap erase "${FS_DEGREE}/temp_`V'_`C'.dta"
}	// End loop over country
}	// End loop over variables
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
}	// End quitely


