qui {
	cap log close
	log using 8_Descriptive, replace t
	set linesize 255

*-------------------------------------------------------------------------------------------------
* Item response rates (by country and sample type)
local def "a b"
foreach V of local def {

	* ITR by country and sample type
		use sample_income, clear
		replace samptype=1 			if samptype==3

		gen I1=foode_obs_`V'
		gen I2=hincome_obs_`V'
		gen I3=w_food_obs_`V'

		replace country_s="DK" 			if country==18
		replace country_s="ES" 			if country==15
		replace country_s="IT" 			if country==16
		replace country_s="NL" 			if country==14
		replace country_s="SE" 			if country==13

		gen E=(part==1)
		collapse (sum) E I1 I2 I3, by(country_s samptype)
		forvalue i=1(1)3 {
			gen double I`i'_b=I`i'/E
		}
		format I?_b %9.2f
		gen order=_n
		save temp_r, replace

	* ITR by sample type
		use temp_r, clear

		collapse (sum) E I1 I2 I3, by(samptype)
		gen country_s="ALL"
		forvalue i=1(1)3 {
			gen double I`i'_b=I`i'/E
		}
		format I?_b %9.2f
		append using temp_r
		sort order samptype
		replace order=_n
		save temp_r2, replace

	* ITR by country and sample type
		use temp_r, clear
		collapse (sum) E I?
		gen country_s="ALL"
		gen sample="Total"
		forvalue i=1(1)3 {
			gen double I`i'_b=I`i'/E
		}
		format I?_b %9.2f
		append using temp_r2
		sort order
		replace order=_n
		replace sample="Main" 			if samptype==1
		replace sample="Vignette" 		if samptype==2
		replace sample="Supplement" 		if samptype==3
		sort country_s order
		bys country_s: replace country_s="" if _n>1

	* Display table
		gen and="&"
		gen end="\\"
		sort order
		noi di in gr _n "{hline 80}" 						///
			 _n "Table 2: Item response rates - Definition `V'"	///
			 _n "{hline 80}"
		noi list country_s and sample and E and I1 and I2 and I3 and I1_b and I2_b and I3_b end, noobs clean
		noi di in gr _n "{hline 80}" 				
		cap erase temp_r.dta
		cap erase temp_r2.dta
}
*-------------------------------------------------------------------------------------------------




*-------------------------------------------------------------------------------------------------
* Definition and summary statistics for the main covariates
*-------------------------------------------------------------------------------------------------
noi di in gr _n "{hline 80}" 								///
	 _n "Definition and summary statistics for the main covariates"	///
	 _n "{hline 80}"

	use sample_income, clear
	
	replace gs_age=gs_age+65

	replace iv_age=iv_age+50
	replace iv_edu=iv_edu+12

	replace delay=delay+.4537445	if country_s=="dk"
	replace delay=delay+.22509225	if country_s=="se" & samptype==1
	replace delay=delay+.02631579	if country_s=="se" & samptype==2
	replace delay=delay+.20833333	if country_s=="se" & samptype==3

	replace delay=delay+.36144578	if country_s=="es" & samptype==1
	replace delay=delay+.36363637	if country_s=="es" & samptype==1

	replace delay=delay+.30384615	if country_s=="it" & samptype==1
	replace delay=delay+.22962964	if country_s=="it" & samptype==1

	replace delay=delay+.33838382	if country_s=="nl" & samptype==1
	replace delay=delay+.54440153	if country_s=="nl" & samptype==1

	rename ES_nuts1_1 	ES_nuts1
	rename ES_nuts1_2 	ES_nuts2 
	rename ES_nuts1_3 	ES_nuts3 
	rename ES_nuts1_4 	ES_nuts4 
	rename ES_nuts1_5 	ES_nuts5 
	rename ES_nuts1_6 	ES_nuts6 
	rename ES_nuts1_7 	ES_nuts7
	rename IT_nuts1_1 	IT_nuts1 
	rename IT_nuts1_2 	IT_nuts2 
	rename IT_nuts1_3 	IT_nuts3
	rename IT_nuts1_4 	IT_nuts4 
	rename IT_nuts1_5 	IT_nuts5
	rename NL_nuts1_1 	NL_nuts1 
	rename NL_nuts1_2 	NL_nuts2 
	rename NL_nuts1_3 	NL_nuts3 
	rename NL_nuts1_4 	NL_nuts4 

	replace age=age+65

	replace partner_age =partner_age+65
	replace hsize=hsize+2

	replace education=education+12

	replace orient=orient+4
	replace math=math+4
	replace recall_d=recall_d+7
	replace fluency=fluency+25

	global CC = "ALL"
	global V = "a"
	noi run 0_Predictors
	keep	part w_food_obs_a ln_hincome_a w_food_a 	///
		ln_hincome_imp1_a w_food_imp1_a					///
		gs_age gs_female 								///
		vignette suppl ans_mac delay					///
		iv_female iv_age iv_edu							///
		DK												///
		ES ES_nuts1 ES_nuts2 ES_nuts3 ES_nuts4 			///
		ES_nuts6 ES_nuts7								///
		IT IT_nuts2 IT_nuts3 IT_nuts4 IT_nuts5 			///
		NL NL_nuts1 NL_nuts2 NL_nuts4					///
		SE												///
		proxy int_clarif int_out						///
		orient math recall_d fluency					///
		age female education single partner_age 		///
		hsize children small_city 
		 
	order	part w_food_obs_a ln_hincome_a w_food_a 	///
		ln_hincome_imp1_a w_food_imp1_a					///
		gs_age gs_female 								///
		vignette suppl ans_mac delay					///
		iv_female iv_age iv_edu							///
		DK												///
		ES ES_nuts1 ES_nuts2 ES_nuts3 ES_nuts4 			///
		ES_nuts6 ES_nuts7								///
		IT IT_nuts2 IT_nuts3 IT_nuts4 IT_nuts5 			///
		NL NL_nuts1 NL_nuts2 NL_nuts4					///
		SE												///
		proxy int_clarif int_out						///
		orient math recall_d fluency					///
		age female education single partner_age 		///
		hsize children small_city 
		
	rename w_food_obs_a 		food_s_obs
	rename w_food_a 			food_s
	rename w_food_imp1_a 		food_s_imp
	rename ln_hincome_a 		ln_income
	rename ln_hincome_imp1_a 	ln_income_imp
	rename recall_d 			recall
	
	save temp, replace

	local j = 1
	local stat "count mean sd"
	foreach jj of local stat {
		if "`jj'"=="count" 	local name "n"
		if "`jj'"=="mean" 	local name "mean"
		if "`jj'"=="sd" 		local name "sd"
		use temp, clear
		collapse (`jj') _all
		xpose, clear varname promote
		gen order=_n
		rename v1 `name'
		if "`jj'"!="count" {
			merge _varname using temp2, sort
			drop _merge
		}
		save temp2, replace
	}

	use temp2, clear
	gen descr=""
	gen eq=""
	sort order
	order order _varname n mean sd descr eq
	format mean sd %9.2f
	replace descr="Dummy for household survey participation" 	if _varname=="part"
	replace descr="Dummy for item response on food share" 		if _varname=="food_s_obs"
	replace descr="Age of SHM"					 				if _varname=="gs_age"
	replace descr="Dummy for female SHM" 						if _varname=="gs_female"
	replace descr="Dummy for female interviewer" 				if _varname=="iv_female"
	replace descr="Age of interviewer" 							if _varname=="iv_age"
	replace descr="Interviewer years of education" 				if _varname=="iv_edu"
	replace descr="Dummy for presence of answering machine" 	if _varname=="ans_mac"
	replace descr="Measure of delay in the contact process" 	if _varname=="delay"
	replace descr="Dummy for vignette sample"			 		if _varname=="vignette"
	replace descr="Dummy for Swedish supplementary sample" 		if _varname=="suppl"
	replace descr="Dummy for Denmark" 							if _varname=="DK"
	replace descr="Dummy for Spain" 							if _varname=="ES"
	replace descr="Dummy for Spain-Region 1"					if _varname=="ES_nuts1"
	replace descr="Dummy for Spain-Region 2"					if _varname=="ES_nuts2"
	replace descr="Dummy for Spain-Region 3"					if _varname=="ES_nuts3"
	replace descr="Dummy for Spain-Region 4"					if _varname=="ES_nuts4"
	replace descr="Dummy for Spain-Region 5"					if _varname=="ES_nuts5"
	replace descr="Dummy for Spain-Region 6"					if _varname=="ES_nuts6"
	replace descr="Dummy for Spain-Region 7"					if _varname=="ES_nuts7"
	replace descr="Dummy for Italy" 							if _varname=="IT"
	replace descr="Dummy for Italy-Region 1"					if _varname=="IT_nuts1"
	replace descr="Dummy for Italy-Region 2"					if _varname=="IT_nuts2"
	replace descr="Dummy for Italy-Region 3"					if _varname=="IT_nuts3"
	replace descr="Dummy for Italy-Region 4"					if _varname=="IT_nuts4"
	replace descr="Dummy for Italy-Region 5"					if _varname=="IT_nuts5"
	replace descr="Dummy for Netherlands" 						if _varname=="NL"
	replace descr="Dummy for Netherlands-Region 1"				if _varname=="NL_nuts1"
	replace descr="Dummy for Netherlands-Region 2"				if _varname=="NL_nuts2"
	replace descr="Dummy for Netherlands-Region 3"				if _varname=="NL_nuts3"
	replace descr="Dummy for Netherlands-Region 4"				if _varname=="NL_nuts4"
	replace descr="Dummy for Sweden"	 						if _varname=="SE"
	replace descr="Age of HR"									if _varname=="age"
	replace descr="Dummy for female HR"							if _varname=="female"
	replace descr="HR years of education"						if _varname=="education"
	replace descr="Dummy for HR living as single"				if _varname=="single"
	replace descr="Age of spouse/partner"						if _varname=="partner_age"
	replace descr="Household size"								if _varname=="hsize"
	replace descr="Number of children"							if _varname=="children"
	replace descr="Dummy for household living in a small city"	if _varname=="small_city"
	replace descr="Dummy for HR employee"						if _varname=="employee"
	replace descr="Dummy for HR self-employed"					if _varname=="self"
	replace descr="Dummy for home owner"						if _varname=="home_own"
	replace descr="HR score on orientation in time (15)"		if _varname=="orient"
	replace descr="HR score on math (15)"						if _varname=="math"
	replace descr="HR score on delayed recall (010)"			if _varname=="recall"
	replace descr="HR score on fluency (088)"					if _varname=="fluency"
	replace descr="Dummy for proxy interview"					if _varname=="proxy"
	replace descr="Dummy for often asked clarifications"		if _varname=="int_clarif"
	replace descr="Dummy for interview outside home"			if _varname=="int_out"
	replace descr="PPP-adj. household food exp."				if _varname=="food"
	replace descr="PPP-adj. imputed household food exp."		if _varname=="food_imp"
	replace descr="PPP-adj. household income"					if _varname=="ln_income"
	replace descr="PPP-adj. imputed household income"			if _varname=="ln_income_imp"
	replace descr="Food share"									if _varname=="food_s"
	replace descr="Imputed food share"							if _varname=="food_s_imp"

	replace eq="\$Y_1$" 			if _varname=="part"
	replace eq="\$Y_2$" 			if _varname=="food_s_obs"

	replace eq="\$Y_3$"				if _varname=="ln_income"	
	replace eq="\$Y_3^*$"			if _varname=="ln_income_imp"	

	replace eq="\$Y_4$" 			if _varname=="food_s"		
	replace eq="\$Y_4^*$"			if _varname=="food_s_imp"	

	replace eq="\$X_1$" 			if _varname=="gs_female"			///
							| _varname=="gs_age"						///
							| _varname=="ans_mac"						///
							| _varname=="delay"							///
							| _varname=="vignette"						///
							| _varname=="suppl"		

	replace eq="\$X_1$, \$X_2$" 		if _varname=="iv_female"		///
							| _varname=="iv_age"						///
							| _varname=="iv_edu"		

	replace eq="\$X_2$"			if _varname=="int_clarif"				///
							| _varname=="int_out"						///
							| _varname=="proxy"							///
							| _varname=="employee"						///
							| _varname=="self"		

	replace eq="\$X_2$, \$X_3$" 		if _varname=="orient"			///
							| _varname=="math"							///
							| _varname=="recall"						///
							| _varname=="fluency"		

	replace eq="\$X_2$, \$X_3$, \$X_4$" if _varname=="female"			///
							| _varname=="age"							///
							| _varname=="education"						///
							| _varname=="single"						///
							| _varname=="partner_age"					///
							| _varname=="hsize"							///
							| _varname=="children"						///
							| _varname=="small_city"

	replace eq="\$X_1$, \$X_2$, \$X_3$, \$X_4$" 	if _varname=="DK"	///
									| _varname=="ES"					///
									| _varname=="ES_nuts1"				///
									| _varname=="ES_nuts2"				///
									| _varname=="ES_nuts3"				///
									| _varname=="ES_nuts4"				///
									| _varname=="ES_nuts5"				///
									| _varname=="ES_nuts6"				///
									| _varname=="ES_nuts7"				///
									| _varname=="IT"					///
									| _varname=="IT_nuts1"				///
									| _varname=="IT_nuts2"				///
									| _varname=="IT_nuts3"				///
									| _varname=="IT_nuts4"				///
									| _varname=="IT_nuts5"				///
									| _varname=="NL"					///
									| _varname=="NL_nuts1"				///
									| _varname=="NL_nuts2"				///
									| _varname=="NL_nuts3"				///
									| _varname=="NL_nuts4"				///
									| _varname=="SE"		

	gen and="&"
	gen end="\\"

	noi list _varname and descr and eq and n and mean and sd end, noobs clean	
	cap erase temp.dta
	cap erase temp2.dta
*-------------------------------------------------------------------------------------------------

cap log close

}
