qui {
*------------------------------------------------------------------------------------------------
* Budget shares - definitions a and b
*------------------------------------------------------------------------------------------------
	use mydata, clear
	
	gen hincome_obs_a=income_obs
	gen double hincome_a=income
	gen double hincome_imp1_a=income_imp1

	gen hincome_obs_b=income2_obs
	gen double hincome_b=income2
	gen double hincome_imp1_b=income2_imp1

	gen foode_obs_a=food_a_obs
	gen double foode_a=food_a 
	gen double foode_imp1_a=food_a_imp1

	gen foode_obs_b=food_a_obs
	gen double foode_b=food_a 
	gen double foode_imp1_b=food_a_imp1

	local bs "a b"
	foreach bb of local bs {
		gen w_food_obs_`bb'=(foode_obs_`bb'==1 & hincome_obs_`bb'==1)	if part==1
		gen w_food_`bb'=foode_`bb' / hincome_`bb'						if part==1 & w_food_obs_`bb'==1
		gen w_food_imp1_`bb'=foode_imp1_`bb'/hincome_imp1_`bb'			if part==1 
	}
	save temp, replace
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* About 200 in the budget share
* Use recursive hot-deck imputations to deal with these inconsistencies separately by country
* conditioning set: household size, food expenditure quantiles,
*					telephone expenditure quantiles,
*					total household income quantiles			
*------------------------------------------------------------------------------------------------
use temp, clear
local country "DK ES IT NL SE"
foreach vv of local bs {
	foreach cc of local country {
		replace w_food_`vv'=. 			if (hincome_`vv'==0|w_food_`vv'>=1) & `cc'==1
		replace w_food_imp1_`vv'=. 		if (hincome_imp1_`vv'==0|w_food_imp1_`vv'>1) & `cc'==1
	}
}
save temp2, replace

local seed 1234
foreach vv of local bs {
	foreach cc of local country {
		forvalues r=0(1)1 {
			if `r'==0 	{
				local ext ""
				local control "& w_food_obs_`vv'==1"
			}
			if `r'>0	{
				local ext "_imp`r'"
				local control "& w_food_obs_`vv'==0"
			}

			use temp2, clear
			keep if part==1 & `cc'==1 `control'

			* Set of conditioning variables
				recode hsize (-1=1) (0=2) (1=3) (2=4) (3=4) (4=4) (5=4) (6=4) (7=4), gen(x1)
				if `r'==0|`r'==1 {
					xtile x2=foode_imp1_a		, nq(5)
					xtile x3=tel_a_imp1			, nq(5)
					xtile x4=hincome_imp1_a		, nq(5)
				}
				local cond_set "x1 x2 x3 x4"

			* Costruct recursive sets of conditioning variables
				local ncs: word count `cond_set'
				forvalues s=1(1)`ncs'{
					local t=`ncs'-`s'+1
					local cond_set`s' ""
					forvalues i=1(1)`t'{
						local w: word `i' of `cond_set'
						local cond_set`s' "`cond_set`s'' `w'"
					}
				}

			* Recursive hot-deck imputations
				count if w_food`ext'_`vv'==.
				if r(N)>0 {
					local t=1
					while `t'<=`ncs' {
						cap hotdeck w_food`ext'_`vv' using imp_`cc'_`r',		///
						by(`cond_set`t'') store seed(`seed')					///
						keep(sampid part `cond_set')

						use imp_`cc'_`r'1, clear
						sum part 
						local tot_obs=r(N)
						sum w_food`ext'_`ww'  
						local mis=`tot_obs'-r(N)
						if "`mis'"=="0" local t=`ncs'+2	
						else 			local t=`t'+1
					}
					if `mis'>0 exit
					else {
						use imp_`cc'_`r'1, clear
						keep sampid2 w_food`ext'_`vv'   
						rename w_food`ext'_`vv' w_food`ext'_`vv'_`cc'
						merge sampid2 using temp2, sort
						replace w_food`ext'_`vv'=w_food`ext'_`vv'_`cc'	if _merge==3 `control'
						drop w_food`ext'_`vv'_`cc'
					}
					drop _merge
					compress
					save temp2, replace
				}
				cap erase imp_`cc'_`r'1.dta
		}
	}
}

use temp2, clear
foreach vv of local bs {
	replace w_food_imp1_`vv'=w_food_`vv' 						if part==1 & w_food_obs_`vv'==1 	///
																& w_food_imp1_`vv'==.
}
save temp2, replace

use temp2, clear
foreach vv of local bs {
	gen double hincome_t1_`vv'=foode_`vv'/w_food_`vv'			if w_food_obs_`vv'==1
	gen double hincome_t2_`vv'=foode_imp1_`vv'/w_food_imp1_`vv'	if w_food_obs_`vv'==0 	///
																& hincome_obs_`vv'==1
	replace hincome_`vv'=hincome_t1_`vv'						if w_food_obs_`vv'==1
	replace hincome_`vv'=hincome_t2_`vv'						if w_food_obs_`vv'==0 	///
																& hincome_obs_`vv'==1
	drop hincome_t1_`vv' hincome_t2_`vv'
	gen double  hincome_temp_`vv'=foode_imp1_`vv'/w_food_imp1_`vv'
	replace hincome_imp1_`vv'=hincome_temp_`vv' 
	drop hincome_temp_`vv' 
}
save temp2, replace
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Log of total household income and its powers
*------------------------------------------------------------------------------------------------
use temp2, clear
foreach vv of local bs {
	* Observed values
		gen ln_hincome_`vv'=ln(hincome_`vv')						if part==1 & hincome_obs_`vv'==1
		gen ln_hincome_1_`vv'=ln_hincome_`vv'-ln(30000)				if part==1 & hincome_obs_`vv'==1
		forvalues ss=2(1)5 {
			gen double ln_hincome_`ss'_`vv'=ln_hincome_1_`vv'^`ss' 	if part==1 & hincome_obs_`vv'==1
		}

	* Imputed values
		gen ln_hincome_imp1_`vv'=ln(hincome_imp1_`vv')							if part==1 
		gen ln_hincome_imp1_1_`vv'=ln_hincome_imp1_`vv'-ln(30000)				if part==1 
		forvalues ss=2(1)5 {
			gen double ln_hincome_imp1_`ss'_`vv'=ln_hincome_imp1_1_`vv'^`ss' 	if part==1
		}
}
save temp2, replace
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* List of food, income and budget share variables
*------------------------------------------------------------------------------------------------
use temp2, clear
local main ""
foreach vv of local bs {
	#delimit;
	local main 	"`main' 
			w_food_obs_`vv' w_food_`vv' w_food_imp1_`vv' 
			foode_obs_`vv' foode_`vv' foode_imp1_`vv' 
			hincome_obs_`vv' hincome_`vv' hincome_imp1_`vv' 
			ln_hincome_`vv' ln_hincome_1_`vv' ln_hincome_2_`vv' 
			ln_hincome_3_`vv' ln_hincome_4_`vv' ln_hincome_5_`vv'
			ln_hincome_imp1_`vv' ln_hincome_imp1_1_`vv' 
			ln_hincome_imp1_2_`vv' ln_hincome_imp1_3_`vv' 
			ln_hincome_imp1_4_`vv' ln_hincome_imp1_5_`vv'";
	#delimit cr
}
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Final dataset
*------------------------------------------------------------------------------------------------
// drop couple cvid respid country_s wgtach_imp
	use temp2, clear
	#delimit;
	keep  	country country_s sampid2 			 			// Basic variables
			samptype vignette suppl wgtach 
			part nonresponse 								// Unit response 
			`main'											// Main variables
			gs_female gs_age	 							// Sampling frame info
			ans_mac f_delay delay 								// Fieldwork info
			iv_female iv_age iv_edu 						// Interviewer Characteristics
			female age education hsize children				// HR demographic variables
			couple single small_city partner_age		
			orient math fluency recall_d					// Cognitive functioning variables 
			proxy int_out int_clarif 						// Features of the interview process
			DK ES IT NL SE									// Country indicators
			DK_nuts* ES_nuts* IT_nuts* NL_nuts* SE_nuts*
			nrpart_h ppp
		; 

	order  	country country_s sampid2 			 			// Basic variables
			samptype vignette suppl wgtach 
			part nonresponse 								// Unit response 
			`main'											// Main variables
			gs_female gs_age	 							// Sampling frame info
			ans_mac f_delay delay 								// Fieldwork info
			iv_female iv_age iv_edu 						// Interviewer Characteristics
			female age education hsize children				// HR demographic variables
			couple single small_city partner_age		
			orient math fluency recall_d					// Cognitive functioning variables 
			proxy int_out int_clarif 						// Features of the interview process
			DK ES IT NL SE									// Country indicators
			DK_nuts* ES_nuts* IT_nuts* NL_nuts* SE_nuts*
			nrpart_h ppp
		; 
	#delimit cr
	compress
	sort sampid2 
	save sample_income, replace
	cap erase temp.dta
	cap erase temp2.dta
*------------------------------------------------------------------------------------------------
}
