qui {

*------------------------------------------------------------------------------------------------
* Select one household respondent(HR) in each household
*------------------------------------------------------------------------------------------------
* Load data
	use capi, clear

* hhs without HR
	bys sampid2: egen num_hr=total(dumhhr)
	bys sampid2: replace dumhhr=1 		if num_hr==0 & _n==1
	drop num_hr

* hhs with two HR
	bys sampid2: egen num_hr=total(dumhhr)
	replace dumhhr=0 			if num_hr==2 									///
								& (co002e==-9999998|co002e==-9999999|co002e==.) ///
								& (co003e==-9999998|co003e==-9999999|co003e==.) ///
								& (co004e==-9999998|co004e==-9999999|co004e==.) ///
								& (co005e==-9999998|co005e==-9999999|co005e==.)
	drop num_hr

	bys sampid2: egen num_hr=sum(dumhhr)
	sort sampid cvid
	bys sampid: replace dumhhr=0 				if _n==2 & num_hr==2
	drop num_hr
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Collapse data at the household level 
*------------------------------------------------------------------------------------------------
* Sex HR
	gen female=(gender==2) 
	lab var female "HR Female"

* Age HR  
	gen age_r=2004-yrbirth if yrbirth<2000
	lab var age_r "Respondent age"

* Age of partner
	gen couple=(mstat<3)
	bys sampid2: egen n=count(cvid)
	sum n
	local n = r(max) 
	gen part_age=.
	forvalues i=1(1)`n' {
		gen temp_age=age_r 								if cvid==`i' 
		gen temp_cvidp=cvidp							if cvid==`i' 
		bys sampid2: egen temp_age_h=max(temp_age)
		bys sampid2: egen temp_cvidp_h=max(temp_cvidp)
		bys sampid2: replace part_age=temp_age_h 		if cvid==temp_cvidp_h
		drop temp*
	}
	replace part_age=age_np 	if age_np!=.
	replace part_age=0 			if couple==0
	drop couple n 

* Select only observations of the HR
	keep if dumhhr==1
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* List of household income components and their flags
*------------------------------------------------------------------------------------------------
	#delimit;
	local income_fin "
		ybaccv_h ybondv_h ystocv_h ymutfv_h
		ybaccvi_h ybondvi_h ystocvi_h ymutfvi_h";
	#delimit cr
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Select list of relevant variables from capi data
*------------------------------------------------------------------------------------------------
	#delimit;
	keep  country sampid2 						 		// Country and sample identifiers		
		fahcv_1 fahcvi fohcv_1 fohcvi telcv_1 			// Consumption variables
		income_1 inc_mis inc_mis_n						// Income variables	
		income_tot_1 inc_tot_mis inc_tot_mis_n 
		inc_mis_par `income_fin' 
		age_r female mstat dn014 hsize 					// Bachground variables	
		part_age										// Age of partner
		isced_r iscedy_r 								// Education variables: isced cooding
		ch001_ ch006_* ch007_*							// Children
		ho002_ ho032_ ho037_ areabldg typebldg 			// Home
		numeracy orienti cf001_ cf002_					// Cognitive functioning	
		cf008tot cf016tot cf010_
		int_* ho001_									// Interview Conditions	
		co009_ as057_ ep210_ hh014_ ho041_
		finsep dumfamr dumfinr   
		iv002d* iv003_ iv004_ iv005d*		
		iv007_ iv008_ iv018_  iv009_ iv010_ iv011_
		iv012_ iv020_
		isced_iv iscedy_i								// Interviewer education
		samptype wgtach									// sampling info & weights
		nrpart_h ppp
	;
	order  country sampid2 						 		// Country and sample identifiers		
		fahcv_1 fahcvi fohcv_1 fohcvi telcv_1 			// Consumption variables
		income_1 inc_mis inc_mis_n						// Income variables	
		income_tot_1 inc_tot_mis inc_tot_mis_n 
		inc_mis_par `income_fin' 
		age_r female mstat dn014 hsize 					// Bachground variables	
		part_age										// Age of partner
		isced_r iscedy_r 								// Education variables: isced cooding
		ch001_ ch006_* ch007_*							// Children
		ho002_ ho032_ ho037_ areabldg typebldg 			// Home
		numeracy orienti cf001_ cf002_					// Cognitive functioning	
		cf008tot cf016tot cf010_
		int_* ho001_									// Interview Conditions	
		co009_ as057_ ep210_ hh014_ ho041_
		finsep dumfamr dumfinr   
		iv002d* iv003_ iv004_ iv005d*		
		iv007_ iv008_ iv018_  iv009_ iv010_ iv011_
		iv012_ iv020_
		isced_iv iscedy_i								// Interviewer education
		samptype wgtach									// sampling info & weights
		nrpart_h ppp
	;
	#delimit cr
	compress
	sort sampid 
	save capi, replace
*------------------------------------------------------------------------------------------------
}
