qui {

*------------------------------------------------------------------------------------------------
* Share, wave 2, release 2, coverscreen respondent
*------------------------------------------------------------------------------------------------
	use "${share_w1}\share1rel2-0-1_cv_r", clear
	noi di _n in ye "Module: cv_r" 
	drop if country==11|country==12|country==17|country>18
	gen nrpart=(status==2)
	bys sampid2: egen nrpart_h=total(nrpart)
	gen age=2004-yrbirth if nrpart==1
	bys sampid2: egen n=count(cvid)
	sum n
	local n = r(max) 
	gen age_np=.
	forvalues i=1(1)`n' {
		gen temp_age=age 		if cvid==`i' & nrpart==1 
		gen temp_cvidp=cvidp	if cvid==`i' & nrpart==1
		bys sampid2: egen temp_age_h=max(temp_age)
		bys sampid2: egen temp_cvidp_h=max(temp_cvidp)
		bys sampid2: replace age_np=temp_age_h if cvid==temp_cvidp_h
		drop temp*
	}
	drop n age nrpart_h
	lab var nrpart "Non responding partner"
	lab var age_np "Age of non responding partner"
	sort sampid2 cvid
	save capi, replace
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Add modules from SHARE, wave 2, release 2-0-1
*------------------------------------------------------------------------------------------------
	local list "iv ho hh ep co dn ch cf as"
	foreach jj of local list {
		noi di _n in ye "Module: `jj'" 
		use "${share_w1}\share1rel2-0-1_`jj'", clear
		drop if country==11|country==12|country==17|country>18
		sort sampid2 cvid
		merge sampid2 cvid using capi
		assert _merge==2|_merge==3
		drop _merge
		sort sampid2 cvid
		save capi, replace
	}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Keep respondents
	use capi, clear
	noi di _n in ye "Capi, only respondents" 
	keep if status==1
	sort sampid2 cvid
	save capi, replace
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Merge capi data with weights 
	use "${share_w1}\share1rel2-0-1_gv_weight_resp_only", clear
	noi di _n in ye "Merge with generated variables for weights" 
	drop if country==11|country==12|country==17|country>18
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Merge capi data with generated health variables 
	use "${share_w1}\share1rel2-0-1_gv_health", clear
	noi di _n in ye "Merge with generated variables for health" 
	drop if country==11|country==12|country==17|country>18
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Merge capi data with generated housing variables 
	use "${share_w1}\share1rel2-0-1_gv_housing", clear
	noi di _n in ye "Merge with generated variables for housing" 
	drop if country==11|country==12|country==17|country>18
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Merge capi data with generated variables for education 
	use "${share_w1}\share1rel2-0-1_gv_isced", clear
	noi di _n in ye "Merge with generated variables for education" 
	drop if country==11|country==12|country==17|country>18
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Merge capi data with generated variables for isco 
/*	use "${share_w1}\share1rel2-0-1_gv_isco", clear
	noi di _n in ye "Merge with generated variables for isco" 
	drop if country==11|country==12|country==17|country>18
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*/	
*------------------------------------------------------------------------------------------------



/*
*------------------------------------------------------------------------------------------------
* Merge capi data with generated variables for support 
	use "${share_w1}\share1rel2-0-1_gv_support", clear
	noi di _n in ye "Merge with generated variables for support" 
	drop if country==11|country==12|country==17|country>18
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*------------------------------------------------------------------------------------------------
*/



*------------------------------------------------------------------------------------------------
* Merge capi data with generated variables for imputed variables 
	use "imp_income", clear
	noi di _n in ye "Merge with imp_income" 
	sort sampid2 cvid
	merge sampid2 cvid using capi
	assert _merge==3
	drop _merge
	sort sampid2 cvid
	compress
	save capi, replace
*------------------------------------------------------------------------------------------------

}
