qui {


*------------------------------------------------------------------------------------------------
* Cleaning of dataset_1.dta -> unit.dta

	* Load gross sample data
		use "${share_w1}\gsd_w1", clear

	* Select countries 
		keep if country=="dk"|country=="es"|country=="it"|country=="nl"|country=="se"

	* Adjust iv info on education
		replace iv_yedu=0 		if iv_yedu==97
		replace iv_edu=0  		if iv_edu==97

	* Numeric country code
		rename country country_s
		gen country=18 			if country_s=="dk"
		replace country=16 		if country_s=="it"
		replace country=14 		if country_s=="nl"
		replace country=15 		if country_s=="es"
		replace country=13 		if country_s=="se"
		lab define cou 			///
			13 "sweden"			///
			14 "netherlands"	///
			15 "spain"			///
			16 "italy"			///
			18 "denmark"	
		lab val country cou

	* Save unit.dta
		compress
		sort sampid2
		save unit, replace
*------------------------------------------------------------------------------------------------


		
*------------------------------------------------------------------------------------------------
* Cleaning of final_contact.dta

	* Load data
		use "${share_w1}\contact_w1", clear

	* Select relevant sample 
		keep if country=="dk"|country=="es"|country=="it"|country=="nl"|country=="se"

	* Adjust date of contact attemp
		gen day=day(datetime)
		replace day=30 if sampid2=="1404253111900" & day==31 & month==4 & year==2004
		gen date_c= mdy(month, day, year)
		format date_c %dD_m_Y
		lab var day "Day of the contact attempt"
		lab var date_c "Date of the contact attempt"

	* Numeric country code
		rename country country_s
		gen country=18 			if country_s=="dk"
		replace country=16 		if country_s=="it"
		replace country=14 		if country_s=="nl"
		replace country=15 		if country_s=="es"
		replace country=13 		if country_s=="se"
		lab define cou 	 			 	///
					 13 "sweden"		///
					 14 "netherlands"	///
					 15 "spain"			///
					 16 "italy"			///
					 18 "denmark"	
		lab val country cou

	* Drop duplicated contact attempts for completed interview
 		gen complete=1 if code==101
		sort sampid cvid datetime 
		bysort sampid2 cvid: gen duplicate=sum(complete)
		bysort sampid2 cvid: egen duplicate2=sum(complete)
		drop if duplicate>1
		drop complete duplicate duplicate2 

	* Drop other duplicated contact attempts  
		gen contact=1
		sort sampid cvid datetime
		bysort sampid2 cvid datetime hour minute mode code: gen duplicate=sum(contact)
		bysort sampid2 cvid datetime hour minute mode code: egen duplicate2=sum(contact)
		drop if duplicate>1
		drop duplicate duplicate2

	* Save dataset
		compress
		sort sampid2
		save contact, replace
*------------------------------------------------------------------------------------------------
}
