qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables "a"
	local Country_list "ALL DK ES IT NL SE"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Variables2
*------------------------------------------------------------------------------------------------
foreach V of local Variables {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over Country_list2
*------------------------------------------------------------------------------------------------

foreach C of local Country_list {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="ALL" 	{
			local C_tit "All countries"
			local M1_order=3
			local M2_order=3
			local M3_order=3
		}
		if "`C'"=="DK" 	{
			local C_tit "Denmark"
			local M1_order=3
			local M2_order=3
			local M3_order=3
		}
		if "`C'"=="ES" 	{
			local C_tit "Spain"
			local M1_order=1
			local M2_order=3
			local M3_order=1
		}
		if "`C'"=="IT" 	{
			local C_tit "Italy"
			local M1_order=2
			local M2_order=3
			local M3_order=1
		}
		if "`C'"=="NL" 	{
			local C_tit "Netherland"
			local M1_order=2
			local M2_order=3
			local M3_order=1
		}
		if "`C'"=="SE" 	{
			local C_tit "Sweden"
			local M1_order=2
			local M2_order=3
			local M3_order=3
		}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye						///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}					if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		order sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		noi tab _merge
		drop _merge
		compress
		saveold "${TS_GRA}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Construct average derivatives and confidence bands over model list
*------------------------------------------------------------------------------------------------
noi di _n in gr "{hline 78}" _n in ye											///
"Average derivatives and confidence bands - Variable: `V' - Country: `C'"		///
_n in gr "{hline 78}"

local Models "M1 M2 S3 M3" 
local lower=8.6
local upper=12.2
local step=.2
local obs=1000

foreach M of local Models {

	* Title	 
		noi di _n "Model `M'"
		if "`M'"=="S3" & "`C'"!="ALL" continue

	* Read parameter estimates
		use "${TS_GRA}/temp_`V'_`C'", replace
		*if "`M'"!="S3" {
			local bestim "TS_BOOT\\`V'_`C'_`M'" 
			estread "${TS_EST}/`V'_`C'_`M'", estsave id(sampid2)
		*}
		*else {
		*	local bestim "TS_BOOT\\`V'_`C'_`M'" 
		*	estread "${TS_EST}/`V'_`C'_`M'", estsave id(sampid2)
		*}	
		estimates restore `M'

	* Read estimates
		if "`M'"=="M1" {
			local porder=`M1_order'		
			local name1 	"ln_hincome_1_a" 
			local bname1 	"w_food_`V'_b_`name1'"
			local name2 	"ln_hincome_1_a2" 
			local bname2 	"w_food_`V'_b_`name2'"
			local name3 	"ln_hincome_1_a3"
			local bname3 	"w_food_`V'_b_`name3'"
		}
		if "`M'"=="M2" {
			local porder=`M2_order'		
			local name1 	"ln_hincome_1_a" 
			local bname1 	"w_food_imp1_`V'_b_`name1'"
			local name2 	"ln_hincome_1_a2" 
			local bname2 	"w_food_imp1_`V'_b_`name2'"
			local name3 	"ln_hincome_1_a3"
			local bname3 	"w_food_imp1_`V'_b_`name3'"
		}
		if "`M'"=="S3" {
			local porder=`M3_order'		
			local name1 	"ln_hincome_1_a" 
			local bname1 	"w_food_`V'_b_`name1'"
			local name2 	"ln_hincome_2_a" 
			local bname2 	"w_food_`V'_b_`name2'"
			local name3 	"ln_hincome_3_a"
			local bname3 	"w_food_`V'_b_`name3'"
		}
		if "`M'"=="M3" {
			local porder=`M3_order'		
			local name1 	"ln_hincome_1_a" 
			local bname1 	"w_food_`V'_b_`name1'"
			local name2 	"END_2" 
			local bname2 	"w_food_`V'_b_`name2'"
			local name3 	"END_3"
			local bname3 	"w_food_`V'_b_`name3'"
		}

	* Draw prediction	 
		local a1=_b[`name1']
		if `porder'>=2 local a2=_b[`name2']
		if `porder'>=3 local a3=_b[`name3']
		clear
		set obs `obs'
		gen double `M'=.
		gen double x=.
		gen order=_n
		local n=1
		forvalues s=`lower'(`step')`upper'{ 
			replace x=`s'																		if order==`n'
			if `porder'==1 replace `M'=`a1'														if order==`n'
			if `porder'==2 replace `M'=`a1'+2*`a2'*(`s'-ln(30000))								if order==`n'
			if `porder'==3 replace `M'=`a1'+2*`a2'*(`s'-ln(30000))+3*`a3'*(`s'-ln(30000))^2		if order==`n'
			local n=`n'+1
		}
		keep if `M'!=.
		sort order
		save "${TS_GRA}/GRA_`V'_`C'_`M'.dta", replace

	* Construct lower and upper bounds	 
		use "`bestim'", clear
		count 
		local R = r(N)
		local n=1
		forvalues s=`lower'(`step')`upper'{ 	

			* Inizialize bootstrap estimates by s
				clear
				set obs 1
				gen r=0
				save "${TS_GRA}/temp_r.dta", replace
	
			* Bootstrap replicates by s
				forvalues r=1(1)`R'{ 
					use "`bestim'", clear
					local a1=`bname1'[`r']
					if `porder'>=2 local a2=`bname2'[`r']
					if `porder'>=3 local a3=`bname3'[`r']
					keep if _n==1
					gen r=`r'
					if `porder'==1 gen double y=`a1'	
					if `porder'==2 gen double y=`a1'+2*`a2'*(`s'-ln(30000))
					if `porder'==3 gen double y=`a1'+2*`a2'*(`s'-ln(30000))+3*`a3'*(`s'-ln(30000))^2		
					keep y r
					append using "${TS_GRA}\temp_r.dta"
					save "${TS_GRA}\temp_r.dta", replace
				}
				drop if r==0

			* Drop lower and upper bounds from bootstrap replicates by s
				_pctile y, p(2.5 97.5)
				keep if _n==1
				gen `M'_lower=r(r1)
				gen `M'_upper=r(r2)
				keep `M'_lower `M'_upper
				gen order=`n'						
				merge order using "${TS_GRA}/GRA_`V'_`C'_`M'.dta", sort
				drop _merge
				keep 	order x `M' `M'_lower `M'_upper
				order order x `M' `M'_lower `M'_upper
				sort order
				save "${TS_GRA}\GRA_`V'_`C'_`M'.dta", replace
				local n=`n'+1

				cap erase "${TS_GRA}\temp_r.dta"
		}			

	* Merge results by models
		if "`M'"=="M1" 	save "${TS_GRA}\GRA_`V'_`C'.dta", replace
		else {
			merge order using "${TS_GRA}\GRA_`V'_`C'.dta", sort
			drop _merge
			save "${TS_GRA}\GRA_`V'_`C'.dta", replace
		}
		cap erase "${TS_GRA}\GRA_`V'_`C'_`M'.dta"
}
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Draw average derivatives and confidence bands by country
*------------------------------------------------------------------------------------------------
	use "${TS_GRA}/GRA_`V'_`C'.dta", clear

if "`C'"=="ALL" {
/*	twoway 													///
	(rarea	M1_lower M1_upper x, col(gs11) psty(ci) )		///
	(rarea	M2_lower M2_upper x, col(gs9) psty(ci2))		///
	(scatter 	M1 M2 S3 x, 								///
			m(i i i)										///
			c(l l l)										///
			lc(gs1 gs2 gs3 )								/// 
			lw(medium medium medium)						/// 
			lp(-. shortdash longdash )						/// 
			legend(off) graphr(c(white)) 					///
			xtitle(ln income) 								///
			ytitle("Food share derivative")					///
			t1title("Parametric")							///
			xlab(8.5(1)12.5)		 						///
			ylab(-.5(.1).1)		 							///
			yscale(range(-.5 .1))							///
	)														///
	, saving("${TS_GRA}/DER_`V'_`C'_p.gph", replace) 		///
	name(DER_`V'_`C'_p, replace)

	twoway 													///
	(rarea	M1_lower M1_upper x, col(gs11) psty(ci) )		///
	(rarea	M2_lower M2_upper x, col(gs9) psty(ci2))		///
	(scatter 	M1 M2 M3 x, 								///
			m(i i i)										///
			c(l l l)										///
			lc(gs1 gs2 gs4)									/// 
			lw(medium medium medium)						/// 
			lp(-. shortdash solid)							/// 
			legend(off) graphr(c(white)) 					///
			xtitle(ln income) 								///
			ytitle("Food share derivative")					///
			t1title("Semiparametric")						///
			xlab(8.5(1)12.5)		 						///
			ylab(-.5(.1).1)		 							///
			yscale(range(-.5 .1))							///
	)														///
	, saving("${TS_GRA}/DER_`V'_`C'_s.gph", replace) 		///
	name(DER_`V'_`C'_s, replace)

	gr combine DER_`V'_`C'_p DER_`V'_`C'_s					///
		, xcomm ycomm graphr(c(white)) 						///
		saving("${TS_GRA}/DER_`V'_`C'.gph", replace)

	gr export "${TS_GRA}/DER_`V'_`C'.eps", replace
	gr export "${TS_GRA}/DER_`V'_`C'.wmf", replace
*/
	twoway 													///
	(rarea	S3_lower S3_upper x , col(gs13) psty(ci) )		///
	(rarea	M1_lower M1_upper x, col(gs11) psty(ci) )		///
	(rarea	M2_lower M2_upper x, col(gs9) psty(ci2))		///
	(scatter 	M1 M2 S3 x, 								///
			m(i i i)										///
			c(l l l)										///
			lc(gs1 gs2 gs3)									/// 
			lw(medium medium medium)						/// 
			lp(-. shortdash longdash )						/// 
			legend(off) graphr(c(white)) 					///
			xtitle(ln income) 								///
			ytitle("Food share derivative")					///
			t1title("Parametric")							///
			xlab(8.5(1)12.5)		 						///
			ylab(-.5(.1).1)		 							///
			yscale(range(-.5 .1))							///
	)														///
	, saving("${TS_GRA}/DER_`V'_`C'_p_cb.gph", replace) 	///
	name(DER_`V'_`C'_p_cb, replace)

	twoway 													///
	(rarea	M3_lower M3_upper x , col(gs14) psty(ci) )		///
	(rarea	M1_lower M1_upper x, col(gs11) psty(ci) )		///
	(rarea	M2_lower M2_upper x, col(gs9) psty(ci2))		///
	(scatter 	M1 M2 M3 x, 								///
			m(i i i)										///
			c(l l l)										///
			lc(gs1 gs2 gs4)									/// 
			lw(medium medium medium)						/// 
			lp(-. shortdash solid)							/// 
			legend(off) graphr(c(white)) 					///
			xtitle(ln income) 								///
			ytitle("Food share derivative")					///
			t1title("Semiparametric")						///
			xlab(8.5(1)12.5)		 						///
			ylab(-.5(.1).1)		 							///
			yscale(range(-.5 .1))							///
	)														///
	, saving("${TS_GRA}/DER_`V'_`C'_s_cb.gph", replace) 	///
	name(DER_`V'_`C'_s_cb, replace)

	gr combine DER_`V'_`C'_p_cb DER_`V'_`C'_s_cb			///
		, xcomm ycomm graphr(c(white)) 						///
		saving("${TS_GRA}/DER_`V'_`C'_cb.gph", replace)

	gr export "${TS_GRA}/DER_`V'_`C'_cb.eps", replace
	gr export "${TS_GRA}/DER_`V'_`C'_cb.wmf", replace

}
twoway 														///
	(scatter 	M1 M2 M3 x, 								///
			m(i i i)										///
			c(l l l)										///
			lc(gs1 gs2 gs4)									/// 
			lw(medium medium medium)						/// 
			lp(-. shortdash solid)							/// 
			legend(off) graphr(c(white)) 					///
			xtitle(ln income) 								///
			ytitle("Food share derivative")					///
			xlab(8.5(1)12.5)		 						///
			t1(`C_tit')										///
	)														///
	, saving("${TS_GRA}/DER_`V'_`C'_nob.gph", replace)		///
	name(DER_`V'_`C'_nob, replace)
	cap erase "${TS_GRA}/temp_`V'_`C'.dta"
}
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Combine country specific graph by variable
*------------------------------------------------------------------------------------------------
gr combine 	DER_`V'_ALL_nob DER_`V'_DK_nob DER_`V'_ES_nob	///
		DER_`V'_IT_nob  DER_`V'_NL_nob DER_`V'_SE_nob		///
		, ycomm xcomm graphr(c(white)) 						///
		saving("${TS_GRA}/DER_`V'.gph", replace)		 	///
		name(DER_`V', replace)
gr export "${TS_GRA}/DER_`V'.eps", replace
gr export "${TS_GRA}/DER_`V'.wmf", replace
}
*------------------------------------------------------------------------------------------------


} // close quitely

