qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables1 "a"
	local Country_list1 "ALL"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
* Do estimates
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Variables1
*------------------------------------------------------------------------------------------------
foreach V of local Variables1 {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Country_list1
*------------------------------------------------------------------------------------------------

foreach C of local Country_list1 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		local C_tit "All countries"

	* Variable and country specific log file
		cap log close
		log using "${TS_USM}/`V'_`C'", replace text
		estimates clear
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye						///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}					if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  
		order sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'_44", sort
		noi tab _merge
		drop _merge
		rename sam2_`V'_ALL sam2_`V'_ALL_44
		rename sam3_`V'_ALL sam3_`V'_ALL_44
		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		noi tab _merge
		drop _merge
		compress
		saveold "${TS_USM}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Initialize file of estimates and load variable and country specific dataset
	use "${TS_USM}/temp_`V'_`C'", replace
	keep sampid2
	sort sampid2
	saveold "${TS_USM}/`V'_`C'", replace
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Define starting values and degree of the SNP estimator
	if "`C'"=="ALL" {

/*		* K1=K2=3
		estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
		estimates restore SNP_3_2
		matrix b_32=e(b)
		local k0=e(k)-6
		local k1=e(k)-5
		local k2=e(k)-4
		local k3=e(k)-3
		local k4=e(k)-2
		local k5=e(k)-1
		matrix b0=b_32[1,1..`k0']
		matrix g1=(b_32[1,`k1'..`k2'],0)
		matrix g2=(b_32[1,`k3'..`k4'],0)
		matrix g3=(b_32[1,`k5'..e(k)],0)
		matrix b_start_33=(b0,g1,g2,g3)
		matrix drop b0 g1 g2 g3
		local from "from(b_start_33, copy)"
		local K1=3
		local K2=3
*/
		* First-step: K=(4,4)
		estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
		estimates restore SNP_3_3
		matrix b_33=e(b)
		local k0=e(k)-9
		local k1=e(k)-8
		local k2=e(k)-6
		local k3=e(k)-5
		local k4=e(k)-3         
		local k5=e(k)-2         
		matrix b0=b_33[1,1..`k0']
		matrix g1=(b_33[1,`k1'..`k2'],0)
		matrix g2=(b_33[1,`k3'..`k4'],0)
		matrix g3=(b_33[1,`k5'..e(k)],0)
		matrix b_start_44=(b0,g1,g2,g3,0,0,0,0)
		local from "from(b_start_44, copy)"
		matrix drop b0 g1 g2 g3
		local K1=4
		local K2=4
	}
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* M1: Undersmoothing
*------------------------------------------------------------------------------------------------
	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"M1: Undersmoothing"							///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_USM}/temp_`V'_`C'", replace

	* Second step - food budget share 
		noi plinear `Y' ${denom} ${Y_X}, 				///
			nonlinear(${denom}) order(4) trim(1)		///
			save("TS_BOOT_USM\\`V'_`C'_M1_USM")			///
			reps(1000) seed($seed) 	 
		noi di e(N)

		estimates store M1_USM
		estwrite M1_USM using "${TS_USM}/`V'_`C'", estsave append id(sampid2)
		noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* M2: Undersmoothing
*------------------------------------------------------------------------------------------------
	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M2: Undersmoothing"				///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_USM}/temp_`V'_`C'", replace
		drop ln_hincome_1_`V' ln_hincome_2_`V' ln_hincome_3_`V' ln_hincome_4_`V' ln_hincome_5_`V'
		rename ln_hincome_imp1_1_$V ln_hincome_1_`V'
		rename ln_hincome_imp1_2_$V ln_hincome_2_`V'
		rename ln_hincome_imp1_3_$V ln_hincome_3_`V'
		rename ln_hincome_imp1_4_$V ln_hincome_4_`V'
		rename ln_hincome_imp1_5_$V ln_hincome_5_`V'

	* Second step - food budget share 
		noi plinear `Y_imp' ${denom} ${Y_X} [pw=${wgt}], 		///
			nonlinear(${denom}) order(4) trim(1)			///
			save("TS_BOOT_USM\\`V'_`C'_M2_USM")				///
			reps(1000) seed($seed) 	 
		noi di e(N)

		estimates store M2_USM
		estwrite M2_USM using "${TS_USM}/`V'_`C'", estsave append id(sampid2)

		noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* S3: Undersmoothing
* No bootstrap
*------------------------------------------------------------------------------------------------
	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"S3: Undersmoothing"						///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_USM}/temp_`V'_`C'", replace
		local inc "ln_hincome_1_`V' ln_hincome_2_`V' ln_hincome_3_`V' ln_hincome_4_`V'"

	* Estimates 
		noi heck2s_0 `Y' `inc' ${Y_X}, 				///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})	///
			endog(${denom}=${E_X})  				///
			first second 							///
			sample2(sam2_`V'_`C') 					///
			sample3(sam3_`V'_`C') 				

			*save("TS_BOOT_USM\\`V'_`C'_S3_USM")	///
			*reps(1000) seed($seed)	iter($iter)	

		estimates store S3_USM
		estwrite S3_USM using "${TS_USM}/`V'_`C'", estsave append id(sampid2)
		noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* M3: Undersmoothing
* No bootstrap
*------------------------------------------------------------------------------------------------
	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"M3: Undersmoothing"						///
		_n in gr "{hline 78}"

	* Linear in [h1, h2] 
		local s2list1 "2_0 1_1 0_2"
		local s3list1 "2_0_0 0_2_0 0_0_2 1_1_0 1_0_1 0_1_1 3_0_0 0_3_0 0_0_3 2_1_0 2_0_1 1_2_0 1_1_1 0_2_1 0_1_2"

		local s3list2 "2 3 4"

	* Load data
		use "${TS_USM}/temp_`V'_`C'", replace

	* Second step - Total household income
		noi pl2se_0 `Y' ${Y_X} ${denom},					///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})			///
			endog(${denom}=${E_X})  						///
			first s1order1(`K1') s1order2(`K2') `from' 		///
			second s2list1(`s2list1') sample2(sam2_`V'_`C') ///
			s3list1(`s3list1') s3list2(`s3list2')			///
			sample3(sam3_`V'_`C')					

			*save("TS_BOOT_USM\\`V'_`C'_USM")			///
			*reps($replicates) seed($seed) iter($iter)	

		estimates store M3_USM
		estwrite M3_USM using "${TS_USM}/`V'_`C'", estsave append id(sampid2)
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------
		cap log close
		cap erase "${TS_USM}/temp_`V'_`C'.dta"
	}						// Close Loop over Specifications
}							// Close Loop over Variables

*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
}




