qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	*local Variables1 		"a b"
	local Variables1 		" "
	local Country_list1 	"ALL"
	local Model_list1 		"M1 M2 S3 M3"

	local Variables2 		"a"
	local Country_list2 	"ALL"
	local Model_list2 		"M1 M2 S3 M3"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
* Do estimates
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Variables1
*------------------------------------------------------------------------------------------------
foreach V of local Variables1 {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Country_list1
*------------------------------------------------------------------------------------------------

foreach C of local Country_list1 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country specific elements
	// This can be simplied
	if "`V'"=="a" 	{
		if "`C'"=="ALL" 	{
			local C_tit "All countries"

			local order_MCAR=3
			local order1_MCAR=3
			local order2_MCAR=3

			local order_MAR=3
			local order1_MAR=2
			local order2_MAR=3

			local K1=3
			local K2=3
			local s2list1 " "
			local s3list1 "2_0_0 0_2_0 0_0_2 1_1_0 1_0_1 0_1_1 0_0_3 2_1_0 1_1_1"
			local s3list2 "2 3"
		}
	}
	if "`V'"=="b" 	{
		if "`C'"=="ALL" 	{
			local C_tit "All countries"

			local order_MCAR=3
			local order1_MCAR=3
			local order2_MCAR=3

			local order_MAR=3
			local order1_MAR=2
			local order2_MAR=3

			local K1=3
			local K2=3
			local s2list1 " "
			local s3list1 "2_0_0 0_1_1 0_0_2"
			local s3list2 "2"
		}
	}

*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye					///
			"Dropping other missing data on predictors "		///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}					if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  
		order sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		if "`C'"=="ALL" {
			merge sampid using "${PL_DEGREE}/trimm_`V'_`C'_44", sort
			noi tab _merge
			drop _merge
			rename sam2_`V'_ALL sam2_`V'_ALL_44
			rename sam3_`V'_ALL sam3_`V'_ALL_44
		}
		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		drop _merge
		compress
		saveold "${TS_EST}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop by models
*------------------------------------------------------------------------------------------------
foreach m of local Model_list1 {

	* Variable, country and model specific log file
		cap log close
		log using "${TS_EST}/`V'_`C'_`m'", replace text
		estimates clear
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Define starting values of the SNP estimator
*------------------------------------------------------------------------------------------------
if "`m'"=="M3"	{
	estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
	estimates restore SNP_3_2
	matrix b_32=e(b)
	local k0=e(k)-6
	local k1=e(k)-5
	local k2=e(k)-4
	local k3=e(k)-3
	local k4=e(k)-2
	local k5=e(k)-1
	matrix b0=b_32[1,1..`k0']
	matrix g1=(b_32[1,`k1'..`k2'],0)
	matrix g2=(b_32[1,`k3'..`k4'],0)
	matrix g3=(b_32[1,`k5'..e(k)],0)
	matrix b_start_33=(b0,g1,g2,g3)
	matrix drop b0 g1 g2 g3
	local from "from(b_start_33, copy)"
}

*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* M1: Model 1 
*------------------------------------------------------------------------------------------------
if "`m'"=="M1" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"M1: Model 1"								///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace

	* Second step - food budget share 
		noi plinear `Y' ${denom} ${Y_X}, 					///
			nonlinear(${denom}) order(`order_MCAR') trim(1)	///
			save("TS_BOOT\\`V'_`C'_`m'")					///
			reps(1000) seed($seed) 	 
		noi di e(N)

		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* M2: Model 2 
*------------------------------------------------------------------------------------------------
if "`m'"=="M2" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M2: Model 2"							///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace
		drop ln_hincome_1_`V' ln_hincome_2_`V' ln_hincome_3_`V' ln_hincome_4_`V' ln_hincome_5_`V'
		rename ln_hincome_imp1_1_$V ln_hincome_1_`V'
		rename ln_hincome_imp1_2_$V ln_hincome_2_`V'
		rename ln_hincome_imp1_3_$V ln_hincome_3_`V'
		rename ln_hincome_imp1_4_$V ln_hincome_4_`V'
		rename ln_hincome_imp1_5_$V ln_hincome_5_`V'

	* Second step - food budget share 
		noi plinear `Y_imp' ${denom} ${Y_X} [pw=${wgt}], 		///
			nonlinear(${denom}) order(`order_MAR') trim(1)		///
			save("TS_BOOT\\`V'_`C'_`m'")						///
			reps(1000) seed($seed) 	 
		noi di e(N)

		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)

		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* S3: Model 3
*------------------------------------------------------------------------------------------------
if "`m'"=="S3" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"S3: Model 3"								///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace
		local inc "ln_hincome_1_`V' ln_hincome_2_`V' ln_hincome_3_`V'"

	* Estimates 
		noi heck2s `Y' `inc' ${Y_X}, 				///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})	///
			endog(${denom}=${E_X})  				///
			first second 							///
			sample2(sam2_`V'_`C') 					///
			sample3(sam3_`V'_`C') 					///
			save("TS_BOOT\\`V'_`C'_`m'")			///
			reps($replicates) seed($seed)	iter($iter)	
		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* M3: Model 4 
*------------------------------------------------------------------------------------------------
if "`m'"=="M3" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M3: Model 4"							///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace

	* Third step 
		noi pl2se `Y' ${Y_X} ${denom},						///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})			///
			endog(${denom}=${E_X})  						///
			first s1order1(`K1') s1order2(`K2') `from' 		///
			second s2list1(`s2list1') sample2(sam2_`V'_`C') ///
			s3list1(`s3list1') s3list2(`s3list2')			///
			sample3(sam3_`V'_`C')							///				
			save("TS_BOOT\\`V'_`C'_`m'")					///
			reps(1000) seed($seed) iter($iter)	

		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"

}
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Close loops
*------------------------------------------------------------------------------------------------
			cap log close
		}					// Close Loop over Models
		cap erase "${TS_EST_COU}/temp_`V'_`C'.dta"
	}						// Close Loop over Country
}							// Close Loop over Variables
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------


















*------------------------------------------------------------------------------------------------
* Loop over Variables2
*------------------------------------------------------------------------------------------------
foreach V of local Variables2 {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over Country_list2
*------------------------------------------------------------------------------------------------
foreach C of local Country_list2 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Variable and country specific log file
		cap log close
		log using "${TS_EST}/Table_`V'_`C'", replace text
		estimates clear
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		dropping `U' 	${U_X}
		dropping `I_Y' 	${I_Y_X}					if `U'==1
		dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
		dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
		dropping `E' 	${E_X}						if `U'==1 & `I_E'==1 
		dropping `Y' 	${Y_X}						if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators

		keep sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  
		order sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		drop _merge
		compress
		saveold "${TS_EST}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Read estimates
*------------------------------------------------------------------------------------------------
foreach m of local Model_list2 {	
	estread "${TS_EST}/`V'_`C'_`m'", estsave id(sampid2)
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Display Second step estimates
*------------------------------------------------------------------------------------------------
	set linesize 255
	noi estout M1 M2 S3 M3 							///
		, sty(tex) stardetach 						///
		cells(b(star fmt(%9.3f))) 					///
		starlevels(* 0.05 ** 0.01)					///
		equations(1)								///
		nolz modelwidth(7) varwidth(13)				///
		varlabels(									///
			${denom} "ln income"					///
			ln_hincome_2_a "(ln income)$^2$"		///
			ln_hincome_3_a "(ln income)$^3$"		///
			ln_hincome_1_a2 "(ln income)$^2$"		///
			ln_hincome_1_a3 "(ln income)$^3$"		///
			END_2 "(ln income)$^2$"					///
			END_3 "(ln income)$^3$"					///
			gs_female "female SHM"					///
			gs_age "age SHM"						///
			gs_age2 "age$^2$ SHM"					///
			ans_mac "ans. machine"					///
			delay2 "delay$^2$"						///
			age2 "age$^2$"							///
			iv_female "female IV"					///
			iv_age "age IV"							///
			iv_age2 "age$^2$ IV"					///
			iv_edu "educ IV"						///
			partner_age "age spouse"				///
			partner_age2 "age$^2$ spouse"			///
			small_city "small city"					///
			recall_d "recall"						///
			proxy_co "proxy con."					///
			proxy_inc "proxy inc."					///
			int_length "length"						///
			int_clarif "clarif"						///
			int_out   "outside"						///
			nuts1	 "nuts 1"						///
			nuts2	 "nuts 2"						///
			nuts3	 "nuts 3"						///
			nuts4	 "nuts 4"						///
			nuts5	 "nuts 5"						///
			nuts6	 "nuts 6"						///
			nuts7	 "nuts 7"						///
			nuts8	 "nuts 8"						///
			nuts9	 "nuts 9"						///
			nuts10 "nuts 10"						///
			nuts11 "nuts 11"						///
			nuts12 "nuts 12"						///
			nuts13 "nuts 13"						///
			nuts14 "nuts 14"						///
			nuts15 "nuts 15"						///
			str_1	 "stratum 1"					///
			str_2	 "stratum 2"					///
			str_3	 "stratum 3"					///
			str_4	 "stratum 4"					///
			str_5	 "stratum 5"					///
			str_6	 "stratum 6"					///
			str_7	 "stratum 7"					///
			str_8	 "stratum 8"					///
			str_9	 "stratum 9"					///
			str_10 "stratum 10"						///
			str_11 "stratum 11"						///
			str_12 "stratum 12"						///
			str_13 "stratum 13"						///
			str_14 "stratum 14"						///
			str_15 "stratum 15"						///
			ES_nuts1 "ES nuts\$_1$"					///
			ES_nuts2 "ES nuts\$_2$"					///
			ES_nuts3 "ES nuts\$_3$"					///
			ES_nuts4 "ES nuts\$_4$"					///
			ES_nuts5 "ES nuts\$_5$"					///
			ES_nuts6 "ES nuts\$_6$"					///
			ES_nuts7 "ES nuts\$_7$"					///
			IT_nuts1 "IT nuts\$_1$"					///
			IT_nuts2 "IT nuts\$_2$"					///
			IT_nuts3 "IT nuts\$_3$"					///
			IT_nuts4 "IT nuts\$_4$"					///
			IT_nuts5 "IT nuts\$_5$"					///
			NL_nuts1 "NL nuts\$_1$"					///
			NL_nuts2 "NL nuts\$_2$"					///
			NL_nuts3 "NL nuts\$_3$"					///
			NL_nuts4 "NL nuts\$_4$"					///
			lambda1  	"\$h_1$"					///
			lambda2  	"\$h_2$"					///
			l1_2     	"\$h_1^2$"					///
			l1_3     	"\$h_1^3$"					///
			l2_2     	"\$h_2^2$"					///
			l2_3     	"\$h_2^3$"					///
			l1_1_l2_1   "\$h_1 * h_2$"				///
			l1_2_l2_1   "\$h_1^2 * h_2$"			///
			l1_1_l2_2   "\$h_1 * h_2^2$"			///
			Lambda1	"\$l_1$"						///
			Lambda2	"\$l_2$"						///
			resid		"\$u_3$"					///
			L1_2 		"\$l_1^2$"					///
			L2_2 		"\$l_2^2$"					///
			Re_2 		"\$u_3^2$"					///
			L1_1_L2_1 	"\$l_1 * l_2$"				///
			L1_1_Re_1 	"\$l_1 * u_3$"				///
			L2_1_Re_1 	"\$l_2 * u_3$"				///
			L1_3 		"\$l_1^3$"					///
			L2_3 		"\$l_2^3$"					///
			Re_3 		"\$u_3^3$"					///
			L1_2_L2_1 	"\$l_1^2 * l_2$"			///
			L1_2_Re_1 	"\$l_1^2 * u_3$"			///
			L1_1_L2_2 	"\$l_1 * l_2^2$"			///
			L1_1_Re_2 	"\$l_1 * u_3^2$"			///
			L1_1_L2_1_Re_1 	"\$l_1 *l_2 * u_3$"		///
			L2_2_Re_1 	"\$l_2^2 * u_3$"			///
			L2_1_Re_2 	"\$l_2 * u_3^2$"			///
			_cons		"constant"					///
		)											///
		title(Third Step Estimates)
*------------------------------------------------------------------------------------------------


		cap log close
		cap erase "${TS_EST}/temp_`V'_`C'.dta"
	}						// Close Loop over Specifications
}							// Close Loop over Variables
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------



}




