qui {
*------------------------------------------------------------------------------------------------
* Legend: M1 - Model 1, M2 - Model 2, S3 - Model 3, M3 - Model 4
*------------------------------------------------------------------------------------------------
 

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables1 		" "
	local Country_list1 	"ALL"
	local Model_list1   	"M1 M2 S3 M3"

	local Variables2 	  	"a"
	local Country_list2 	"ALL"
	local Model_list2  	"M1 M2 S3 M3"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
* Do estimates
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Variables1
*------------------------------------------------------------------------------------------------
foreach V of local Variables1 {

	* Dependent variables
		local U	="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y	="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Country_list1
*------------------------------------------------------------------------------------------------

foreach C of local Country_list1 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="DK" 		local C_tit "Denmark"
		if "`C'"=="ES" 		local C_tit "Spain"
		if "`C'"=="IT" 		local C_tit "Italy"
		if "`C'"=="NL" 		local C_tit "Netherland"
		if "`C'"=="SE" 		local C_tit "Sweden"
		if "`C'"=="ALL" 	local C_tit "All countries"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye					///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}					if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep  sampid2 country					///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 				///
			${Y_X} ${Y_imp_X} 				///
			${denom} ${denom_imp}				///
			${wgt} 		 
		order sampid2 country					///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 				///
			${Y_X} ${Y_imp_X} 				///
			${denom} ${denom_imp}				///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		noi tab _merge
		drop _merge
		compress
		saveold "${SS_EST}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop by models
*------------------------------------------------------------------------------------------------
foreach m of local Model_list1 {

	* Variable, country and model specific log file
		cap log close
		log using "${SS_EST}/`V'_`C'_`m'", replace text
		estimates clear
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Load starting values SNP estimator
	if "`m'"=="M3"	{
		if "`C'"=="ALL"|"`C'"=="IT"|"`C'"=="ES"|"`C'"=="SE" {
			estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
			estimates restore SNP_3_2
			matrix b_32=e(b)
			local k0=e(k)-6
			local k1=e(k)-5
			local k2=e(k)-4
			local k3=e(k)-3
			local k4=e(k)-2
			local k5=e(k)-1
			matrix b0=b_32[1,1..`k0']
			matrix g1=(b_32[1,`k1'..`k2'],0)
			matrix g2=(b_32[1,`k3'..`k4'],0)
			matrix g3=(b_32[1,`k5'..e(k)],0)
			matrix b_start_33=(b0,g1,g2,g3)
			matrix drop b0 g1 g2 g3
			local from "from(b_start_33, copy)"
			local K1=3
			local K2=3
		}
		if "`C'"=="DK"|"`C'"=="NL" {
			local from "startprobit"
			local K1=3
			local K2=2
		}
	}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Model 1
*------------------------------------------------------------------------------------------------
if "`m'"=="M1" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye			///
		"M1: Model 1"							///
		_n in gr "{hline 78}"

	* Load data
		use "${SS_EST}/temp_`V'_`C'", replace

	* First step - Total household income
		noi reg ${denom} ${E_X}		if `I_Y'==1
		estimates store `m'
		estwrite `m' using "${SS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Model 2
*------------------------------------------------------------------------------------------------
if "`m'"=="M2" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M2: Model 2"					///
		_n in gr "{hline 78}"

	* Load data
		use "${SS_EST}/temp_`V'_`C'", replace
		drop ln_hincome_1_`V'
		rename ln_hincome_imp1_1_$V ln_hincome_1_`V'

	* First step - Total household income
		noi reg ${denom} ${E_X} [pw=${wgt}] if `U'==1

		estimates store `m'
		estwrite `m' using "${SS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Model 3
*------------------------------------------------------------------------------------------------
if "`m'"=="S3" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"S3: Model 3"					///
		_n in gr "{hline 78}"

	* Load data
		use "${SS_EST}/temp_`V'_`C'", replace

	* Second step 
		noi heck2s ${denom} ${E_X}, 						///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})			///
			first sample2(sam2_`V'_`C') 					///
			reps($replicates) seed($seed) iter($iter)
		noi di e(N)	
		estimates store `m'
		estwrite `m' using "${SS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Model 4
*------------------------------------------------------------------------------------------------
if "`m'"=="M3" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M3: Model 4"					///
		_n in gr "{hline 78}"

	* Load data
		use "${SS_EST}/temp_`V'_`C'", replace

	* Linear in [h1, h2] 
		local s2list1 " "

	* Second step - Total household income
		noi pl2se ${denom} ${E_X}, 					///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})		///
			first s1order1(`K1') s1order2(`K2') `from' 	///
			s2list1(`s2list1') sample2(sam2_`V'_`C') 		///
			reps($replicates) seed($seed) iter($iter)	
		estimates store `m'
		estwrite `m' using "${SS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Close loops
*------------------------------------------------------------------------------------------------
		cap log close
		}					// Close Loop over Models
		cap erase "${SS_EST}/temp_`V'_`C'.dta"
	}						// Close Loop over Country
}							// Close Loop over Variables
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------










 
*------------------------------------------------------------------------------------------------
* Loop over Variables2
*------------------------------------------------------------------------------------------------
foreach V of local Variables2 {

	* Dependent variables
		local U	="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y	="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over Country_list2
*------------------------------------------------------------------------------------------------

foreach C of local Country_list2 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="DK" 		local C_tit "Denmark"
		if "`C'"=="ES" 		local C_tit "Spain"
		if "`C'"=="IT" 		local C_tit "Italy"
		if "`C'"=="NL" 		local C_tit "Netherland"
		if "`C'"=="SE" 		local C_tit "Sweden"
		if "`C'"=="ALL" 	local C_tit "All countries"

	* Variable and country specific log file
		cap log close
		log using "${SS_EST}/Table_`V'_`C'", replace text
		estimates clear
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		dropping `U' 		${U_X}
		dropping `I_Y' 	${I_Y_X}					if `U'==1
		dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
		dropping `Y_imp' 	${Y_imp_X} 	${wgt}			if `U'==1 
		dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
		dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		keep sampid2 country						///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} 					///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 						///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' 	///
			ln_hincome_imp1_5_`V' 					///
			${wgt}  
		order sampid2 country						///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} 					///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 						///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' 	///
			ln_hincome_imp1_5_`V' 					///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		drop _merge
		compress
		saveold "${SS_EST}/temp_`V'_`C'", replace
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Display Second step estimates
*------------------------------------------------------------------------------------------------
	noi di _n in gr "{hline 75}" _n in ye	///
		"Second step estimates"			///
		_n in gr "{hline 75}"

	foreach mm of local Model_list2 {
		estread "${SS_EST}/`V'_`C'_`mm'", estsave id(sampid2)
	}
	set linesize 255
	noi estout M1 M2 S3 M3 							///
		, sty(tex) stardetach 						///
		cells(b(star fmt(%9.3f))) 					///
		starlevels(* 0.05 ** 0.01)					///
		nolz modelwidth(7) varwidth(13)				///
		equations(1)							///
		varlabels(								///
			gs_female "g.s. female"					///
			gs_age "g.s. age"						///
			gs_age2 "g.s. age$^2$"					///
			ans_mac "ans. mac."					///
			delay2 "delay$^2$"					///
			age2 "age$^2$"						///
			iv_female "iv. female"					///
			iv_age "iv. age"						///
			iv_age2 "iv. age$^2$"					///
			iv_edu "iv. edu."						///
			partner_age "part. age"					///
			partner_age2 "part. age$^2$"				///
			small_city "small city"					///
			recall_d "recall"						///
			proxy_co "proxy con."					///
			proxy_inc "proxy inc."					///
			int_length "int. length"				///
			int_clarif "int. clarif"				///
			int_out   "int. out"					///
			_cons	"constant"						///
			nuts1	 "nuts 1"						///
			nuts2	 "nuts 2"						///
			nuts3	 "nuts 3"						///
			nuts4	 "nuts 4"						///
			nuts5	 "nuts 5"						///
			nuts6	 "nuts 6"						///
			nuts7	 "nuts 7"						///
			nuts8	 "nuts 8"						///
			nuts9	 "nuts 9"						///
			nuts10 "nuts 10"						///
			nuts11 "nuts 11"						///
			nuts12 "nuts 12"						///
			nuts13 "nuts 13"						///
			nuts14 "nuts 14"						///
			nuts15 "nuts 15"						///
			str_1	 "stratum 1"					///
			str_2	 "stratum 2"					///
			str_3	 "stratum 3"					///
			str_4	 "stratum 4"					///
			str_5	 "stratum 5"					///
			str_6	 "stratum 6"					///
			str_7	 "stratum 7"					///
			str_8	 "stratum 8"					///
			str_9	 "stratum 9"					///
			str_10 "stratum 10"					///
			str_11 "stratum 11"					///
			str_12 "stratum 12"					///
			str_13 "stratum 13"					///
			str_14 "stratum 14"					///
			str_15 "stratum 15"					///
			ES_nuts1 "ES nuts\$_1$"					///
			ES_nuts2 "ES nuts\$_2$"					///
			ES_nuts3 "ES nuts\$_3$"					///
			ES_nuts4 "ES nuts\$_4$"					///
			ES_nuts5 "ES nuts\$_5$"					///
			ES_nuts6 "ES nuts\$_6$"					///
			ES_nuts7 "ES nuts\$_7$"					///
			IT_nuts1 "IT nuts\$_1$"					///
			IT_nuts2 "IT nuts\$_2$"					///
			IT_nuts3 "IT nuts\$_3$"					///
			IT_nuts4 "IT nuts\$_4$"					///
			IT_nuts5 "IT nuts\$_5$"					///
			NL_nuts1 "NL nuts\$_1$"					///
			NL_nuts2 "NL nuts\$_2$"					///
			NL_nuts3 "NL nuts\$_3$"					///
			NL_nuts4 "NL nuts\$_4$"					///
			lambda1  	"\$h_1$"					///
			lambda2  	"\$h_2$"					///
			l1_2     	"\$h_1^2$"					///
			l2_2     	"\$h_2^2$"					///
			l1_1_l2_1   "\$h_1 * h_2$"				///
			l1_3     	"\$h_1^3$"					///
			l2_3     	"\$h_2^3$"					///
			l1_2_l2_1   "\$h_1^2 * h_2$"				///
			l1_1_l2_2   "\$h_1 * h_2^2$"				///
			_cons		"constant"					///
		)									///
		title(Second Step Estimaets - Variable. `V' - Country: `V')
*------------------------------------------------------------------------------------------------

		cap log close
		cap erase "${SS_EST}/temp_`V'_`C'.dta"
	}						// Close Loop over Specifications
}							// Close Loop over Variables

*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------

}




