qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables "a b"
	local Country_list "ALL DK ES IT NL SE"
	local trim= 1
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over variables
foreach V of local Variables {

	* Dependent variables
		local U	="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y	="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over country_list1
foreach C of local Country_list {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="DK" 		local C_tit "Denmark"
		if "`C'"=="ES" 		local C_tit "Spain"
		if "`C'"=="IT" 		local C_tit "Italy"
		if "`C'"=="NL" 		local C_tit "Netherland"
		if "`C'"=="SE" 		local C_tit "Sweden"
		if "`C'"=="ALL" 	local C_tit "All countries"

	* Variable and country specific log file
		cap log close
		log using "${PL_DEGREE}/`V'_`C'_baseline", replace text
		estimates clear
*------------------------------------------------------------------------------------------------






*------------------------------------------------------------------------------------------------
* Generate country specific dataset

	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye						///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}							if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}					if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${denom_imp} ${wgt}	if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}							if `U'==1 & `I_Y'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}							if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep  sampid2 country					///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  	///
			${U_X} ${I_Y_X} ${E_X} 				///
			${Y_X} ${Y_imp_X} 					///
			${denom} ${denom_imp}				///
			${wgt} 		 
		order sampid2 country					///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  	///
			${U_X} ${I_Y_X} ${E_X} 				///
			${Y_X} ${Y_imp_X} 					///
			${denom} ${denom_imp}				///
			${wgt} 		 
		compress
		saveold "${PL_DEGREE}/temp_`V'_`C'_baseline", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------





*------------------------------------------------------------------------------------------------
* CV on second and third semiparametric estimation step  
noi di _n in gr "{hline 80}" _n in ye								///
"CV on second and third semiparametric estimation step  - `C_tit'"	///
_n in gr "{hline 80}"



	* Model M01
		use "${PL_DEGREE}/temp_`V'_`C'_baseline", replace
		local m=1

		_pctile ${denom} 		, p(1 99)
		gen use1=(${denom}>= r(r1) & ${denom} <= r(r2))
		noi reg_cv2 `Y' ${Y_X} ${denom} 			///
			if use1==1,								///
			cvlist1(${denom}) order1(4) suffix1(INC)
		noi ereturn list


	* Model M02
		local m=2
		use "${PL_DEGREE}/temp_`V'_`C'_baseline", replace
		drop ln_hincome_1_`V' 
		rename ln_hincome_imp1_1_$V ln_hincome_1_`V'
		_pctile ${denom} 		, p(1 99)
		gen use1=(${denom}>= r(r1) & ${denom} <= r(r2))
		noi reg_cv2 `Y_imp' ${Y_X} ${denom} 		///
			if use1==1,								///
			cvlist1(${denom}) order1(4) suffix1(INC)
		noi ereturn list

noi di _n in gr "{hline 80}"
*------------------------------------------------------------------------------------------------
		cap log close
		cap erase "${PL_DEGREE}/temp_`V'_`C'_baseline.dta"
	}						// Close Loop over Country
}							// Close Loop over Variables
}							// End quitely


