qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
*------------------------------------------------------------------------------------------------
	local Variables "a"

	local CON_VAR_U "delay"
	local CON_VAL_U "-1"
	local CON_VAR_I "single"
	local CON_VAL_I "1"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Load data & log file for each variable in local Variables
*------------------------------------------------------------------------------------------------

foreach V of local Variables {

	* Log File
		cap log close
		log using "10_FS_Estimates_`V'", replace text
		estimates clear

	* Dependent variables
		use sample_income, clear
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"

	* Construct list of predictors
		global CC="ALL"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		dropping `U' 	${U_X}
		dropping `I_Y' 	${I_Y_X}					if `U'==1
		dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
		dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
		dropping `E' 	${E_X}						if `U'==1 & `I_E'==1 
		dropping `Y' 	${Y_X}						if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		keep  sampid2  								///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} ${wgt} 		 
		order sampid2 	 							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} ${wgt} 	
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* MODEL selection criteria and summary statistics on the error term distributions 
*------------------------------------------------------------------------------------------------
	estread "${FS_DEGREE}/`V'_ALL_snp", estsave id(sampid2)

	estimates restore BP
	local rho_BP=e(rho)
	estat ic
	matrix S=r(S)	
	local ll_BP=S[1,3]
	local Parameters_BP=S[1,4]

	estimates restore SNP_3_3
	local sd1_33=e(sd1)
	local ske1_33=e(ske1)
	local kurt1_33=e(kurt1)
	local sd2_33=e(sd2)
	local ske2_33=e(ske2)
	local kurt2_33=e(kurt2)
	local rho_33=e(rho)
	estat ic
	matrix S=r(S)	
	local ll_33=S[1,3]
	local Parameters_33=S[1,4]
	local AIC_33=S[1,5]	
	local BIC_33=S[1,6]	

	estimates restore SNP_3_4
	local sd1_34=e(sd1)
	local ske1_34=e(ske1)
	local kurt1_34=e(kurt1)
	local sd2_34=e(sd2)
	local ske2_34=e(ske2)
	local kurt2_34=e(kurt2)
	local rho_34=e(rho)
	estat ic
	matrix S=r(S)	
	local ll_34=S[1,3]
	local Parameters_34=S[1,4]
	local AIC_34=S[1,5]	
	local BIC_34=S[1,6]	
	local LR_34=2*(`ll_34'-`ll_33')
	local LR_p_34=chiprob(`Parameters_34'-`Parameters_33',`LR_34')
 
	estimates restore SNP_4_3
	local sd1_43=e(sd1)
	local ske1_43=e(ske1)
	local kurt1_43=e(kurt1)
	local sd2_43=e(sd2)
	local ske2_43=e(ske2)
	local kurt2_43=e(kurt2)
	local rho_43=e(rho)
	estat ic
	matrix S=r(S)	
	local ll_43=S[1,3]
	local Parameters_43=S[1,4]
	local AIC_43=S[1,5]	
	local BIC_43=S[1,6]	
	local LR_43=2*(`ll_43'-`ll_33')
	local LR_p_43=chiprob(`Parameters_43'-`Parameters_33',`LR_43')

	estimates restore SNP_4_4
	local sd1_44=e(sd1)
	local ske1_44=e(ske1)
	local kurt1_44=e(kurt1)
	local sd2_44=e(sd2)
	local ske2_44=e(ske2)
	local kurt2_44=e(kurt2)
	local rho_44=e(rho)
	estat ic
	matrix S=r(S)	
	local ll_44=S[1,3]
	local Parameters_44=S[1,4]
	local AIC_44=S[1,5]	
	local BIC_44=S[1,6]	
	local LR_44=2*(`ll_44'-`ll_33')
	local LR_p_44=chiprob(`Parameters_44'-`Parameters_33',`LR_44')
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Load and rename estimates from FS_DEGREE folder
*------------------------------------------------------------------------------------------------
	estread "${FS_DEGREE}/`V'_ALL_snp", estsave id(sampid2)
	estimates restore SNP_3_3
	estimates store BS_33
	estimates restore SNP_3_4
	estimates store BS_34
	estimates restore SNP_4_3
	estimates store BS_43
	estimates restore SNP_4_4
	estimates store BS_44
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Normalize estimates
*------------------------------------------------------------------------------------------------
* BP unit
	cap estimates restore BP
	local BP_U_c ""
	foreach xx of global U_X {
		if "`xx'"!="`CON_VAR_U'" {
			local BP_U_c "`BP_U_c' (`xx':`CON_VAL_U'*_b[`U':`xx']/_b[`U':`CON_VAR_U']) "
		}
	}
	nlcom `BP_U_c', post nohead
	estimates store BP_U_c
	
* BP Item
	cap estimates restore BP
	local BP_I_c ""
	foreach xx of global I_Y_X {
		if "`xx'"!="`CON_VAR_I'" {
			local BP_I_c "`BP_I_c' (`xx':`CON_VAL_I'*_b[`I_Y':`xx']/_b[`I_Y':`CON_VAR_I']) "
		}
	}
	nlcom `BP_I_c', post nohead
	estimates store BP_I_c


* BS 
	forvalues k1=3(1)4{
		forvalues k2=3(1)4{
			* Unit
				cap estimates restore BS_`k1'`k2'
				local BS_`k1'`k2'_U_c ""
				foreach xx of global U_X {
					if "`xx'"!="`CON_VAR_U'" {
						local BS_`k1'`k2'_U_c "`BS_`k1'`k2'_U_c' (`xx':`CON_VAL_U'*_b[`U':`xx']/_b[`U':`CON_VAR_U']) "
					}
				}
				nlcom `BS_`k1'`k2'_U_c', post nohead
				estimates store BS_`k1'`k2'_U_c
	
			* Item
				cap estimates restore BS_`k1'`k2'
				local BS_`k1'`k2'_I_c ""
				foreach xx of global I_Y_X {
					if "`xx'"!="`CON_VAR_I'" {
						local BS_`k1'`k2'_I_c "`BS_`k1'`k2'_I_c' (`xx':`CON_VAL_I'*_b[`I_Y':`xx']/_b[`I_Y':`CON_VAR_I']) "
					}
				}
				nlcom `BS_`k1'`k2'_I_c', post nohead
				estimates store BS_`k1'`k2'_I_c
		}
	}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Display normalized estimates of the unit nonresponse equation
*------------------------------------------------------------------------------------------------
	* BS_34_U_c BS_43_U_c BS_44_U_c 
	noi estout 	BP_U_c BS_33_U_c  					///
		, sty(tex) stardetach 						///
		cells(b(star fmt(%9.3f))) 					///
		starlevels(* 0.05 ** 0.01)					///
		nolz modelwidth(7) varwidth(13)				///
		varlabels(								///
			gs_female "female SHM"					///
			gs_age "age SHM"						///
			gs_age2 "age$^2$ SHM"					///
			ans_mac "ans. machine"					///
			delay2 "delay$^2$"					///
			suppl "supplement"					///
			age2 "age$^2$"						///
			iv_female "female IV"					///
			iv_age "age IV"						///
			iv_age2 "age$^2$ IV"					///
			iv_edu "educ IV"						///
			partner_age "age spouse"				///
			partner_age2 "age$^2$ spouse"				///
			small_city "small city"					///
			recall_d "recall"						///
			proxy_co "proxy con."					///
			proxy_inc "proxy inc."					///
			int_length "int. length"				///
			int_clarif "clarif"					///
			int_out   "outside"					///
			_cons	"constant"						///
			nuts1	 "nuts 1"						///
			nuts2	 "nuts 2"						///
			nuts3	 "nuts 3"						///
			nuts4	 "nuts 4"						///
			nuts5	 "nuts 5"						///
			nuts6	 "nuts 6"						///
			nuts7	 "nuts 7"						///
			nuts8	 "nuts 8"						///
			nuts9	 "nuts 9"						///
			nuts10 "nuts 10"						///
			nuts11 "nuts 11"						///
			nuts12 "nuts 12"						///
			nuts13 "nuts 13"						///
			nuts14 "nuts 14"						///
			nuts15 "nuts 15"						///
			str_1	 "stratum 1"					///
			str_2	 "stratum 2"					///
			str_3	 "stratum 3"					///
			str_4	 "stratum 4"					///
			str_5	 "stratum 5"					///
			str_6	 "stratum 6"					///
			str_7	 "stratum 7"					///
			str_8	 "stratum 8"					///
			str_9	 "stratum 9"					///
			str_10 "stratum 10"					///
			str_11 "stratum 11"					///
			str_12 "stratum 12"					///
			str_13 "stratum 13"					///
			str_14 "stratum 14"					///
			str_15 "stratum 15"					///
			ES_nuts1 "ES nuts\$_1$"					///
			ES_nuts2 "ES nuts\$_2$"					///
			ES_nuts3 "ES nuts\$_3$"					///
			ES_nuts4 "ES nuts\$_4$"					///
			ES_nuts5 "ES nuts\$_5$"					///
			ES_nuts6 "ES nuts\$_6$"					///
			ES_nuts7 "ES nuts\$_7$"					///
			IT_nuts1 "IT nuts\$_1$"					///
			IT_nuts2 "IT nuts\$_2$"					///
			IT_nuts3 "IT nuts\$_3$"					///
			IT_nuts4 "IT nuts\$_4$"					///
			IT_nuts5 "IT nuts\$_5$"					///
			NL_nuts1 "NL nuts\$_1$"					///
			NL_nuts2 "NL nuts\$_2$"					///
			NL_nuts3 "NL nuts\$_3$"					///
			NL_nuts4 "NL nuts\$_4$"					///
		)									///
		title(ALL country - unit response)
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Display summary statistics on the distribution of U1
*------------------------------------------------------------------------------------------------
	local stat "sd1 ske1 kurt1"
	foreach ss of local stat {
		local form "%9.2f"
		local s=1
		noi di in ye _col(`s') "`ss'", _c 
		local s=`s'+13
		noi di in ye _col(`s') "&" `form' ``ss'_BP' "& ", _c 
		local s=`s'+13
		forvalues k1=3(1)3{
			forvalues k2=3(1)3{
				noi di in ye _col(`s') "&" `form' ``ss'_`k1'`k2'' "& ", _c
				local s=`s'+13
			}
		}
		noi di in ye "\\"
	}		
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Display normalized estimates of the item nonresponse equation
*------------------------------------------------------------------------------------------------
	* BS_34_I_c BS_43_I_c BS_44_I_c
	noi estout 	BP_I_c BS_33_I_c 						///
		, sty(tex) stardetach						///
		cells(b(star fmt(%9.3f))) 					///
		starlevels(* 0.05 ** 0.01)					///
		nolz modelwidth(7) varwidth(13)				///
		varlabels(								///
			gs_female "female SHM"					///
			gs_age "age SHM"						///
			gs_age2 "age$^2$ SHM"					///
			ans_mac "ans. machine"					///
			delay2 "delay$^2$"					///
			suppl "supplement"					///
			age2 "age$^2$"						///
			iv_female "female IV"					///
			iv_age "age IV"						///
			iv_age2 "age$^2$ IV"					///
			iv_edu "educ IV"						///
			partner_age "age spouse"				///
			partner_age2 "age$^2$ spouse"				///
			small_city "small city"					///
			recall_d "recall"						///
			proxy_co "proxy con."					///
			proxy_inc "proxy inc."					///
			int_length "int. length"				///
			int_clarif "clarif"					///
			int_out   "outside"					///
			_cons	"constant"						///
			nuts1	 "nuts 1"						///
			nuts2	 "nuts 2"						///
			nuts3	 "nuts 3"						///
			nuts4	 "nuts 4"						///
			nuts5	 "nuts 5"						///
			nuts6	 "nuts 6"						///
			nuts7	 "nuts 7"						///
			nuts8	 "nuts 8"						///
			nuts9	 "nuts 9"						///
			nuts10 "nuts 10"						///
			nuts11 "nuts 11"						///
			nuts12 "nuts 12"						///
			nuts13 "nuts 13"						///
			nuts14 "nuts 14"						///
			nuts15 "nuts 15"						///
			str_1	 "stratum 1"					///
			str_2	 "stratum 2"					///
			str_3	 "stratum 3"					///
			str_4	 "stratum 4"					///
			str_5	 "stratum 5"					///
			str_6	 "stratum 6"					///
			str_7	 "stratum 7"					///
			str_8	 "stratum 8"					///
			str_9	 "stratum 9"					///
			str_10 "stratum 10"					///
			str_11 "stratum 11"					///
			str_12 "stratum 12"					///
			str_13 "stratum 13"					///
			str_14 "stratum 14"					///
			str_15 "stratum 15"					///
			ES_nuts1 "ES nuts\$_1$"					///
			ES_nuts2 "ES nuts\$_2$"					///
			ES_nuts3 "ES nuts\$_3$"					///
			ES_nuts4 "ES nuts\$_4$"					///
			ES_nuts5 "ES nuts\$_5$"					///
			ES_nuts6 "ES nuts\$_6$"					///
			ES_nuts7 "ES nuts\$_7$"					///
			IT_nuts1 "IT nuts\$_1$"					///
			IT_nuts2 "IT nuts\$_2$"					///
			IT_nuts3 "IT nuts\$_3$"					///
			IT_nuts4 "IT nuts\$_4$"					///
			IT_nuts5 "IT nuts\$_5$"					///
			NL_nuts1 "NL nuts\$_1$"					///
			NL_nuts2 "NL nuts\$_2$"					///
			NL_nuts3 "NL nuts\$_3$"					///
			NL_nuts4 "NL nuts\$_4$"					///
		)									///
		title(ALL country - Item response)
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Display summary statistics on the distribution of U1
*------------------------------------------------------------------------------------------------
	local stat "sd2 ske2 kurt2"
	foreach ss of local stat {
		local form "%9.2f"
		local s=1
		noi di in ye _col(`s') "`ss'", _c 
		local s=`s'+13
		noi di in ye _col(`s') "&" `form' ``ss'_BP' "& ", _c 
		local s=`s'+13
		forvalues k1=3(1)3{
			forvalues k2=3(1)3{
				noi di in ye _col(`s') "&" `form' ``ss'_`k1'`k2'' "& ", _c
				local s=`s'+13
			}
		}
		noi di in ye "\\"
	}		
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Display Model selection criteria for the joint model
*------------------------------------------------------------------------------------------------
	local stat "rho Parameters LR LR_p AIC BIC"
	foreach ss of local stat {
		if "`ss'"=="rho"|"`ss'"=="LR"|"`ss'"=="LR_p" local form "%9.2f"
		else local form "%9.0f"
		local s=1
		noi di in ye _col(`s') "`ss'", _c 
		local s=`s'+15
		noi di in ye _col(`s') "&" `form' ``ss'_BP' "& ", _c 
		local s=`s'+15
		forvalues k1=3(1)3{
			forvalues k2=3(1)3{
				noi di in ye _col(`s') "&" `form' ``ss'_`k1'`k2'' "& ", _c
				local s=`s'+15
			}
		}
		noi di in ye "\\"
	}		
*------------------------------------------------------------------------------------------------
}
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------

}

