qui {

*---------------------------------------------------------------------------------------
* Gross sample demographics
	global gs_demo	"gs_female gs_age"
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Interviewer demographics
	if "${CC}"!="SE"  	global iv_demo 	"iv_female iv_age iv_edu"
	else 				global iv_demo 	"iv_age iv_edu"
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Fieldwork variables
	if "${CC}"=="DK"	{
		global field 	"ans_mac"
		global delay	"delay"
		global sample 	" "
	}
	if "${CC}"=="ES"	{
		global field 	"ans_mac"
		global delay	"delay"
		global sample 	"vignette"
	}
	if "${CC}"=="IT"	{
		global field 	"ans_mac"
		global delay	"delay"
		global sample 	"vignette"
	}
	if "${CC}"=="NL"	{
		global field 	"ans_mac"
		global delay	"delay"
		global sample 	"vignette"
	}
	if "${CC}"=="SE"	{
		global field 	"ans_mac"
		global delay	"delay"
		global sample 	"vignette suppl"
	}
	if "${CC}"=="ALL"	{
		global field 	"ans_mac"
		global delay	"delay"
		global sample 	"vignette suppl"
	}
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Nuts1 variables variables
#delimit;
	if "${CC}"=="DK" 	global nuts " ";			
	if "${CC}"=="ES" 	global nuts "ES_nuts1 ES_nuts2 ES_nuts3 ES_nuts4 ES_nuts6 ES_nuts7";	
	if "${CC}"=="IT" 	global nuts "IT_nuts2 IT_nuts3 IT_nuts4 IT_nuts5";
	if "${CC}"=="NL" 	global nuts "NL_nuts1 NL_nuts2 NL_nuts4";
	if "${CC}"=="SE" 	global nuts " ";
	if "${CC}"=="ALL" 	global nuts "ES_nuts1 ES_nuts2 ES_nuts3 ES_nuts4 ES_nuts6 ES_nuts7 IT_nuts2 IT_nuts3 IT_nuts4 IT_nuts5 NL_nuts1 NL_nuts2 NL_nuts4";	
#delimit cr
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Country dummies
	if "${CC}"!="ALL" 	global country_d " "
	else 				global country_d "DK ES IT NL"
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Capi demographics
	global hr_demo  	"female age"
	global hr_fs  		"single partner_age hsize children small_city"
	global hr_edu  		"education"
	global hr_cogn  	"orient math recall_d fluency"
	global interview  	"proxy int_clarif int_out"
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Log total expenditure terms
	global denom 		"ln_hincome_1_$V"
	global denom_imp 	"ln_hincome_imp1_1_$V"
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Weights and common covariates
	global wgt			"wgtach"
*---------------------------------------------------------------------------------------

*---------------------------------------------------------------------------------------
* Final list of covariates
global U_X	   "${gs_demo} ${iv_demo} ${sample} ${field} ${delay} ${country_d} ${nuts}"
global I_Y_X   "${hr_demo} ${hr_fs} ${hr_edu} ${hr_cogn} ${iv_demo} ${interview} ${country_d} ${nuts}"
global E_X	   "${hr_demo} ${hr_fs} ${hr_edu} ${hr_cogn} ${country_d} ${nuts}"
global Y_X	   "${hr_demo} ${hr_fs} ${hr_edu} ${country_d} ${nuts}"
global Y_imp_X "${hr_demo} ${hr_fs} ${hr_edu} ${country_d} ${nuts}"
*---------------------------------------------------------------------------------------

}
