set more off

cap log close
log using "Output/merge", replace

/// MERGE STUDENTS ADMGR AND SCHOOL
use "Output/students", clear

rename nummer_instelling hoofdnr
rename intern_volgnr_vpl vplnr

merge m:1 nummer_admgr using "Output/admgr"
tab birth_year if _merge==1
tab schooljaar if _merge==1

drop if _merge==2 //options that were not chosen
drop _merge


merge m:1 hoofdnr vplnr using "Output/schools"
drop if _merge==2 //schools with no students (e.g. kindergarten or new/old schools)
drop _merge

label var g_lon "longitude of school"
label var g_lat "latitude of school"

*add schoolnr of bao too
rename hoofdnr hoofdnr_TEMP
rename vplnr vplnr_TEMP
rename adnr adnr_TEMP
rename bao_nummer_instelling hoofdnr
rename bao_intern_volgnr_vpl vplnr

merge m:1 hoofdnr vplnr using "Output/schools",keepusing(adnr)
rename adnr bao_adnr
label var bao_adnr "Last elementary school"
drop if _merge==2 //schools with no students (e.g. kindergarten or new/old schools)
drop _merge
drop hoofdnr
drop vplnr

rename hoofdnr_TEMP hoofdnr
rename vplnr_TEMP vplnr
rename adnr_TEMP adnr


drop if missing(anoniem)
drop if missing(schooljaar)

//create additional variables for defining track
*first year
tab naamadmini if natuurlijk==1
gen eersteA=0 if  natuurlijk==1
replace eersteA=1 if  naamadmini=="1ste leerjaar A" & natuurlijk==1
gen eersteB=0 if  natuurlijk==1
replace eersteB=1 if  naamadmini=="1ste leerjaar B" & natuurlijk==1
gen eerste=1 if eersteA==1 & natuurlijk==1
set more off
replace eerste=0 if eersteB==1 & natuurlijk==1
label variable eerste "Track choice in first year: 1 is A, 0 is B"

gen eersteBUSO=1 if  naamadmini=="1e complementair jaar (BuSO-fr.)" & natuurlijk==1
replace eersteBUSO=1 if  naamadmini=="1e leerjaar Observatiejaar" & natuurlijk==1
replace eersteBUSO=1 if  naamadmini=="1e leerjaar A (BuSO)" & natuurlijk==1
replace eersteBUSO=1 if  naamadmini=="1e leerjaar B (BuSO)" & natuurlijk==1
replace eersteBUSO=0 if  natuurlijk==1 & missing(eersteBUSO)

sum eersteA eersteB eerste eersteBUSO

**second year
tab naamadmini if  natuurlijk==2

*officialy this still is GSO but in practice already ASO TSO BSO: check this practice and use it by classifying each study
sort anoniem schooljaar

gen tweedeASO=0 if natuurlijk==2
replace tweedeASO=1 if naamadmin=="2e leerjaar in de 1e graad Latijn"  & natuurlijk==2
replace tweedeASO=1 if naamadmin=="2e leerjaar in de 1e graad Moderne wetenschappen"  & natuurlijk==2
replace tweedeASO=1 if naamadmin=="2e leerjaar in de 1e graad Grieks-Latijn"  & natuurlijk==2

*BSO is seen in the name as it start with "Beroepsvoorbereidend"
gen tweedeBSO=0 if  natuurlijk==2
replace tweedeBSO=1 if substr(naamadmin,1,7)=="Beroeps" & natuurlijk==2
replace tweedeBSO=1 if substr(naamadmin,1,7)=="beroeps" & natuurlijk==2

*indicator for buso
gen buso=(hs==321)
replace ASO=0 if ASO==1 & hs==321 //hs seems to be more correct
replace TSO=0 if TSO==1 & hs==321 //hs seems to be more correct
replace KSO=0 if KSO==1 & hs==321 //hs seems to be more correct
replace BSO=0 if BSO==1 & hs==321 //hs seems to be more correct
replace GSO=0 if GSO==1 & hs==321

*indicator for dbso
gen DBSO=(hs==312)

*what is left? if clear switchings pick the most logical one
sort anoniem schooljaar
by anoniem: gen ASO_next=ASO[_n+1]
by anoniem: gen TSO_next=TSO[_n+1]
by anoniem: gen KSO_next=KSO[_n+1]
by anoniem: gen BSO_next=BSO[_n+1]

tab naamadmin if tweedeBSO==0 & tweedeASO==0 & natuurlijk==2 & ASO_next==1 & buso==0
tab naamadmin if tweedeBSO==0 & tweedeASO==0 & natuurlijk==2 & TSO_next==1 & buso==0
tab naamadmin if tweedeBSO==0 & tweedeASO==0 & natuurlijk==2 & KSO_next==1 & buso==0
tab naamadmin if tweedeBSO==0 & tweedeASO==0 & natuurlijk==2 & BSO_next==1 & buso==0

replace tweedeASO=1 if naamadmin=="2e leerjaar in de 1e graad Topsport" 
replace tweedeASO=1 if naamadmin=="2e leerjaar in de 1e graad Yeshiva"
gen tweedeKSO=0 if natuurlijk==2
replace tweedeKSO=1 if naamadmin=="2e leerjaar in de 1e graad Artistieke vorming"
replace tweedeKSO=1 if naamadmin=="2e leerjaar in de 1e graad Ballet"

gen tweedeTSO=0 if  natuurlijk==2
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Agro- en biotechnieken"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Bouw- en houttechnieken"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Creatie en vormgeving"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Handel"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Hotel-voeding"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Industriële wetenschappen"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Maritieme technieken"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Maritieme vorming"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Grafische communicatie en media"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Sociale en technische vorming"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Mechanica-elektriciteit"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Techniek-wetenschappen"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Textiel"
replace tweedeTSO=1 if naamadmin=="2e leerjaar in de 1e graad Proeftuin"

*steiner as ASO
replace tweedeASO=1 if naamadmin=="2e leerjaar in de 1e graad Rudolf Steinerpedagogie"
tab naamadmin if tweedeBSO==0 & tweedeASO==0 & tweedeTSO==0 & tweedeKSO==0 & natuurlijk==2 & buso==0

*create better ASO etc.. variables
foreach var of varlist ASO TSO KSO BSO {
clonevar `var'_official=`var'
label variable `var'_official "Officially `var' thus second year of SO is not included"
replace `var'=tweede`var' if natuurlijk==2
}

*set beroepsvoorbereidende jaren back to buso if they were buso
replace BSO=0 if BSO==1 & hs==321

*set GSO to 0 if others are known
replace GSO=0 if ASO==1 | TSO==1 | BSO==1 | KSO==1 | DBSO==1 | buso==1
replace GSO=0 if natuurlijk==2 //the rest is just unknown subtrack

*update onderwijsvorm
replace onderwijsvorm="ASO" if ASO==1
replace onderwijsvorm="TSO" if TSO==1
replace onderwijsvorm="KSO" if KSO==1
replace onderwijsvorm="BSO" if BSO==1
replace onderwijsvorm="DBSO" if DBSO==1
replace onderwijsvorm="buso" if buso==1
replace onderwijsvorm="GSO" if GSO==1

tab nummer_admgr if natuurlijk==2 & onderwijsvorm=="GSO" & buso==0

tab onderwijsvorm, missing //999 is onthaaljaar voor anderstalige nieuwkomers, HBO is 20 weken onderwijs, GSO zie hiervoor
tab naamadmin if missing(onderwijsvorm), missing //van onderwijsvormen die niet gekend zijn, kennen we ook niet de richting

**create identifier if school is ASO, TSO, BSO, KSO
bysort adnr: egen total_ASO=total(ASO)
by adnr: egen total_TSO=total(TSO)
by adnr: egen total_KSO=total(KSO)
by adnr: egen total_BSO=total(BSO)

gen total=total_ASO+total_TSO+total_KSO+total_BSO

gen total_ASO_rel=total_ASO/total
gen total_TSO_rel=total_TSO/total
gen total_KSO_rel=total_KSO/total
gen total_BSO_rel=total_BSO/total

sum total_*rel

gen scho_someASO=0 if !missing(adnr)
gen scho_someTSO=0 if !missing(adnr)
gen scho_someKSO=0 if !missing(adnr)
gen scho_someBSO=0 if !missing(adnr)


*criteria to define ASO,TSO... schools: at least 1 student
replace scho_someASO=1 if total_ASO>=1 & !missing(total_ASO) & !missing(adnr)
replace scho_someTSO=1 if total_TSO>=1 & !missing(total_TSO) & !missing(adnr)
replace scho_someKSO=1 if total_KSO>=1 & !missing(total_KSO) & !missing(adnr)
replace scho_someBSO=1 if total_BSO>=1 & !missing(total_BSO) & !missing(adnr)

/*
*criteria to define ASO,TSO... schools: at least 5 students
replace scho_someASO=1 if total_ASO>5 & !missing(total_ASO) & !missing(adnr)
replace scho_someTSO=1 if total_TSO>5 & !missing(total_TSO) & !missing(adnr)
replace scho_someKSO=1 if total_KSO>5 & !missing(total_KSO) & !missing(adnr)
replace scho_someBSO=1 if total_BSO>5 & !missing(total_BSO) & !missing(adnr)
*/

/*
*criteria to define ASO,TSO... schools: at least 1% of students and at least 5 students (except for very small schools)
replace scho_someASO=1 if total_ASO_rel>0.01 & total>0 & (total_ASO>5 | total<10) & !missing(total_ASO_rel) & !missing(total) & !missing(total_ASO) & !missing(adnr)
replace scho_someTSO=1 if total_TSO_rel>0.01 & total>0 & (total_TSO>5 | total<10) & !missing(total_TSO_rel) & !missing(total) & !missing(total_TSO) & !missing(adnr)
replace scho_someKSO=1 if total_KSO_rel>0.01 & total>0 & (total_KSO>5 | total<10) & !missing(total_KSO_rel) & !missing(total) & !missing(total_KSO) & !missing(adnr)
replace scho_someBSO=1 if total_BSO_rel>0.01 & total>0 & (total_BSO>5 | total<10) & !missing(total_BSO_rel) & !missing(total) & !missing(total_BSO) & !missing(adnr)
*/

*check if someone does a track but does not belong to a school in the year he starts hs
list hoofdnr vplnr if (ASO==1 | BSO==1 | TSO==1 | KSO==1) & scho_someASO==0 & scho_someKSO==0 & scho_someBSO==0 & scho_someTSO==0

save "Output/database",replace

log close
/*
Note: criteria not very important

at least 1

    Variable |        Obs        Mean    Std. Dev.       Min        Max
-------------+---------------------------------------------------------
scho_someASO |    891,023    .6819869    .4657049          0          1
scho_someTSO |    891,023    .7268892    .4455575          0          1
scho_someKSO |    891,023    .0713382    .2573891          0          1
scho_someBSO |    891,023    .6250703     .484105          0          1


at least 5

    Variable |        Obs        Mean    Std. Dev.       Min        Max
-------------+---------------------------------------------------------
scho_someASO |    891,023     .680731    .4661937          0          1
scho_someTSO |    891,023    .7219522    .4480373          0          1
scho_someKSO |    891,023    .0700173    .2551763          0          1
scho_someBSO |    891,023    .6181412    .4858425          0          1



at least 1% of students and at least 5 students (except for very small schools):



    Variable |        Obs        Mean    Std. Dev.       Min        Max
-------------+---------------------------------------------------------
scho_someASO |    891,023     .676473    .4678221          0          1
scho_someTSO |    891,023    .7220532    .4479873          0          1
scho_someKSO |    891,023    .0639501    .2446641          0          1
scho_someBSO |    891,023     .618296    .4858048          0          1


*/
