clear
set more off

cap log close
log using "Output/geocode",replace

**GEOCODE
*(note that the geocoding itself is deactivated because it takes very long)
*(instead, geocodedaddress is added to "Source")
use "Output/vpl",clear
tostring postcode,replace

*simplify nr
clonevar huisnr_simple=huisnr

replace huisnr_simple="3" if huisnr_simple=="1-5"
replace huisnr_simple="4" if huisnr_simple=="3-5"

replace huisnr_simple=subinstr(huisnr_simple,"A","",.)
replace huisnr_simple=subinstr(huisnr_simple,"B","",.)
replace huisnr_simple=subinstr(huisnr_simple,"C","",.)
replace huisnr_simple=subinstr(huisnr_simple,"D","",.)
replace huisnr_simple=subinstr(huisnr_simple,"E","",.)
replace huisnr_simple=subinstr(huisnr_simple,"F","",.)
replace huisnr_simple=subinstr(huisnr_simple,"G","",.)
replace huisnr_simple=subinstr(huisnr_simple,"H","",.)
replace huisnr_simple=subinstr(huisnr_simple,"I","",.)
replace huisnr_simple=subinstr(huisnr_simple,"J","",.)
replace huisnr_simple=subinstr(huisnr_simple,"K","",.)
replace huisnr_simple=subinstr(huisnr_simple,"S","",.)
replace huisnr_simple=subinstr(huisnr_simple,"a","",.)
replace huisnr_simple=subinstr(huisnr_simple,"b","",.)
replace huisnr_simple=subinstr(huisnr_simple,"c","",.)
replace huisnr_simple=subinstr(huisnr_simple,"d","",.)
replace huisnr_simple=subinstr(huisnr_simple,"e","",.)
replace huisnr_simple=subinstr(huisnr_simple,"f","",.)
replace huisnr_simple=subinstr(huisnr_simple,"g","",.)
replace huisnr_simple=subinstr(huisnr_simple,"h","",.)
replace huisnr_simple=subinstr(huisnr_simple,"i","",.)
replace huisnr_simple=subinstr(huisnr_simple,"j","",.)
replace huisnr_simple=subinstr(huisnr_simple,"k","",.)
replace huisnr_simple=subinstr(huisnr_simple,"s","",.)
replace huisnr_simple=subinstr(huisnr_simple,"bis","",.)
replace huisnr_simple=subinstr(huisnr_simple,"BIS","",.)
replace huisnr_simple=subinstr(huisnr_simple,"bi","",.)
replace huisnr_simple=subinstr(huisnr_simple,"BI","",.)
forvalues i=1/100 {
replace huisnr_simple=subinstr(huisnr_simple,"_`i'","",.)
replace huisnr_simple=subinstr(huisnr_simple,"_0`i'","",.)
}
replace huisnr_simple=subinstr(huisnr_simple,"-","",.)
replace huisnr_simple=subinstr(huisnr_simple,"_","",.)

destring huisnr_simple,replace
tostring huisnr_simple,replace

gen straatnaam_plus=subinstr(straatnaam," ","+",.) 

gen address=huisnr_simple+"+"+straatnaam_plus+"+"+postcode+"+belgie"

replace address=subinstr(address,"ö","o",.)
replace address=subinstr(address,"é","e",.)
replace address=subinstr(address,"è","e",.)
replace address=subinstr(address,"ë","e",.)
replace address=subinstr(address,"ü","u",.)
replace address=subinstr(address,"ö","o",.)
replace address=subinstr(address,"ï","i",.)
replace address=subinstr(address,"ç","c",.)

save "Output/vpl_extra",replace

/*
keep straatnaam huisnr postcode naam_fusiegemeente
duplicates drop
set more off
geocode3, address(address)  fulladdress quality zip state number street ad1 ad2 ad3 sub 

*manual adj
replace address=upper(address)
replace address=subinstr(address,"BELGIE","belgie",.)
replace g_lat=51.1883598 if straatnaam=="KAULILLERDORP" & huisnr=="43" & postcode=="3950"
replace g_lon=5.5214428 if straatnaam=="KAULILLERDORP" & huisnr=="43" & postcode=="3950"
replace g_lon=. if naam_fusiegemeente=="Belg. Strijdkrachten Duitsland"
replace g_lat=. if naam_fusiegemeente=="Belg. Strijdkrachten Duitsland"
replace g_lon=4.930736  if address=="6+KERKSTRAAT+2387+belgie"
replace g_lat=51.442610 if address=="6+KERKSTRAAT+2387+belgie"
replace g_lon=5.387048  if address=="18+SCHOOLSTRAAT+3940+belgie"
replace g_lat=51.154826 if address=="18+SCHOOLSTRAAT+3940+belgie"
replace g_lon=3.419561  if address=="1++KLOOSTERSTRAAT+8580+belgie"
replace g_lat=50.790850 if address=="1++KLOOSTERSTRAAT+8580+belgie"
replace g_lon=4.028106  if address=="2+JULIE+BILLIARTPLEIN+9240+belgie"
replace g_lat=51.064210 if address=="2+JULIE+BILLIARTPLEIN+9240+belgie"
replace g_lon=3.485634  if address=="3+O.L.VROUWSTRAAT+8582+belgie"
replace g_lat=50.790663 if address=="3+O.L.VROUWSTRAAT+8582+belgie"
replace g_lon=3.530321  if address=="10+PETER+BENOITLAAN+9850+belgie"
replace g_lat=50.985912 if address=="10+PETER+BENOITLAAN+9850+belgie" //scholengemeenshap van deinze
replace g_lat=51.1883598 if straatnaam=="KAULILLERDORP" & huisnr=="43" & postcode=="3950"
replace g_lon=5.5214428 if straatnaam=="KAULILLERDORP" & huisnr=="43" & postcode=="3950"
replace g_lon=. if naam_fusiegemeente=="Butgenbach"
replace g_lat=. if naam_fusiegemeente=="Butgenbach"

*check "approximate" solutions and change
replace g_lat=50.774835 if straatnaam=="Kloosterstraat Kloosterstraat" & huisnr=="1" & postcode=="8580" //mentioned on website of school to use other address in gps
replace g_lon=3.446564 if straatnaam=="Kloosterstraat Kloosterstraat" & huisnr=="1" & postcode=="8580"
replace g_lat=50.884905 if straatnaam=="Bolle Meersstraat" & huisnr=="12" & postcode=="8906"
replace g_lon=2.815865 if straatnaam=="Bolle Meersstraat" & huisnr=="12" & postcode=="8906"
replace g_lat=51.173815 if straatnaam=="Fernand Hanusdreef" & huisnr=="39" & postcode=="9160"
replace g_lon=3.942432 if straatnaam=="Fernand Hanusdreef" & huisnr=="39" & postcode=="9160"
replace g_lat=50.832611 if straatnaam=="Sint-Truidensestraat" & huisnr=="14" & postcode=="3440"
replace g_lon=5.103840  if straatnaam=="Sint-Truidensestraat" & huisnr=="14" & postcode=="3440"
replace g_lat=50.949820 if straatnaam=="Borggravevijversstraat" & huisnr=="9" & postcode=="3500"
replace g_lon=5.371268 if straatnaam=="Borggravevijversstraat" & huisnr=="9" & postcode=="3500"
replace g_lat=51.112347 if straatnaam=="Albert Fastenaekelslaan Noorddui"
replace g_lon=2.639826 if straatnaam=="Albert Fastenaekelslaan Noorddui"
replace g_lat=51.248921 if straatnaam=="Eethuisstraat Leercentrum"
replace g_lon=4.463082 if straatnaam=="Eethuisstraat Leercentrum"
replace g_lat=51.238191 if straatnaam=="Noorderlaan TIVO" & huisnr=="52"
replace g_lon=4.420763 if straatnaam=="Noorderlaan TIVO" & huisnr=="52"
replace g_lat=50.984016 if straatnaam=="Onderwijsstraat Campus Maasmeche"
replace g_lon=5.710183 if straatnaam=="Onderwijsstraat Campus Maasmeche"
replace g_lat=51.019239 if straatnaam=="Stadsgraaf Campus Dilsen-Stokkem"
replace g_lon=5.742717 if straatnaam=="Stadsgraaf Campus Dilsen-Stokkem"
replace g_lat=51.252525 if straatnaam=="Scheldedijk Havennr. 1069"
replace g_lon=4.293766  if straatnaam=="Scheldedijk Havennr. 1069"
replace g_lat=50.821836 if straatnaam=="Minister Vanden Peereboomlaan Mi"
replace g_lon=3.255870 if straatnaam=="Minister Vanden Peereboomlaan Mi"
replace g_lat=50.949828 if straatnaam=="Borggravevijversstraat Borggrave"
replace g_lon=5.368331 if straatnaam=="Borggravevijversstraat Borggrave"
replace g_lat=. if straatnaam==""
replace g_lon=. if straatnaam==""
replace g_lat=51.260817 if straatnaam=="Hoeven Bos en Bremdreef 4"
replace g_lon=5.026035 if straatnaam=="Hoeven Bos en Bremdreef 4"
replace g_lat=51.085943 if straatnaam=="Laarbemdeweg Campus de Wingerd ("
replace g_lon=5.222599 if straatnaam=="Laarbemdeweg Campus de Wingerd ("
replace g_lat=50.876697 if straatnaam=="Vlinderhof 1" & postcode=="3740"
replace g_lon=5.513160 if straatnaam=="Vlinderhof 1" & postcode=="3740"
replace g_lat=50.876697 if straatnaam==" Vlinderhof 1" & postcode=="3740"
replace g_lon=5.513160 if straatnaam==" Vlinderhof 1" & postcode=="3740"

save "Output/geocodedaddress",replace
*/

use "Source/geocodedaddress",clear

keep address g_lon g_lat
duplicates drop
save temp,replace

use "Output/vpl_extra",clear
replace address=upper(address)
replace address=subinstr(address,"BELGIE","belgie",.)
merge m:1 address using temp

sum g_lon g_lat
br if missing(g_lon) & !missing(address)

erase temp.dta
drop _merge

sort hoofdnr vplnr
tostring hoofdnr, format(%06.0f) gen(hoofdvplnr)
destring vplnr,replace
tostring vplnr, format(%02.0f) replace
replace hoofdvplnr=hoofdvplnr+vplnr
destring vplnr,replace
sort address hoofdvplnr
encode address,gen(adnr)

save "Output/schools",replace

*do not allow same school to have different address
*will need this later to add g_lon and g_lat of correct ids
preserve
drop if missing(g_lon) | missing(g_lat)
keep adnr g_lon g_lat
duplicates drop
save temp2,replace
restore

tempvar temp
foreach var of varlist adnr  {
bysort hoofdnr vplnr: egen `temp'=mode(`var'), maxmode
replace `var'=`temp'
drop `temp'
}

sort hoofdnr schooljaar
drop schooljaar
duplicates drop 

*make sure that each adnr has one set of coordinates that corresponds to the adnr that was chosen using egen=mode()
merge m:1 adnr using temp2, update replace
drop _merge
erase temp2.dta

*extra info
merge m:1 hoofdnr using "Output/nummer_inst",update
drop if _merge==2
drop _merge

*renumber address (and make sure different koepels are still different schools)
drop if missing(hoofdnr)
drop address
decode adnr,gen(address)
drop adnr
decode koepel,gen(koepel_str)
replace address=address+koepel_str
sort addres
encode address,gen(adnr)

keep hoofdvplnr hoofdnr vplnr adnr g_lat g_lon scholengemeenschap_nr scholengemeenschap_naam koepel
duplicates drop

duplicates tag hoofdnr vplnr,gen(dup)
tab dup
drop if dup==1 & missing(g_lat)
drop dup
duplicates tag hoofdnr vplnr,gen(dup)
tab dup
drop dup

save "Output/schools",replace
