set more off
cap log close
log using "Output/admgr", replace

///////////////////////////////////////////////////////////// CREATE ADMGR ///////////////////////////////////////////////////////////////////////////////////////
// - Add information about options (=administrative group) using databases on  
///////// http://www.ond.vlaanderen.be/hogeronderwijs/samenwerking-kinderbijslagfonds/lijstadministratievegroepen.htm
// - There was also a list sent by department of education and some cleaning done at HIVA
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/// DB from ministry of education
*load primary education
insheet using "Source/Education/3_admgr_bas.csv", delimiter(";") clear
save "Output/admgr_bao",replace

*load secondary education
insheet using "Source/Education/4_admgr_sec.csv", delimiter(";") clear
replace onderwijsvorm=subinstr(onderwijsvorm," ","",.)
save "Output/admgr_so",replace

*merge
append using "Output/admgr_bao"

save "Output/admgr_ministry",replace

///DB cleaned (via SSL at HIVA)
import excel "Source/education/seg2_admgr.xls",clear firstrow
rename NATUURLIJK_LEERJR natuurlijk_leerjr 
rename naam_srt naamadministratievegroep
rename GRAAD_EHT graad
rename leerjaar_eht leerjaar
destring hs,replace

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj","1ste leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e lj 3e gr","3e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e gr bvlj","Beroepsvoorbereidend leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e leerjaar 3e gr","3e leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 3e gr","1ste leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 2e gr","1ste modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 2e gr","2e modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 3e gr","1ste modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 3e gr","2e modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e mj 3e gr","3e modulair leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e leerjaar 3e gr","3e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e gr bvlj","Beroepsvoorbereidend leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 2e gr","1ste modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 2e gr","2e modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 3e gr","1ste modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 3e gr","2e modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e mj 3e gr","3e modulair leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"SenSe","Se-n-Se",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1lj","1ste leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2lj","2e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3lj","3e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1gr","in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2gr","in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3gr","in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj","1ste leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj","2e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e lj","3e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1egr","in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2egr","in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3egr","in de 3e graad",.)

save "Output/admgr_hiva",replace

/// on line data
*secundair 2012-2013
import excel "Source/Education/lijstAdmGroepenSecundair12.xls", sheet("Lijst AdmGroepen Secundair 2012") firstrow case(lower) clear
tab hs
tab onderwijsvorm


replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj","1ste leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e lj 3e gr","3e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e gr bvlj","Beroepsvoorbereidend leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e leerjaar 3e gr","3e leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 3e gr","1ste leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 2e gr","1ste modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 2e gr","2e modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 3e gr","1ste modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 3e gr","2e modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e mj 3e gr","3e modulair leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e leerjaar 3e gr","3e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e gr bvlj","Beroepsvoorbereidend leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 2e gr","1ste modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 2e gr","2e modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 3e gr","1ste modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 3e gr","2e modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e mj 3e gr","3e modulair leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"SenSe","Se-n-Se",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1lj","1ste leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2lj","2e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3lj","3e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1gr","in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2gr","in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3gr","in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj","1ste leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj","2e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e lj","3e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1egr","in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2egr","in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3egr","in de 3e graad",.)

save "Output/admgr_1",replace

*secundair 2011-2012
import excel "Source/Education/Lijst AdmGroepen Secundair 2011 2012.xls", sheet("Lijst AdmGroepen Secundair 2011") firstrow case(lower) clear
tab hs
tab onderwijsvorm

rename soortrubriekdeeltijds soortrubriekdeeltijds_naam
label variable soortrubriekdeeltijds_naam "Found in database 2011"


replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj","1ste leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e lj 3e gr","3e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e gr bvlj","Beroepsvoorbereidend leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e leerjaar 3e gr","3e leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1ste leerjaar 3e gr","1ste leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 2e gr","1ste modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 2e gr","2e modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 3e gr","1ste modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 3e gr","2e modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e mj 3e gr","3e modulair leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 1e gr","1ste leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 1e gr","2e leerjaar in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 2e gr","1ste leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 2e gr","2e leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e leerjaar 3e gr","1ste leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e leerjaar 3e gr","2e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e leerjaar 3e gr","3e leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e gr bvlj","Beroepsvoorbereidend leerjaar",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 2e gr","1ste modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 2e gr","2e modulair leerjaar in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e mj 3e gr","1ste modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e mj 3e gr","2e modulair leerjaar in de 3e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e mj 3e gr","3e modulair leerjaar in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"SenSe","Se-n-Se",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1lj","1ste leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2lj","2e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3lj","3e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1gr","in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2gr","in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3gr","in de 3e graad",.)

replace naamadministratievegroep=subinstr(naamadministratievegroep,"1e lj","1ste leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2e lj","2e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3e lj","3e leerjaar",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"1egr","in de 1e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"2egr","in de 2e graad",.)
replace naamadministratievegroep=subinstr(naamadministratievegroep,"3egr","in de 3e graad",.)

save "Output/admgr_2",replace

*merge
use "Output/admgr_1", clear
merge 1:1 admgroepnr using "Output/admgr_2", update
*conflicts ok, see below to check
drop _merge
/*
foreach var of varlist hs onderwijsvorm naamadministratievegroepgraad leerjaar soortleerjaar  natuurlijk_leerjropleidingsvormbuso ko_opleidvorm_buso soortrubriekdeeltijds {
di "`var'"
list `var' `var'_2011 if `var'~=`var'_2011 & !missing(`var') & !missing(`var'_2011)
}
*naamadministratievegroep lichtelijk anders maar niet fundamenteel
*1 verschil voor soortleerjaar, in 2012 "andere", in 2011 "modulair leerjaar"
*natuurlijk leerjaar 1observatie fout in 2011 (waarde=17 ipv 0)
*soortrubriekdeeltijds is verschillend: een code in 2012, een naam in 2011 -> use as extra variable
*/

rename admgroepnr nummer_admgr
rename onderwijsvorm onderwijsvorm_so

replace hs=subinstr(hs," ","",.)
destring hs, replace

*correct mistake
replace natuurlijk_leerj=6 if nummer_admgr==37998
replace leerjaar=2 if nummer_admgr==37998

save  "Output/admgr_mergeonline",replace

/// MERGE ministry and on line
use "Output/admgr_ministry",clear
merge 1:1 nummer_admgr using "Output/admgr_mergeonline", update
*on line db adds 1360 observations, 341 obs of ministry are not matched, extra info for matched so, no conflicts (because of the one correction)

drop _merge
merge 1:1 nummer_admgr using "Output/admgr_hiva",update 
//checked some of the _merge==5, are all about using different abreviations, I corrected the most common ones but give preference to source data by not specifiying replace
drop _merge

//tracks (note that ASO corresponds to academic track, ie only track in an elite school)
replace onderwijsvorm=subinstr(onderwijsvorm," ","",.)
gen ASO=0 if onderwijsvorm=="ASO" |onderwijsvorm=="BSO" | onderwijsvorm=="GSO"  | onderwijsvorm=="KSO"  | onderwijsvorm=="TSO" 
gen BSO=0 if onderwijsvorm=="ASO" |onderwijsvorm=="BSO" | onderwijsvorm=="GSO"  | onderwijsvorm=="KSO"  | onderwijsvorm=="TSO" 
gen GSO=0 if onderwijsvorm=="ASO" |onderwijsvorm=="BSO" | onderwijsvorm=="GSO"  | onderwijsvorm=="KSO"  | onderwijsvorm=="TSO" 
gen KSO=0 if onderwijsvorm=="ASO" |onderwijsvorm=="BSO" | onderwijsvorm=="GSO"  | onderwijsvorm=="KSO"  | onderwijsvorm=="TSO" 
gen TSO=0 if onderwijsvorm=="ASO" |onderwijsvorm=="BSO" | onderwijsvorm=="GSO"  | onderwijsvorm=="KSO"  | onderwijsvorm=="TSO" 

replace ASO=1 if onderwijsvorm=="ASO" 
replace BSO=1 if onderwijsvorm=="BSO" 
replace GSO=1 if onderwijsvorm=="GSO" 
replace KSO=1 if onderwijsvorm=="KSO" 
replace TSO=1 if onderwijsvorm=="TSO" 

save "Output/admgr",replace


log close

