close all
var Xi P M F1 F2 F3 F4 F5 COM SEC;

varexo E EP EM M1 M2 M3 M4 M5;
 
parameters l1 l2 l3 l4 l5 
 rhop2 rhop3 rhop4 rhop5 rhop6 rhop7 rhop8 rhop9 rhop10 rhop11 rhop12 rhop13 rhopsum;

model(linear); 
# rhop1 = rhopsum - (rhop2+rhop3+rhop4+rhop5+rhop6+rhop7+rhop8+rhop9+rhop10+rhop11+rhop12+rhop13);
Xi = l1*F1 + l2*F2 + l3*F3 + l4*F4 + l5*F5 + P + M + E;
P = rhop1*P(-1) + rhop2*P(-2) + rhop3*P(-3) + rhop4*P(-4) + rhop5*P(-5) +
    rhop6*P(-6) + rhop7*P(-7) + rhop8*P(-8) + rhop9*P(-9) + rhop10*P(-10) + 
    rhop11*P(-11) + rhop12*P(-12) + rhop13*P(-13) + EP ;
M = EM - EM(-1);

F1 = M1;
F2 = M2;
F3 = M3;
F4 = M4;
F5 = M5;

// for comparison to BGM:
COM = l1*F1 + l2*F2 + l3*F3 + l4*F4 + l5*F5;
SEC = P + M + E;

end; 

shocks;
var M1; stderr 0.2981;
var M2; stderr 0.2093;
var M3; stderr 0.1693;
var M4; stderr 0.1544;
var M5; stderr 0.1316;
end;

estimated_params;
stderr E,    .5,0.00001,1.5;  // 0.000001
stderr EP,   .5,0.00001,1.5;  
stderr EM,   .5,0.00001,1.5;  

rhopsum,    .5, -10, 0.9999;
rhop2,       0, -5, 5;
rhop3,       0, -5, 5;
rhop4,       0, -5, 5;
rhop5,       0, -5, 5;
rhop6,       0, -5, 5;
rhop7,       0, -5, 5;
rhop8,       0, -5, 5;
rhop9,       0, -5, 5;
rhop10,      0, -5, 5;
rhop11,      0, -5, 5;
rhop12,      0, -5, 5;
rhop13,      0, -5, 5;

l1,0,-5,5;
l2,0,-5,5;
l3,0,-5,5;
l4,0,-5,5;
l5,0,-5,5;

end;

varobs Xi F1 F2 F3 F4 F5;

estimation(mode_compute=1, datafile=dynadatam, first_obs=1, lik_init=1, nograph);