%=========================================================================
% Estimate unobs component model for each series
%=========================================================================

% full set: [112:141 143:207 209:303] 
% to complement earlier run: 112:141 143:207 209:221
% trouble: 229 236
ind=[112:141 143:207 209:303]; 

for i = ind 
    i
    close all
    % 1. load and save relevant files (dynare clears)
    load data_X652_5F653
    save predynm i
    % 2. make data
    Xi = X(:,i);
    F1  = F(:,1);
    F2  = F(:,2);
    F3  = F(:,3);
    F4  = F(:,4);
    F5  = F(:,5);
    save dynadatam Xi F1 F2 F3 F4 F5 i     % data ready for dynare
    
    % 3. estimate unobserved components model
    dynare MA1_AR13

    % reload index, as dynare has run
    load predynm
    eval(['save oo' num2str(i) 'MA1_AR13'])  % store dynare output
end