#delimit;
clear all;
set more off;
set memory 1500m;
set matsize 1000;
global basedirectory "C:\Files\published\gas\upload data\";
graph set eps fontface Garamond;
graph set print logo off;

*Monthly Prices Gasoline By State (83-07);
*In DOE site, select "area" for the State breakdown, open EXCEL file, delete heading (top two rows), and save as .csv file;
*http://tonto.eia.doe.gov/dnav/pet/pet_pri_allmg_d_nus_PTA_cpgal_m.htm;

*Prime Supplier Sales Volumes;
*In DOE site, select "area" for the State breakdown, open EXCEL file, delete heading (top two rows), and save as .csv file;
*http://tonto.eia.doe.gov/dnav/pet/pet_cons_prim_dcu_SDE_m.htm;

*----------------------------------------*;
*--------------VOLUMES-------------------*;
*----------------------------------------*;
insheet using "${basedirectory}pet_cons_prim_a_EPM0_P00_Mgalpd_m.csv";
rename alab xAL; rename alas xAK;   rename ariz xAZ;   rename arka xAR;   rename cali xCA;  rename colo xCO;   rename conn xCT;
rename dela xDE; rename dist xDC;   rename flor xFL;   rename geor xGA;   rename hawa xHI;  rename idah xID;   rename illi xIL; 
rename indi xIN; rename iowa xIA;   rename kans xKS;   rename kent xKY;   rename loui xLA;  rename main xME;   rename mary xMD; 
rename mass xMA; rename mich xMI;   rename minn xMN;   rename missi xMS;  rename misso xMO; rename mont xMT;   rename nebr xNE; 
rename neva xNV; rename newh xNH;   rename newj xNJ;   rename newm xNM;   rename newy xNY;  rename northc xNC; rename northd xND; 
rename ohio xOH; rename okla xOK;   rename oreg xOR;   rename penn xPA;   rename rhod xRI;  rename southc xSC; rename southd xSD;
rename tenn xTN; rename texa xTX;   rename utah xUT;   rename verm xVT;   rename virg xVA;  rename wash xWA;   rename west xWV;   
rename wisc xWI; rename wyom xWY;   rename usto xUS;
drop padd* newenglandpadd centralatlanticpadd loweratlanticpadd;
reshape long x, i(date) j(state) string; rename x volume; sort state date; save "${basedirectory}temp1.dta", replace; clear;

*----------------------------------------*;
*--------------PRICES--------------------*;
*----------------------------------------*;
insheet using "${basedirectory}PET_PRI_ALLMG_A_EPM0_PTA_CPGAL_M.csv";
rename alab xAL; rename alas xAK;   rename ariz xAZ;   rename arka xAR;   rename cali xCA;  rename colo xCO;   rename conn xCT;
rename dela xDE; rename dist xDC;   rename flor xFL;   rename geor xGA;   rename hawa xHI;  rename idah xID;   rename illi xIL; 
rename indi xIN; rename iowa xIA;   rename kans xKS;   rename kent xKY;   rename loui xLA;  rename main xME;   rename mary xMD; 
rename mass xMA; rename mich xMI;   rename minn xMN;   rename missi xMS;  rename misso xMO; rename mont xMT;   rename nebr xNE; 
rename neva xNV; rename newh xNH;   rename newj xNJ;   rename newm xNM;   rename newy xNY;  rename northc xNC; rename northd xND; 
rename ohio xOH; rename okla xOK;   rename oreg xOR;   rename penn xPA;   rename rhod xRI;  rename southc xSC; rename southd xSD;
rename tenn xTN; rename texa xTX;   rename utah xUT;   rename verm xVT;   rename virg xVA;  rename wash xWA;   rename west xWV;   
rename wisc xWI; rename wyom xWY;   rename usto xUS;
drop padd* newenglandpadd centralatlanticpadd loweratlanticpadd;
reshape long x, i(date) j(state) string; rename x price; sort state date; 
merge state date using "${basedirectory}temp1.dta"; drop _merge; erase "${basedirectory}temp1.dta";

*----------------------------------------*;
*--------USE STANDARD STATE FIPS---------*;
*----------------------------------------*;
gen statefip=.;   
replace statefip=1 if state=="AL";  replace statefip=2 if state=="AK";  replace statefip=4 if state=="AZ";  replace statefip=5 if state=="AR";
replace statefip=6 if state=="CA";  replace statefip=8 if state=="CO";  replace statefip=9 if state=="CT";  replace statefip=10 if state=="DE";
replace statefip=11 if state=="DC"; replace statefip=12 if state=="FL"; replace statefip=13 if state=="GA"; replace statefip=15 if state=="HI";
replace statefip=16 if state=="ID"; replace statefip=17 if state=="IL"; replace statefip=18 if state=="IN"; replace statefip=19 if state=="IA";
replace statefip=20 if state=="KS"; replace statefip=21 if state=="KY"; replace statefip=22 if state=="LA"; replace statefip=23 if state=="ME";
replace statefip=24 if state=="MD"; replace statefip=25 if state=="MA"; replace statefip=26 if state=="MI"; replace statefip=27 if state=="MN";
replace statefip=28 if state=="MS"; replace statefip=29 if state=="MO"; replace statefip=30 if state=="MT"; replace statefip=31 if state=="NE";
replace statefip=32 if state=="NV"; replace statefip=33 if state=="NH"; replace statefip=34 if state=="NJ"; replace statefip=35 if state=="NM";
replace statefip=36 if state=="NY"; replace statefip=37 if state=="NC"; replace statefip=38 if state=="ND"; replace statefip=39 if state=="OH";
replace statefip=40 if state=="OK"; replace statefip=41 if state=="OR"; replace statefip=42 if state=="PA"; replace statefip=44 if state=="RI";
replace statefip=45 if state=="SC"; replace statefip=46 if state=="SD"; replace statefip=47 if state=="TN"; replace statefip=48 if state=="TX";
replace statefip=49 if state=="UT"; replace statefip=50 if state=="VT"; replace statefip=51 if state=="VA"; replace statefip=53 if state=="WA";
replace statefip=54 if state=="WV"; replace statefip=55 if state=="WI"; replace statefip=56 if state=="WY"; rename state statename;
save "${basedirectory}temp2.dta", replace;

*----------------------------------------*;
*-------------PREPARE CPI DATA-----------*;
*----------------------------------------*;
*CPI downloaded from BLS, all urban consumers, excluding energy;
insheet using "${basedirectory}cpi.csv", clear;
rename value cpi; rename period mon; drop seriesid;
gen month=0; replace month=1 if mon=="Jan"; replace month=2  if mon=="Feb"; replace month=3  if mon=="Mar"; replace month=4  if mon=="Apr"; 
		 replace month=5 if mon=="May"; replace month=6  if mon=="Jun"; replace month=7  if mon=="Jul"; replace month=8  if mon=="Aug";  
		 replace month=9 if mon=="Sep"; replace month=10 if mon=="Oct"; replace month=11 if mon=="Nov"; replace month=12 if mon=="Dec"; drop mon;
drop if year<1989; drop if year>=2008 & month>3; sort year month; save "${basedirectory}cpi.dta", replace; clear;

*----------------------------------------*;
*--------CREATE YEAR AND MONTH-----------*;
*----------------------------------------*;
use "${basedirectory}temp2.dta", clear; erase "${basedirectory}temp2.dta";
gen year=real(substr(date,5,9));
gen mon=substr(date,1,3); drop date;
gen month=0; replace month=1 if mon=="Jan"; replace month=2  if mon=="Feb"; replace month=3  if mon=="Mar"; replace month=4  if mon=="Apr"; 
		 replace month=5 if mon=="May"; replace month=6  if mon=="Jun"; replace month=7  if mon=="Jul"; replace month=8  if mon=="Aug";  
		 replace month=9 if mon=="Sep"; replace month=10 if mon=="Oct"; replace month=11 if mon=="Nov"; replace month=12 if mon=="Dec"; drop mon;
gen date=year+(month-1)/12;

*----------------------------------------*;
*--------CREATE REGION DUMMIES-----------*;
*----------------------------------------*;
gen R1=0; replace R1=1 if statefip==09 | statefip==23 | statefip==25 | statefip==33 | statefip==44 | statefip==50
	 | statefip==34 | statefip==36 | statefip==42;
gen R2=0; replace R2=1 if statefip==18 | statefip==17 | statefip==26 | statefip==39 | statefip==55 | statefip==19
	 | statefip==20 | statefip==27 | statefip==29 | statefip==31 | statefip==38 | statefip==46;
gen R3=0; replace R3=1 if statefip==10 | statefip==11 | statefip==12 | statefip==13 | statefip==24 | statefip==37
	 | statefip==45 | statefip==51 | statefip==54 | statefip==1 | statefip==21 | statefip==28 | statefip==47
	 | statefip==5 | statefip==22 | statefip==40 | statefip==48;
gen R4=0; replace R4=1 if statefip==4 | statefip==8 | statefip==16 | statefip==35 | statefip==30 | statefip==49
	 | statefip==32 | statefip==56 | statefip==2 | statefip==6 | statefip==15 | statefip==41 | statefip==53;

*----------------------------------------*;
*----IMPUTE MISSING PRICES AND VOLUMES---*;
*----------------------------------------*;
bysort statefip: ipolate volume date, gen(i_volume) epolate;
bysort statefip: ipolate price date, gen(i_price) epolate;
replace volume=i_volume if volume==.;
replace price=i_price   if price==.;
drop i_volume i_price;

*-----------------------------------------------------*;
*----------MERGE WITH UNEMPLOYMENT DATA---------------*;
*-----------------------------------------------------*;
sort statefip year month;
merge statefip year month using "${basedirectory}Unemployment Rates from BLS\unemp.dta";
keep if _merge==3; drop _merge;

*-----------------------------------------------------*;
*----------MERGE WITH POPULATION DENSITY--------------*;
*-----------------------------------------------------*;
sort statefip year month;
merge statefip year month using "${basedirectory}Pop Density from Census\popdensity.dta";
keep if _merge==3; drop _merge;

*-----------------------------------------------------*;
*----------------MERGE WITH TAX DATA------------------*;
*-----------------------------------------------------*;
*THE DOT DATA DESCRIBE ONLY THE PER UNIT TAX, AD VALOREM TAXES ARE ADDED IN BELOW;
drop if statefip==.;
sort statefip year month;
merge statefip year month using "${basedirectory}Tax Rates from Highway Statistics\taxrates.dta";
keep if _merge==3; drop _merge;

*---------------------------------------------------*;
*-----INCORPORATE AD VALOREM TAX WHERE NECESSARY----*;
*---------------------------------------------------*;
gen Utax=statetax+fedtax;   *Utax denotes the tax, here nominal, in cents per gallon;
gen AfterTaxPrice=price+statetax+fedtax;
replace AfterTaxPrice=(price+statetax+fedtax)*(1.06) if state=="California";
replace AfterTaxPrice=(price+fedtax)*(1.04)+statetax if state=="Georgia" & year>=1992;
replace AfterTaxPrice=(price+fedtax)*(1.03)+statetax if state=="Georgia" & year<1992;
replace AfterTaxPrice=(price)*(1.04)+statetax+fedtax if state=="Hawaii";
replace AfterTaxPrice=(price)*(1.06)+statetax+fedtax if state=="Illinois" & year<1990;
replace AfterTaxPrice=(price)*(1.0625)+statetax+fedtax if state=="Illinois" & year>=1990 & year<=2000;
replace AfterTaxPrice=(price)*(1.06)+statetax+fedtax if state=="Indiana" & year>=2003;
replace AfterTaxPrice=(price)*(1.05)+statetax+fedtax if state=="Indiana" & year<2003;
replace AfterTaxPrice=(price+fedtax)*(1.06)+statetax if state=="Michigan" & year>=1994;
replace AfterTaxPrice=(price+fedtax)*(1.04)+statetax if state=="Michigan" & year<1994;
replace AfterTaxPrice=(price+statetax+fedtax)*(1.06) if state=="Mississippi" & year<=1987;
replace AfterTaxPrice=(price+fedtax)*(1.04)+statetax if state=="New York";
replace AfterTaxPrice=(price+fedtax)*(1.0425)+statetax if state=="New York" & ((year==2003 & month>=6) | year==2004 | (year==2005 & month<6));
replace AfterTaxPrice=(price+fedtax+statetax)*(1.02) if state=="Virginia" & year<=1994;

*-----------------------------------------------------*;
*----------------DEFLATE USING CPI--------------------*;
*-----------------------------------------------------*;
*Base period January 2008 (cpi=212.281);
sort year month;
merge year month using "${basedirectory}cpi.dta";
replace cpi=(cpi/212.281)*100;
drop if _merge!=3; drop _merge;
replace AfterTaxPrice=AfterTaxPrice/(cpi); 
replace Utax=Utax/cpi;
save "${basedirectory}prices&volumes.dta", replace;

*-----------------------------------------------------*;
*---------MAKE A BAR CHART WITH TAX VARIANCE----------*;
*-----------------------------------------------------*;
use "${basedirectory}prices&volumes.dta", clear;
bysort state: egen sd=sd(Utax); bysort state: egen mean=mean(Utax); gen sdpercent=sd/mean;
graph hbar (sd) Utax, over(state, sort(1) descending) ysize(12) ytitle(`"Standard Deviation (percent)"')
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(,nogrid); 
	*graph export "${basedirectory}CSVariationTax.eps", replace;
drop sd mean sdpercent;

*-----------------------------------------------------*;
*---------CREATE NATIONAL PRICES, VOLUMES-------------*;
*-----------------------------------------------------*;
use "${basedirectory}prices&volumes.dta", clear;
replace volume=volume/1000;  *Millions of Gallons Per Day;
replace volume=int(volume);
collapse (rawsum) volume (mean) month AfterTaxPrice Utax fedtax statetax [fweight=volume], by(date);
gen year=date-(month-1)/12; sort year month;
merge year month using "${basedirectory}Unemployment Rates from BLS\nationalunemp.dta";
keep if _merge==3; drop _merge;
sort date; save "${basedirectory}national.dta", replace;

*-----------------------------------------------------*;
*---------GRAPH NATIONAL PRICES AND TAXES-------------*;
*-----------------------------------------------------*;
use "${basedirectory}national.dta", clear;
scatter AfterTaxPrice date, connect(l) ms(p) msize(vtiny)
	xtitle("Year") ytitle("Price per Gallon After Tax in 2008 Dollars") title(Gasoline Price)
	note(`"Source: U.S. Department of Energy, "Petroleum Marketing Monthly Report"."') xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(,nogrid);
*graph export "${basedirectory}USprices.eps", replace; 
scatter Utax date, connect(l) ms(p) msize(vtiny)
	xtitle("Year") ytitle("Tax Per Gallon in 2008 Dollars") title(Gasoline Tax)
	note(`"Source: U.S. Department of Transportation, "Highway Statistics", 1991-2008."') xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(,nogrid);
*graph export "${basedirectory}UStax.eps", replace; 
*outsheet AfterTaxPrice using "${basedirectory}USprice.txt", replace names;
*outsheet Utax          using "${basedirectory}US_utax.txt", replace names;

*-----------------------------------------------------*;
*---------COMPARE NATIONAL PRICES TO BLS--------------*;
*-----------------------------------------------------*;
*The BLS measure is the U.S. city average price for unleaded regular gasoline per gallon/3.785 liters;
*The BLS measure includes excise taxes and sales taxes, use January 1980 as base year;
clear; insheet using "${basedirectory}BLSprices.csv";
gen month=.; replace month=1  if period=="Jan"; replace month=2  if period=="Feb"; replace month=3  if period=="Mar";
             replace month=4  if period=="Apr"; replace month=5  if period=="May"; replace month=6  if period=="Jun";
             replace month=7  if period=="Jul"; replace month=8  if period=="Aug"; replace month=9  if period=="Sep";
             replace month=10 if period=="Oct"; replace month=11 if period=="Nov"; replace month=12 if period=="Dec";
sort year month; merge year month using "${basedirectory}cpi.dta"; keep if _merge==3; drop _merge;
replace cpi=(cpi/205.993)*100;
replace value=(value/cpi)*100;
gen date=year+(month-1)/12; sort date;
merge date using "${basedirectory}national.dta"; keep if _merge==3;
scatter AfterTaxPrice value date, connect(l l) ms(p p) msize(vtiny)
	xtitle("Year") ytitle("Price per Gallon in 2008 Dollars") xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(,nogrid)
	legend(order(1 2) col(1) label(1 "E.I.A. Data") label(2 "B.L.S. Data"));
*graph export "${basedirectory}BLScomparison.eps", replace; 

*-----------------------------------------------------*;
*---------GRAPH NATIONAL VOLUMES----------------------*;
*-----------------------------------------------------*;
use "${basedirectory}national.dta", clear;
scatter volume date, connect(l) ms(p) msize(vsmall)
	xtitle("Year") ytitle("Millions of Gallons Per Day") title("Gasoline Consumption")  
	note(`"Source: U.S. Department of Energy, "Petroleum Marketing Monthly Report"."') xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(,nogrid);
*graph export "${basedirectory}USvolumes.eps", replace; 
*outsheet volume using "${basedirectory}USvolume.txt", replace names;

*-----------------------------------------------------*;
*---------GRAPH TAX VARIANCE OVER TIME----------------*;
*-----------------------------------------------------*;
use "${basedirectory}prices&volumes.dta", clear;
replace volume=int(volume);
collapse (sd) Utax [fweight=volume], by(date); sort date; 
scatter Utax date, connect(l) ms(p) msize(vsmall) 
	xtitle("Year") ytitle("Standard Deviation in 2008 Dollars") xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(,nogrid);
	*graph export "${basedirectory}CSVariationTaxOverTime.eps", replace; 

*-----------------------------------------------------*;
*---------GRAPH TAX CHANGES OVER TIME-----------------*;
*-----------------------------------------------------*;
use "${basedirectory}prices&volumes.dta", clear;
replace volume=int(volume);
gen yearmonth=ym(year,month);
tsset statefip yearmonth, monthly; gen diffstatetax=d1.statetax; 
gen increase=0; replace increase=1 if diffstatetax>=2  & diffstatetax!=.;
gen decrease=0; replace decrease=1 if diffstatetax<=-2 & diffstatetax!=.;
collapse (rawsum) increase decrease, by(date); sort date; 
twoway bar increase date, barw(.01)	xtitle("Year") ytitle("Number of Increases") xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(1(1)6,nogrid);
	*graph export "${basedirectory}TimingTaxIncreases.eps", replace; 
twoway bar decrease date, barw(.01)	xtitle("Year") ytitle("Number of Decreases") xlabel(1989(3)2007)
	plotregion(style(none)) graphregion(fcolor(white)) ylabel(1(1)6,nogrid);
	*graph export "${basedirectory}TimingTaxDecreases.eps", replace; 

*-----------------------------------------------------*;
*-------------KEEP TEXT VERSION OF DATA---------------*;
*-----------------------------------------------------*;
use "${basedirectory}prices&volumes.dta", clear; 
keep statename volume AfterTaxPrice Utax date; sum;
reshape wide volume AfterTaxPrice Utax, i(date) j(statename) string;
sort date; drop date;
*outsheet volume*         using "${basedirectory}volume.txt", replace names;
*outsheet AfterTaxPrice*  using "${basedirectory}price.txt", replace names;
*outsheet Utax*           using "${basedirectory}Utaxes.txt", replace names;

*-----------------------------------------------------*;
*-----FIRST DIFFERENCING NATIONAL SPECIFICATION-------*;
*-----------------------------------------------------*;
use "${basedirectory}national.dta", clear; 
gen logprice=log(AfterTaxPrice); gen logvolume=log(volume); gen logtax=log(Utax); 
replace date=date*12; tsset date; quietly tab month, gen(M); drop M12; 

*REPORT VOLUME-WEIGHTED PRICE AND TAX IN MARCH 2008;
quietly sum Utax if year==2008 & month==3; local meantax=r(mean); 
quietly sum AfterTaxPrice if year==2008 & month==3; local meanprice=r(mean); 

*FD RESULTS;
quietly reg d.logprice d.logtax M*; test d.logtax;
quietly reg d.logvolume d.logprice M*; lincom _b[d.logprice]; display e(r2); display e(N);
lincom _b[d.logprice]*.10/`meanprice'*100; *PERCENTAGE EFFECT OF 10 CENT INCREASE;

*IV RESULTS;
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) M*; lincom _b[d.logprice]; display e(N);
lincom _b[d.logprice]*.10/`meanprice'*100; *PERCENTAGE EFFECT OF 10 CENT INCREASE;

*MOREIRA AND TWO STAGE IV; 
condivreg d.logvolume (d.logprice=d.logtax) M*;
quietly reg d.logprice d.logtax M*; lincom _b[d.logtax]; test d.logtax; display e(r2); 
quietly reg d.logvolume d.logtax M*; lincom _b[d.logtax]; test d.logtax; display e(r2); 

*-----------------------------------------------------*;
*-----FIRST DIFFERENCES STATE SPECIFICATION-----------*;
*-----------------------------------------------------*;
*PREPARE DATA;
use "${basedirectory}prices&volumes.dta", clear;
gen logprice=log(AfterTaxPrice); gen logvolume=log(volume); gen logtax=log(Utax); gen logpopdensity=log(popdensity);
gen timevariable=year*12+month; quietly tabulate timevariable, gen(T); drop T1 T231; tsset statefip timevariable;

*REPORT VOLUME-WEIGHTED PRICE AND TAX IN MARCH 2008;
egen wmean=wtmean(Utax) if year==2008 & month==3, weight(volume); sum wmean; local meantax=r(mean); drop wmean;
egen wmean=wtmean(AfterTaxPrice) if year==2008 & month==3, weight(volume); sum wmean; local meanprice=r(mean); drop wmean;

*FD SPECIFICATION;
quietly reg d.logvolume d.logprice T*, cluster(statefip); lincom _b[d.logprice]; display e(r2); display e(N);
lincom _b[d.logprice]*.10/`meanprice'*100; *PERCENTAGE EFFECT OF 10 CENT INCREASE;

*IV SPECIFICATION;
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) T*, cluster(statefip); lincom _b[d.logprice]; 
lincom _b[d.logprice]*.10/`meanprice'*100; *PERCENTAGE EFFECT OF 10 CENT INCREASE;

*MOREIRA AND TWO STAGE IV;
condivreg d.logvolume (d.logprice=d.logtax) T*; 
quietly reg d.logprice d.logtax T*, cluster(statefip); lincom _b[d.logtax]; lincom _b[d.logtax]*1.81/.45; test d.logtax; display e(r2); 
quietly reg d.logvolume d.logtax T*, cluster(statefip); lincom _b[d.logtax]; test d.logtax; display e(r2);

*---------------------------------------------------*;
*--------FOCUSING ONLY ON NOMINAL CHANGES-----------*;
*---------------------------------------------------*;
*PREPARE DATA;
use "${basedirectory}prices&volumes.dta", clear;
gen logprice=log(AfterTaxPrice); gen logvolume=log(volume); gen logtax=log(Utax); gen logpopdensity=log(popdensity);
gen timevariable=year*12+month; quietly tabulate timevariable, gen(T); drop T1 T231; tsset statefip timevariable;

*TABLE 4 -- Nominal Tax Changes Only;
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax!=0, cluster(statefip); lincom _b[d.logprice]; display e(N);
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax<=-1 | d.statetax>=1, cluster(statefip); lincom _b[d.logprice]; display e(N);
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax<=-2 | d.statetax>=2, cluster(statefip); lincom _b[d.logprice]; display e(N);
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax>0, cluster(statefip); lincom _b[d.logprice]; display e(N);
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax>=1, cluster(statefip); lincom _b[d.logprice]; display e(N);
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax>=2, cluster(statefip); lincom _b[d.logprice]; display e(N);

*REPORT INSTRUMENT F-STATISTICS;
quietly reg d.logprice d.logtax if d.statetax!=0, cluster(statefip); test d.logtax;
quietly reg d.logprice d.logtax if d.statetax<=-1 | d.statetax>=1, cluster(statefip); test d.logtax;
quietly reg d.logprice d.logtax if d.statetax<=-2 | d.statetax>=2, cluster(statefip); test d.logtax;
quietly reg d.logprice d.logtax if d.statetax>0, cluster(statefip); test d.logtax;
quietly reg d.logprice d.logtax if d.statetax>=1, cluster(statefip); test d.logtax;
quietly reg d.logprice d.logtax if d.statetax>=2, cluster(statefip); test d.logtax;

*Nominal Tax Changes Only -- With Month Fixed Effects;
quietly tab month, gen(M); 
quietly ivregress gmm d.logvolume M* (d.logprice=d.logtax) if d.statetax>0, cluster(statefip); lincom _b[d.logprice]; display e(N);

*-----------------------------------------------------*;
*----ALTERNATIVE SPECIFICATIONS, NOMINAL CHANGES------*;
*-----------------------------------------------------*;
*PREPARE DATA;
use "${basedirectory}prices&volumes.dta", clear;
gen logprice=log(AfterTaxPrice); gen logvolume=log(volume); gen logtax=log(Utax); gen logpopdensity=log(popdensity);
gen timevariable=year*12+month; quietly tabulate timevariable, gen(T); drop T1 T231; tsset statefip timevariable;

*BASELINE ESTIMATE;
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) if d.statetax>0, cluster(statefip); lincom _b[d.logprice];

*INCLUDING CHANGE IN UNEMPLOYMENT RATE (MEAN UNEMPLOYMENT RATE IS 5.12);
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) d.unemployment if d.statetax>0, cluster(statefip); lincom _b[d.logprice]; 

*INCLUDING CHANGE IN LOG POPULATION DENSITY (MEAN POP DENSITY IS 362.2 (PERSONS PER SQ MILE));
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) d.logpopdensity if d.statetax>0, cluster(statefip); lincom _b[d.logprice];

*ALL STATE-LEVEL CONTROLS;
quietly ivregress 2sls d.logvolume (d.logprice=d.logtax) d.unemployment d.logpopdensity if d.statetax>0, cluster(statefip); lincom _b[d.logprice]; 

*MEDIAN IV - BOOTSTRAP STANDARD ERRORS;
gen dlogprice=d.logprice; gen dlogtax=d.logtax; gen dlogvolume=d.logvolume; gen dstatetax=d.statetax; tsset, clear;
program medianIV, rclass;
quietly qreg dlogprice dlogtax if dstatetax>0; lincom _b[dlogtax];  local beta1=_b[dlogtax];
quietly qreg dlogvolume dlogtax if dstatetax>0; lincom _b[dlogtax]; local beta2=_b[dlogtax];
gen beta=`beta2'/`beta1'; sum beta; return scalar beta=r(mean); drop beta; end program; 
bootstrap r(beta), reps(100) cluster(statefip): medianIV;

*ERASE TEMPORARY FILES;
erase "${basedirectory}national.dta";
erase "${basedirectory}prices&volumes.dta";
erase "${basedirectory}cpi.dta";
