function [w,m] = west(F,C,D,n)
%        [w,m] = west(F,C,D,n)
% estimate weights for LR of Heu=(C*eta=0, D*eta>=0) against
% Hee=(C*eta=0, D*eta=0) where F is information for eta under Hee
% if f=rank(F)-rank(C) and dx=rank(D*X), w has f elements but the first
% f-dx are always 0; m=[norm-projection norm-residual]
% weights as for T01

% - preliminaries
  [p,p]=size(F);  tol=10^(-12); 
  out=zeros(n,3); [c,q]=size(C);
  [d,r]=size(D); 
  if c==0, q=r; end
  if ((p~=q)+(p~=r)),
    error('check dim of C, D');
  end
  c=rank(C); cd=rank([C;D])-c;

% - linear model
  if c == 0,
    X=eye(p); 
  else,
    X=null(C); 
  end
  C=[]; F=X'*F*X;
  L=chol(inv(F))';
%  Mi=inv(chol(F));
%  D=D*X*Mi; 
  D=D*X*L;

% - reduce dimension of space
  p=p-c; 

% - generate normal vectors
  Z=randn(p,n); 

disp('____o____1____o____2____o____3____o____4____o____5____o____6')
Qn=ceil(n*(1:60)/60);

% - use lde
  for i=1:n,
    z=Z(:,i);
    eta=lde(z,C,D); 
  % detect dimensions 
    id=find(D*eta <= tol); 
    id=D(id,:); % id=rank(id,tol); 
    id=p-size(null(id),2);
    out(i,1)=id;
    if any(i == Qn),
      fprintf('x');    %  -  To see the speed.
    end

  % quadractic forms
    if nargout == 2,
      Qt=z'*z; Q1=z-eta;
      Q1=Q1'*Q1;
      Q0=Qt-Q1;
      out(i,2:3)=[Q0 Q1];
    end
  end

% - weights and averages
  w=zeros(cd+1,1); m=[w w];
  for ic=0:cd,
    h=find(out(:,1)==ic); w(ic+1)=length(h); 
    if nargout == 2,
      if w(ic+1) == 0, m(ic+1,:)=[p-ic,ic];
      elseif w(ic+1) > 0,
        m(ic+1,:)=mean(out(h,2:3),1);
      end
    end
  end
  m=flipud(m);  w=flipud(w)/n;
  fprintf('\n')