function y = tabel(M,last)
%        y = tabel(M,last) 
% build the frequency vector y corresponding to the data matrix M
% the first level on any variable in M is 0; in y, the variable on the right run faster
% last (optiona) is the row vector with elements equal to the last category of any variable

% determines numeber of categories
  if nargin<2,
     es = max(M)+1;
  else
     es = last+1;
  end
% inizialize  
  y = zeros(prod(es),1);
  es = [es 1]; es(1) = [];
  es = fliplr(cumprod(fliplr(es)))';
  ind = M*es+1;
% iterate  
  for i = 1:size(M,1),
     y(ind(i)) = y(ind(i))+1;
  end
