function M = sq(J,t)
% -      M = sq(J,t)
% - costruisce matrice formata da tutti
% - i possibili vettori riga composti da 
% - t  1 e J-t  0. Se t  omesso genera 
% - la matrice dello sviluppo binomiale

  M=[];
  if J==0, M=zeros(1,0);;
  elseif nargin==2,           % se t  presente
      if t == J,          % se sono tutti elementi 1
          M=ones(1,J); 

        elseif t>1,       % se sono sia 1 che 0
          for i=1:J-t+1, 
            S=sq(J-i,t-1);
            r=size(S,1);
            T=[zeros(r,i-1) ones(r,1) S];
            M=[T;M];
          end

        elseif t==1,      % se c' un solo elemento 1       
          M=zeros(J);
          for j=1:J, M(j,J-j+1)=1; end

        else 
          M=zeros(1,J);   % se non ci sono elementi 1
      end

    else                % se t  omesso
      if J==1,
          M = [0;1];
        else
          T = sq(J-1);  nt=size(T,1);
          M = [ zeros(nt,1) T; ones(nt,1) T];
      end
  end
