function Y = shape(X,nr)
%  -  y = shape(x,nr) returns a matrix with nr rows and elements
%     taken columnwise from X.  An error results if the number
%     of elements of X is not a multiple of nr
 
[r,c] = size(X); n=r*c; nc=floor(n/nr);
if n~= nr*nc,
	error('Matrix must have M*N elements.')
end
Y = zeros(nr,nc);
Y(:) = X;
