function [q,f] = qtile(y,dim) 
%        [q,f] = qtile(y,dim) 
% . given a vector y returns the vector of quantiles
% . of order dim and the vector of actual frequencies
% . n (the quantile is the largest value in each set) 
% . if dim is omitted, q is the vector of distinct values

% -> preliminaries
  [m,n]=size(y); Y=y;
  Y=sort(y);
  if (m > n), Y=Y'; n=m;  end

%  - distinct values
if nargin == 1,
   i=(2:n); 
   in=[1 (Y(i)-Y(i-1)) >= 10^(-12)];
   q=Y(find(in)); 
   f=sum(abs(Y'*ones(1,length(q))-ones(n,1)*q) < 10^(-12));

%  -  quantiles
else,
  N=n*(1:dim-1)/dim; 
  N=ceil(N);  q=Y(N); 
  f=[N n]-[0 N];
end