function [LL,be,F,P] = newmult(y,V,G,Ma,Co,C,D,be,P)
%        [LL,be,F,P] = newmult(y,V,G,Ma,Co,C,D,be,P)
% multivariate responsese by Atchicson-ilvey
% fits equality and inequality constraints to
% regression parameters of a multiway table as 
% defined by the function model

% preliminaries
  n=size(y,1); t=max(y); ep=10^(-80);
  acc=10^(-4); k=size(be,1);
  [rc cc]=size(C);  [rd,cd]=size(D);
  if k ~= cc, disp('check col C'); end
  if k ~= cd, disp('check col D'); end
  if rc>0, Z=null(C); end
  seta=size(Co,1);  H=Hmat(G);

% initialize
  QK=ceil(n*(1:70)/70);  
  if nargin<9,
    disp('----o----1----o----2----o----3----o----4----o----5----o----6----o----7')
    P=zeros(t,n); disp('initial probabilities')
    for iu=1:n, % initialize P
      [X,of] = model(V(iu,:));
       eta=X*be+of; [p,err] = binve(Co,Ma,G,eta);
       if err==1, disp(iu); return; end
       p=max(p,ep); p=p/sum(p);  P(:,iu)=p;
      if any(iu == QK), fprintf('+');  end           
    end
    fprintf('\n');    
  end
  
% Iterate  
  it=0; test=0; mit=50;
  diss=1;  LL0=0; dis=1; dm=1;
  while it<mit & dis+diss>acc,
    LL=0; s=zeros(k,1); F=zeros(k); dis=0; t0=clock;
    for iu=1:n,  % compute theta
      X = model(V(iu,:)); p=P(:,iu); 
      p=P(:,iu); 
      if it>0,
        Op=diag(p)-p*p'; 
        R=Co*diagv((Ma*p).^(-1),Ma)*Op*G;
        while rcond(R)<10^(-12),
          R=R+eye(seta);
        end             
        R=inv(R); delta=X*be-Co*log(Ma*p);
        th=H*log(p)+R*delta;
        dm=max(th)-min(th); 
        p=exp(G*th); p=p/sum(p);
        p=max(p,ep); p=p/sum(p);  P(:,iu)=p;
      end
      LL=LL+log(p(y(iu)));
      Op=diag(p)-p*p'; 
      R=Co*diagv((Ma*p).^(-1),Ma)*Op*G;
      while rcond(R)<10^(-12),
        R=R+eye(seta);
      end      
      R=inv(R); eta=Co*log(Ma*p);
      delta=X*be-eta;
      dis=dis+sum(abs(delta)); 
      A=G*R*X; B=R'*G'*Op*A; F=F+B'*X;
      s=s+(A(y(iu),:)'-A'*p)+B'*eta;% versione 1
      if any(iu == QK), fprintf('-');  end         
    end
    fprintf('\n');  
    while rcond(F)<10^(-10),
      F=F+mean(abs(diag(F)))*eye(k);
    end
    b0=be; v=inv(F)*s; % versione 1
%  
    if rc==0 && rd==0,
      de=v-b0;    
    elseif rc == 0, % only inequalities
      Fi=inv(F); Li=chol(Fi)'; Di=D*Li; 
      de=v-b0+Li*ldp(Di,-D*v);
    elseif rd == 0,  % only equalities
      Ai=inv(Z'*F*Z);
      de=Z*Ai*Z'*F*v-b0;
    else       % equalities and inequalities
      Ai=inv(Z'*F*Z);
      Li=chol(Ai)'; Dz=D*Z; ta=Ai*Z'*F*v;
      de=Z*(ta+Li*ldp(Dz*Li,-Dz*ta))-b0;
    end
    dm=max(de)-min(de); % shorten step
    dd=(dm>2.5);  de=de/((1+mit/it)^(0.8)+dd*(dm^(.8)));      
    be=b0+de;  diss=sum(abs(de));
    it=it+1; 
    if it==floor(it/10)*10,  save temp be P F; end
    et=etime(clock,t0); disp([it LL/100 dis/100 diss et]);    
  end