function [M,C,G] = mageco(lev,Md,Bm)
%        [M,C,G] = mageco(lev,Md,Bm)
%  marginal and conditional parameterization for 
%  levels in lev: finds M and C in the model eta = C*log(M*p)
%  elements in the matrix Md  may be "l" for local, 
%  'g' for global, 'c' for continuation,
% 'r' for reverse continuation, 'l' for local,
%  marginals in the matrix Bm: 1=active, 0=marginal,
%  -2=cconditional; loglin design matrix in G

% preliminaries
  J=length(lev);  
  if nargin == 1, 
     Bm=ones(1,J); Md='l'*ones(1,J); end 
  if nargin == 2,  Md='l'*ones(1,J); end
  m=size(Bm,1);  
  if size(Md,1)==1,   Md=ones(m,1)*Md; end
  C=[]; M=[];  Jt=(1:J); mal=max(lev); Id=eye(mal);      
  S=sq(J); S(1,:)=[]; rs=size(S,1); jT=[];
% cycle across marginals
  for im=1:m,    % detect active and conditioning var.
      bm=Bm(im,:);  jv=find(bm>-2);  
      jc=stract(Jt,jv);   C1=1; M1=1;       
      mod=Md(im,:);  Cv=[]; Mv=[];
      for j=jv,         % process active var
        [C2,M2]=globserv(lev(j),mod(j),bm(j));
        M1=kron(M1,M2); C1=kron(C1,C2);
      end
      Cv=blkdiag(Cv,C1); Mv=[Mv;M1]; sc=size(jc,2);
      lc=prod(lev(jc)); IC=eye(lc); Mc=1;
      for j=jc,                          % process condit. var.
        jj=1:lev(j); bcj=bm(j);
        m=Id(jj,jj)*(bcj==-2);
        Mc=kron(Mc,m);
      end
      Cv=kron(IC,Cv);  Mv=kron(Mc,Mv);   % combine the two  
      [Inew,Iold]=reord(lev,[jc,jv]);
      M=[M;Mv(:,Iold)]; C=blkdiag(C,Cv);
      % construct design matrix
      su=abs(bm)>0; sd=bm<0; jS=[]; jC=jS;
      for js=1:rs
          jj=min(su-S(js,:))>=0; if jj==1, jS=[jS js]; end
          jj=min(sd-S(js,:))>=0; if jj==1, jC=[jC js]; end
      end
      jS=stract(jS,jC); jT=qtile([jT jS]);
  end
  S=S(jT,:); G=mdes(lev,'g'*ones(1,J),S);
