function [LL,P,be,F] = macsil(y,be,lev,V,Gt,H,Cont,Mart,C,D,P)
%        [LL,P,be,F] = macsil(y,be,lev,V,Gt,H,Cont,Mart,C,D,P)
% M step with Aitchison Silvey algorithm

% preliminaries
  n=size(y,1); t=max(y); J=size(lev,2)-1;
  ep=10^(-80); seta=size(Cont,1);
  [X,of]=model(V(1,:)); k=size(X,2);
  acc=0.0005; mit=150; 
  [rc cc]=size(C);  [rd,cd]=size(D);
  if k ~= cc, disp('check col C'); end
  if k ~= cd, disp('check col D'); end
  if rc>0, Z=null(C); end 
  QK=ceil(n*(1:35)/35);
  
% initialize
  QK=ceil(n*(1:70)/70); 
  if nargin < 11,
    disp('----o----1----o----2----o----3----o----4----o----5----o----6----o----7')
    P=zeros(t,n); disp('initial probabilities')
    for iu=1:n, % initialize P
      [X,of] = model(V(iu,:));
       eta=X*be+of; [p,err] = binve(Cont,Mart,Gt,eta);
       if err==1, disp(iu); return; end
       p=max(p,ep); p=p/sum(p);  P(:,iu)=p;
      if any(iu == QK), fprintf('+');  end           
    end
    fprintf('\n');    
  end
% Iterate  
  % QK=ceil(mit*(1:300)/300); 
  it=0; test=1; Eta=Cont*log(Mart*P);
  if size(be,1)==0, be=zeros(k,1); end
  while test>0,
    time0=clock; LL=0; sc=zeros(k,1); F=zeros(k); 
    for is=1:n,  % calcola score e informazione
       [X,of] = model(V(is,:));  p=P(:,is); 
       Op=diag(p)-p*p'; LL=LL+log(p(y(is)));
       R=Cont*diagv((Mart*p).^(-1),Mart)*Op*Gt;    
       while rcond(R)<10^(-12), 
           R=R+5*eye(seta); fprintf('!'); end             
       R=inv(R); eta=Eta(:,is); 
       A=Gt*R*X; B=R'*Gt'*Op*A; F=F+B'*X;
       sc=sc+(A(y(is),:)'-A'*p)+B'*eta;
%       if any(QK==is), fprintf('-'); end
    end     
%    while rcond(F)<10^(-10),
%       F=F+A'*A;
%    end
    b0=be; v=inv(F)*sc; 
    if rc==0 & rd==0,
      de=v-b0;    
    elseif rc == 0, % only inequalities
      Fi=inv(F); Li=chol(Fi)'; Di=D*Li; 
      de=v-b0+Li*ldp(Di,-D*v);
    elseif rd == 0,  % only equalities
      Ai=inv(Z'*F*Z);
      de=Z*Ai*Z'*F*v-b0;
    else,       % equalities and inequalities
      Ai=inv(Z'*F*Z);
      Li=chol(Ai)'; Dz=D*Z; ta=Ai*Z'*F*v;
      de=Z*(ta+Li*ldp(Dz*Li,-Dz*ta))-b0;
    end
    dis2=sum(abs(de)); dm=max(de)-min(de); % shorten step
    it=it+1; dd=(dm>2); de=de/((1+mit/it)^(0.5)+dd*(dm^(.75)));  
    be=b0+de; dis3=sum(abs(be-b0)); dis1=0; 
    for iu=1:n, % ricostruisce P
      [X,of]=model(V(iu,:)); EL(:,iu)=of+X*be; 
      p=P(:,iu); Op=diag(p)-p*p';
      R=Cont*diagv((Mart*p).^(-1),Mart)*Op*Gt;
      while rcond(R)<10^(-12), 
          R=R+5*eye(seta); fprintf('!'); end             
      R=inv(R); ga=H*log(p)+R*(EL(:,iu)-Eta(:,iu)); 
      p=exp(Gt*ga); p=p/sum(p);
      p=max(p,ep); p=p/sum(p); P(:,iu)=p;              
%      if any(QK==iu), fprintf('+'); end
    end   
    Eta=Cont*log(Mart*P);
    %% tenta di diminuire la discrepanza
    if it+5==6*floor((it+5)/6), 
    sc=zeros(k,1); F=zeros(k);% fprintf('\n'); 
    for iu=1:n,
       [X,of]=model(V(iu,:)); sc=sc+X'*Eta(:,iu);
       F=F+X'*X;
    end
    be=be+(inv(F)*sc-be)/2;
    % seconda ricostruzione
    for iu=1:n,   
      [X,of]=model(V(iu,:)); EL(:,iu)=of+X*be; 
      p=P(:,iu); Op=diag(p)-p*p';
      R=Cont*diagv((Mart*p).^(-1),Mart)*Op*Gt;
      while rcond(R)<10^(-12), 
          R=R+5*eye(seta); fprintf('!'); end             
      R=inv(R); ga=H*log(p)+R*(EL(:,iu)-Eta(:,iu)); 
      p=exp(Gt*ga); p=p/sum(p);
      p=max(p,ep); p=p/sum(p); P(:,iu)=p;  
      if any(QK==iu), fprintf(':'); end
    end
    save temp be P; fprintf('\n');  
    end
    %%%%% diminuisce discrepanza
    dis1=EL-Eta; dis1=sum(sum(abs(dis1)));
    test=(it<mit) * ((dis1>acc) + (dis3>5*acc));   
%    if (test==0)|(it==1),
    disp([it LL/10 dis1 dis2 dis3 etime(clock,time0)]);    
%    end
  end    