function eta = lsde(y,C,D,F,c,d)
%        eta = lsde(y,C,D,F,c,d)
%  finds  min (y-eta)'*F*(y-eta)
%  subject to C*eta=c and D*eta>=d

% preliminaries
  n=length(y); nar=nargin;
  if nar == 3, F=eye(n); end
  [rc,cc]=size(C); 
  if nar <= 4, c=zeros(rc,1); end   
  [rd,cd]=size(D);
  if nar <= 5, d=zeros(rd,1); end
     
% check dimensions
  [f,f]=size(F); ld=length(d); lc=length(c);
  if n~=f, error('check dim y,F'); return, end
  if (cc~=n)&&(cc>0), 
    error('check cols C'); return, 
  end
  if cd~=n, error('check cols D'); return, end
  if rd~=ld, error('check rows d'); return, end
  if rc~=lc, error('check rows c'); return, end

% only inequalities
  if rc == 0,
    L=chol(F); Li=inv(L);
    dx=d-D*y; DLi=D*Li;
    eta=y+Li*ldp(DLi,dx);
% only equalities
  elseif rd == 0,
    X=null(C); FX=F*X;
    XFi=inv(X'*FX); ci=C'*inv(C*C')*c; 
    eta=ci+X*XFi*FX'*(y-ci);
% equalities and inequalities
  else
    X=null(C); Fi=inv(F); 
    XF=X'*F; XFi=inv(XF*X);
    Mi=chol((XFi+XFi')/2)'; CFi=Fi*C';
    CFic=CFi*inv(C*CFi)*c;
    DX=D*X; DXMi=DX*Mi; 
    b=XFi*XF*(y-CFic);
    dx=d-D*CFic-DX*b;
    tau=ldp(DXMi,dx);
    eta=X*(Mi*tau+b)+CFic;
 end
 
