function x = ldp(G,h);
%        x = ldp(G,h)
% Least distance programming: the problem is
%        min x'x   subject to Gx >= h
% Algorithm LDP of Lawson and Hanson (1974).

x = [];
[m,n] = size(G);
E = [G';h'];
f = [zeros(n,1) ; 1];
u = lsqnonneg(E,f);
r = E*u - f;
if 0==r'*r,
   return
end
x = -r(1:n)./r(n+1);