function eta = lde(y,C,D,F)
%        eta = lde(y,C,D,F)
%  minimize (y-eta)'*F*(y-eta) subject 
%  to C*eta=0 and D*eta >= 0; if omitted
%  F=identity, C or D may be empty

% prliminaries
  n=length(y); nar=nargin;
  if nar == 3, F=eye(n); end
  [rc,cc]=size(C); [rd,cd]=size(D);
  [f,f]=size(F); 
     
% check dimensions
  if n~=f, error('check dim y,F'); return, end
  if (cc~=n)&(cc>0), 
    error('check cols C'); return, 
  end
  if cd~=n,
    error('check cols D'); return, 
  end

% only inequalities 
  if rc == 0,
    L=chol(F); Li=inv(L);
    DLi=D*Li; d=-D*y; 
    eta=y+Li*ldp(DLi,d);
% only equalities
  elseif rd == 0,
    X=null(C); FX=F*X;
    XFi=inv(X'*FX); 
    eta=X*XFi*FX'*y;
% the general case
  else
    X=null(C); FX=F*X;
    XFi=inv(X'*FX);
    Mi=chol(XFi)'; DX=D*X;
    DXMi=DX*Mi; b=XFi*FX'*y;
    d=-DX*b; tau=ldp(DXMi,d);
    eta=X*(b+Mi*tau);
  end
